Clazz.declarePackage ("JS");
Clazz.load (null, "JS.CIPChirality", ["java.util.Arrays", "$.Hashtable", "JU.BS", "$.Lst", "$.Measure", "$.PT", "$.V3", "JU.BSUtil", "$.Logger"], function () {
c$ = Clazz.decorateAsClass (function () {
this.vwr = null;
this.ptID = 0;
this.root = null;
this.currentRule = 0;
this.htPathPoints = null;
if (!Clazz.isClassDefined ("JS.CIPChirality.CIPAtom")) {
JS.CIPChirality.$CIPChirality$CIPAtom$ ();
}
Clazz.instantialize (this, arguments);
}, JS, "CIPChirality");
Clazz.makeConstructor (c$, 
function () {
});
Clazz.defineMethod (c$, "setViewer", 
function (vwr) {
this.vwr = vwr;
return this;
}, "JV.Viewer");
Clazz.defineMethod (c$, "getChiralityForAtoms", 
function (atoms, bsAtoms) {
var bsToDo = JU.BSUtil.copy (bsAtoms);
for (var i = bsAtoms.nextSetBit (0); i >= 0; i = bsAtoms.nextSetBit (i + 1)) {
var atom = atoms[i];
var c = atom.getCIPChirality (true);
if (c.length > 0) {
bsToDo.clear (i);
}}
for (var i = bsAtoms.nextSetBit (0); i >= 0; i = bsAtoms.nextSetBit (i + 1)) {
this.getAtomBondChirality (atoms[i], true);
}
for (var i = bsToDo.nextSetBit (0); i >= 0; i = bsToDo.nextSetBit (i + 1)) {
var a = atoms[i];
if (a.getCovalentBondCount () != 4) continue;
a.setCIPChirality (0);
a.setCIPChirality (this.getAtomChiralityLimited (a, null, null, 5, -1));
}
}, "~A,JU.BS");
Clazz.defineMethod (c$, "getAtomChirality", 
function (atom) {
return this.getAtomChiralityLimited (atom, null, null, 3, -1);
}, "JU.Node");
Clazz.defineMethod (c$, "getBondChirality", 
function (bond) {
return this.getBondChiralityLimited (bond, 3);
}, "JU.Edge");
Clazz.defineMethod (c$, "getAtomBondChirality", 
function (atom, allBonds) {
var bonds = atom.getEdges ();
var index = atom.getIndex ();
for (var j = bonds.length; --j >= 0; ) {
var bond = bonds[j];
if (bond.getCovalentOrder () == 2 && (allBonds || bond.getOtherAtomNode (atom).getIndex () > index)) {
this.getBondChirality (bond);
}}
}, "JU.Node,~B");
Clazz.defineMethod (c$, "getAtomChiralityLimited", 
 function (atom, cipAtom, parent, ruleMax, iref) {
var rs = 0;
var isChiral = false;
if (cipAtom != null) atom = cipAtom.atom;
var nSubs = atom.getCovalentBondCount ();
var isAlkene = (nSubs == 3);
if (nSubs == (parent == null ? 4 : 3)) {
if (cipAtom == null) {
this.htPathPoints =  new java.util.Hashtable ();
cipAtom = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, atom, null, false);
}this.root = cipAtom;
cipAtom.parent = parent;
this.currentRule = 0;
if (cipAtom.set ()) {
try {
if (iref >= 0) cipAtom.bsPath.set (iref);
for (this.currentRule = 0; this.currentRule <= ruleMax && !isChiral; this.currentRule++) {
isChiral = false;
if (JU.Logger.debugging) JU.Logger.info ("-Rule " + this.currentRule + " CIPChirality for " + cipAtom + "-----");
cipAtom.sortSubstituents ();
isChiral = true;
if (JU.Logger.debugging) {
JU.Logger.info (this.currentRule + ">>>>" + cipAtom);
for (var i = 0; i < nSubs; i++) JU.Logger.info (cipAtom.atoms[i] + " " + Integer.toHexString (cipAtom.prevPriorities[i]));

}for (var i = 0; i < nSubs - 1; i++) {
if (cipAtom.prevPriorities[i] == cipAtom.prevPriorities[i + 1]) {
isChiral = false;
break;
}}
}
if (isChiral) {
rs = (!isAlkene ? JS.CIPChirality.checkHandedness (cipAtom) : cipAtom.atoms[0].isDuplicate ? 2 : 1);
}} catch (e) {
System.out.println (e + " in CIPChirality");
if (!this.vwr.isJS) e.printStackTrace ();
}
if (JU.Logger.debugging) JU.Logger.info (atom + " " + (isAlkene ? "" + rs : rs == 1 ? "R" : rs == 2 ? "S" : ""));
}}if (JU.Logger.debugging) JU.Logger.info ("----------------------------------");
return rs;
}, "JU.Node,JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,~N,~N");
Clazz.defineMethod (c$, "getBondChiralityLimited", 
 function (bond, ruleMax) {
if (JU.Logger.debugging) JU.Logger.info ("get Bond Chirality " + bond);
var ez = 0;
var atoms = this.vwr.ms.at;
if (bond.getCovalentOrder () == 2) {
var a = atoms[bond.getAtomIndex1 ()];
var b = atoms[bond.getAtomIndex2 ()];
this.htPathPoints =  new java.util.Hashtable ();
var a1 = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, a, null, false);
var b1 = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, b, null, false);
var atop = this.getAtomChiralityLimited (a, a1, b1, ruleMax, -1) - 1;
this.htPathPoints =  new java.util.Hashtable ();
var a2 = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, a, null, false);
var b2 = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, b, null, false);
var btop = this.getAtomChiralityLimited (b, b2, a2, ruleMax, -1) - 1;
if (atop >= 0 && btop >= 0) {
ez = (JS.CIPChirality.isCIS (b2.atoms[btop], b2, a1, a1.atoms[atop]) ? 1 : 2);
}if (ez != 0) {
a.setCIPChirality (ez << 3);
b.setCIPChirality (ez << 3);
}if (JU.Logger.debugging) JU.Logger.info (bond + " " + (ez == 1 ? "Z" : ez == 2 ? "E" : "_"));
}return ez;
}, "JU.Edge,~N");
c$.checkHandedness = Clazz.defineMethod (c$, "checkHandedness", 
function (a) {
var p1 = a.atoms[0].atom;
var p2 = a.atoms[1].atom;
var p3 = a.atoms[2].atom;
var p4 = a.atoms[3].atom;
var vNorm =  new JU.V3 ();
var d = JU.Measure.getNormalThroughPoints (p1, p2, p3, vNorm,  new JU.V3 ());
return (JU.Measure.distanceToPlaneV (vNorm, d, p4) > 0 ? 1 : 2);
}, "JS.CIPChirality.CIPAtom");
c$.isCIS = Clazz.defineMethod (c$, "isCIS", 
function (me, parent, grandParent, greatGrandParent) {
var vNorm1 =  new JU.V3 ();
var vTemp =  new JU.V3 ();
JU.Measure.getNormalThroughPoints (me.atom, parent.atom, grandParent.atom, vNorm1, vTemp);
var vNorm2 =  new JU.V3 ();
JU.Measure.getNormalThroughPoints (parent.atom, grandParent.atom, greatGrandParent.atom, vNorm2, vTemp);
return (vNorm1.dot (vNorm2) > 0);
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom");
c$.$CIPChirality$CIPAtom$ = function () {
Clazz.pu$h(self.c$);
c$ = Clazz.decorateAsClass (function () {
Clazz.prepareCallback (this, arguments);
this.atom = null;
this.id = 0;
this.parent = null;
this.rootSubstituent = null;
this.elemNo = 0;
this.massNo = 0;
this.sphere = 0;
this.bsPath = null;
this.rootDistance = 0;
this.nAtoms = 0;
this.nPriorities = 0;
this.h1Count = 0;
this.auxiliaryEZ = -1;
this.knownAtomChirality = ".";
this.knownChiralityPath = "";
this.isSet = false;
this.isDuplicate = true;
this.isTerminal = false;
this.isAlkeneAtom2 = false;
this.atoms = null;
this.priorities = null;
this.prevPriorities = null;
Clazz.instantialize (this, arguments);
}, JS.CIPChirality, "CIPAtom", null, [Comparable, Cloneable]);
Clazz.prepareFields (c$, function () {
this.atoms =  new Array (4);
this.priorities =  Clazz.newIntArray (4, 0);
this.prevPriorities =  Clazz.newIntArray (4, 0);
});
Clazz.makeConstructor (c$, 
function (a, b, c) {
this.id = ++this.b$["JS.CIPChirality"].ptID;
this.parent = b;
if (a == null) return;
this.atom = a;
this.knownAtomChirality = a.getCIPChirality (false);
if (this.knownAtomChirality.equals ("")) this.knownAtomChirality = ".";
if (b != null) {
this.knownChiralityPath = b.knownAtomChirality + this.knownAtomChirality;
this.sphere = b.sphere + 1;
}if (this.sphere == 1) this.rootSubstituent = this;
 else if (b != null) this.rootSubstituent = b.rootSubstituent;
this.isTerminal = a.getCovalentBondCount () == 1;
this.elemNo = a.getElementNumber ();
this.massNo = a.getNominalMass ();
this.bsPath = (b == null ?  new JU.BS () : JU.BSUtil.copy (b.bsPath));
var d = a.getIndex ();
if (b == null) {
this.bsPath.set (d);
this.rootDistance = 0;
} else if (a === this.b$["JS.CIPChirality"].root.atom) {
this.rootDistance = 0;
c = true;
} else if (this.bsPath.get (d)) {
c = true;
this.rootDistance = this.b$["JS.CIPChirality"].htPathPoints.get (this.rootSubstituent.atom.toString () + a).intValue ();
} else {
this.bsPath.set (d);
this.rootDistance = b.rootDistance + 1;
this.b$["JS.CIPChirality"].htPathPoints.put (this.rootSubstituent.atom.toString () + a,  new Integer (this.rootDistance));
}this.isDuplicate = c;
if (JU.Logger.debugging) JU.Logger.info ("new CIPAtom " + b + "->" + this);
}, "JU.Node,JS.CIPChirality.CIPAtom,~B");
Clazz.defineMethod (c$, "set", 
function () {
if (this.isSet) return true;
this.isSet = true;
if (this.isTerminal || this.isDuplicate) return true;
this.atoms =  new Array (4);
var a = this.atom.getBondCount ();
var b = this.atom.getEdges ();
if (JU.Logger.debugging) JU.Logger.info ("set " + this);
var c = 0;
for (var d = 0; d < a; d++) {
var e = b[d];
if (!e.isCovalent ()) continue;
var f = e.getOtherAtomNode (this.atom);
var g = (this.parent != null && this.parent.atom === f);
var h = e.getCovalentOrder ();
if (g && h == 2) {
this.isAlkeneAtom2 = true;
this.knownAtomChirality = e.getCIPChirality (false);
}switch (h) {
case 3:
if (this.addAtom (c++, f, g) == null) {
this.isTerminal = true;
return false;
}case 2:
if (this.addAtom (c++, f, h != 2 || g) == null) {
this.isTerminal = true;
return false;
}case 1:
if (!g && this.addAtom (c++, f, h != 1) == null) {
this.isTerminal = true;
return false;
}break;
default:
this.isTerminal = true;
return false;
}
}
this.isTerminal = (c == 0);
this.nAtoms = c;
this.fillNull (c);
var e = this.b$["JS.CIPChirality"].currentRule;
this.b$["JS.CIPChirality"].currentRule = 0;
java.util.Arrays.sort (this.atoms);
this.b$["JS.CIPChirality"].currentRule = e;
return !this.isTerminal;
});
Clazz.defineMethod (c$, "fillNull", 
 function (a) {
for (; a < this.atoms.length; a++) this.atoms[a] = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, null, this, true);

}, "~N");
Clazz.defineMethod (c$, "addAtom", 
 function (a, b, c) {
if (a >= this.atoms.length) {
if (JU.Logger.debugging) JU.Logger.info (" too many bonds on " + this.atom);
return null;
}if (this.parent == null) {
var d = b.getAtomicAndIsotopeNumber ();
if (d == 1) {
if (++this.h1Count > 1) {
if (JU.Logger.debugging) JU.Logger.info (" second H atom found on " + this.atom);
return null;
}}}this.atoms[a] = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, b, this, c);
if (this.b$["JS.CIPChirality"].currentRule > 2) this.prevPriorities[a] = this.getBasePriority (this.atoms[a]);
return this.atoms[a];
}, "~N,JU.Node,~B");
Clazz.defineMethod (c$, "sortSubstituents", 
function () {
var a = 4;
if (JU.Logger.debugging) {
JU.Logger.info ("---sortSubstituents---" + this.atom);
for (var b = 0; b < a; b++) JU.Logger.info (this.b$["JS.CIPChirality"].currentRule + ": " + this + "[" + b + "]=" + this.atoms[b] + " " + Integer.toHexString (this.prevPriorities[b]));

}var b =  Clazz.newIntArray (4, 0);
for (var c = 0; c < a; c++) {
this.priorities[c] = 1;
if (this.prevPriorities[c] == 0 && this.b$["JS.CIPChirality"].currentRule > 1) this.prevPriorities[c] = this.getBasePriority (this.atoms[c]);
}
for (var d = 0; d < a; d++) {
var e = this.atoms[d];
for (var f = d + 1; f < a; f++) {
var g = this.atoms[f];
if (JU.Logger.debuggingHigh) JU.Logger.info ("ordering " + this.id + "." + d + "." + f + " " + this + "-" + e + " vs " + g + " " + Integer.toHexString (this.prevPriorities[d]) + " " + Integer.toHexString (this.prevPriorities[f]));
var h = this.compareSubs (e, g, d, f);
if (JU.Logger.debuggingHigh) JU.Logger.info ("ordering " + this.id + "." + d + "." + f + " " + this + "-" + e + " vs " + g + " = " + h);
switch (h) {
case -2:
System.out.println ("OHNO");
break;
case 1:
b[d]++;
this.priorities[d]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this.atom + "." + g + " B-beats " + e + " ind=" + b[d]);
break;
case -1:
b[f]++;
this.priorities[f]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this.atom + "." + e + " A-beats " + g + " ind=" + b[f]);
break;
case 0:
switch (e.breakTie (g)) {
case -2:
System.out.println ("OHNO2");
break;
case 0:
b[d]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this.atom + "." + g + " ends up with tie with " + e + " ind=" + b[d]);
break;
case 1:
b[d]++;
this.priorities[d]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this.atom + "." + g + " wins in tie with " + e + " ind=" + b[d] + "\n");
break;
case -1:
b[f]++;
this.priorities[f]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this.atom + "." + e + " wins in tie with " + g + " ind=" + b[f] + "\n");
break;
}
break;
}
}
}
var e =  new Array (a);
var f =  Clazz.newIntArray (a, 0);
var g =  Clazz.newIntArray (a, 0);
var h =  new JU.BS ();
var i = JS.CIPChirality.PRIORITY_SHIFT[this.b$["JS.CIPChirality"].currentRule];
for (var j = 0; j < a; j++) {
var k = b[j];
var l = e[k] = this.atoms[j];
var m = this.priorities[j];
f[k] = m;
g[k] = this.prevPriorities[j] | (m << i);
if (l.atom != null) h.set (this.priorities[j]);
}
this.atoms = e;
this.priorities = f;
this.prevPriorities = g;
this.nPriorities = h.cardinality ();
if (JU.Logger.debugging) {
JU.Logger.info (this.atom + " nPriorities = " + this.nPriorities);
for (var k = 0; k < a; k++) JU.Logger.info (this.atom + "[" + k + "]=" + this.atoms[k] + " " + this.priorities[k]);

}});
Clazz.defineMethod (c$, "compareSubs", 
 function (a, b, c, d) {
return (a.atom == null ? 1 : b.atom == null ? -1 : this.prevPriorities[c] == this.prevPriorities[d] ? a.compareTo (b) : this.prevPriorities[d] < this.prevPriorities[c] ? 1 : -1);
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,~N,~N");
Clazz.defineMethod (c$, "checkDuplicate", 
 function (a) {
return a.isDuplicate == this.isDuplicate ? 0 : a.isDuplicate ? -1 : 1;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "breakTie", 
 function (a) {
var b = this.checkDuplicate (a);
if (b != 0) return b;
if (this.atom === a.atom && (this.atom == null || this.b$["JS.CIPChirality"].currentRule < 3)) return 0;
if ((this.atom == null) != (a.atom == null)) return (this.atom == null ? 1 : -1);
if (!this.set () || !a.set () || this.isTerminal || a.isTerminal || this.isDuplicate && a.isDuplicate) return 0;
if (JU.Logger.debugging) JU.Logger.info ("tie for " + this + " and " + a);
if ((b = this.compareWith (a, false)) != 0) return b;
this.sortSubstituents ();
a.sortSubstituents ();
return this.compareWith (a, true);
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "compareWith", 
 function (a, b) {
for (var c = 0; c < this.nAtoms; c++) {
var d = this.atoms[c];
var e = a.atoms[c];
if (JU.Logger.debugging) JU.Logger.info ("compareAB " + d.parent + "-" + d + " with " + e.parent + "-" + e + " goDeep=" + b);
var f = (b ? d.breakTie (e) : d.checkCurrentRule (e));
if (f == -2) f = 0;
if (f != 0) {
if (JU.Logger.debugging) JU.Logger.info ("compareAB " + (f == 1 ? e + " beats " + d : d + " beats " + e) + " " + b);
return f;
}}
if (JU.Logger.debugging) JU.Logger.info ("compareAB ends in tie for " + this + " vs. " + a);
return 0;
}, "JS.CIPChirality.CIPAtom,~B");
Clazz.overrideMethod (c$, "compareTo", 
function (a) {
var b;
if ((this.atom == null) != (a.atom == null)) return (this.atom == null ? 1 : -1);
return (b = this.checkCurrentRule (a)) == -2 ? 0 : b != 0 ? b : this.checkDuplicate (a);
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkCurrentRule", 
function (a) {
switch (this.b$["JS.CIPChirality"].currentRule) {
default:
case 0:
return this.checkRule1a (a);
case 1:
return this.checkRule1b (a);
case 2:
return this.checkRule2 (a);
case 3:
return this.checkRule3 (a);
case 4:
return this.checkRule4 (a);
case 5:
return this.checkRule5 (a);
}
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule1a", 
 function (a) {
return a.atom === this.atom ? 0 : a.atom == null ? -1 : this.atom == null ? 1 : a.elemNo < this.elemNo ? -1 : a.elemNo > this.elemNo ? 1 : 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule1b", 
 function (a) {
return !a.isDuplicate || !this.isDuplicate ? 0 : a.rootDistance < this.rootDistance ? 1 : a.rootDistance > this.rootDistance ? -1 : 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule2", 
 function (a) {
return a.massNo < this.massNo ? -1 : a.massNo > this.massNo ? 1 : 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule3", 
 function (a) {
var b;
var c;
return this.parent == null || !this.parent.isAlkeneAtom2 || !a.parent.isAlkeneAtom2 || this.isDuplicate || a.isDuplicate ? -2 : this.parent === a.parent ? this.breakTie (a) : (b = this.parent.getZaux ()) < (c = a.parent.getZaux ()) ? -1 : b > c ? 1 : 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "getZaux", 
 function () {
if (this.auxiliaryEZ < 0) this.auxiliaryEZ = this.parent.auxiliaryEZ;
if (this.auxiliaryEZ < 0) {
var a = null;
var b = null;
var c = null;
this.auxiliaryEZ = 3;
this.sortSubstituents ();
b = this.getTopAtom ();
if (b != null) {
if (JU.Logger.debugging) JU.Logger.info ("reversing path for " + this.parent);
var d = this.getReturnPath (this.parent);
c = this.parent.clone ();
c.addReturnPath (this, d);
c.sortSubstituents ();
a = c.getTopAtom ();
if (a != null) {
this.auxiliaryEZ = (JS.CIPChirality.isCIS (b, this, c, a) ? 1 : 2);
if (JU.Logger.debugging) JU.Logger.info ("getZaux " + (this.auxiliaryEZ == 1 ? "Z" : "E") + " for " + this.atom + "=" + this.parent.atom + " : " + a + " " + b);
}}}this.parent.auxiliaryEZ = this.auxiliaryEZ;
return this.auxiliaryEZ;
});
Clazz.defineMethod (c$, "getReturnPath", 
 function (a) {
var b =  new JU.Lst ();
while (a.parent != null && a.parent.atoms[0] != null) {
if (JU.Logger.debugging) JU.Logger.info ("path:" + a.parent.atom + "->" + a.atom);
b.addLast (a = a.parent);
}
b.addLast (null);
return b;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "addReturnPath", 
 function (a, b) {
var c = this;
for (var d = 0, e = b.size (); d < e; d++) {
var f = b.get (d);
if (f == null) f = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, null, this, true);
 else f = f.clone ();
c.replaceParentSubstituent (a, f);
a = a.parent;
c = f;
}
}, "JS.CIPChirality.CIPAtom,JU.Lst");
Clazz.defineMethod (c$, "replaceParentSubstituent", 
 function (a, b) {
for (var c = 0; c < 4; c++) if (this.atoms[c] === a) {
this.atoms[c] = b;
if (JU.Logger.debugging) JU.Logger.info ("replace " + this + "[" + c + "]=" + b);
this.prevPriorities[c] = this.getBasePriority (this.atoms[c]);
this.parent = a;
break;
}
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "getTopAtom", 
 function () {
var a = (this.atoms[0].isDuplicate ? 1 : 0);
return this.priorities[a] == this.priorities[a + 1] ? null : this.priorities[a] < this.priorities[a + 1] ? this.atoms[a] : this.atoms[a + 1];
});
Clazz.defineMethod (c$, "checkRule4", 
 function (a) {
if (JU.Logger.debugging) JU.Logger.info ("Checking Rule 4 for " + this + " and " + a);
var b = this.getCommonAncestor (a).knownChiralityPath.length;
if (b >= this.knownChiralityPath.length) return 0;
var c = this.knownChiralityPath.substring (b);
var d = a.knownChiralityPath.substring (b);
if (c != null && c.length == d.length && !c.equals (d)) {
var e = c.length;
for (var f = 0; f < e - 1; f++) for (var g = f + 1; g < e; g++) {
var h = (c.charAt (f) == c.charAt (g));
var i = (d.charAt (f) == d.charAt (g));
if (h != i) return (h ? -1 : 1);
}

}return 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "getCommonAncestor", 
 function (a) {
var b = this;
if ((b.parent == null) != (a.parent == null)) System.out.println ("OHOH3");
while ((b = b.parent) !== (a = a.parent)) {
}
return b;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule5", 
 function (a) {
var b = JU.PT.isOneOf (this.knownAtomChirality, ";rRZ;");
return (b == JU.PT.isOneOf (a.knownAtomChirality, ";RZ;") ? 0 : b ? -1 : 1);
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "clone", 
function () {
var a = null;
try {
a = Clazz.superCall (this, JS.CIPChirality.CIPAtom, "clone", []);
a.id = this.b$["JS.CIPChirality"].ptID++;
} catch (e) {
if (Clazz.exceptionOf (e, CloneNotSupportedException)) {
} else {
throw e;
}
}
a.atoms =  new Array (4);
a.priorities =  Clazz.newIntArray (4, 0);
a.prevPriorities =  Clazz.newIntArray (4, 0);
for (var b = 0; b < 4; b++) {
if (this.atoms[b] != null) {
a.atoms[b] = this.atoms[b];
a.prevPriorities[b] = this.getBasePriority (this.atoms[b]);
}}
if (JU.Logger.debugging) JU.Logger.info ("cloning " + this + " as " + a);
return a;
});
Clazz.defineMethod (c$, "getBasePriority", 
 function (a) {
var b = 0;
if (a.atom == null) {
b = 0x7FFFF << JS.CIPChirality.PRIORITY_SHIFT[2];
} else {
b = ((127 - a.elemNo) << JS.CIPChirality.PRIORITY_SHIFT[0]) | ((255 - a.massNo) << JS.CIPChirality.PRIORITY_SHIFT[2]);
}return b;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "toString", 
function () {
return (this.atom == null ? "<null>" : "[" + this.sphere + "." + this.id + " " + this.atom.toString () + (this.isDuplicate ? "*" : "")) + "]";
});
c$ = Clazz.p0p ();
};
Clazz.defineStatics (c$,
"NO_CHIRALITY", 0,
"TIED", 0,
"B_WINS", 1,
"A_WINS", -1,
"NA", -2,
"STEREO_R", 1,
"STEREO_S", 2,
"STEREO_Z", 1,
"STEREO_E", 2,
"PRIORITY_SHIFT",  Clazz.newIntArray (-1, [24, 20, 12, 8, 4, 0]));
});
