/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GeoUrlToBounds;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class OsmUrlToBounds {
    private static final String SHORTLINK_PREFIX = "http://osm.org/go/";
    private static final char[] SHORTLINK_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '@'};
    private static final int TILE_SIZE_IN_PIXELS = 256;

    private OsmUrlToBounds() {
    }

    public static Bounds parse(String string) {
        if (string.startsWith("geo:")) {
            return GeoUrlToBounds.parse(string);
        }
        try {
            if (string.contains("%")) {
                string = Utils.decodeUrl(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.error(illegalArgumentException);
        }
        Bounds bounds = OsmUrlToBounds.parseShortLink(string);
        if (bounds != null) {
            return bounds;
        }
        if (string.contains("#map")) {
            return OsmUrlToBounds.parseHashURLs(string);
        }
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        String[] stringArray = string.substring(n + 1).split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            int n2 = string2.indexOf(61);
            if (n2 == -1) continue;
            hashMap.put(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        try {
            if (hashMap.containsKey("bbox")) {
                String[] d = ((String)hashMap.get("bbox")).split(",");
                bounds = new Bounds(Double.parseDouble(d[1]), Double.parseDouble(d[0]), Double.parseDouble(d[3]), Double.parseDouble(d[2]));
            } else if (hashMap.containsKey("minlat")) {
                double runtimeException = Double.parseDouble((String)hashMap.get("minlat"));
                double d = Double.parseDouble((String)hashMap.get("minlon"));
                double d2 = Double.parseDouble((String)hashMap.get("maxlat"));
                double d3 = Double.parseDouble((String)hashMap.get("maxlon"));
                bounds = new Bounds(runtimeException, d, d2, d3);
            } else {
                String string3 = (String)hashMap.get("zoom");
                bounds = OsmUrlToBounds.positionToBounds(OsmUrlToBounds.parseDouble(hashMap, "lat"), OsmUrlToBounds.parseDouble(hashMap, "lon"), string3 == null ? 18 : Integer.parseInt(string3));
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            Main.error(runtimeException);
        }
        return bounds;
    }

    private static Bounds parseHashURLs(String string) {
        double d;
        double d2;
        int n;
        String string2;
        String[] stringArray;
        int n2 = string.indexOf("#map=");
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(38, n2);
        if (n3 == -1) {
            n3 = string.length();
        }
        if ((stringArray = (string2 = string.substring(n2 + 5, n3)).split("/")).length < 3) {
            Main.warn(I18n.tr("URL does not contain {0}/{1}/{2}", I18n.tr("zoom", new Object[0]), I18n.tr("latitude", new Object[0]), I18n.tr("longitude", new Object[0])));
            return null;
        }
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("zoom", new Object[0])), numberFormatException);
            return null;
        }
        try {
            d2 = Double.parseDouble(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("latitude", new Object[0])), numberFormatException);
            return null;
        }
        try {
            d = Double.parseDouble(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("longitude", new Object[0])), numberFormatException);
            return null;
        }
        return OsmUrlToBounds.positionToBounds(d2, d, n);
    }

    private static double parseDouble(Map<String, String> map, String string) {
        if (map.containsKey(string)) {
            return Double.parseDouble(map.get(string));
        }
        return Double.parseDouble(map.get('m' + string));
    }

    private static Bounds parseShortLink(String string) {
        if (!string.startsWith(SHORTLINK_PREFIX)) {
            return null;
        }
        String string2 = string.substring(SHORTLINK_PREFIX.length());
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (int i = 0; i < SHORTLINK_CHARS.length; ++i) {
            hashMap.put(Character.valueOf(SHORTLINK_CHARS[i]), i);
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        for (char c : string2.toCharArray()) {
            if (hashMap.containsKey(Character.valueOf(c))) {
                int n3 = (Integer)hashMap.get(Character.valueOf(c));
                for (int i = 0; i < 3; ++i) {
                    l <<= 1;
                    if ((n3 & 0x20) != 0) {
                        l |= 1L;
                    }
                    l2 <<= 1;
                    if (((n3 <<= 1) & 0x20) != 0) {
                        l2 |= 1L;
                    }
                    n3 <<= 1;
                }
                n += 3;
                continue;
            }
            --n2;
        }
        return OsmUrlToBounds.positionToBounds((double)(l2 <<= 32 - n) * 180.0 / 4.294967296E9 - 90.0, (double)(l <<= 32 - n) * 360.0 / 4.294967296E9 - 180.0, n - 8 - n2 % 3 - 2);
    }

    private static Dimension getScreenSize() {
        if (Main.isDisplayingMapView()) {
            return new Dimension(Main.map.mapView.getWidth(), Main.map.mapView.getHeight());
        }
        return GuiHelper.getScreenSize();
    }

    public static Bounds positionToBounds(double d, double d2, int n) {
        Dimension dimension = OsmUrlToBounds.getScreenSize();
        double d3 = (double)((1 << n) * 256) / (Math.PI * 2 * Ellipsoid.WGS84.a);
        double d4 = dimension.getWidth() / 2.0 / d3;
        double d5 = dimension.getHeight() / 2.0 / d3;
        Projection projection = Projections.getProjectionByCode("EPSG:3857");
        EastNorth eastNorth = projection.latlon2eastNorth(new LatLon(d, d2));
        return new Bounds(projection.eastNorth2latlon(eastNorth.add(-d4, -d5)), projection.eastNorth2latlon(eastNorth.add(d4, d5)));
    }

    public static int getZoom(Bounds bounds) {
        Projection projection = Projections.getProjectionByCode("EPSG:3857");
        EastNorth eastNorth = projection.latlon2eastNorth(bounds.getMin());
        EastNorth eastNorth2 = projection.latlon2eastNorth(bounds.getMax());
        double d = eastNorth2.getX() - eastNorth.getX();
        double d2 = OsmUrlToBounds.getScreenSize().getWidth() / d;
        double d3 = d2 * (Math.PI * 2 * Ellipsoid.WGS84.a) / 256.0;
        return (int)Math.round(Math.log(d3) / Math.log(2.0));
    }

    public static String getURL(Bounds bounds) {
        return OsmUrlToBounds.getURL(bounds.getCenter(), OsmUrlToBounds.getZoom(bounds));
    }

    public static String getURL(LatLon latLon, int n) {
        return OsmUrlToBounds.getURL(latLon.lat(), latLon.lon(), n);
    }

    public static String getURL(double d, double d2, int n) {
        int n2 = (int)Math.pow(10.0, (double)n / 3.0);
        double d3 = Math.round(d * (double)n2);
        double d4 = Math.round(d2 * (double)n2);
        return Main.getOSMWebsite() + "/#map=" + n + '/' + (d3 /= (double)n2) + '/' + (d4 /= (double)n2);
    }
}

