/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.write.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.StringOperations;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class WriteMIMEStringNode
extends FormatNode {
    private final int length;
    private static final byte[] hex_table = StringOperations.plain("0123456789ABCDEF");

    public WriteMIMEStringNode(int length) {
        this.length = length;
    }

    @Specialization(guards={"isNil(nil)"})
    public Object write(Object nil) {
        return null;
    }

    @Specialization
    public Object write(VirtualFrame frame, byte[] bytes) {
        this.writeBytes(frame, this.encode(bytes));
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] encode(byte[] bytes) {
        ByteList output = new ByteList();
        WriteMIMEStringNode.qpencode(output, new ByteList(bytes, false), this.length);
        return output.bytes();
    }

    public static ByteList qpencode(ByteList io2Append, ByteList i2Encode, int iLength) {
        io2Append.ensure(1024);
        int lCurLineLength = 0;
        int lPrevChar = -1;
        byte[] l2Encode = i2Encode.getUnsafeBytes();
        try {
            int end = i2Encode.getBegin() + i2Encode.getRealSize();
            for (int i = i2Encode.getBegin(); i < end; ++i) {
                int lCurChar = l2Encode[i] & 0xFF;
                if (lCurChar > 126 || lCurChar < 32 && lCurChar != 10 && lCurChar != 9 || lCurChar == 61) {
                    io2Append.append(61);
                    io2Append.append(hex_table[lCurChar >>> 4]);
                    io2Append.append(hex_table[lCurChar & 0xF]);
                    lCurLineLength += 3;
                    lPrevChar = -1;
                } else if (lCurChar == 10) {
                    if (lPrevChar == 32 || lPrevChar == 9) {
                        io2Append.append(61);
                        io2Append.append(lCurChar);
                    }
                    io2Append.append(lCurChar);
                    lCurLineLength = 0;
                    lPrevChar = lCurChar;
                } else {
                    io2Append.append(lCurChar);
                    ++lCurLineLength;
                    lPrevChar = lCurChar;
                }
                if (lCurLineLength <= iLength) continue;
                io2Append.append(61);
                io2Append.append(10);
                lCurLineLength = 0;
                lPrevChar = 10;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (lCurLineLength > 0) {
            io2Append.append(61);
            io2Append.append(10);
        }
        return io2Append;
    }
}

