/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.source.Source;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Locale;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.loader.JRubySourceLoaderSupport;

public class SourceLoader {
    public static final String TRUFFLE_SCHEME = "truffle:";
    public static final String JRUBY_SCHEME = "jruby:";
    private final RubyContext context;

    public SourceLoader(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public Source loadMain(String path) throws IOException {
        if (path.equals("-e")) {
            return this.loadFragment(new String(this.context.getOptions().INLINE_SCRIPT, StandardCharsets.UTF_8), "-e");
        }
        if (path.equals("-")) {
            return Source.newBuilder(new InputStreamReader(System.in)).name(path).mimeType("application/x-ruby").build();
        }
        File file = new File(path).getCanonicalFile();
        SourceLoader.ensureReadable(path, file);
        return Source.newBuilder(file).name(path).mimeType("application/x-ruby").build();
    }

    @CompilerDirectives.TruffleBoundary
    public Source load(String canonicalPath) throws IOException {
        if (canonicalPath.startsWith(TRUFFLE_SCHEME) || canonicalPath.startsWith(JRUBY_SCHEME)) {
            return this.loadResource(canonicalPath);
        }
        File file = new File(canonicalPath).getCanonicalFile();
        SourceLoader.ensureReadable(canonicalPath, file);
        if (canonicalPath.toLowerCase().endsWith(".su")) {
            return Source.newBuilder(file).name(file.getPath()).mimeType("application/x-sulong-library").build();
        }
        return Source.newBuilder(file).name(file.getPath()).mimeType("application/x-ruby").build();
    }

    @CompilerDirectives.TruffleBoundary
    public Source loadFragment(String fragment, String name) {
        return Source.newBuilder(fragment).name(name).mimeType("application/x-ruby").build();
    }

    @CompilerDirectives.TruffleBoundary
    private Source loadResource(String path) throws IOException {
        Path relativePath;
        Class relativeClass;
        if (TruffleOptions.AOT) {
            if (!path.startsWith(TRUFFLE_SCHEME) && !path.startsWith(JRUBY_SCHEME)) {
                throw new UnsupportedOperationException();
            }
            String canonicalPath = JRubySourceLoaderSupport.canonicalizeResourcePath(path);
            JRubySourceLoaderSupport.CoreLibraryFile coreFile = JRubySourceLoaderSupport.allCoreLibraryFiles.get(canonicalPath);
            if (coreFile == null) {
                throw new FileNotFoundException(path);
            }
            return Source.newBuilder(new InputStreamReader((InputStream)new ByteArrayInputStream(coreFile.code), StandardCharsets.UTF_8)).name(path).mimeType("application/x-ruby").build();
        }
        if (!path.toLowerCase(Locale.ENGLISH).endsWith(".rb")) {
            throw new FileNotFoundException(path);
        }
        if (path.startsWith(TRUFFLE_SCHEME)) {
            relativeClass = RubyContext.class;
            relativePath = FileSystems.getDefault().getPath(path.substring(TRUFFLE_SCHEME.length()), new String[0]);
        } else if (path.startsWith(JRUBY_SCHEME)) {
            relativeClass = SourceLoader.jrubySchemeRelativeClass();
            relativePath = FileSystems.getDefault().getPath(path.substring(JRUBY_SCHEME.length()), new String[0]);
        } else {
            throw new UnsupportedOperationException();
        }
        Path normalizedPath = relativePath.normalize();
        InputStream stream = relativeClass.getResourceAsStream(StringUtils.replace(normalizedPath.toString(), '\\', '/'));
        if (stream == null) {
            throw new FileNotFoundException(path);
        }
        return Source.newBuilder(new InputStreamReader(stream, StandardCharsets.UTF_8)).name(path).mimeType("application/x-ruby").build();
    }

    private static Class<?> jrubySchemeRelativeClass() {
        try {
            return Class.forName("org.jruby.Ruby");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void ensureReadable(String path, File file) throws IOException {
        if (!file.canRead()) {
            throw new IOException("Can't read file " + path);
        }
    }
}

