/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataInputOutputUtil {
    @Nullable
    public static StringRef readNAME(@NotNull DataInput record2, @NotNull AbstractStringEnumerator nameStore) throws IOException {
        if (record2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "readNAME"));
        }
        if (nameStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStore", "com/intellij/util/io/DataInputOutputUtil", "readNAME"));
        }
        return StringRef.fromStream(record2, nameStore);
    }

    public static void writeNAME(@NotNull DataOutput record2, @Nullable String name2, @NotNull AbstractStringEnumerator nameStore) throws IOException {
        if (record2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "writeNAME"));
        }
        if (nameStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStore", "com/intellij/util/io/DataInputOutputUtil", "writeNAME"));
        }
        int nameId = name2 != null ? nameStore.enumerate(name2) : 0;
        DataInputOutputUtil.writeINT(record2, nameId);
    }

    public static int readINT(@NotNull DataInput record2) throws IOException {
        if (record2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "readINT"));
        }
        int val = record2.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res2 = val - 192;
        int sh = 6;
        while (true) {
            int next = record2.readUnsignedByte();
            res2 |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res2;
            }
            sh += 7;
        }
    }

    public static long readLONG(@NotNull DataInput record2) throws IOException {
        if (record2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "readLONG"));
        }
        int val = record2.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        long res2 = val - 192;
        int sh = 6;
        while (true) {
            int next = record2.readUnsignedByte();
            res2 |= (long)(next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res2;
            }
            sh += 7;
        }
    }

    public static void writeINT(@NotNull DataOutput record2, int val) throws IOException {
        if (record2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "writeINT"));
        }
        if (0 <= val && val < 192) {
            record2.writeByte(val);
        } else {
            record2.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record2.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
            record2.writeByte(val);
        }
    }

    public static void writeLONG(@NotNull DataOutput record2, long val) throws IOException {
        if (record2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "writeLONG"));
        }
        if (0L <= val && val < 192L) {
            record2.writeByte((int)val);
        } else {
            record2.writeByte(192 + (int)(val & 0x3FL));
            val >>>= 6;
            while (val >= 128L) {
                record2.writeByte((int)(val & 0x7FL) | 0x80);
                val >>>= 7;
            }
            record2.writeByte((int)val);
        }
    }
}

