/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.AbstractBinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u0016\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bH\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightType", "getSupportTokens", "Lcom/google/common/collect/ImmutableSet;", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "isEnumIntrinsicApplicable", "", "isNegated", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "EnumEqualsIntrinsic", "EqualsIntrinsic", "kotlin-compiler"})
public final class EqualsBOIF
implements BinaryOperationIntrinsicFactory {
    public static final EqualsBOIF INSTANCE;

    @NotNull
    public ImmutableSet<KtSingleValueToken> getSupportTokens() {
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.EQUALS_OPERATIONS;
        if (immutableSet == null) {
            Intrinsics.throwNpe();
        }
        return immutableSet;
    }

    @Override
    @Nullable
    public BinaryOperationIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @Nullable KotlinType leftType, @Nullable KotlinType rightType) {
        AbstractBinaryOperationIntrinsic result2;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        AbstractBinaryOperationIntrinsic abstractBinaryOperationIntrinsic = this.isEnumIntrinsicApplicable(descriptor2, leftType, rightType) ? (AbstractBinaryOperationIntrinsic)EnumEqualsIntrinsic.INSTANCE : (result2 = KotlinBuiltIns.isBuiltIn(descriptor2) || TopLevelFIF.EQUALS_IN_ANY.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)EqualsIntrinsic.INSTANCE : null);
        if (result2 != null && Intrinsics.areEqual(leftType, rightType) ^ true) {
            boolean rightChar;
            boolean leftChar = leftType != null && KotlinBuiltIns.isCharOrNullableChar(leftType);
            boolean bl = rightChar = rightType != null && KotlinBuiltIns.isCharOrNullableChar(rightType);
            if (leftChar ^ rightChar) {
                return new AbstractBinaryOperationIntrinsic(leftChar, rightChar, result2){
                    final /* synthetic */ boolean $leftChar;
                    final /* synthetic */ boolean $rightChar;
                    final /* synthetic */ AbstractBinaryOperationIntrinsic $result;

                    @NotNull
                    public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
                        Intrinsics.checkParameterIsNotNull(expression, "expression");
                        Intrinsics.checkParameterIsNotNull(left, "left");
                        Intrinsics.checkParameterIsNotNull(right, "right");
                        Intrinsics.checkParameterIsNotNull(context, "context");
                        JsExpression maybeBoxedLeft = this.$leftChar ? JsAstUtils.charToBoxedChar(left) : left;
                        JsExpression maybeBoxedRight = this.$rightChar ? JsAstUtils.charToBoxedChar(right) : right;
                        JsExpression jsExpression = maybeBoxedLeft;
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "maybeBoxedLeft");
                        JsExpression jsExpression2 = maybeBoxedRight;
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "maybeBoxedRight");
                        return this.$result.apply(expression, jsExpression, jsExpression2, context);
                    }
                    {
                        this.$leftChar = $captured_local_variable$0;
                        this.$rightChar = $captured_local_variable$1;
                        this.$result = $captured_local_variable$2;
                    }
                };
            }
        }
        return result2;
    }

    private final boolean isEnumIntrinsicApplicable(FunctionDescriptor descriptor2, KotlinType leftType, KotlinType rightType) {
        return DescriptorUtils.isEnumClass(descriptor2.getContainingDeclaration()) && leftType != null && rightType != null && !TypeUtils.isNullableType(leftType) && !TypeUtils.isNullableType(rightType);
    }

    private final boolean isNegated(@NotNull KtBinaryExpression $receiver) {
        return Intrinsics.areEqual(PsiUtils.getOperationToken($receiver), KtTokens.EXCLEQ);
    }

    private EqualsBOIF() {
        INSTANCE = this;
    }

    static {
        new EqualsBOIF();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF$EqualsIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "canUseSimpleEquals", "", "kotlin-compiler"})
    private static final class EqualsIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final EqualsIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            JsExpression jsExpression;
            boolean appliedToDynamic;
            ReceiverValue receiverValue;
            ReceiverValue $receiver;
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            boolean isNegated = INSTANCE.isNegated(expression);
            if (Intrinsics.areEqual(right, JsLiteral.NULL) || Intrinsics.areEqual(left, JsLiteral.NULL)) {
                JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(Intrinsics.areEqual(right, JsLiteral.NULL) ? left : right, isNegated);
                Intrinsics.checkExpressionValueIsNotNull(jsBinaryOperation, "TranslationUtils.nullChe\u2026ft else right, isNegated)");
                return jsBinaryOperation;
            }
            if (this.canUseSimpleEquals(expression, context)) {
                return new JsBinaryOperation(isNegated ? JsBinaryOperator.REF_NEQ : JsBinaryOperator.REF_EQ, left, right);
            }
            KtElement ktElement = expression;
            BindingContext bindingContext = context.bindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.bindingContext()");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            boolean bl = resolvedCall2 != null && (($receiver = (receiverValue = resolvedCall2.getDispatchReceiver())) != null ? DynamicTypesKt.isDynamic($receiver.getType()) : false) ? true : (appliedToDynamic = false);
            if (appliedToDynamic) {
                return new JsBinaryOperation(isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ, left, right);
            }
            JsExpression result2 = TopLevelFIF.KOTLIN_EQUALS.apply(left, Arrays.asList(right), context);
            if (isNegated) {
                JsPrefixOperation jsPrefixOperation = JsAstUtils.not(result2);
                Intrinsics.checkExpressionValueIsNotNull(jsPrefixOperation, "JsAstUtils.not(result)");
                jsExpression = jsPrefixOperation;
            } else {
                JsExpression jsExpression2 = result2;
                jsExpression = jsExpression2;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "result");
            }
            return jsExpression;
        }

        private final boolean canUseSimpleEquals(KtBinaryExpression expression, TranslationContext context) {
            Name typeName;
            boolean bl;
            KtExpression left = expression.getLeft();
            boolean bl2 = bl = left != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "No left-hand side: " + expression.getText();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpression ktExpression = left;
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            return (typeName = JsDescriptorUtils.getNameIfStandardType(ktExpression, context)) != null && NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS.apply(typeName);
        }

        private EqualsIntrinsic() {
            INSTANCE = this;
        }

        static {
            new EqualsIntrinsic();
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF$EnumEqualsIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "kotlin-compiler"})
    public static final class EnumEqualsIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final EnumEqualsIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsBinaryOperation apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = INSTANCE.isNegated(expression) ? JsBinaryOperator.REF_NEQ : JsBinaryOperator.REF_EQ;
            return new JsBinaryOperation(operator, left, right);
        }

        private EnumEqualsIntrinsic() {
            INSTANCE = this;
        }

        static {
            new EnumEqualsIntrinsic();
        }
    }
}

