/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;

public final class KtNamedDeclarationUtil {
    @Nullable
    public static FqNameUnsafe getUnsafeFQName(@NotNull KtNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/KtNamedDeclarationUtil", "getUnsafeFQName"));
        }
        FqName fqName2 = namedDeclaration.getFqName();
        return fqName2 != null ? fqName2.toUnsafe() : null;
    }

    @Nullable
    static FqName getFQName(@NotNull KtNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/KtNamedDeclarationUtil", "getFQName"));
        }
        Name name2 = namedDeclaration.getNameAsName();
        if (name2 == null) {
            return null;
        }
        FqName parentFqName = KtNamedDeclarationUtil.getParentFqName(namedDeclaration);
        if (parentFqName == null) {
            return null;
        }
        return parentFqName.child(name2);
    }

    @Nullable
    public static FqName getParentFqName(@NotNull KtNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/KtNamedDeclarationUtil", "getParentFqName"));
        }
        PsiElement parent2 = namedDeclaration.getParent();
        if (parent2 instanceof KtClassBody) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof KtFile) {
            return ((KtFile)parent2).getPackageFqName();
        }
        if (parent2 instanceof KtNamedFunction || parent2 instanceof KtClass) {
            return KtNamedDeclarationUtil.getFQName((KtNamedDeclaration)parent2);
        }
        if (namedDeclaration instanceof KtParameter) {
            KtClassOrObject constructorClass = KtPsiUtil.getClassIfParameterIsProperty((KtParameter)namedDeclaration);
            if (constructorClass != null) {
                return KtNamedDeclarationUtil.getFQName(constructorClass);
            }
        } else if (parent2 instanceof KtObjectDeclaration) {
            return KtNamedDeclarationUtil.getFQName((KtNamedDeclaration)parent2);
        }
        return null;
    }

    private KtNamedDeclarationUtil() {
    }
}

