/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.Base64;
import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.HomeURLContent;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HomeContentContext {
    private URL homeUrl;
    private boolean containsInvalidContents;
    private List<Content> invalidContents;
    private List<URLContent> validContentsNotInPreferences;
    private Map<URLContent, byte[]> contentDigests;
    private Set<URLContent> preferencesContentsCache;
    private boolean preferPreferencesContent;

    public HomeContentContext(URL uRL, UserPreferences userPreferences, boolean bl) {
        this.homeUrl = uRL;
        this.preferPreferencesContent = bl;
        this.contentDigests = this.readContentDigests(uRL);
        this.invalidContents = new ArrayList<Content>();
        this.validContentsNotInPreferences = new ArrayList<URLContent>();
        if (userPreferences != null && this.preferencesContentsCache == null) {
            this.preferencesContentsCache = this.getUserPreferencesContent(userPreferences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URLContent, byte[]> readContentDigests(URL uRL) {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(uRL.openStream());
            ZipEntry zipEntry = null;
            while (true) {
                if ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    Object object;
                    if (!"ContentDigests".equals(zipEntry.getName())) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, "UTF-8"));
                    String string = bufferedReader.readLine();
                    if (string == null || !string.trim().startsWith("ContentDigests-Version: 1")) continue;
                    HashMap<URLContent, byte[]> hashMap = new HashMap<URLContent, byte[]>();
                    String string2 = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith("Name:")) {
                            string2 = string.substring("Name:".length()).trim();
                            continue;
                        }
                        if (!string.startsWith("SHA-1-Digest:")) continue;
                        object = Base64.decode(string.substring("SHA-1-Digest:".length()).trim());
                        if (string2 == null) {
                            throw new IOException("Missing entry name");
                        }
                        URL uRL2 = new URL("jar:" + uRL + "!/" + string2);
                        hashMap.put(new HomeURLContent(uRL2), (byte[])object);
                        string2 = null;
                    }
                    object = hashMap;
                    return object;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Content lookupContent(String string) throws IOException {
        URL uRL = new URL("jar:" + this.homeUrl + "!/" + string);
        HomeURLContent homeURLContent = new HomeURLContent(uRL);
        ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
        if (!this.isValid(homeURLContent)) {
            this.containsInvalidContents = true;
            URLContent uRLContent = this.findUserPreferencesContent(homeURLContent);
            if (uRLContent != null) {
                return uRLContent;
            }
            this.invalidContents.add(homeURLContent);
            return homeURLContent;
        }
        for (URLContent uRLContent : this.validContentsNotInPreferences) {
            if (!contentDigestManager.equals(homeURLContent, uRLContent)) continue;
            return uRLContent;
        }
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (this.contentDigests != null) {
            byte[] byArray = this.contentDigests.get(homeURLContent);
            Object object = byArray;
            if (byArray != null && !contentDigestManager.isContentDigestEqual(homeURLContent, (byte[])object)) {
                this.containsInvalidContents = true;
                URLContent uRLContent = this.findUserPreferencesContent(homeURLContent);
                if (uRLContent != null) {
                    return uRLContent;
                }
                this.invalidContents.add(homeURLContent);
                return homeURLContent;
            }
        }
        if (this.preferencesContentsCache != null && this.preferPreferencesContent) {
            for (URLContent uRLContent : this.preferencesContentsCache) {
                if (!contentDigestManager.equals(homeURLContent, uRLContent)) continue;
                return uRLContent;
            }
        }
        this.validContentsNotInPreferences.add(homeURLContent);
        return homeURLContent;
    }

    private boolean isValid(Content content) {
        try {
            InputStream inputStream = content.openStream();
            try {
                inputStream.close();
                return true;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean containsCheckedContents() {
        return this.contentDigests != null && this.invalidContents.size() == 0;
    }

    public boolean containsInvalidContents() {
        return this.containsInvalidContents;
    }

    private URLContent findUserPreferencesContent(URLContent uRLContent) {
        byte[] byArray;
        if (this.contentDigests != null && this.preferencesContentsCache != null && (byArray = this.contentDigests.get(uRLContent)) != null) {
            ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
            for (URLContent uRLContent2 : this.preferencesContentsCache) {
                if (!contentDigestManager.isContentDigestEqual(uRLContent2, byArray)) continue;
                return uRLContent2;
            }
        }
        return null;
    }

    public List<Content> getInvalidContents() {
        return Collections.unmodifiableList(this.invalidContents);
    }

    private Set<URLContent> getUserPreferencesContent(UserPreferences userPreferences) {
        HashSet<URLContent> hashSet = new HashSet<URLContent>();
        for (FurnitureCategory comparable : userPreferences.getFurnitureCatalog().getCategories()) {
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : comparable.getFurniture()) {
                this.addURLContent(catalogPieceOfFurniture.getIcon(), hashSet);
                this.addURLContent(catalogPieceOfFurniture.getModel(), hashSet);
                this.addURLContent(catalogPieceOfFurniture.getPlanIcon(), hashSet);
            }
        }
        for (TexturesCategory texturesCategory : userPreferences.getTexturesCatalog().getCategories()) {
            for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                this.addURLContent(catalogTexture.getImage(), hashSet);
            }
        }
        return hashSet;
    }

    private void addURLContent(Content content, Set<URLContent> set) {
        if (content instanceof URLContent) {
            set.add((URLContent)content);
        }
    }
}

