-- EFL LuaJIT bindings: elm_pan.eo (class Elm.Pan)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_pan_class_get()
    eo.class_register("Elm_Pan", {"Efl_Canvas_Group_Clipped"}, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_pan_class_get(void);
    void elm_obj_pan_gravity_set(double x, double y);
    void elm_obj_pan_gravity_get(double *x, double *y);
    void elm_obj_pan_pos_set(Evas_Coord x, Evas_Coord y);
    void elm_obj_pan_pos_get(Evas_Coord *x, Evas_Coord *y);
    void elm_obj_pan_content_size_get(Evas_Coord *w, Evas_Coord *h);
    void elm_obj_pan_pos_min_get(Evas_Coord *x, Evas_Coord *y);
    void elm_obj_pan_pos_max_get(Evas_Coord *x, Evas_Coord *y);
    extern const Eo_Event_Description _ELM_PAN_EVENT_CHANGED;
]]

__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    gravity_set = function(self, x, y)
        eo.__do_start(self, __class)
        __lib.elm_obj_pan_gravity_set(x, y)
        eo.__do_end()
    end,

    gravity_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("double[1]")
        local y = ffi.new("double[1]")
        __lib.elm_obj_pan_gravity_get(x, y)
        eo.__do_end()
        return tonumber(x[0]), tonumber(y[0])
    end,

    pos_set = function(self, x, y)
        eo.__do_start(self, __class)
        __lib.elm_obj_pan_pos_set(x, y)
        eo.__do_end()
    end,

    pos_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("Evas_Coord[1]")
        local y = ffi.new("Evas_Coord[1]")
        __lib.elm_obj_pan_pos_get(x, y)
        eo.__do_end()
        return x[0], y[0]
    end,

    content_size_get = function(self)
        eo.__do_start(self, __class)
        local w = ffi.new("Evas_Coord[1]")
        local h = ffi.new("Evas_Coord[1]")
        __lib.elm_obj_pan_content_size_get(w, h)
        eo.__do_end()
        return w[0], h[0]
    end,

    pos_min_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("Evas_Coord[1]")
        local y = ffi.new("Evas_Coord[1]")
        __lib.elm_obj_pan_pos_min_get(x, y)
        eo.__do_end()
        return x[0], y[0]
    end,

    pos_max_get = function(self)
        eo.__do_start(self, __class)
        local x = ffi.new("Evas_Coord[1]")
        local y = ffi.new("Evas_Coord[1]")
        __lib.elm_obj_pan_pos_max_get(x, y)
        eo.__do_end()
        return x[0], y[0]
    end,

    __events = {
        ["changed"] = __lib._ELM_PAN_EVENT_CHANGED
    },

    __properties = {
        ["content_size"] = { 0, 0, 2, 0, true, false },
        ["pos"] = { 0, 0, 2, 2, true, true },
        ["pos_max"] = { 0, 0, 2, 0, true, false },
        ["gravity"] = { 0, 0, 2, 2, true, true },
        ["pos_min"] = { 0, 0, 2, 0, true, false }
    }
}

M.Pan = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_Pan").__eo_ctor,
                            1, ...)
end

return M
