# -*- coding: utf-8 -*-
#
# Copyright (C) 2007-2016 Red Hat, Inc.
# Authors:
# Thomas Woerner <twoerner@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from __future__ import absolute_import

# translation
import locale
try:
    locale.setlocale(locale.LC_ALL, "")
except locale.Error:
    import os
    os.environ['LC_ALL'] = 'C'
    locale.setlocale(locale.LC_ALL, "")

DOMAIN = 'firewalld'
import gettext
gettext.install(domain=DOMAIN)

from . import dbus

# configuration
DAEMON_NAME = 'firewalld'
CONFIG_NAME = 'firewall-config'
APPLET_NAME = 'firewall-applet'
DATADIR = '/usr/share/' + DAEMON_NAME
CONFIG_GLADE_NAME = CONFIG_NAME + '.glade'
COPYRIGHT = '(C) 2010-2016 Red Hat, Inc.'
VERSION = '0.4.4.3'
AUTHORS = [
    "Thomas Woerner <twoerner@redhat.com>",
    "Jiri Popelka <jpopelka@redhat.com>",
    ]
LICENSE = _(
    "This program is free software; you can redistribute it and/or modify "
    "it under the terms of the GNU General Public License as published by "
    "the Free Software Foundation; either version 2 of the License, or "
    "(at your option) any later version.\n"
    "\n"
    "This program is distributed in the hope that it will be useful, "
    "but WITHOUT ANY WARRANTY; without even the implied warranty of "
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
    "GNU General Public License for more details.\n"
    "\n"
    "You should have received a copy of the GNU General Public License "
    "along with this program.  If not, see <http://www.gnu.org/licenses/>.")
WEBSITE = 'http://www.firewalld.org'

ETC_FIREWALLD = '/etc/firewalld'
FIREWALLD_CONF = ETC_FIREWALLD + '/firewalld.conf'
ETC_FIREWALLD_ZONES = ETC_FIREWALLD + '/zones'
ETC_FIREWALLD_SERVICES = ETC_FIREWALLD + '/services'
ETC_FIREWALLD_ICMPTYPES = ETC_FIREWALLD + '/icmptypes'
ETC_FIREWALLD_IPSETS = ETC_FIREWALLD + '/ipsets'
ETC_FIREWALLD_HELPERS = ETC_FIREWALLD + '/helpers'

USR_LIB_FIREWALLD = '/usr/lib/firewalld'
FIREWALLD_ZONES = USR_LIB_FIREWALLD + '/zones'
FIREWALLD_SERVICES = USR_LIB_FIREWALLD + '/services'
FIREWALLD_ICMPTYPES = USR_LIB_FIREWALLD + '/icmptypes'
FIREWALLD_IPSETS = USR_LIB_FIREWALLD + '/ipsets'
FIREWALLD_HELPERS = USR_LIB_FIREWALLD + '/helpers'

FIREWALLD_LOGFILE = '/var/log/firewalld'

FIREWALLD_PIDFILE = "/var/run/firewalld.pid"

FIREWALLD_TEMPDIR = '/run/firewalld'

FIREWALLD_DIRECT = ETC_FIREWALLD + '/direct.xml'

LOCKDOWN_WHITELIST = ETC_FIREWALLD + '/lockdown-whitelist.xml'

SYSCONFIGDIR = '/etc/conf.d'
IFCFGDIR = SYSCONFIGDIR + '/network-scripts'

SYSCTL_CONFIG = '/etc/sysctl.conf'

# commands used by backends
COMMANDS = {
    "ipv4":         "/usr/bin/iptables",
    "ipv4-restore": "/usr/bin/iptables-restore",
    "ipv6":         "/usr/bin/ip6tables",
    "ipv6-restore": "/usr/bin/ip6tables-restore",
    "eb":           "/usr/bin/ebtables",
    "eb-restore":   "/usr/bin/ebtables-restore",
    "ipset":        "/usr/bin/ipset",
    "modinfo":      "/usr/bin/modinfo",
    "modprobe":     "/usr/bin/modprobe",
    "rmmod":        "/usr/bin/rmmod",
}

LOG_DENIED_VALUES = [ "all", "unicast", "broadcast", "multicast", "off" ]
AUTOMATIC_HELPERS_VALUES = [ "yes", "no", "system" ]

# fallbacks: will be overloaded by firewalld.conf
FALLBACK_ZONE = "public"
FALLBACK_MINIMAL_MARK = 100
FALLBACK_CLEANUP_ON_EXIT = True
FALLBACK_LOCKDOWN = False
FALLBACK_IPV6_RPFILTER = True
FALLBACK_INDIVIDUAL_CALLS = False
FALLBACK_LOG_DENIED = "off"
FALLBACK_AUTOMATIC_HELPERS = "system"
