/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh.org.objectweb.asm;

import java.lang.reflect.Method;

public class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int FLOAT = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int ARRAY = 9;
    public static final int OBJECT = 10;
    public static final Type VOID_TYPE = new Type(0);
    public static final Type BOOLEAN_TYPE = new Type(1);
    public static final Type CHAR_TYPE = new Type(2);
    public static final Type BYTE_TYPE = new Type(3);
    public static final Type SHORT_TYPE = new Type(4);
    public static final Type INT_TYPE = new Type(5);
    public static final Type FLOAT_TYPE = new Type(6);
    public static final Type LONG_TYPE = new Type(7);
    public static final Type DOUBLE_TYPE = new Type(8);
    private final int sort;
    private char[] buf;
    private int off;
    private int len;

    private Type(int n) {
        this.sort = n;
        this.len = 1;
    }

    private Type(int n, char[] cArray, int n2, int n3) {
        this.sort = n;
        this.buf = cArray;
        this.off = n2;
        this.len = n3;
    }

    public static Type getType(String string) {
        return Type.getType(string.toCharArray(), 0);
    }

    public static Type getType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            return LONG_TYPE;
        }
        return Type.getType(Type.getDescriptor(clazz));
    }

    public static Type[] getArgumentTypes(String string) {
        char c;
        char[] cArray = string.toCharArray();
        int n = 1;
        int n2 = 0;
        while ((c = cArray[n++]) != ')') {
            if (c == 'L') {
                while (cArray[n++] != ';') {
                }
                ++n2;
                continue;
            }
            if (c == '[') continue;
            ++n2;
        }
        Type[] typeArray = new Type[n2];
        n = 1;
        n2 = 0;
        while (cArray[n] != ')') {
            typeArray[n2] = Type.getType(cArray, n);
            n += typeArray[n2].len;
            ++n2;
        }
        return typeArray;
    }

    public static Type[] getArgumentTypes(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        Type[] typeArray = new Type[classArray.length];
        for (int i = classArray.length - 1; i >= 0; --i) {
            typeArray[i] = Type.getType(classArray[i]);
        }
        return typeArray;
    }

    public static Type getReturnType(String string) {
        char[] cArray = string.toCharArray();
        return Type.getType(cArray, string.indexOf(41) + 1);
    }

    public static Type getReturnType(Method method) {
        return Type.getType(method.getReturnType());
    }

    private static Type getType(char[] cArray, int n) {
        switch (cArray[n]) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                int n2 = 1;
                while (cArray[n + n2] == '[') {
                    ++n2;
                }
                if (cArray[n + n2] == 'L') {
                    ++n2;
                    while (cArray[n + n2] != ';') {
                        ++n2;
                    }
                }
                return new Type(9, cArray, n, n2 + 1);
            }
        }
        int n3 = 1;
        while (cArray[n + n3] != ';') {
            ++n3;
        }
        return new Type(10, cArray, n, n3 + 1);
    }

    public int getSort() {
        return this.sort;
    }

    public int getDimensions() {
        int n = 1;
        while (this.buf[this.off + n] == '[') {
            ++n;
        }
        return n;
    }

    public Type getElementType() {
        return Type.getType(this.buf, this.off + this.getDimensions());
    }

    public String getClassName() {
        return new String(this.buf, this.off + 1, this.len - 2).replace('/', '.');
    }

    public String getInternalName() {
        return new String(this.buf, this.off + 1, this.len - 2);
    }

    public String getDescriptor() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getDescriptor(stringBuilder);
        return stringBuilder.toString();
    }

    public static String getMethodDescriptor(Type type, Type[] typeArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i].getDescriptor(stringBuilder);
        }
        stringBuilder.append(')');
        type.getDescriptor(stringBuilder);
        return stringBuilder.toString();
    }

    private void getDescriptor(StringBuilder stringBuilder) {
        switch (this.sort) {
            case 0: {
                stringBuilder.append('V');
                return;
            }
            case 1: {
                stringBuilder.append('Z');
                return;
            }
            case 2: {
                stringBuilder.append('C');
                return;
            }
            case 3: {
                stringBuilder.append('B');
                return;
            }
            case 4: {
                stringBuilder.append('S');
                return;
            }
            case 5: {
                stringBuilder.append('I');
                return;
            }
            case 6: {
                stringBuilder.append('F');
                return;
            }
            case 7: {
                stringBuilder.append('J');
                return;
            }
            case 8: {
                stringBuilder.append('D');
                return;
            }
        }
        stringBuilder.append(this.buf, this.off, this.len);
    }

    public static String getInternalName(Class clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String getDescriptor(Class clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Type.getDescriptor(stringBuilder, clazz);
        return stringBuilder.toString();
    }

    public static String getMethodDescriptor(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            Type.getDescriptor(stringBuilder, classArray[i]);
        }
        stringBuilder.append(')');
        Type.getDescriptor(stringBuilder, method.getReturnType());
        return stringBuilder.toString();
    }

    private static void getDescriptor(StringBuilder stringBuilder, Class clazz) {
        Class<?> clazz2 = clazz;
        while (true) {
            if (clazz2.isPrimitive()) {
                int n = clazz2 == Integer.TYPE ? 73 : (clazz2 == Void.TYPE ? 86 : (clazz2 == Boolean.TYPE ? 90 : (clazz2 == Byte.TYPE ? 66 : (clazz2 == Character.TYPE ? 67 : (clazz2 == Short.TYPE ? 83 : (clazz2 == Double.TYPE ? 68 : (clazz2 == Float.TYPE ? 70 : 74)))))));
                stringBuilder.append((char)n);
                return;
            }
            if (!clazz2.isArray()) break;
            stringBuilder.append('[');
            clazz2 = clazz2.getComponentType();
        }
        stringBuilder.append('L');
        String string = clazz2.getName();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuilder.append(c == '.' ? (char)'/' : (char)c);
        }
        stringBuilder.append(';');
    }

    public int getSize() {
        return this.sort == 7 || this.sort == 8 ? 2 : 1;
    }

    public int getOpcode(int n) {
        if (n == 46 || n == 79) {
            switch (this.sort) {
                case 0: {
                    return n + 5;
                }
                case 1: 
                case 3: {
                    return n + 6;
                }
                case 2: {
                    return n + 7;
                }
                case 4: {
                    return n + 8;
                }
                case 5: {
                    return n;
                }
                case 6: {
                    return n + 2;
                }
                case 7: {
                    return n + 1;
                }
                case 8: {
                    return n + 3;
                }
            }
            return n + 4;
        }
        switch (this.sort) {
            case 0: {
                return n + 5;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return n;
            }
            case 6: {
                return n + 2;
            }
            case 7: {
                return n + 1;
            }
            case 8: {
                return n + 3;
            }
        }
        return n + 4;
    }
}

