/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ImageryAdjustAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.layer.imagery.TileCoordinateConverter;
import org.openstreetmap.josm.gui.layer.imagery.TilePosition;
import org.openstreetmap.josm.gui.layer.imagery.TileRange;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.WMSLayerImporter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MemoryManager;

public abstract class AbstractTileSourceLayer<T extends AbstractTMSTileSource>
extends ImageryLayer
implements ImageObserver,
TileLoaderListener,
NavigatableComponent.ZoomChangeListener,
ImageryFilterSettings.FilterChangeListener,
TileSourceDisplaySettings.DisplaySettingsChangeListener {
    private static final String PREFERENCE_PREFIX = "imagery.generic";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    private static final Font InfoFont;
    private static List<MenuAddition> menuAdditions;
    public static final IntegerProperty PROP_MIN_ZOOM_LVL;
    public static final IntegerProperty PROP_MAX_ZOOM_LVL;
    public int currentZoomLevel;
    private final AttributionSupport attribution = new AttributionSupport();
    private final TileHolder clickedTileHolder = new TileHolder();
    public static final IntegerProperty ZOOM_OFFSET;
    protected TileCache tileCache;
    protected T tileSource;
    protected TileLoader tileLoader;
    private final Timer invalidateLaterTimer = new Timer(100, actionEvent -> this.invalidate());
    private final MouseAdapter adapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!AbstractTileSourceLayer.this.isVisible()) {
                return;
            }
            if (mouseEvent.getButton() == 3) {
                AbstractTileSourceLayer.this.clickedTileHolder.setTile(AbstractTileSourceLayer.this.getTileForPixelpos(mouseEvent.getX(), mouseEvent.getY()));
                new TileSourceLayerPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getButton() == 1) {
                AbstractTileSourceLayer.this.attribution.handleAttribution(mouseEvent.getPoint(), true);
            }
        }
    };
    private final TileSourceDisplaySettings displaySettings = this.createDisplaySettings();
    private final ImageryAdjustAction adjustAction = new ImageryAdjustAction(this);
    private TileCoordinateConverter coordinateConverter;
    private final TileSet nullTileSet = new TileSet();

    public AbstractTileSourceLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.setBackgroundLayer(true);
        this.setVisible(true);
        this.getFilterSettings().addFilterChangeListener(this);
        this.getDisplaySettings().addSettingsChangeListener(this);
    }

    protected TileSourceDisplaySettings createDisplaySettings() {
        return new TileSourceDisplaySettings();
    }

    public TileSourceDisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    @Override
    public void filterChanged() {
        this.invalidate();
    }

    protected abstract TileLoaderFactory getTileLoaderFactory();

    protected abstract T getTileSource();

    protected Map<String, String> getHeaders(T t) {
        if (t instanceof TemplatedTileSource) {
            return ((TemplatedTileSource)t).getHeaders();
        }
        return null;
    }

    protected void initTileSource(T t) {
        Map<String, String> map;
        block4: {
            this.coordinateConverter = new TileCoordinateConverter(Main.map.mapView, (TileSource)t, this.getDisplaySettings());
            this.attribution.initialize((Attributed)t);
            this.currentZoomLevel = this.getBestZoom();
            map = this.getHeaders(t);
            this.tileLoader = this.getTileLoaderFactory().makeTileLoader(this, map);
            try {
                if ("file".equalsIgnoreCase(new URL(((AbstractTMSTileSource)t).getBaseUrl()).getProtocol())) {
                    this.tileLoader = new OsmTileLoader(this);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!Main.isDebugEnabled()) break block4;
                Main.debug(malformedURLException.getMessage());
            }
        }
        if (this.tileLoader == null) {
            this.tileLoader = new OsmTileLoader(this, map);
        }
        this.tileCache = new MemoryTileCache(this.estimateTileCacheSize());
    }

    @Override
    public synchronized void tileLoadingFinished(Tile tile, boolean bl) {
        if (tile.hasError()) {
            bl = false;
            tile.setImage(null);
        }
        tile.setLoaded(bl);
        this.invalidateLater();
        if (Main.isDebugEnabled()) {
            Main.debug("tileLoadingFinished() tile: " + tile + " success: " + bl);
        }
    }

    public void clearTileCache() {
        if (this.tileLoader instanceof CachedTileLoader) {
            ((CachedTileLoader)((Object)this.tileLoader)).clearCache((TileSource)this.tileSource);
        }
        this.tileCache.clear();
    }

    protected void redraw() {
        this.invalidate();
    }

    @Override
    @Deprecated
    public double getDx() {
        return this.getDisplaySettings().getDx();
    }

    @Override
    @Deprecated
    public double getDy() {
        return this.getDisplaySettings().getDy();
    }

    @Override
    @Deprecated
    public void displace(double d, double d2) {
        this.getDisplaySettings().addDisplacement(new EastNorth(d, d2));
    }

    @Override
    @Deprecated
    public void setOffset(double d, double d2) {
        this.getDisplaySettings().setDisplacement(new EastNorth(d, d2));
    }

    @Override
    public Object getInfoComponent() {
        JPanel jPanel = (JPanel)super.getInfoComponent();
        EastNorth eastNorth = this.getDisplaySettings().getDisplacement();
        if (eastNorth.distanceSq(0.0, 0.0) > 1.0E-10) {
            jPanel.add((Component)new JLabel(I18n.tr("Offset: ", new Object[0]) + eastNorth.east() + ';' + eastNorth.north()), GBC.eol().insets(0, 5, 10, 0));
        }
        return jPanel;
    }

    @Override
    protected Action getAdjustAction() {
        return this.adjustAction;
    }

    private double getScaleFactor(int n) {
        if (this.coordinateConverter != null) {
            return this.coordinateConverter.getScaleFactor(n);
        }
        return 1.0;
    }

    protected int getBestZoom() {
        double d = this.getScaleFactor(1);
        double d2 = Math.log(d) / Math.log(2.0) / 2.0;
        int n = (int)Math.round(d2 + 1.0 + (double)ZOOM_OFFSET.get().intValue() / 1.9);
        n = Math.min(n, this.getMaxZoomLvl());
        n = Math.max(n, this.getMinZoomLvl());
        return n;
    }

    private static boolean actionSupportLayers(List<Layer> list) {
        return list.size() == 1 && list.get(0) instanceof TMSLayer;
    }

    @Override
    public void hookUpMapView() {
        this.initializeIfRequired();
        super.hookUpMapView();
    }

    @Override
    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
        this.initializeIfRequired();
        mapViewEvent.getMapView().addMouseListener(this.adapter);
        MapView.addZoomChangeListener(this);
        if (this instanceof NativeScaleLayer) {
            mapViewEvent.getMapView().setNativeScaleLayer((NativeScaleLayer)((Object)this));
        }
        mapViewEvent.getMapView().repaint(500L);
        return super.attachToMapView(mapViewEvent);
    }

    private void initializeIfRequired() {
        if (this.tileSource == null) {
            this.tileSource = this.getTileSource();
            if (this.tileSource == null) {
                throw new IllegalArgumentException(I18n.tr("Failed to create tile source", new Object[0]));
            }
            this.projectionChanged(null, Main.getProjection());
            this.initTileSource(this.tileSource);
        }
    }

    @Override
    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent mapViewEvent) {
        return new TileSourcePainter();
    }

    protected int estimateTileCacheSize() {
        Dimension dimension = GuiHelper.getMaximumScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        int n3 = 256;
        if (this.tileSource != null) {
            n3 = ((AbstractTMSTileSource)this.tileSource).getTileSize();
        }
        int n4 = (int)(Math.ceil((double)n / (double)n3 + 1.0) * Math.ceil((double)n2 / (double)n3 + 1.0));
        int n5 = (int)Math.ceil(Math.pow(2.0, ZOOM_OFFSET.get().intValue()) * (double)n4 * 4.0);
        Main.info("AbstractTileSourceLayer: estimated visible tiles: {0}, estimated cache size: {1}", n4, n5);
        return n5;
    }

    @Override
    public void displaySettingsChanged(TileSourceDisplaySettings.DisplaySettingsChangeEvent displaySettingsChangeEvent) {
        if (this.tileSource == null) {
            return;
        }
        switch (displaySettingsChangeEvent.getChangedSetting()) {
            case "automatically-change-resolution": {
                if (!this.getDisplaySettings().isAutoZoom() || this.getBestZoom() == this.currentZoomLevel) break;
                this.setZoomLevel(this.getBestZoom());
                this.invalidate();
                break;
            }
            case "automatic-downloading": {
                if (!this.getDisplaySettings().isAutoLoad()) break;
                this.invalidate();
                break;
            }
            default: {
                this.invalidate();
            }
        }
    }

    public static int checkMaxZoomLvl(int n, TileSource tileSource) {
        if (n > 30) {
            n = 30;
        }
        if (n < PROP_MIN_ZOOM_LVL.get()) {
            n = PROP_MIN_ZOOM_LVL.get();
        }
        if (tileSource != null && tileSource.getMaxZoom() != 0 && tileSource.getMaxZoom() < n) {
            n = tileSource.getMaxZoom();
        }
        return n;
    }

    public static int checkMinZoomLvl(int n, TileSource tileSource) {
        if (n < 2) {
            n = 2;
        }
        if (n > PROP_MAX_ZOOM_LVL.get()) {
            n = AbstractTileSourceLayer.getMaxZoomLvl(tileSource);
        }
        if (tileSource != null && tileSource.getMinZoom() > n) {
            n = tileSource.getMinZoom();
        }
        return n;
    }

    public static int getMaxZoomLvl(TileSource tileSource) {
        return AbstractTileSourceLayer.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), tileSource);
    }

    public static int getMinZoomLvl(TileSource tileSource) {
        return AbstractTileSourceLayer.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), tileSource);
    }

    public static void setMaxZoomLvl(int n) {
        PROP_MAX_ZOOM_LVL.put(AbstractTileSourceLayer.checkMaxZoomLvl(n, null));
    }

    public static void setMinZoomLvl(int n) {
        PROP_MIN_ZOOM_LVL.put(AbstractTileSourceLayer.checkMinZoomLvl(n, null));
    }

    @Override
    public void zoomChanged() {
        if (Main.isDebugEnabled()) {
            Main.debug("zoomChanged(): " + this.currentZoomLevel);
        }
        if (this.tileLoader instanceof TMSCachedTileLoader) {
            ((TMSCachedTileLoader)this.tileLoader).cancelOutstandingTasks();
        }
        this.invalidate();
    }

    protected int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return AbstractTileSourceLayer.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return AbstractTileSourceLayer.getMaxZoomLvl(this.tileSource);
    }

    protected int getMinZoomLvl() {
        if (this.info.getMinZoom() != 0) {
            return AbstractTileSourceLayer.checkMinZoomLvl(this.info.getMinZoom(), this.tileSource);
        }
        return AbstractTileSourceLayer.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean bl;
        boolean bl2 = bl = this.currentZoomLevel < this.getMaxZoomLvl();
        if (Main.isDebugEnabled()) {
            Main.debug("zoomIncreaseAllowed(): " + bl + ' ' + this.currentZoomLevel + " vs. " + this.getMaxZoomLvl());
        }
        return bl;
    }

    public boolean increaseZoomLevel() {
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
            if (Main.isDebugEnabled()) {
                Main.debug("increasing zoom level to: " + this.currentZoomLevel);
            }
        } else {
            Main.warn("Current zoom level (" + this.currentZoomLevel + ") could not be increased. Max.zZoom Level " + this.getMaxZoomLvl() + " reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean setZoomLevel(int n) {
        if (n == this.currentZoomLevel) {
            return true;
        }
        if (n > this.getMaxZoomLvl()) {
            return false;
        }
        if (n < this.getMinZoomLvl()) {
            return false;
        }
        this.currentZoomLevel = n;
        this.zoomChanged();
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        boolean bl;
        boolean bl2 = bl = this.currentZoomLevel > this.getMinZoomLvl();
        if (Main.isDebugEnabled()) {
            Main.debug("zoomDecreaseAllowed(): " + bl + ' ' + this.currentZoomLevel + " vs. " + this.getMinZoomLvl());
        }
        return bl;
    }

    public boolean decreaseZoomLevel() {
        if (this.zoomDecreaseAllowed()) {
            if (Main.isDebugEnabled()) {
                Main.debug("decreasing zoom level to: " + this.currentZoomLevel);
            }
            --this.currentZoomLevel;
        } else {
            return false;
        }
        this.zoomChanged();
        return true;
    }

    private Tile tempCornerTile(Tile tile) {
        int n;
        int n2;
        int n3 = tile.getXtile() + 1;
        Tile tile2 = this.getTile(n3, n2 = tile.getYtile() + 1, n = tile.getZoom());
        if (tile2 != null) {
            return tile2;
        }
        return new Tile((TileSource)this.tileSource, n3, n2, n);
    }

    private Tile getOrCreateTile(TilePosition tilePosition) {
        return this.getOrCreateTile(tilePosition.getX(), tilePosition.getY(), tilePosition.getZoom());
    }

    private Tile getOrCreateTile(int n, int n2, int n3) {
        Tile tile = this.getTile(n, n2, n3);
        if (tile == null) {
            tile = new Tile((TileSource)this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
        }
        if (!tile.isLoaded()) {
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        return tile;
    }

    private Tile getTile(TilePosition tilePosition) {
        return this.getTile(tilePosition.getX(), tilePosition.getY(), tilePosition.getZoom());
    }

    private Tile getTile(int n, int n2, int n3) {
        if (n < ((AbstractTMSTileSource)this.tileSource).getTileXMin(n3) || n > ((AbstractTMSTileSource)this.tileSource).getTileXMax(n3) || n2 < ((AbstractTMSTileSource)this.tileSource).getTileYMin(n3) || n2 > ((AbstractTMSTileSource)this.tileSource).getTileYMax(n3)) {
            return null;
        }
        return this.tileCache.getTile((TileSource)this.tileSource, n, n2, n3);
    }

    private boolean loadTile(Tile tile, boolean bl) {
        if (tile == null) {
            return false;
        }
        if (!bl && (tile.isLoaded() || tile.hasError())) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        this.tileLoader.createTileLoaderJob(tile).submit(bl);
        return true;
    }

    private TileSet getVisibleTileSet() {
        ProjectionBounds projectionBounds = Main.map.mapView.getState().getViewArea().getProjectionBounds();
        return this.getTileSet(projectionBounds.getMin(), projectionBounds.getMax(), this.currentZoomLevel);
    }

    protected void loadAllTiles(boolean bl) {
        TileSet tileSet = this.getVisibleTileSet();
        if (tileSet.tooLarge()) {
            Main.warn("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        tileSet.loadAllTiles(bl);
        this.invalidate();
    }

    protected void loadAllErrorTiles(boolean bl) {
        TileSet tileSet = this.getVisibleTileSet();
        tileSet.loadAllErrorTiles(bl);
        this.invalidate();
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2 = bl = (n & 0x70) != 0;
        if (Main.isDebugEnabled()) {
            Main.debug("imageUpdate() done: " + bl + " calling repaint");
        }
        if (bl) {
            this.invalidate();
        } else {
            this.invalidateLater();
        }
        return !bl;
    }

    private void invalidateLater() {
        GuiHelper.runInEDT(() -> {
            if (!this.invalidateLaterTimer.isRunning()) {
                this.invalidateLaterTimer.setRepeats(false);
                this.invalidateLaterTimer.start();
            }
        });
    }

    private boolean imageLoaded(Image image) {
        if (image == null) {
            return false;
        }
        int n = Toolkit.getDefaultToolkit().checkImage(image, -1, -1, this);
        return (n & 0x20) != 0;
    }

    private Image getLoadedTileImage(Tile tile) {
        BufferedImage bufferedImage = tile.getImage();
        if (!this.imageLoaded(bufferedImage)) {
            return null;
        }
        return bufferedImage;
    }

    private void drawImageInside(Graphics graphics, Image image, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = rectangle2D;
        if (rectangle2D2 != null) {
            rectangle2D3 = rectangle2D.createIntersection(rectangle2D2);
            if (Main.isDebugEnabled()) {
                Main.debug("source: " + rectangle2D + "\nborder: " + rectangle2D2 + "\nintersection: " + rectangle2D3);
            }
        }
        double d = (double)image.getHeight(this) / rectangle2D.getHeight();
        double d2 = (double)image.getWidth(this) / rectangle2D.getWidth();
        double d3 = rectangle2D3.getX() - rectangle2D.getX();
        double d4 = rectangle2D3.getY() - rectangle2D.getY();
        int n = (int)(d3 * d2 + 0.5);
        int n2 = (int)(d4 * d + 0.5);
        int n3 = n + (int)(rectangle2D3.getWidth() * d2 + 0.5);
        int n4 = n2 + (int)(rectangle2D3.getHeight() * d + 0.5);
        if (Main.isDebugEnabled()) {
            Main.debug("drawing image into target rect: " + rectangle2D3);
        }
        graphics.drawImage(image, (int)rectangle2D3.getX(), (int)rectangle2D3.getY(), (int)rectangle2D3.getMaxX(), (int)rectangle2D3.getMaxY(), n, n2, n3, n4, this);
    }

    private List<Tile> paintTileImages(Graphics graphics, TileSet tileSet) {
        Object object = new Object();
        List list = Collections.synchronizedList(new ArrayList());
        tileSet.visitTiles(tile -> {
            Image image = this.getLoadedTileImage((Tile)tile);
            if (image == null) {
                list.add(new TilePosition((Tile)tile));
                return;
            }
            image = this.applyImageProcessors((BufferedImage)image);
            Rectangle2D rectangle2D = this.coordinateConverter.getRectangleForTile((Tile)tile);
            Object object2 = object;
            synchronized (object2) {
                this.drawImageInside(graphics, image, rectangle2D, null);
            }
        }, list::add);
        return list.stream().map(this::getOrCreateTile).collect(Collectors.toList());
    }

    private List<Tile> paintTileImages(Graphics graphics, TileSet tileSet, int n, Tile tile) {
        if (n <= 0) {
            return Collections.emptyList();
        }
        Rectangle2D rectangle2D = this.coordinateConverter.getRectangleForTile(tile);
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        for (Tile tile2 : tileSet.allTilesCreate()) {
            Image image = this.getLoadedTileImage(tile2);
            if (image == null || tile2.hasError()) {
                if (Main.isDebugEnabled()) {
                    Main.debug("missed tile: " + tile2);
                }
                linkedList.add(tile2);
                continue;
            }
            image = this.applyImageProcessors((BufferedImage)image);
            Rectangle2D rectangle2D2 = this.coordinateConverter.getRectangleForTile(tile2);
            if (!rectangle2D2.intersects(rectangle2D)) continue;
            this.drawImageInside(graphics, image, rectangle2D2, rectangle2D);
        }
        return linkedList;
    }

    private void myDrawString(Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        String string2 = string;
        if (graphics.getFontMetrics().stringWidth(string) > ((AbstractTMSTileSource)this.tileSource).getTileSize()) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            String[] stringArray = string.split(" ");
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                String string3 = stringArray[i];
                if (graphics.getFontMetrics().stringWidth(stringBuilder.toString() + string3) > ((AbstractTMSTileSource)this.tileSource).getTileSize()) {
                    stringBuilder2.append((CharSequence)stringBuilder).append('\n');
                    stringBuilder.setLength(0);
                }
                stringBuilder.append(string3).append(' ');
            }
            stringBuilder2.append((CharSequence)stringBuilder);
            string2 = stringBuilder2.toString();
        }
        int n4 = 0;
        for (String string4 : string2.split("\n")) {
            graphics.setColor(Color.black);
            graphics.drawString(string4, n + 1, n2 + n4 + 1);
            graphics.setColor(color);
            graphics.drawString(string4, n, n2 + n4);
            n4 += graphics.getFontMetrics().getHeight() + 3;
        }
    }

    private void paintTileText(TileSet tileSet, Tile tile, Graphics graphics, MapView mapView, int n, Tile tile2) {
        if (tile == null) {
            return;
        }
        Point2D point2D = this.coordinateConverter.getPixelForTile(tile2);
        int n2 = graphics.getFontMetrics().getHeight();
        int n3 = (int)point2D.getX();
        int n4 = (int)point2D.getY();
        int n5 = n4 + 2 + n2;
        if (tile.hasError() && this.getDisplaySettings().isShowErrors()) {
            this.myDrawString(graphics, I18n.tr("Error", new Object[0]) + ": " + I18n.tr(tile.getErrorMessage(), new Object[0]), n3 + 2, n5);
        }
        int n6 = -1;
        int n7 = -1;
        if (Main.isDebugEnabled()) {
            if (n7 < tile2.getYtile()) {
                if (Math.abs(tile2.getYtile() % 32) == 31) {
                    graphics.fillRect(0, n4 - 1, mapView.getWidth(), 3);
                } else {
                    graphics.drawLine(0, n4, mapView.getWidth(), n4);
                }
            }
            if (n6 < tile2.getXtile()) {
                if (tile2.getXtile() % 32 == 0) {
                    graphics.fillRect(n3 - 1, 0, 3, mapView.getHeight());
                } else {
                    graphics.drawLine(n3, 0, n3, mapView.getHeight());
                }
            }
        }
    }

    private LatLon getShiftedLatLon(EastNorth eastNorth) {
        return this.coordinateConverter.getProjecting().eastNorth2latlonClamped(eastNorth);
    }

    private ICoordinate getShiftedCoord(EastNorth eastNorth) {
        return this.getShiftedLatLon(eastNorth).toCoordinate();
    }

    private LatLon getShiftedLatLon(ICoordinate iCoordinate) {
        return this.getShiftedLatLon(Main.getProjection().latlon2eastNorth(new LatLon(iCoordinate)));
    }

    protected TileSet getTileSet(EastNorth eastNorth, EastNorth eastNorth2, int n) {
        return this.getTileSet(this.getShiftedLatLon(eastNorth), this.getShiftedLatLon(eastNorth2), n);
    }

    protected TileSet getTileSet(LatLon latLon, LatLon latLon2, int n) {
        if (n == 0) {
            return new TileSet();
        }
        TileXY tileXY = ((AbstractTMSTileSource)this.tileSource).latLonToTileXY(latLon.toCoordinate(), n);
        TileXY tileXY2 = ((AbstractTMSTileSource)this.tileSource).latLonToTileXY(latLon2.toCoordinate(), n);
        return new TileSet(tileXY, tileXY2, n);
    }

    private static <S extends AbstractTMSTileSource> TileSetInfo getTileSetInfo(TileSet tileSet) {
        List list = tileSet.allExistingTiles();
        TileSetInfo tileSetInfo = new TileSetInfo();
        tileSetInfo.hasLoadingTiles = list.size() < tileSet.size();
        tileSetInfo.hasAllLoadedTiles = true;
        for (Tile tile : list) {
            if ("no-tile".equals(tile.getValue("tile-info"))) {
                tileSetInfo.hasOverzoomedTiles = true;
            }
            if (tile.isLoaded()) {
                if (tile.hasError()) continue;
                tileSetInfo.hasVisibleTiles = true;
                continue;
            }
            tileSetInfo.hasAllLoadedTiles = false;
            if (!tile.isLoading()) continue;
            tileSetInfo.hasLoadingTiles = true;
        }
        return tileSetInfo;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
    }

    private void drawInViewArea(Graphics2D graphics2D, MapView mapView, ProjectionBounds projectionBounds) {
        LinkedList<Tile> linkedList;
        int n = this.currentZoomLevel;
        if (this.getDisplaySettings().isAutoZoom()) {
            n = this.getBestZoom();
        }
        DeepTileSet deepTileSet = new DeepTileSet(projectionBounds, this.getMinZoomLvl(), n);
        TileSet tileSet = deepTileSet.getTileSet(n);
        int n2 = n;
        boolean bl = false;
        if (this.getDisplaySettings().isAutoZoom() && this.getDisplaySettings().isAutoLoad()) {
            linkedList = deepTileSet.getTileSetInfo(n);
            if (!(((TileSetInfo)((Object)linkedList)).hasVisibleTiles || ((TileSetInfo)((Object)linkedList)).hasLoadingTiles && !((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles)) {
                bl = true;
            }
            for (int i = n; i > deepTileSet.minZoom; --i) {
                if (!deepTileSet.getTileSetInfo((int)i).hasVisibleTiles) continue;
                n2 = i;
                break;
            }
            while (n > n2 && !((TileSetInfo)((Object)linkedList)).hasVisibleTiles && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles) {
                n = (n + n2) / 2;
                linkedList = deepTileSet.getTileSetInfo(n);
            }
            this.setZoomLevel(n);
            if (n == n2 && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles && n < deepTileSet.maxZoom) {
                linkedList = deepTileSet.getTileSetInfo(++n);
            }
            while (n > deepTileSet.minZoom && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles) {
                linkedList = deepTileSet.getTileSetInfo(--n);
            }
            tileSet = deepTileSet.getTileSet(n);
        } else if (this.getDisplaySettings().isAutoZoom()) {
            this.setZoomLevel(n);
        }
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        if (n2 != n) {
            tileSet = deepTileSet.getTileSet(n2);
            if (!deepTileSet.getTileSetInfo((int)n2).hasAllLoadedTiles && n2 < n) {
                tileSet.loadAllTiles(false);
            }
        }
        graphics2D.setColor(Color.DARK_GRAY);
        linkedList = this.paintTileImages(graphics2D, tileSet);
        int[] nArray = new int[]{-1, 1, -2, 2, -3, -4, -5};
        for (int n3 : nArray) {
            if (!this.getDisplaySettings().isAutoZoom()) break;
            int n4 = n2 + n3;
            if (n4 < this.getMinZoomLvl() || n4 > this.getMaxZoomLvl()) continue;
            if (linkedList.isEmpty()) break;
            LinkedList<Tile> linkedList2 = new LinkedList<Tile>();
            for (Tile tile : linkedList) {
                if (n3 > 0 && "no-tile".equals(tile.getValue("tile-info"))) {
                    linkedList2.add(tile);
                    continue;
                }
                Tile tile2 = this.tempCornerTile(tile);
                TileSet tileSet2 = this.getTileSet(this.getShiftedLatLon(((AbstractTMSTileSource)this.tileSource).tileXYToLatLon(tile)), this.getShiftedLatLon(((AbstractTMSTileSource)this.tileSource).tileXYToLatLon(tile2)), n4);
                if (tileSet2.allLoadedTiles().isEmpty()) {
                    linkedList2.add(tile);
                    continue;
                }
                if (tileSet2.tooLarge()) continue;
                linkedList2.addAll(this.paintTileImages(graphics2D, tileSet2, n4, tile));
            }
            linkedList = linkedList2;
        }
        if (Main.isDebugEnabled() && !linkedList.isEmpty()) {
            Main.debug("still missed " + linkedList.size() + " in the end");
        }
        graphics2D.setColor(Color.red);
        graphics2D.setFont(InfoFont);
        Object object = tileSet.allExistingTiles().iterator();
        while (object.hasNext()) {
            Tile tile = (Tile)object.next();
            this.paintTileText(tileSet, tile, graphics2D, mapView, n2, tile);
        }
        object = projectionBounds.getMin();
        EastNorth eastNorth = projectionBounds.getMax();
        this.attribution.paintAttribution(graphics2D, mapView.getWidth(), mapView.getHeight(), this.getShiftedCoord((EastNorth)object), this.getShiftedCoord(eastNorth), n2, this);
        graphics2D.setColor(Color.lightGray);
        if (tileSet.insane()) {
            this.myDrawString(graphics2D, I18n.tr("zoom in to load any tiles", new Object[0]), 120, 120);
        } else if (tileSet.tooLarge()) {
            this.myDrawString(graphics2D, I18n.tr("zoom in to load more tiles", new Object[0]), 120, 120);
        } else if (!this.getDisplaySettings().isAutoZoom() && tileSet.tooSmall()) {
            this.myDrawString(graphics2D, I18n.tr("increase tiles zoom level (change resolution) to see more detail", new Object[0]), 120, 120);
        }
        if (bl) {
            this.myDrawString(graphics2D, I18n.tr("No tiles at this zoom level", new Object[0]), 120, 120);
        }
        if (Main.isDebugEnabled()) {
            this.myDrawString(graphics2D, I18n.tr("Current zoom: {0}", this.currentZoomLevel), 50, 140);
            this.myDrawString(graphics2D, I18n.tr("Display zoom: {0}", n2), 50, 155);
            this.myDrawString(graphics2D, I18n.tr("Pixel scale: {0}", this.getScaleFactor(this.currentZoomLevel)), 50, 170);
            this.myDrawString(graphics2D, I18n.tr("Best zoom: {0}", this.getBestZoom()), 50, 185);
            this.myDrawString(graphics2D, I18n.tr("Estimated cache size: {0}", this.estimateTileCacheSize()), 50, 200);
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                int n5 = 200;
                for (String string : ((TMSCachedTileLoader)this.tileLoader).getStats().split("\n")) {
                    this.myDrawString(graphics2D, I18n.tr("Cache stats: {0}", string), 50, n5 += 15);
                }
            }
        }
    }

    private Tile getTileForPixelpos(int n, int n2) {
        EastNorth eastNorth;
        if (Main.isDebugEnabled()) {
            Main.debug("getTileForPixelpos(" + n + ", " + n2 + ')');
        }
        MapView mapView = Main.map.mapView;
        Point point = new Point(n, n2);
        EastNorth eastNorth2 = mapView.getEastNorth(0, 0);
        TileSet tileSet = this.getTileSet(eastNorth2, eastNorth = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight()), this.currentZoomLevel);
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        Stream<Tile> stream = tileSet.allExistingTiles().stream().filter(tile -> this.coordinateConverter.getRectangleForTile((Tile)tile).contains(point));
        if (Main.isTraceEnabled()) {
            stream = stream.peek(tile -> Main.trace("Clicked on tile: " + tile.getXtile() + ' ' + tile.getYtile() + " currentZoomLevel: " + this.currentZoomLevel));
        }
        return stream.findAny().orElse(null);
    }

    public static void registerMenuAddition(Action action) {
        menuAdditions.add(new MenuAddition(action, AbstractTileSourceLayer.class));
    }

    public static void registerMenuAddition(Action action, Class<? extends AbstractTileSourceLayer<?>> clazz) {
        menuAdditions.add(new MenuAddition(action, clazz));
    }

    private List<Action> getMenuAdditions() {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        for (MenuAddition menuAddition : menuAdditions) {
            if (!menuAddition.clazz.isInstance(this)) continue;
            linkedList.add(menuAddition.addition);
        }
        if (!linkedList.isEmpty()) {
            linkedList.addFirst(Layer.SeparatorLayerAction.INSTANCE);
        }
        return linkedList;
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(this.getLayerListEntries()));
        arrayList.addAll(Arrays.asList(this.getCommonEntries()));
        arrayList.addAll(this.getMenuAdditions());
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new LayerListPopup.InfoAction(this));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public Action[] getLayerListEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE};
    }

    public Action[] getCommonEntries() {
        return new Action[]{new AutoLoadTilesAction(), new AutoZoomAction(), new ShowErrorsAction(), new IncreaseZoomAction(), new DecreaseZoomAction(), new ZoomToBestAction(), new ZoomToNativeLevelAction(), new FlushTileCacheAction(), new LoadErroneusTilesAction(), new LoadAllTilesAction()};
    }

    @Override
    public String getToolTipText() {
        if (this.getDisplaySettings().isAutoLoad()) {
            return I18n.tr("{0} ({1}), automatically downloading in zoom {2}", this.getClass().getSimpleName(), this.getName(), this.currentZoomLevel);
        }
        return I18n.tr("{0} ({1}), downloading in zoom {2}", this.getClass().getSimpleName(), this.getName(), this.currentZoomLevel);
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    public PrecacheTask downloadAreaToCache(ProgressMonitor progressMonitor, List<LatLon> list, double d, double d2) {
        PrecacheTask precacheTask = new PrecacheTask(progressMonitor);
        ConcurrentSkipListSet<Tile> concurrentSkipListSet = new ConcurrentSkipListSet<Tile>((tile, tile2) -> String.CASE_INSENSITIVE_ORDER.compare(tile.getKey(), tile2.getKey()));
        for (LatLon object : list) {
            TileXY tileXY = this.tileSource.latLonToTileXY(object.lat() - d2, object.lon() - d, this.currentZoomLevel);
            TileXY tileXY2 = ((AbstractTMSTileSource)this.tileSource).latLonToTileXY(object.toCoordinate(), this.currentZoomLevel);
            TileXY tileXY3 = this.tileSource.latLonToTileXY(object.lat() + d2, object.lon() + d, this.currentZoomLevel);
            int n = Math.min(tileXY2.getYIndex() - 1, tileXY.getYIndex());
            int n2 = Math.max(tileXY2.getYIndex() + 1, tileXY3.getYIndex());
            int n3 = Math.min(tileXY2.getXIndex() - 1, tileXY.getXIndex());
            int n4 = Math.max(tileXY2.getXIndex() + 1, tileXY3.getXIndex());
            for (int i = n3; i <= n4; ++i) {
                for (int j = n; j <= n2; ++j) {
                    concurrentSkipListSet.add(new Tile((TileSource)this.tileSource, i, j, this.currentZoomLevel));
                }
            }
        }
        precacheTask.totalCount = concurrentSkipListSet.size();
        precacheTask.progressMonitor.setTicksCount(concurrentSkipListSet.size());
        TileLoader tileLoader = precacheTask.getTileLoader();
        for (Tile tile3 : concurrentSkipListSet) {
            tileLoader.createTileLoaderJob(tile3).submit();
        }
        return precacheTask;
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save WMS file", new Object[0]), WMSLayerImporter.FILE_FILTER);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.adjustAction.destroy();
    }

    static {
        new TileSourceDisplaySettings();
        InfoFont = new Font("sansserif", 1, 13);
        menuAdditions = new LinkedList<MenuAddition>();
        PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.generic.min_zoom_lvl", 2);
        PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.generic.max_zoom_lvl", 20);
        ZOOM_OFFSET = new IntegerProperty("imagery.generic.zoom_offset", 0);
    }

    private class TileSourcePainter
    extends AbstractMapViewPaintable.CompatibilityModeLayerPainter {
        private MemoryManager.MemoryHandle<?> memory;

        private TileSourcePainter() {
            super(AbstractTileSourceLayer.this);
        }

        @Override
        public void paint(MapViewGraphics mapViewGraphics) {
            this.allocateCacheMemory();
            if (this.memory != null) {
                this.doPaint(mapViewGraphics);
            }
        }

        private void doPaint(MapViewGraphics mapViewGraphics) {
            AbstractTileSourceLayer.this.drawInViewArea(mapViewGraphics.getDefaultGraphics(), mapViewGraphics.getMapView(), mapViewGraphics.getClipBounds().getProjectionBounds());
        }

        private void allocateCacheMemory() {
            MemoryManager memoryManager;
            if (this.memory == null && (memoryManager = MemoryManager.getInstance()).isAvailable(this.getEstimatedCacheSize())) {
                try {
                    this.memory = memoryManager.allocateMemory("tile source layer", this.getEstimatedCacheSize(), Object::new);
                }
                catch (MemoryManager.NotEnoughMemoryException notEnoughMemoryException) {
                    Main.warn("Could not allocate tile source memory", notEnoughMemoryException);
                }
            }
        }

        protected long getEstimatedCacheSize() {
            return 4L * (long)((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileSize() * (long)((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileSize() * (long)AbstractTileSourceLayer.this.estimateTileCacheSize();
        }

        @Override
        public void detachFromMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
            mapViewEvent.getMapView().removeMouseListener(AbstractTileSourceLayer.this.adapter);
            MapView.removeZoomChangeListener(AbstractTileSourceLayer.this);
            super.detachFromMapView(mapViewEvent);
            if (this.memory != null) {
                this.memory.free();
            }
        }
    }

    public class PrecacheTask
    implements TileLoaderListener {
        private final ProgressMonitor progressMonitor;
        private int totalCount;
        private final AtomicInteger processedCount = new AtomicInteger(0);
        private final TileLoader tileLoader;

        public PrecacheTask(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
            this.tileLoader = AbstractTileSourceLayer.this.getTileLoaderFactory().makeTileLoader(this, AbstractTileSourceLayer.this.getHeaders(AbstractTileSourceLayer.this.tileSource));
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                ((TMSCachedTileLoader)this.tileLoader).setDownloadExecutor(TMSCachedTileLoader.getNewThreadPoolExecutor("Precache downloader"));
            }
        }

        public boolean isFinished() {
            return this.processedCount.get() >= this.totalCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void cancel() {
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                ((TMSCachedTileLoader)this.tileLoader).cancelOutstandingTasks();
            }
        }

        @Override
        public void tileLoadingFinished(Tile tile, boolean bl) {
            int n = this.processedCount.incrementAndGet();
            if (bl) {
                this.progressMonitor.worked(1);
                this.progressMonitor.setCustomText(I18n.tr("Downloaded {0}/{1} tiles", n, this.totalCount));
            } else {
                Main.warn("Tile loading failure: " + tile + " - " + tile.getErrorMessage());
            }
        }

        public TileLoader getTileLoader() {
            return this.tileLoader;
        }
    }

    private static class MenuAddition {
        final Action addition;
        final Class<? extends AbstractTileSourceLayer> clazz;

        MenuAddition(Action action, Class<? extends AbstractTileSourceLayer> clazz) {
            this.addition = action;
            this.clazz = clazz;
        }
    }

    private class DeepTileSet {
        private final ProjectionBounds bounds;
        private final int minZoom;
        private final int maxZoom;
        private final TileSet[] tileSets;
        private final TileSetInfo[] tileSetInfos;

        DeepTileSet(ProjectionBounds projectionBounds, int n, int n2) {
            this.bounds = projectionBounds;
            this.minZoom = n;
            this.maxZoom = n2;
            this.tileSets = new TileSet[n2 - n + 1];
            this.tileSetInfos = new TileSetInfo[n2 - n + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSet getTileSet(int n) {
            if (n < this.minZoom) {
                return AbstractTileSourceLayer.this.nullTileSet;
            }
            TileSet[] tileSetArray = this.tileSets;
            synchronized (this.tileSets) {
                TileSet tileSet = this.tileSets[n - this.minZoom];
                if (tileSet == null) {
                    this.tileSets[n - this.minZoom] = tileSet = AbstractTileSourceLayer.this.getTileSet(this.bounds.getMin(), this.bounds.getMax(), n);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tileSet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSetInfo getTileSetInfo(int n) {
            if (n < this.minZoom) {
                return new TileSetInfo();
            }
            TileSetInfo[] tileSetInfoArray = this.tileSetInfos;
            synchronized (this.tileSetInfos) {
                TileSetInfo tileSetInfo = this.tileSetInfos[n - this.minZoom];
                if (tileSetInfo == null) {
                    this.tileSetInfos[n - this.minZoom] = tileSetInfo = AbstractTileSourceLayer.getTileSetInfo(this.getTileSet(n));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tileSetInfo;
            }
        }
    }

    private static class TileSetInfo {
        boolean hasVisibleTiles;
        boolean hasOverzoomedTiles;
        boolean hasLoadingTiles;
        boolean hasAllLoadedTiles;

        private TileSetInfo() {
        }
    }

    private class TileSet
    extends TileRange {
        protected TileSet(TileXY tileXY, TileXY tileXY2, int n) {
            super(tileXY, tileXY2, n);
            this.sanitize();
        }

        private TileSet() {
        }

        protected void sanitize() {
            if (this.minX < ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMin(this.zoom)) {
                this.minX = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMin(this.zoom);
            }
            if (this.minY < ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMin(this.zoom)) {
                this.minY = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMin(this.zoom);
            }
            if (this.maxX > ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMax(this.zoom)) {
                this.maxX = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMax(this.zoom);
            }
            if (this.maxY > ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMax(this.zoom)) {
                this.maxY = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMax(this.zoom);
            }
        }

        private boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        private boolean tooLarge() {
            return this.insane() || this.tilesSpanned() > 20.0;
        }

        private boolean insane() {
            return AbstractTileSourceLayer.this.tileCache == null || this.size() > AbstractTileSourceLayer.this.tileCache.getCacheSize();
        }

        private List<Tile> allExistingTiles() {
            return this.allTiles(tilePosition -> AbstractTileSourceLayer.this.getTile(tilePosition));
        }

        private List<Tile> allTilesCreate() {
            return this.allTiles(tilePosition -> AbstractTileSourceLayer.this.getOrCreateTile(tilePosition));
        }

        private List<Tile> allTiles(Function<TilePosition, Tile> function) {
            return this.tilePositions().map(function).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Override
        public Stream<TilePosition> tilePositions() {
            if (this.insane()) {
                return Stream.empty();
            }
            return super.tilePositions();
        }

        private List<Tile> allLoadedTiles() {
            return this.allExistingTiles().stream().filter(Tile::isLoaded).collect(Collectors.toList());
        }

        private Comparator<Tile> getTileDistanceComparator() {
            int n = (int)Math.ceil((double)(this.minX + this.maxX) / 2.0);
            int n2 = (int)Math.ceil((double)(this.minY + this.maxY) / 2.0);
            return Comparator.comparingInt(tile -> Math.abs(tile.getXtile() - n) + Math.abs(tile.getYtile() - n2));
        }

        private void loadAllTiles(boolean bl) {
            if (!AbstractTileSourceLayer.this.getDisplaySettings().isAutoLoad() && !bl) {
                return;
            }
            List<Tile> list = this.allTilesCreate();
            list.sort(this.getTileDistanceComparator());
            for (Tile tile : list) {
                AbstractTileSourceLayer.this.loadTile(tile, bl);
            }
        }

        private void loadAllErrorTiles(boolean bl) {
            if (!AbstractTileSourceLayer.this.getDisplaySettings().isAutoLoad() && !bl) {
                return;
            }
            for (Tile tile : this.allTilesCreate()) {
                if (!tile.hasError()) continue;
                AbstractTileSourceLayer.this.tileLoader.createTileLoaderJob(tile).submit(bl);
            }
        }

        public void visitTiles(Consumer<Tile> consumer, Consumer<TilePosition> consumer2) {
            ((Stream)this.tilePositions().parallel()).forEach(tilePosition -> this.visitTilePosition(consumer, (TilePosition)tilePosition, consumer2));
        }

        private void visitTilePosition(Consumer<Tile> consumer, TilePosition tilePosition, Consumer<TilePosition> consumer2) {
            Tile tile = AbstractTileSourceLayer.this.getTile(tilePosition);
            if (tile == null) {
                consumer2.accept(tilePosition);
            } else {
                consumer.accept(tile);
            }
        }

        public String toString() {
            return this.getClass().getName() + ": zoom: " + this.zoom + " X(" + this.minX + ", " + this.maxX + ") Y(" + this.minY + ", " + this.maxY + ") size: " + this.size();
        }
    }

    public class TileSourceLayerPopup
    extends JPopupMenu {
        public TileSourceLayerPopup() {
            for (Action action : AbstractTileSourceLayer.this.getCommonEntries()) {
                if (action instanceof Layer.LayerAction) {
                    this.add(((Layer.LayerAction)((Object)action)).createMenuComponent());
                    continue;
                }
                this.add(new JMenuItem(action));
            }
            this.add(new JSeparator());
            this.add(new JMenuItem(new LoadTileAction()));
            this.add(new JMenuItem(new ShowTileInfoAction()));
        }
    }

    private static final class TileHolder {
        private Tile t;

        private TileHolder() {
        }

        public Tile getTile() {
            return this.t;
        }

        public void setTile(Tile tile) {
            this.t = tile;
        }
    }

    private class FlushTileCacheAction
    extends AbstractAction {
        FlushTileCacheAction() {
            super(I18n.tr("Flush tile cache", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new PleaseWaitRunnable(I18n.tr("Flush tile cache", new Object[0])){

                @Override
                protected void realRun() {
                    AbstractTileSourceLayer.this.clearTileCache();
                }

                @Override
                protected void finish() {
                }

                @Override
                protected void cancel() {
                }
            }.run();
        }
    }

    private class DecreaseZoomAction
    extends AbstractAction {
        DecreaseZoomAction() {
            super(I18n.tr("Decrease zoom", new Object[0]));
            this.setEnabled(!AbstractTileSourceLayer.this.getDisplaySettings().isAutoZoom() && AbstractTileSourceLayer.this.zoomDecreaseAllowed());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.decreaseZoomLevel();
        }
    }

    private class IncreaseZoomAction
    extends AbstractAction {
        IncreaseZoomAction() {
            super(I18n.tr("Increase zoom", new Object[0]));
            this.setEnabled(!AbstractTileSourceLayer.this.getDisplaySettings().isAutoZoom() && AbstractTileSourceLayer.this.zoomIncreaseAllowed());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.increaseZoomLevel();
        }
    }

    private class ZoomToBestAction
    extends AbstractAction {
        ZoomToBestAction() {
            super(I18n.tr("Change resolution", new Object[0]));
            this.setEnabled(!AbstractTileSourceLayer.this.getDisplaySettings().isAutoZoom() && AbstractTileSourceLayer.this.getBestZoom() != AbstractTileSourceLayer.this.currentZoomLevel);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.setZoomLevel(AbstractTileSourceLayer.this.getBestZoom());
        }
    }

    private class ZoomToNativeLevelAction
    extends AbstractAction {
        ZoomToNativeLevelAction() {
            super(I18n.tr("Zoom to native resolution", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d = Math.sqrt(AbstractTileSourceLayer.this.getScaleFactor(AbstractTileSourceLayer.this.currentZoomLevel));
            Main.map.mapView.zoomToFactor(d);
            AbstractTileSourceLayer.this.redraw();
        }
    }

    private class LoadErroneusTilesAction
    extends AbstractAction {
        LoadErroneusTilesAction() {
            super(I18n.tr("Load all error tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.loadAllErrorTiles(true);
        }
    }

    private class LoadAllTilesAction
    extends AbstractAction {
        LoadAllTilesAction() {
            super(I18n.tr("Load all tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.loadAllTiles(true);
        }
    }

    private class ShowErrorsAction
    extends AbstractAction
    implements Layer.LayerAction {
        ShowErrorsAction() {
            super(I18n.tr("Show errors", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.getDisplaySettings().setShowErrors(!AbstractTileSourceLayer.this.getDisplaySettings().isShowErrors());
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(AbstractTileSourceLayer.this.getDisplaySettings().isShowErrors());
            return jCheckBoxMenuItem;
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return AbstractTileSourceLayer.actionSupportLayers(list);
        }
    }

    private class AutoLoadTilesAction
    extends AbstractAction
    implements Layer.LayerAction {
        AutoLoadTilesAction() {
            super(I18n.tr("Auto load tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.getDisplaySettings().setAutoLoad(!AbstractTileSourceLayer.this.getDisplaySettings().isAutoLoad());
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(AbstractTileSourceLayer.this.getDisplaySettings().isAutoLoad());
            return jCheckBoxMenuItem;
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return AbstractTileSourceLayer.actionSupportLayers(list);
        }
    }

    private class AutoZoomAction
    extends AbstractAction
    implements Layer.LayerAction {
        AutoZoomAction() {
            super(I18n.tr("Auto zoom", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.getDisplaySettings().setAutoZoom(!AbstractTileSourceLayer.this.getDisplaySettings().isAutoZoom());
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(AbstractTileSourceLayer.this.getDisplaySettings().isAutoZoom());
            return jCheckBoxMenuItem;
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return AbstractTileSourceLayer.actionSupportLayers(list);
        }
    }

    private final class LoadTileAction
    extends AbstractAction {
        private LoadTileAction() {
            super(I18n.tr("Load tile", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tile tile = AbstractTileSourceLayer.this.clickedTileHolder.getTile();
            if (tile != null) {
                AbstractTileSourceLayer.this.loadTile(tile, true);
                AbstractTileSourceLayer.this.invalidate();
            }
        }
    }

    private final class ShowTileInfoAction
    extends AbstractAction {
        private ShowTileInfoAction() {
            super(I18n.tr("Show tile info", new Object[0]));
        }

        private String getSizeString(int n) {
            return "" + n + 'x' + n;
        }

        private JTextField createTextField(String string) {
            JTextField jTextField = new JTextField(string);
            jTextField.setEditable(false);
            jTextField.setBorder(BorderFactory.createEmptyBorder());
            return jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tile tile = AbstractTileSourceLayer.this.clickedTileHolder.getTile();
            if (tile != null) {
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Tile Info", new Object[0]), I18n.tr("OK", new Object[0]));
                JPanel jPanel = new JPanel(new GridBagLayout());
                Rectangle2D rectangle2D = AbstractTileSourceLayer.this.coordinateConverter.getRectangleForTile(tile);
                String string = "";
                try {
                    string = tile.getUrl();
                }
                catch (IOException iOException) {
                    Main.trace(iOException);
                }
                String[][] stringArrayArray = new String[][]{{"Tile name", tile.getKey()}, {"Tile url", string}, {"Tile size", this.getSizeString(tile.getTileSource().getTileSize())}, {"Tile display size", "" + rectangle2D.getWidth() + 'x' + rectangle2D.getHeight()}};
                for (String[] stringArray : stringArrayArray) {
                    jPanel.add((Component)new JLabel(I18n.tr(stringArray[0], new Object[0]) + ':'), GBC.std());
                    jPanel.add(GBC.glue(5, 0), GBC.std());
                    jPanel.add((Component)this.createTextField(stringArray[1]), GBC.eol().fill(2));
                }
                for (Map.Entry entry : tile.getMetadata().entrySet()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Metadata ", new Object[0]) + I18n.tr((String)entry.getKey(), new Object[0]) + ':'), GBC.std());
                    jPanel.add(GBC.glue(5, 0), GBC.std());
                    String string2 = (String)entry.getValue();
                    if ("lastModification".equals(entry.getKey()) || "expirationTime".equals(entry.getKey())) {
                        string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(Long.parseLong(string2)));
                    }
                    jPanel.add((Component)this.createTextField(string2), GBC.eol().fill(2));
                }
                extendedDialog.setIcon(1);
                extendedDialog.setContent(jPanel);
                extendedDialog.showDialog();
            }
        }
    }
}

