/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.BreakpointLocation;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.ExecutionEvent;
import com.oracle.truffle.api.debug.SuspendedCallback;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.impl.DebuggerInstrument;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Debugger {
    static final boolean TRACE = Boolean.getBoolean("truffle.debug.trace");
    @Deprecated
    public static final String HALT_TAG = "debug-HALT";
    @Deprecated
    public static final String CALL_TAG = "debug-CALL";
    private final PolyglotEngine sourceVM;
    private final TruffleInstrument.Env env;
    private final DebuggerSession legacySession;
    private final Map<BreakpointLocation, Breakpoint> breakpointPerLocation = Collections.synchronizedMap(new HashMap());
    static final AccessorDebug ACCESSOR = new AccessorDebug();

    Debugger(PolyglotEngine sourceVM, TruffleInstrument.Env env) {
        this.env = env;
        this.sourceVM = sourceVM;
        this.legacySession = new DebuggerSession(this, new SuspendedCallback(){

            @Override
            public void onSuspend(SuspendedEvent event) {
                AccessorDebug.dispatchEvent(Debugger.this.sourceVM, event, 2);
            }
        }, true);
    }

    public DebuggerSession startSession(SuspendedCallback callback) {
        return new DebuggerSession(this, callback, false);
    }

    public List<Source> getLoadedSources() {
        final ArrayList sources = new ArrayList();
        EventBinding<2> binding = this.env.getInstrumenter().attachLoadSourceListener(SourceSectionFilter.ANY, new LoadSourceListener(){

            @Override
            public void onLoad(LoadSourceEvent event) {
                sources.add(event.getSource());
            }
        }, true);
        binding.dispose();
        return Collections.unmodifiableList(sources);
    }

    @Deprecated
    @CompilerDirectives.TruffleBoundary
    public Collection<Breakpoint> getBreakpoints() {
        return this.getLegacySession().getLegacyBreakpoints();
    }

    @Deprecated
    public boolean pause() {
        this.getLegacySession().suspendNextExecution();
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @Deprecated
    public Breakpoint setLineBreakpoint(int ignoreCount, LineLocation lineLocation, boolean oneShot) throws IOException {
        return this.setLineBreakpointImpl(ignoreCount, lineLocation.getSource(), lineLocation.getLineNumber(), oneShot);
    }

    @CompilerDirectives.TruffleBoundary
    @Deprecated
    public Breakpoint setLineBreakpoint(int ignoreCount, URI sourceUri, int line, boolean oneShot) throws IOException {
        return this.setLineBreakpointImpl(ignoreCount, sourceUri, line, oneShot);
    }

    private Breakpoint setLineBreakpointImpl(int ignoreCount, Object key, int line, boolean oneShot) throws IOException {
        Breakpoint.Builder builder;
        Breakpoint breakpoint = this.breakpointPerLocation.get(new BreakpointLocation(key, line));
        if (breakpoint != null) {
            if (ignoreCount == breakpoint.getIgnoreCount()) {
                throw new IOException("Breakpoint already set for " + key + " line: " + line);
            }
            breakpoint.setIgnoreCount(ignoreCount);
            return breakpoint;
        }
        if (key instanceof Source) {
            builder = Breakpoint.newBuilder((Source)key);
        } else {
            assert (key instanceof URI);
            builder = Breakpoint.newBuilder((URI)key);
        }
        builder.lineIs(line);
        if (oneShot) {
            builder.oneShot();
        }
        breakpoint = builder.build();
        this.breakpointPerLocation.put(breakpoint.getLocationKey(), breakpoint);
        this.getLegacySession().install(breakpoint);
        return breakpoint;
    }

    PolyglotEngine getSourceVM() {
        return this.sourceVM;
    }

    TruffleInstrument.Env getEnv() {
        return this.env;
    }

    Instrumenter getInstrumenter() {
        return this.env.getInstrumenter();
    }

    DebuggerSession getLegacySession() {
        return this.legacySession;
    }

    void disposeBreakpoint(Breakpoint breakpoint) {
        if (breakpoint.getSession() == this.getLegacySession()) {
            this.breakpointPerLocation.remove(breakpoint.getLocationKey());
        }
    }

    static void trace(String message, Object ... parameters) {
        if (TRACE) {
            PrintStream out = System.out;
            out.println("Debugger: " + String.format(message, parameters));
        }
    }

    public static Debugger find(PolyglotEngine engine) {
        return DebuggerInstrument.getDebugger(engine, new DebuggerInstrument.DebuggerFactory(){

            @Override
            public Debugger create(PolyglotEngine e, TruffleInstrument.Env env) {
                return new Debugger(e, env);
            }
        });
    }

    public static Debugger find(TruffleLanguage.Env env) {
        return Debugger.find((PolyglotEngine)ACCESSOR.findVM(env));
    }

    static final class AccessorDebug
    extends Accessor {
        AccessorDebug() {
        }

        @Override
        protected Accessor.DebugSupport debugSupport() {
            return new DebugImpl();
        }

        static void dispatchEvent(PolyglotEngine vm, Object event, int type) {
            ACCESSOR.engineSupport().dispatchEvent(vm, event, type);
        }

        protected CallTarget parse(Source code, Node context, String ... argumentNames) {
            RootNode rootNode = context.getRootNode();
            Class<? extends TruffleLanguage> languageClass = this.nodes().findLanguage(rootNode);
            if (languageClass == null) {
                throw new IllegalStateException("Could not resolve language class for root node " + rootNode);
            }
            TruffleLanguage<?> truffleLanguage = this.engineSupport().findLanguageImpl(null, languageClass, code.getMimeType());
            return this.languageSupport().parse(truffleLanguage, code, context, argumentNames);
        }

        protected Class<? extends TruffleLanguage> findLanguage(RootNode rootNode) {
            return this.nodes().findLanguage(rootNode);
        }

        protected Object findVM(TruffleLanguage.Env env) {
            return this.languageSupport().getVM(env);
        }

        protected Object evalInContext(Object sourceVM, Node node, MaterializedFrame frame, String code) {
            return this.languageSupport().evalInContext(sourceVM, code, node, frame);
        }

        private static final class DebugImpl
        extends Accessor.DebugSupport {
            private DebugImpl() {
            }

            @Override
            public void executionStarted(Object vm) {
                PolyglotEngine engine = (PolyglotEngine)vm;
                AccessorDebug.dispatchEvent(engine, new ExecutionEvent(engine), 1);
            }
        }
    }
}

