/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.basic;

import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.ObjectLocation;
import com.oracle.truffle.api.object.TypedLocation;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.Locations;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.basic.BasicLayout;
import com.oracle.truffle.object.basic.BasicLocations;

class BasicAllocator
extends ShapeImpl.BaseAllocator {
    BasicAllocator(LayoutImpl layout) {
        super(layout);
        this.advance(((BasicLayout)layout).getPrimitiveArrayLocation());
    }

    BasicAllocator(ShapeImpl shape) {
        super(shape);
    }

    private BasicLayout getLayout() {
        return (BasicLayout)this.layout;
    }

    @Override
    protected Location moveLocation(Location oldLocation) {
        if (oldLocation instanceof LongLocation) {
            return this.newLongLocation(oldLocation.isFinal());
        }
        if (oldLocation instanceof IntLocation) {
            return this.newIntLocation(oldLocation.isFinal());
        }
        if (oldLocation instanceof DoubleLocation) {
            return this.newDoubleLocation(oldLocation.isFinal());
        }
        if (oldLocation instanceof BooleanLocation) {
            return this.newBooleanLocation(oldLocation.isFinal());
        }
        if (oldLocation instanceof ObjectLocation) {
            return this.newObjectLocation(oldLocation.isFinal(), ((ObjectLocation)((Object)oldLocation)).isNonNull());
        }
        assert (oldLocation instanceof Locations.ValueLocation);
        return this.advance(oldLocation);
    }

    @Override
    public Location newObjectLocation(boolean useFinal, boolean nonNull) {
        int insertPos;
        if (ObjectStorageOptions.InObjectFields && (insertPos = this.objectFieldSize) + 1 <= this.getLayout().getObjectFieldCount()) {
            return this.advance((Location)((Object)this.getLayout().getObjectFieldLocation(insertPos)));
        }
        return this.newObjectArrayLocation(useFinal, nonNull);
    }

    private Location newObjectArrayLocation(boolean useFinal, boolean nonNull) {
        return this.advance(new BasicLocations.ObjectArrayLocation(this.objectArraySize, this.getLayout().getObjectArrayLocation()));
    }

    @Override
    public Location newTypedObjectLocation(boolean useFinal, Class<?> type, boolean nonNull) {
        return this.newObjectLocation(useFinal, nonNull);
    }

    @Override
    public Location newIntLocation(boolean useFinal) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.IntegerLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + 1 <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance(new BasicLocations.IntLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize)));
            }
            if (this.getLayout().hasPrimitiveExtensionArray() && this.isPrimitiveExtensionArrayAvailable()) {
                return this.advance(new BasicLocations.IntLocationDecorator(new BasicLocations.LongArrayLocation(this.primitiveArraySize, this.getLayout().getPrimitiveArrayLocation())));
            }
        }
        return this.newObjectLocation(useFinal, true);
    }

    @Override
    public Location newDoubleLocation(boolean useFinal) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.DoubleLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + 1 <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance(new BasicLocations.DoubleLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize), this.getLayout().isAllowedIntToDouble()));
            }
            if (this.getLayout().hasPrimitiveExtensionArray() && this.isPrimitiveExtensionArrayAvailable()) {
                return this.advance(new BasicLocations.DoubleLocationDecorator(new BasicLocations.LongArrayLocation(this.primitiveArraySize, this.getLayout().getPrimitiveArrayLocation()), this.getLayout().isAllowedIntToDouble()));
            }
        }
        return this.newObjectLocation(useFinal, true);
    }

    @Override
    public Location newLongLocation(boolean useFinal) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.LongLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + 1 <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance((Location)((Object)BasicLocations.LongFieldLocation.create(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize), this.getLayout().isAllowedIntToLong())));
            }
            if (this.getLayout().hasPrimitiveExtensionArray() && this.isPrimitiveExtensionArrayAvailable()) {
                return this.advance(new BasicLocations.LongArrayLocation(this.primitiveArraySize, this.getLayout().getPrimitiveArrayLocation(), this.getLayout().isAllowedIntToLong()));
            }
        }
        return this.newObjectLocation(useFinal, true);
    }

    @Override
    public Location newBooleanLocation(boolean useFinal) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.BooleanLocations && this.primitiveFieldSize + 1 <= this.getLayout().getPrimitiveFieldCount()) {
            return this.advance(new BasicLocations.BooleanLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize)));
        }
        return this.newObjectLocation(useFinal, true);
    }

    private boolean isPrimitiveExtensionArrayAvailable() {
        return this.hasPrimitiveArray;
    }

    @Override
    protected Location locationForValueUpcast(Object value, Location oldLocation) {
        assert (!oldLocation.canSet(value));
        if (oldLocation instanceof Locations.DeclaredLocation) {
            return this.locationForValue(value);
        }
        if (oldLocation instanceof Locations.ConstantLocation) {
            return this.constantLocation(value);
        }
        if (oldLocation instanceof TypedLocation && ((TypedLocation)((Object)oldLocation)).getType().isPrimitive()) {
            if (!this.shared && ((TypedLocation)((Object)oldLocation)).getType() == Integer.TYPE) {
                LocationImpl.InternalLongLocation primLocation = ((BasicLocations.PrimitiveLocationDecorator)oldLocation).getInternalLocation();
                if (this.layout.isAllowedIntToLong() && value instanceof Long) {
                    return new BasicLocations.LongLocationDecorator(primLocation, true);
                }
                if (this.layout.isAllowedIntToDouble() && value instanceof Double) {
                    return new BasicLocations.DoubleLocationDecorator(primLocation, true);
                }
            }
            return this.newObjectLocation(oldLocation.isFinal(), value != null);
        }
        return this.locationForValue(value);
    }
}

