/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

public class ReadClassVariableNode
extends RubyNode {
    private final LexicalScope lexicalScope;
    private final String name;
    private final BranchProfile missingProfile = BranchProfile.create();

    public ReadClassVariableNode(LexicalScope lexicalScope, String name) {
        this.lexicalScope = lexicalScope;
        this.name = name;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject module = this.lexicalScope.resolveTargetModuleForClassVariables();
        Object value = ModuleOperations.lookupClassVariable(module, this.name);
        if (value == null) {
            this.missingProfile.enter();
            throw new RaiseException(this.coreExceptions().nameErrorUninitializedClassVariable(module, this.name, this));
        }
        return value;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        DynamicObject module = this.lexicalScope.resolveTargetModuleForClassVariables();
        Object value = ModuleOperations.lookupClassVariable(module, this.name);
        if (value == null) {
            return this.nil();
        }
        return this.coreStrings().CLASS_VARIABLE.createInstance();
    }
}

