/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import org.jruby.truffle.options.OptionDescription;
import org.jruby.truffle.options.OptionTypeException;

public class IntegerOptionDescription
extends OptionDescription {
    private final int defaultValue;

    public IntegerOptionDescription(String name, String description, int defaultValue) {
        super(name, description);
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object checkValue(Object value) {
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new OptionTypeException(this.getName(), value.toString());
            }
        }
        throw new OptionTypeException(this.getName(), value.toString());
    }
}

