/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCastNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalType;
import org.jruby.truffle.stdlib.bigdecimal.CreateBigDecimalNode;
import org.jruby.truffle.stdlib.bigdecimal.GetIntegerConstantNode;

@GeneratedBy(value=CreateBigDecimalNode.class)
public final class CreateBigDecimalNodeFactory
implements NodeFactory<CreateBigDecimalNode> {
    private static CreateBigDecimalNodeFactory instance;

    private CreateBigDecimalNodeFactory() {
    }

    @Override
    public Class<CreateBigDecimalNode> getNodeClass() {
        return CreateBigDecimalNode.class;
    }

    @Override
    public List getExecutionSignature() {
        return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
    }

    @Override
    public List getNodeSignatures() {
        return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class));
    }

    @Override
    public CreateBigDecimalNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyNode) || arguments[1] != null && !(arguments[1] instanceof RubyNode) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return CreateBigDecimalNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1], (RubyNode)arguments[2]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static NodeFactory<CreateBigDecimalNode> getInstance() {
        if (instance == null) {
            instance = new CreateBigDecimalNodeFactory();
        }
        return instance;
    }

    public static CreateBigDecimalNode create(RubyNode value, RubyNode self, RubyNode digits) {
        return new CreateBigDecimalNodeGen(value, self, digits);
    }

    @GeneratedBy(value=CreateBigDecimalNode.class)
    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
    public static final class CreateBigDecimalNodeGen
    extends CreateBigDecimalNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode value_;
        @Node.Child
        private RubyNode self_;
        @Node.Child
        private RubyNode digits_;
        @CompilerDirectives.CompilationFinal
        private Class<?> valueType_;
        @CompilerDirectives.CompilationFinal
        private Class<?> digitsType_;
        @Node.Child
        private BaseNode_ specialization_;

        private CreateBigDecimalNodeGen(RubyNode value, RubyNode self, RubyNode digits) {
            this.value_ = value;
            this.self_ = self;
            this.digits_ = digits;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public DynamicObject executeInitialize(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
            return this.specialization_.executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            return this.specialization_.executeDynamicObject0(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        private static BigDecimal expectBigDecimal(Object value) throws UnexpectedResultException {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            throw new UnexpectedResultException(value);
        }

        @GeneratedBy(methodName="create(VirtualFrame, DynamicObject, DynamicObject, int, BigDecimalCastNode, ConditionProfile)", value=CreateBigDecimalNode.class)
        private static final class Create6Node_
        extends BaseNode_ {
            @Node.Child
            private BigDecimalCastNode bigDecimalCastNode;
            private final ConditionProfile nilProfile;
            private final Class<?> digitsImplicitType;

            Create6Node_(CreateBigDecimalNodeGen root, Object digitsValue, BigDecimalCastNode bigDecimalCastNode, ConditionProfile nilProfile) {
                super(root, 16);
                this.digitsImplicitType = RubyTypesGen.getImplicitIntegerClass(digitsValue);
                this.bigDecimalCastNode = bigDecimalCastNode;
                this.nilProfile = nilProfile;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.digitsImplicitType == ((Create6Node_)other).digitsImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                int digitsValue_;
                DynamicObject selfValue_;
                DynamicObject valueValue_;
                try {
                    valueValue_ = this.root.value_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    if (this.digitsImplicitType == Integer.TYPE) {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    } else {
                        Object digitsValue__ = this.executeDigits_(frameValue);
                        digitsValue_ = RubyTypesGen.expectImplicitInteger(digitsValue__, this.digitsImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                if (!(RubyGuards.isRubyBignum(valueValue_) || RubyGuards.isRubyBigDecimal(valueValue_) || RubyGuards.isRubyString(valueValue_))) {
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_, this.bigDecimalCastNode, this.nilProfile);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    if (!(RubyGuards.isRubyBignum(valueValue_) || RubyGuards.isRubyBigDecimal(valueValue_) || RubyGuards.isRubyString(valueValue_))) {
                        return this.root.create(frameValue, valueValue_, selfValue, digitsValue_, this.bigDecimalCastNode, this.nilProfile);
                    }
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && selfValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    if (!(RubyGuards.isRubyBignum(valueValue_) || RubyGuards.isRubyBigDecimal(valueValue_) || RubyGuards.isRubyString(valueValue_))) {
                        return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_, this.bigDecimalCastNode, this.nilProfile);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object digitsValue, BigDecimalCastNode bigDecimalCastNode, ConditionProfile nilProfile) {
                return new Create6Node_(root, digitsValue, bigDecimalCastNode, nilProfile);
            }
        }

        @GeneratedBy(methodName="createString(VirtualFrame, DynamicObject, DynamicObject, int)", value=CreateBigDecimalNode.class)
        private static final class CreateString1Node_
        extends BaseNode_ {
            private final Class<?> digitsImplicitType;

            CreateString1Node_(CreateBigDecimalNodeGen root, Object digitsValue) {
                super(root, 15);
                this.digitsImplicitType = RubyTypesGen.getImplicitIntegerClass(digitsValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.digitsImplicitType == ((CreateString1Node_)other).digitsImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                int digitsValue_;
                DynamicObject selfValue_;
                DynamicObject valueValue_;
                try {
                    valueValue_ = this.root.value_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    if (this.digitsImplicitType == Integer.TYPE) {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    } else {
                        Object digitsValue__ = this.executeDigits_(frameValue);
                        digitsValue_ = RubyTypesGen.expectImplicitInteger(digitsValue__, this.digitsImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(valueValue_)) {
                    return this.root.createString(frameValue, valueValue_, selfValue_, digitsValue_);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    if (RubyGuards.isRubyString(valueValue_)) {
                        return this.root.createString(frameValue, valueValue_, selfValue, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && selfValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    if (RubyGuards.isRubyString(valueValue_)) {
                        return this.root.createString(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object digitsValue) {
                return new CreateString1Node_(root, digitsValue);
            }
        }

        @GeneratedBy(methodName="createString(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=CreateBigDecimalNode.class)
        private static final class CreateString0Node_
        extends BaseNode_ {
            CreateString0Node_(CreateBigDecimalNodeGen root) {
                super(root, 14);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    if (RubyGuards.isRubyString(valueValue_)) {
                        return this.root.createString(frameValue, valueValue_, selfValue, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && selfValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    if (RubyGuards.isRubyString(valueValue_)) {
                        return this.root.createString(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root) {
                return new CreateString0Node_(root);
            }
        }

        @GeneratedBy(methodName="createBigDecimal(VirtualFrame, DynamicObject, DynamicObject, int)", value=CreateBigDecimalNode.class)
        private static final class CreateBigDecimal1Node_
        extends BaseNode_ {
            private final Class<?> digitsImplicitType;

            CreateBigDecimal1Node_(CreateBigDecimalNodeGen root, Object digitsValue) {
                super(root, 13);
                this.digitsImplicitType = RubyTypesGen.getImplicitIntegerClass(digitsValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.digitsImplicitType == ((CreateBigDecimal1Node_)other).digitsImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                int digitsValue_;
                DynamicObject selfValue_;
                DynamicObject valueValue_;
                try {
                    valueValue_ = this.root.value_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    if (this.digitsImplicitType == Integer.TYPE) {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    } else {
                        Object digitsValue__ = this.executeDigits_(frameValue);
                        digitsValue_ = RubyTypesGen.expectImplicitInteger(digitsValue__, this.digitsImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                if (RubyGuards.isRubyBigDecimal(valueValue_)) {
                    return this.root.createBigDecimal(frameValue, valueValue_, selfValue_, digitsValue_);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    if (RubyGuards.isRubyBigDecimal(valueValue_)) {
                        return this.root.createBigDecimal(frameValue, valueValue_, selfValue, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && selfValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    if (RubyGuards.isRubyBigDecimal(valueValue_)) {
                        return this.root.createBigDecimal(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object digitsValue) {
                return new CreateBigDecimal1Node_(root, digitsValue);
            }
        }

        @GeneratedBy(methodName="createBigDecimal(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=CreateBigDecimalNode.class)
        private static final class CreateBigDecimal0Node_
        extends BaseNode_ {
            CreateBigDecimal0Node_(CreateBigDecimalNodeGen root) {
                super(root, 12);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    if (RubyGuards.isRubyBigDecimal(valueValue_)) {
                        return this.root.createBigDecimal(frameValue, valueValue_, selfValue, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && selfValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    if (RubyGuards.isRubyBigDecimal(valueValue_)) {
                        return this.root.createBigDecimal(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root) {
                return new CreateBigDecimal0Node_(root);
            }
        }

        @GeneratedBy(methodName="createBignum(VirtualFrame, DynamicObject, DynamicObject, int)", value=CreateBigDecimalNode.class)
        private static final class CreateBignum1Node_
        extends BaseNode_ {
            private final Class<?> digitsImplicitType;

            CreateBignum1Node_(CreateBigDecimalNodeGen root, Object digitsValue) {
                super(root, 11);
                this.digitsImplicitType = RubyTypesGen.getImplicitIntegerClass(digitsValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.digitsImplicitType == ((CreateBignum1Node_)other).digitsImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                int digitsValue_;
                DynamicObject selfValue_;
                DynamicObject valueValue_;
                try {
                    valueValue_ = this.root.value_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    if (this.digitsImplicitType == Integer.TYPE) {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    } else {
                        Object digitsValue__ = this.executeDigits_(frameValue);
                        digitsValue_ = RubyTypesGen.expectImplicitInteger(digitsValue__, this.digitsImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                if (RubyGuards.isRubyBignum(valueValue_)) {
                    return this.root.createBignum(frameValue, valueValue_, selfValue_, digitsValue_);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    if (RubyGuards.isRubyBignum(valueValue_)) {
                        return this.root.createBignum(frameValue, valueValue_, selfValue, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && selfValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    if (RubyGuards.isRubyBignum(valueValue_)) {
                        return this.root.createBignum(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object digitsValue) {
                return new CreateBignum1Node_(root, digitsValue);
            }
        }

        @GeneratedBy(methodName="createBignum(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=CreateBigDecimalNode.class)
        private static final class CreateBignum0Node_
        extends BaseNode_ {
            CreateBignum0Node_(CreateBigDecimalNodeGen root) {
                super(root, 10);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    if (RubyGuards.isRubyBignum(valueValue_)) {
                        return this.root.createBignum(frameValue, valueValue_, selfValue, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof DynamicObject && selfValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    DynamicObject valueValue_ = (DynamicObject)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    if (RubyGuards.isRubyBignum(valueValue_)) {
                        return this.root.createBignum(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root) {
                return new CreateBignum0Node_(root);
            }
        }

        @GeneratedBy(methodName="create(VirtualFrame, BigDecimal, DynamicObject, int)", value=CreateBigDecimalNode.class)
        private static final class Create5Node_
        extends BaseNode_ {
            private final Class<?> digitsImplicitType;

            Create5Node_(CreateBigDecimalNodeGen root, Object digitsValue) {
                super(root, 9);
                this.digitsImplicitType = RubyTypesGen.getImplicitIntegerClass(digitsValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.digitsImplicitType == ((Create5Node_)other).digitsImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                int digitsValue_;
                DynamicObject selfValue_;
                BigDecimal valueValue_;
                try {
                    valueValue_ = CreateBigDecimalNodeGen.expectBigDecimal(this.root.value_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    if (this.digitsImplicitType == Integer.TYPE) {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    } else {
                        Object digitsValue__ = this.executeDigits_(frameValue);
                        digitsValue_ = RubyTypesGen.expectImplicitInteger(digitsValue__, this.digitsImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof BigDecimal && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    BigDecimal valueValue_ = (BigDecimal)valueValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    return this.root.create(frameValue, valueValue_, selfValue, digitsValue_);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof BigDecimal && selfValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    BigDecimal valueValue_ = (BigDecimal)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object digitsValue) {
                return new Create5Node_(root, digitsValue);
            }
        }

        @GeneratedBy(methodName="create(VirtualFrame, BigDecimal, DynamicObject, NotProvided)", value=CreateBigDecimalNode.class)
        private static final class Create4Node_
        extends BaseNode_ {
            Create4Node_(CreateBigDecimalNodeGen root) {
                super(root, 8);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (valueValue instanceof BigDecimal && digitsValue instanceof NotProvided) {
                    BigDecimal valueValue_ = (BigDecimal)valueValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    return this.root.create(frameValue, valueValue_, selfValue, digitsValue_);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof BigDecimal && selfValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    BigDecimal valueValue_ = (BigDecimal)valueValue;
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root) {
                return new Create4Node_(root);
            }
        }

        @GeneratedBy(methodName="createNegativeZero(VirtualFrame, BigDecimalType, DynamicObject, Object)", value=CreateBigDecimalNode.class)
        private static final class CreateNegativeZeroNode_
        extends BaseNode_ {
            CreateNegativeZeroNode_(CreateBigDecimalNodeGen root) {
                super(root, 7);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                BigDecimalType valueValue_;
                if (valueValue instanceof BigDecimalType && (valueValue_ = (BigDecimalType)((Object)valueValue)) == BigDecimalType.NEGATIVE_ZERO) {
                    return this.root.createNegativeZero(frameValue, valueValue_, selfValue, digitsValue);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof BigDecimalType && selfValue instanceof DynamicObject) {
                    BigDecimalType valueValue_ = (BigDecimalType)((Object)valueValue);
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    if (valueValue_ == BigDecimalType.NEGATIVE_ZERO) {
                        return this.root.createNegativeZero(frameValue, valueValue_, selfValue_, digitsValue);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root) {
                return new CreateNegativeZeroNode_(root);
            }
        }

        @GeneratedBy(methodName="createNaN(VirtualFrame, BigDecimalType, DynamicObject, Object, BooleanCastNode, GetIntegerConstantNode, CallDispatchHeadNode, ConditionProfile)", value=CreateBigDecimalNode.class)
        private static final class CreateNaNNode_
        extends BaseNode_ {
            @Node.Child
            private BooleanCastNode booleanCastNode;
            @Node.Child
            private GetIntegerConstantNode getIntegerConstantNode;
            @Node.Child
            private CallDispatchHeadNode modeCallNode;
            private final ConditionProfile raiseProfile;

            CreateNaNNode_(CreateBigDecimalNodeGen root, BooleanCastNode booleanCastNode, GetIntegerConstantNode getIntegerConstantNode, CallDispatchHeadNode modeCallNode, ConditionProfile raiseProfile) {
                super(root, 6);
                this.booleanCastNode = booleanCastNode;
                this.getIntegerConstantNode = getIntegerConstantNode;
                this.modeCallNode = modeCallNode;
                this.raiseProfile = raiseProfile;
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                BigDecimalType valueValue_;
                if (valueValue instanceof BigDecimalType && (valueValue_ = (BigDecimalType)((Object)valueValue)) == BigDecimalType.NAN) {
                    return this.root.createNaN(frameValue, valueValue_, selfValue, digitsValue, this.booleanCastNode, this.getIntegerConstantNode, this.modeCallNode, this.raiseProfile);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof BigDecimalType && selfValue instanceof DynamicObject) {
                    BigDecimalType valueValue_ = (BigDecimalType)((Object)valueValue);
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    if (valueValue_ == BigDecimalType.NAN) {
                        return this.root.createNaN(frameValue, valueValue_, selfValue_, digitsValue, this.booleanCastNode, this.getIntegerConstantNode, this.modeCallNode, this.raiseProfile);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, BooleanCastNode booleanCastNode, GetIntegerConstantNode getIntegerConstantNode, CallDispatchHeadNode modeCallNode, ConditionProfile raiseProfile) {
                return new CreateNaNNode_(root, booleanCastNode, getIntegerConstantNode, modeCallNode, raiseProfile);
            }
        }

        @GeneratedBy(methodName="createInfinity(VirtualFrame, BigDecimalType, DynamicObject, Object, BooleanCastNode, GetIntegerConstantNode, CallDispatchHeadNode, ConditionProfile)", value=CreateBigDecimalNode.class)
        private static final class CreateInfinityNode_
        extends BaseNode_ {
            @Node.Child
            private BooleanCastNode booleanCastNode;
            @Node.Child
            private GetIntegerConstantNode getIntegerConstantNode;
            @Node.Child
            private CallDispatchHeadNode modeCallNode;
            private final ConditionProfile raiseProfile;

            CreateInfinityNode_(CreateBigDecimalNodeGen root, BooleanCastNode booleanCastNode, GetIntegerConstantNode getIntegerConstantNode, CallDispatchHeadNode modeCallNode, ConditionProfile raiseProfile) {
                super(root, 5);
                this.booleanCastNode = booleanCastNode;
                this.getIntegerConstantNode = getIntegerConstantNode;
                this.modeCallNode = modeCallNode;
                this.raiseProfile = raiseProfile;
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                BigDecimalType valueValue_;
                if (valueValue instanceof BigDecimalType && ((valueValue_ = (BigDecimalType)((Object)valueValue)) == BigDecimalType.NEGATIVE_INFINITY || valueValue_ == BigDecimalType.POSITIVE_INFINITY)) {
                    return this.root.createInfinity(frameValue, valueValue_, selfValue, digitsValue, this.booleanCastNode, this.getIntegerConstantNode, this.modeCallNode, this.raiseProfile);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (valueValue instanceof BigDecimalType && selfValue instanceof DynamicObject) {
                    BigDecimalType valueValue_ = (BigDecimalType)((Object)valueValue);
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    if (valueValue_ == BigDecimalType.NEGATIVE_INFINITY || valueValue_ == BigDecimalType.POSITIVE_INFINITY) {
                        return this.root.createInfinity(frameValue, valueValue_, selfValue_, digitsValue, this.booleanCastNode, this.getIntegerConstantNode, this.modeCallNode, this.raiseProfile);
                    }
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, BooleanCastNode booleanCastNode, GetIntegerConstantNode getIntegerConstantNode, CallDispatchHeadNode modeCallNode, ConditionProfile raiseProfile) {
                return new CreateInfinityNode_(root, booleanCastNode, getIntegerConstantNode, modeCallNode, raiseProfile);
            }
        }

        @GeneratedBy(methodName="create(VirtualFrame, double, DynamicObject, int, BigDecimalCastNode)", value=CreateBigDecimalNode.class)
        private static final class Create3Node_
        extends BaseNode_ {
            @Node.Child
            private BigDecimalCastNode bigDecimalCastNode;
            private final Class<?> valueImplicitType;
            private final Class<?> digitsImplicitType;

            Create3Node_(CreateBigDecimalNodeGen root, Object valueValue, Object digitsValue, BigDecimalCastNode bigDecimalCastNode) {
                super(root, 4);
                this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
                this.digitsImplicitType = RubyTypesGen.getImplicitIntegerClass(digitsValue);
                this.bigDecimalCastNode = bigDecimalCastNode;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.valueImplicitType == ((Create3Node_)other).valueImplicitType && this.digitsImplicitType == ((Create3Node_)other).digitsImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                int digitsValue_;
                DynamicObject selfValue_;
                double valueValue_;
                try {
                    if (this.valueImplicitType == Double.TYPE) {
                        valueValue_ = this.root.value_.executeDouble(frameValue);
                    } else {
                        Object valueValue__ = this.executeValue_(frameValue);
                        valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    if (this.digitsImplicitType == Integer.TYPE) {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    } else {
                        Object digitsValue__ = this.executeDigits_(frameValue);
                        digitsValue_ = RubyTypesGen.expectImplicitInteger(digitsValue__, this.digitsImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_, this.bigDecimalCastNode);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType) && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    return this.root.create(frameValue, valueValue_, selfValue, digitsValue_, this.bigDecimalCastNode);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType) && selfValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_, this.bigDecimalCastNode);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object valueValue, Object digitsValue, BigDecimalCastNode bigDecimalCastNode) {
                return new Create3Node_(root, valueValue, digitsValue, bigDecimalCastNode);
            }
        }

        @GeneratedBy(methodName="create(double, DynamicObject, NotProvided)", value=CreateBigDecimalNode.class)
        private static final class Create2Node_
        extends BaseNode_ {
            private final Class<?> valueImplicitType;

            Create2Node_(CreateBigDecimalNodeGen root, Object valueValue) {
                super(root, 3);
                this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.valueImplicitType == ((Create2Node_)other).valueImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                NotProvided digitsValue_;
                DynamicObject selfValue_;
                double valueValue_;
                try {
                    if (this.valueImplicitType == Double.TYPE) {
                        valueValue_ = this.root.value_.executeDouble(frameValue);
                    } else {
                        Object valueValue__ = this.executeValue_(frameValue);
                        valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    digitsValue_ = this.root.digits_.executeNotProvided(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                return this.root.create(valueValue_, selfValue_, digitsValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType) && digitsValue instanceof NotProvided) {
                    double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    return this.root.create(valueValue_, selfValue, digitsValue_);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType) && selfValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    return this.root.create(valueValue_, selfValue_, digitsValue_);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object valueValue) {
                return new Create2Node_(root, valueValue);
            }
        }

        @GeneratedBy(methodName="create(VirtualFrame, long, DynamicObject, int, BigDecimalCastNode)", value=CreateBigDecimalNode.class)
        private static final class Create1Node_
        extends BaseNode_ {
            @Node.Child
            private BigDecimalCastNode bigDecimalCastNode;
            private final Class<?> valueImplicitType;
            private final Class<?> digitsImplicitType;

            Create1Node_(CreateBigDecimalNodeGen root, Object valueValue, Object digitsValue, BigDecimalCastNode bigDecimalCastNode) {
                super(root, 2);
                this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
                this.digitsImplicitType = RubyTypesGen.getImplicitIntegerClass(digitsValue);
                this.bigDecimalCastNode = bigDecimalCastNode;
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.valueImplicitType == ((Create1Node_)other).valueImplicitType && this.digitsImplicitType == ((Create1Node_)other).digitsImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                int digitsValue_;
                DynamicObject selfValue_;
                long valueValue_;
                try {
                    valueValue_ = this.executeValueLong_(frameValue, this.valueImplicitType);
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    if (this.digitsImplicitType == Integer.TYPE) {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    } else {
                        Object digitsValue__ = this.executeDigits_(frameValue);
                        digitsValue_ = RubyTypesGen.expectImplicitInteger(digitsValue__, this.digitsImplicitType);
                    }
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_, this.bigDecimalCastNode);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    return this.root.create(frameValue, valueValue_, selfValue, digitsValue_, this.bigDecimalCastNode);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && selfValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(digitsValue, this.digitsImplicitType)) {
                    long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    int digitsValue_ = RubyTypesGen.asImplicitInteger(digitsValue, this.digitsImplicitType);
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_, this.bigDecimalCastNode);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object valueValue, Object digitsValue, BigDecimalCastNode bigDecimalCastNode) {
                return new Create1Node_(root, valueValue, digitsValue, bigDecimalCastNode);
            }
        }

        @GeneratedBy(methodName="create(VirtualFrame, long, DynamicObject, NotProvided)", value=CreateBigDecimalNode.class)
        private static final class Create0Node_
        extends BaseNode_ {
            private final Class<?> valueImplicitType;

            Create0Node_(CreateBigDecimalNodeGen root, Object valueValue) {
                super(root, 1);
                this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
            }

            @Override
            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.valueImplicitType == ((Create0Node_)other).valueImplicitType;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject0(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                NotProvided digitsValue_;
                DynamicObject selfValue_;
                long valueValue_;
                try {
                    valueValue_ = this.executeValueLong_(frameValue, this.valueImplicitType);
                }
                catch (UnexpectedResultException ex) {
                    Object selfValue = this.root.self_.execute(frameValue);
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                }
                try {
                    selfValue_ = this.root.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object digitsValue = this.executeDigits_(frameValue);
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                }
                try {
                    digitsValue_ = this.root.digits_.executeNotProvided(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeDynamicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                }
                return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
            }

            @Override
            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && digitsValue instanceof NotProvided) {
                    long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    return this.root.create(frameValue, valueValue_, selfValue, digitsValue_);
                }
                return this.getNext().executeDynamicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && selfValue instanceof DynamicObject && digitsValue instanceof NotProvided) {
                    long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    NotProvided digitsValue_ = (NotProvided)digitsValue;
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                }
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root, Object valueValue) {
                return new Create0Node_(root, valueValue);
            }
        }

        @GeneratedBy(value=CreateBigDecimalNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(CreateBigDecimalNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue, selfValue, digitsValue));
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                return this.getNext().executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=CreateBigDecimalNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(CreateBigDecimalNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                return (DynamicObject)this.uninitialized((Frame)frameValue, valueValue, selfValue, digitsValue);
            }

            static BaseNode_ create(CreateBigDecimalNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=CreateBigDecimalNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected CreateBigDecimalNodeGen root;

            BaseNode_(CreateBigDecimalNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (CreateBigDecimalNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.value_, this.root.self_, this.root.digits_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                return this.executeDynamicObject_((VirtualFrame)frameValue, valueValue, selfValue, digitsValue);
            }

            public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

            public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object valueValue, DynamicObject selfValue, Object digitsValue) {
                return this.executeDynamicObject_(frameValue, valueValue, selfValue, digitsValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object valueValue_ = this.executeValue_(frameValue);
                Object selfValue_ = this.root.self_.execute(frameValue);
                Object digitsValue_ = this.executeDigits_(frameValue);
                return this.executeDynamicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                return (DynamicObject)this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                if (selfValue instanceof DynamicObject) {
                    Object valueValue_;
                    if (RubyTypesGen.isImplicitLong(valueValue)) {
                        if (digitsValue instanceof NotProvided) {
                            return Create0Node_.create(this.root, valueValue);
                        }
                        if (RubyTypesGen.isImplicitInteger(digitsValue)) {
                            BigDecimalCastNode bigDecimalCastNode2 = this.root.createBigDecimalCastNode();
                            return Create1Node_.create(this.root, valueValue, digitsValue, bigDecimalCastNode2);
                        }
                    }
                    if (RubyTypesGen.isImplicitDouble(valueValue)) {
                        if (digitsValue instanceof NotProvided) {
                            return Create2Node_.create(this.root, valueValue);
                        }
                        if (RubyTypesGen.isImplicitInteger(digitsValue)) {
                            BigDecimalCastNode bigDecimalCastNode4 = this.root.createBigDecimalCastNode();
                            return Create3Node_.create(this.root, valueValue, digitsValue, bigDecimalCastNode4);
                        }
                    }
                    if (valueValue instanceof BigDecimalType) {
                        valueValue_ = (BigDecimalType)((Object)valueValue);
                        if (valueValue_ == BigDecimalType.NEGATIVE_INFINITY || valueValue_ == BigDecimalType.POSITIVE_INFINITY) {
                            BooleanCastNode booleanCastNode5 = this.root.createBooleanCastNode();
                            GetIntegerConstantNode getIntegerConstantNode5 = this.root.createGetIntegerConstantNode();
                            CallDispatchHeadNode modeCallNode5 = CallDispatchHeadNode.createMethodCallIgnoreVisibility();
                            ConditionProfile raiseProfile5 = ConditionProfile.createBinaryProfile();
                            return CreateInfinityNode_.create(this.root, booleanCastNode5, getIntegerConstantNode5, modeCallNode5, raiseProfile5);
                        }
                        if (valueValue_ == BigDecimalType.NAN) {
                            BooleanCastNode booleanCastNode6 = this.root.createBooleanCastNode();
                            GetIntegerConstantNode getIntegerConstantNode6 = this.root.createGetIntegerConstantNode();
                            CallDispatchHeadNode modeCallNode6 = CallDispatchHeadNode.createMethodCallIgnoreVisibility();
                            ConditionProfile raiseProfile6 = ConditionProfile.createBinaryProfile();
                            return CreateNaNNode_.create(this.root, booleanCastNode6, getIntegerConstantNode6, modeCallNode6, raiseProfile6);
                        }
                        if (valueValue_ == BigDecimalType.NEGATIVE_ZERO) {
                            return CreateNegativeZeroNode_.create(this.root);
                        }
                    }
                    if (valueValue instanceof BigDecimal) {
                        if (digitsValue instanceof NotProvided) {
                            return Create4Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitInteger(digitsValue)) {
                            return Create5Node_.create(this.root, digitsValue);
                        }
                    }
                    if (valueValue instanceof DynamicObject) {
                        valueValue_ = (DynamicObject)valueValue;
                        if (digitsValue instanceof NotProvided && RubyGuards.isRubyBignum((DynamicObject)valueValue_)) {
                            return CreateBignum0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitInteger(digitsValue) && RubyGuards.isRubyBignum((DynamicObject)valueValue_)) {
                            return CreateBignum1Node_.create(this.root, digitsValue);
                        }
                        if (digitsValue instanceof NotProvided && RubyGuards.isRubyBigDecimal((DynamicObject)valueValue_)) {
                            return CreateBigDecimal0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitInteger(digitsValue) && RubyGuards.isRubyBigDecimal((DynamicObject)valueValue_)) {
                            return CreateBigDecimal1Node_.create(this.root, digitsValue);
                        }
                        if (digitsValue instanceof NotProvided && RubyGuards.isRubyString((DynamicObject)valueValue_)) {
                            return CreateString0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitInteger(digitsValue)) {
                            if (RubyGuards.isRubyString((DynamicObject)valueValue_)) {
                                return CreateString1Node_.create(this.root, digitsValue);
                            }
                            if (!(RubyGuards.isRubyBignum((DynamicObject)valueValue_) || RubyGuards.isRubyBigDecimal((DynamicObject)valueValue_) || RubyGuards.isRubyString((DynamicObject)valueValue_))) {
                                BigDecimalCastNode bigDecimalCastNode16 = this.root.createBigDecimalCastNode();
                                ConditionProfile nilProfile16 = ConditionProfile.createBinaryProfile();
                                return Create6Node_.create(this.root, digitsValue, bigDecimalCastNode16, nilProfile16);
                            }
                        }
                    }
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }

            protected final long executeValueLong_(Frame frameValue, Class<?> valueImplicitType) throws UnexpectedResultException {
                if (valueImplicitType == Long.TYPE) {
                    return this.root.value_.executeLong((VirtualFrame)frameValue);
                }
                if (valueImplicitType == Integer.TYPE) {
                    return RubyTypes.promoteToLong(this.root.value_.executeInteger((VirtualFrame)frameValue));
                }
                Object valueValue_ = this.executeValue_(frameValue);
                return RubyTypesGen.expectImplicitLong(valueValue_, valueImplicitType);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeValue_(Frame frameValue) {
                Object object;
                Class valueType_ = this.root.valueType_;
                if (valueType_ == Double.TYPE) {
                    return this.root.value_.executeDouble((VirtualFrame)frameValue);
                }
                if (valueType_ == Integer.TYPE) {
                    return this.root.value_.executeInteger((VirtualFrame)frameValue);
                }
                if (valueType_ == Long.TYPE) {
                    return this.root.value_.executeLong((VirtualFrame)frameValue);
                }
                if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.valueType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.valueType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.valueType_ = _type;
                return object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeDigits_(Frame frameValue) {
                Object object;
                Class digitsType_ = this.root.digitsType_;
                if (digitsType_ == Integer.TYPE) {
                    return this.root.digits_.executeInteger((VirtualFrame)frameValue);
                }
                if (digitsType_ != null) return this.root.digits_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.digits_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.digitsType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.digitsType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.digitsType_ = _type;
                return object;
            }
        }
    }
}

