/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.ScopeCollector;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u00a8\u0006\t"}, d2={"resolveNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "", "knownNames", "resolveTemporaryNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "kotlin-compiler"})
public final class ResolveTemporaryNamesKt {
    public static final void resolveTemporaryNames(@NotNull JsNode $receiver) {
        ScopeCollector scopeCollector;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Set<JsName> allNames = CollectUtilsKt.collectReferencedTemporaryNames($receiver);
        ScopeCollector it = scopeCollector = new ScopeCollector();
        it.accept($receiver);
        Map<JsScope, Set<JsScope>> scopeTree = it.getScopeTree();
        Map<JsName, JsName> renamings = ResolveTemporaryNamesKt.resolveNames(scopeTree, allNames);
        $receiver.accept(new RecursiveJsVisitor(renamings){
            final /* synthetic */ Map $renamings;

            protected void visitElement(@NotNull JsNode node) {
                block1: {
                    JsName name2;
                    Intrinsics.checkParameterIsNotNull(node, "node");
                    super.visitElement(node);
                    if (!(node instanceof HasName) || (name2 = ((HasName)((Object)node)).getName()) == null) break block1;
                    JsName jsName = (JsName)this.$renamings.get(name2);
                    if (jsName != null) {
                        JsName jsName2;
                        JsName it = jsName2 = jsName;
                        ((HasName)((Object)node)).setName(it);
                    }
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(x);
                if (coroutineMetadata != null) {
                    CoroutineMetadata coroutineMetadata2;
                    CoroutineMetadata $receiver = coroutineMetadata2 = coroutineMetadata;
                    this.accept((JsNode)$receiver.getSuspendObjectRef());
                    this.accept((JsNode)$receiver.getBaseClassRef());
                }
                super.visitFunction(x);
            }
            {
                this.$renamings = $captured_local_variable$0;
            }
        });
    }

    private static final Map<JsName, JsName> resolveNames(@NotNull Map<JsScope, ? extends Set<? extends JsScope>> $receiver, Set<? extends JsName> knownNames) {
        Map replacements = new LinkedHashMap();
        Function1<JsScope, Unit> traverse$ = new Function1<JsScope, Unit>($receiver, knownNames, replacements){
            final /* synthetic */ Map receiver$0;
            final /* synthetic */ Set $knownNames;
            final /* synthetic */ Map $replacements;

            public final void invoke(@NotNull JsScope scope) {
                Object $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull(scope, "scope");
                Object $receiver$iv = scope.getTemporaryNames();
                Iterable iterable = $receiver$iv;
                Object destination$iv$iv = new ArrayList<E>();
                Iterator<T> iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    T element$iv$iv = iterator2.next();
                    JsName it = (JsName)element$iv$iv;
                    if (!this.$knownNames.contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new Comparator<JsName>(){

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public int compare(Object a, Object b) {
                        JsName it = (JsName)a;
                        Comparable comparable = Integer.valueOf(it.getOrdinal());
                        it = (JsName)b;
                        Comparable comparable2 = comparable;
                        Integer n = it.getOrdinal();
                        return ComparisonsKt.compareValues(comparable2, (Comparable)n);
                    }
                };
                for (JsName temporaryName : CollectionsKt.sortedWith($receiver$iv$iv, destination$iv$iv)) {
                    $receiver$iv = this.$replacements;
                    Intrinsics.checkExpressionValueIsNotNull(temporaryName, "temporaryName");
                    destination$iv$iv = scope.declareFreshName(temporaryName.getIdent());
                    JsName $receiver = (JsName)destination$iv$iv;
                    JsName jsName = temporaryName;
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "temporaryName");
                    $receiver.copyMetadataFrom(jsName);
                    Object object = destination$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull(object, "scope.declareFreshName(t\u2026dataFrom(temporaryName) }");
                    destination$iv$iv = object;
                    $receiver$iv.put($receiver$iv$iv, destination$iv$iv);
                }
                V v = this.receiver$0.get(scope);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Iterable $receiver$iv2 = (Iterable)v;
                for (JsName element$iv : $receiver$iv2) {
                    JsScope p1 = (JsScope)((Object)element$iv);
                    this.invoke(p1);
                }
            }
            {
                this.receiver$0 = map2;
                this.$knownNames = set;
                this.$replacements = map3;
                super(1);
            }
        };
        Set<JsScope> roots2 = CollectionsKt.toMutableSet((Iterable)$receiver.keySet());
        Iterable $receiver$iv = $receiver.values();
        for (Object element$iv : $receiver$iv) {
            Set it = (Set)element$iv;
            Collection collection = roots2;
            CollectionsKt.removeAll(collection, it);
        }
        for (JsScope root : roots2) {
            traverse$.invoke(root);
        }
        return replacements;
    }
}

