/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.WriterConstants;
import org.objectweb.asm.Handle;

public class FunctionRef {
    public final String invokedName;
    public final MethodType invokedType;
    public final MethodHandle implMethod;
    public final MethodType samMethodType;
    public final MethodType interfaceMethodType;
    public final Handle implMethodASM;

    public FunctionRef(Definition.Type expected, String type, String call, int numCaptures) {
        this(expected, expected.struct.getFunctionalMethod(), FunctionRef.lookup(expected, type, call, numCaptures > 0), numCaptures);
    }

    public FunctionRef(Definition.Type expected, Definition.Method method, Definition.Method impl, int numCaptures) {
        String owner;
        boolean ownerIsInterface;
        this.invokedName = method.name;
        MethodType implType = impl.getMethodType();
        this.invokedType = MethodType.methodType(expected.clazz, implType.dropParameterTypes(numCaptures, implType.parameterCount()));
        this.interfaceMethodType = method.getMethodType().dropParameterTypes(0, 1);
        int tag = "<init>".equals(impl.name) ? 8 : (Modifier.isStatic(impl.modifiers) ? 6 : (impl.owner.clazz.isInterface() ? 9 : 5));
        if (impl.owner == null) {
            ownerIsInterface = false;
            owner = WriterConstants.CLASS_TYPE.getInternalName();
        } else if (impl.augmentation) {
            ownerIsInterface = false;
            owner = WriterConstants.AUGMENTATION_TYPE.getInternalName();
        } else {
            ownerIsInterface = impl.owner.clazz.isInterface();
            owner = impl.owner.type.getInternalName();
        }
        this.implMethodASM = new Handle(tag, owner, impl.name, impl.method.getDescriptor(), ownerIsInterface);
        this.implMethod = impl.handle;
        this.samMethodType = this.adapt(this.interfaceMethodType, impl.getMethodType().dropParameterTypes(0, numCaptures));
    }

    public FunctionRef(Definition.Type expected, Definition.Method method, MethodHandle impl, int numCaptures) {
        this.invokedName = method.name;
        MethodType implType = impl.type();
        this.invokedType = MethodType.methodType(expected.clazz, implType.dropParameterTypes(numCaptures, implType.parameterCount()));
        this.interfaceMethodType = method.getMethodType().dropParameterTypes(0, 1);
        this.implMethod = impl;
        this.implMethodASM = null;
        this.samMethodType = this.adapt(this.interfaceMethodType, impl.type().dropParameterTypes(0, numCaptures));
    }

    private static Definition.Method lookup(Definition.Type expected, String type, String call, boolean receiverCaptured) {
        Definition.Method impl;
        Definition.Method method = expected.struct.getFunctionalMethod();
        if (method == null) {
            throw new IllegalArgumentException("Cannot convert function reference [" + type + "::" + call + "] to [" + expected.name + "], not a functional interface");
        }
        Definition.Struct struct = Definition.getType((String)type).struct;
        if ("new".equals(call)) {
            impl = struct.constructors.get(new Definition.MethodKey("<init>", method.arguments.size()));
        } else {
            Definition.Method staticImpl = struct.staticMethods.get(new Definition.MethodKey(call, method.arguments.size()));
            if (staticImpl == null) {
                int arity = receiverCaptured ? method.arguments.size() : method.arguments.size() - 1;
                impl = struct.methods.get(new Definition.MethodKey(call, arity));
            } else {
                impl = staticImpl;
            }
        }
        if (impl == null) {
            throw new IllegalArgumentException("Unknown reference [" + type + "::" + call + "] matching [" + expected + "]");
        }
        return impl;
    }

    public boolean needsBridges() {
        return !this.interfaceMethodType.equals((Object)this.samMethodType);
    }

    private MethodType adapt(MethodType expected, MethodType actual) {
        if (expected.parameterCount() != actual.parameterCount()) {
            throw new IllegalArgumentException("Incorrect number of parameters for [" + this.invokedName + "] in [" + this.invokedType.returnType() + "]");
        }
        if (((Class)expected.returnType()).isPrimitive() && actual.returnType() == Object.class) {
            actual = actual.changeReturnType((Class<?>)MethodType.methodType(expected.returnType()).wrap().returnType());
        }
        return actual;
    }
}

