/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;

public class EquipmentType
extends BuildableType {
    public static final EquipmentType[] NO_EQUIPMENT = new EquipmentType[0];
    private int maximumCount = 1;
    private int combatLossPriority = -1;
    private String captureEquipmentId = null;
    private boolean captureEquipmentByIndians = false;
    private Role role = null;
    private boolean militaryEquipment = false;
    private List<String> compatibleEquipment = null;
    private static final String BY_INDIANS_TAG = "by-indians";
    private static final String CAPTURE_EQUIPMENT_TAG = "capture-equipment";
    private static final String COMBAT_LOSS_PRIORITY_TAG = "combat-loss-priority";
    private static final String COMPATIBLE_EQUIPMENT_TAG = "compatible-equipment";
    private static final String MAXIMUM_COUNT_TAG = "maximum-count";
    private static final String ROLE_TAG = "role";
    private static final String REQUIRED_LOCATION_ABILITY_TAG = "required-location-ability";

    public EquipmentType(String id, Specification specification) {
        super(id, specification);
    }

    public final int getMaximumCount() {
        return this.maximumCount;
    }

    public final int getCombatLossPriority() {
        return this.combatLossPriority;
    }

    public boolean canBeCaptured() {
        return this.combatLossPriority > 0;
    }

    public EquipmentType getCaptureEquipment(boolean byIndians) {
        return this.captureEquipmentId != null && byIndians == this.captureEquipmentByIndians ? this.getSpecification().getEquipmentType(this.captureEquipmentId) : this;
    }

    public boolean isCompatibleWith(EquipmentType otherType) {
        if (this.getId().equals(otherType.getId())) {
            return true;
        }
        return this.compatibleEquipment != null && this.compatibleEquipment.contains(otherType.getId()) && otherType.compatibleEquipment.contains(this.getId());
    }

    private void addCompatibleEquipment(String equipmentId) {
        if (this.compatibleEquipment == null) {
            this.compatibleEquipment = new ArrayList<String>();
        }
        this.compatibleEquipment.add(equipmentId);
    }

    public final Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public final boolean isMilitaryEquipment() {
        return this.militaryEquipment;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.compatibleEquipment == null ? 0 : this.compatibleEquipment.hashCode());
        return 37 * result + (this.getId() == null ? 0 : this.getId().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EquipmentType other = (EquipmentType)obj;
        if (this.compatibleEquipment == null ? other.compatibleEquipment != null : !this.compatibleEquipment.equals(other.compatibleEquipment)) {
            return false;
        }
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(MAXIMUM_COUNT_TAG, this.maximumCount);
        xw.writeAttribute(COMBAT_LOSS_PRIORITY_TAG, this.combatLossPriority);
        xw.writeAttribute(ROLE_TAG, this.role);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.captureEquipmentId != null) {
            xw.writeStartElement(CAPTURE_EQUIPMENT_TAG);
            xw.writeAttribute("id", this.captureEquipmentId);
            xw.writeAttribute(BY_INDIANS_TAG, this.captureEquipmentByIndians);
            xw.writeEndElement();
        }
        if (this.compatibleEquipment != null) {
            for (String compatible : this.compatibleEquipment) {
                xw.writeStartElement(COMPATIBLE_EQUIPMENT_TAG);
                xw.writeAttribute("id", compatible);
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.maximumCount = xr.getAttribute(MAXIMUM_COUNT_TAG, 1);
        this.combatLossPriority = xr.getAttribute(COMBAT_LOSS_PRIORITY_TAG, -1);
        this.role = xr.getRole(this.getSpecification(), ROLE_TAG, Role.class, this.getSpecification().getDefaultRole());
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.captureEquipmentId = null;
            this.captureEquipmentByIndians = false;
            this.compatibleEquipment = null;
        }
        super.readChildren(xr);
        for (Modifier modifier : this.getModifiers()) {
            if (!"model.modifier.offence".equals(modifier.getId()) && !"model.modifier.defence".equals(modifier.getId())) continue;
            this.militaryEquipment = true;
            break;
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (CAPTURE_EQUIPMENT_TAG.equals(tag)) {
            this.captureEquipmentId = xr.readId();
            this.captureEquipmentByIndians = xr.getAttribute(BY_INDIANS_TAG, false);
            xr.closeTag(CAPTURE_EQUIPMENT_TAG);
        } else if (COMPATIBLE_EQUIPMENT_TAG.equals(tag)) {
            this.addCompatibleEquipment(xr.readId());
            xr.closeTag(COMPATIBLE_EQUIPMENT_TAG);
        } else if (REQUIRED_LOCATION_ABILITY_TAG.equals(tag)) {
            String abilityId = xr.readId();
            Map<String, Boolean> required = this.getRequiredAbilities();
            required.put(abilityId, xr.getAttribute("value", true));
            this.setRequiredAbilities(required);
            spec.addAbility(abilityId);
            xr.closeTag(REQUIRED_LOCATION_ABILITY_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return EquipmentType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "equipment-type";
    }
}

