/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.Viewer;

public class CIPChirality {
    static final int NO_CHIRALITY = 0;
    static final int TIED = 0;
    static final int B_WINS = 1;
    static final int A_WINS = -1;
    static final int DIASTEREOMERIC = Integer.MAX_VALUE;
    static final int IGNORE = Integer.MIN_VALUE;
    static final int NOT_RELEVANT = Integer.MIN_VALUE;
    static final int STEREO_SAME = Integer.MAX_VALUE;
    static final int STEREO_UNDETERMINED = -1;
    static final int STEREO_BOTH = 3;
    static final int STEREO_R = 1;
    static final int STEREO_S = 2;
    static final int STEREO_Z = 1;
    static final int STEREO_E = 2;
    static final int RULE_0 = 0;
    static final int RULE_1 = 1;
    static final int RULE_2 = 2;
    static final int RULE_3 = 3;
    static final int RULE_4 = 4;
    static final int RULE_5 = 5;
    static final float TRIGONALITY_MIN = 0.2f;
    private Viewer vwr;
    int ptID;
    CIPAtom root;
    int currentRule = 1;
    Map<String, Integer> htPathPoints;
    Lst<BS> lstSmallRings = new Lst();
    int nPriorityMax;
    int maxRingSize;
    V3 vNorm = new V3();
    V3 vNorm2 = new V3();
    V3 vTemp = new V3();
    static final int[] PRIORITY_SHIFT = new int[]{24, 20, 12, 8, 4, 0};

    public String getRuleName() {
        return "" + this.currentRule;
    }

    public CIPChirality setViewer(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    private void init() {
        this.ptID = 0;
        this.maxRingSize = 0;
        this.nPriorityMax = 0;
        this.lstSmallRings.clear();
    }

    public void getChiralityForAtoms(Node[] atoms, BS bsAtoms) {
        if (bsAtoms.isEmpty()) {
            return;
        }
        this.init();
        BS bsToDo = BSUtil.copy(bsAtoms);
        boolean haveAlkenes = this.preFilterAtomList(atoms, bsToDo);
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            Node atom = atoms[i];
            String c = atom.getCIPChirality(false);
            if (c.length() > 0) {
                bsToDo.clear(i);
            } else {
                atom.setCIPChirality(this.getAtomChiralityLimited(atom, null, null, 3));
            }
            i = bsToDo.nextSetBit(i + 1);
        }
        Lst<int[]> lstEZ = new Lst<int[]>();
        if (haveAlkenes) {
            this.getSmallRings(atoms[bsAtoms.nextSetBit(0)]);
            int i2 = bsToDo.nextSetBit(0);
            while (i2 >= 0) {
                this.getAtomBondChirality(atoms[i2], false, 3, lstEZ, bsToDo);
                i2 = bsToDo.nextSetBit(i2 + 1);
            }
        }
        int i3 = bsToDo.nextSetBit(0);
        while (i3 >= 0) {
            Node a = atoms[i3];
            a.setCIPChirality(0);
            a.setCIPChirality(this.getAtomChiralityLimited(a, null, null, 5));
            i3 = bsToDo.nextSetBit(i3 + 1);
        }
        if (haveAlkenes) {
            i3 = bsToDo.nextSetBit(0);
            while (i3 >= 0) {
                this.getAtomBondChirality(atoms[i3], false, 5, lstEZ, bsToDo);
                i3 = bsToDo.nextSetBit(i3 + 1);
            }
        }
        if (this.lstSmallRings.size() > 0 && lstEZ.size() > 0) {
            this.clearSmallRingEZ(atoms, lstEZ);
        }
    }

    private boolean preFilterAtomList(Node[] atoms, BS bsToDo) {
        boolean haveAlkenes = false;
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            if (!this.couldBeChiralAtom(atoms[i])) {
                bsToDo.clear(i);
            } else if (!haveAlkenes && this.couldBeEZ(atoms[i], null)) {
                haveAlkenes = true;
            }
            i = bsToDo.nextSetBit(i + 1);
        }
        return haveAlkenes;
    }

    private boolean couldBeChiralAtom(Node a) {
        boolean mustBePlanar = false;
        block0 : switch (a.getCovalentBondCount()) {
            default: {
                return false;
            }
            case 2: {
                return a.getElementNumber() == 7;
            }
            case 3: {
                switch (a.getElementNumber()) {
                    case 6: {
                        mustBePlanar = true;
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 33: 
                    case 34: 
                    case 51: 
                    case 52: 
                    case 83: 
                    case 84: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                return false;
            }
            case 4: 
        }
        Edge[] edges = a.getEdges();
        int nH = 0;
        int j = a.getBondCount();
        while (--j >= 0) {
            if (edges[j].getOtherAtomNode(a).getAtomicAndIsotopeNumber() != 1 || ++nH != 2) continue;
            return false;
        }
        float d = this.getTrigonality(a, this.vNorm);
        return Math.abs(d) < 0.2f == mustBePlanar;
    }

    private boolean couldBeEZ(Node a, Node b) {
        switch (a.getCovalentBondCount()) {
            default: {
                return false;
            }
            case 2: {
                if (a.getElementNumber() == 7) break;
                return false;
            }
            case 3: {
                if (this.isFirstRow(a)) break;
                return false;
            }
        }
        Edge[] bonds = a.getEdges();
        int n = 0;
        int i = bonds.length;
        while (--i >= 0) {
            if (bonds[i].getCovalentOrder() != 2) continue;
            if (++n > 1) {
                return false;
            }
            Node other = bonds[i].getOtherAtomNode(a);
            if (!this.isFirstRow(other)) {
                return false;
            }
            if (b == null || other == b && b.getCovalentBondCount() != 1) continue;
            return false;
        }
        return true;
    }

    boolean isFirstRow(Node a) {
        int n = a.getElementNumber();
        return n > 2 && n <= 10;
    }

    private void getSmallRings(Node atom) {
        this.lstSmallRings = new Lst();
        this.htPathPoints = new Hashtable<String, Integer>();
        this.root = new CIPAtom(atom, null, false, false);
        this.addSmallRings(this.root);
    }

    private void addSmallRings(CIPAtom a) {
        if (a == null || a.isTerminal || a.isDuplicate || a.atom == null || a.atom.getCovalentBondCount() > 4) {
            return;
        }
        Edge[] bonds = a.atom.getEdges();
        int pt = 0;
        int i = bonds.length;
        while (--i >= 0) {
            Node atom2;
            Edge bond = bonds[i];
            if (bond == null || !bond.isCovalent() || (atom2 = bond.getOtherAtomNode(a.atom)).getElementNumber() == 1 || a.parent != null && atom2 == a.parent.atom) continue;
            a.addAtom(pt++, atom2, false, false);
        }
        for (i = 0; i < pt; ++i) {
            this.addSmallRings(a.atoms[i]);
        }
    }

    private void clearSmallRingEZ(Node[] atoms, Lst<int[]> lstEZ) {
        int i = lstEZ.size();
        while (--i >= 0) {
            int[] ab = (int[])lstEZ.get(i);
            int j = this.lstSmallRings.size();
            while (--j >= 0) {
                BS ring = (BS)this.lstSmallRings.get(j);
                if (!ring.get(ab[0]) || !ring.get(ab[1])) continue;
                atoms[ab[0]].setCIPChirality(3);
                atoms[ab[1]].setCIPChirality(3);
            }
        }
    }

    float getTrigonality(Node a, V3 vNorm) {
        P3[] pts = new P3[3];
        Edge[] bonds = a.getEdges();
        int i = bonds.length;
        int pt = 0;
        while (--i >= 0 && pt < 3) {
            if (!bonds[i].isCovalent()) continue;
            pts[pt++] = bonds[i].getOtherAtomNode(a).getXYZ();
        }
        P4 plane = Measure.getPlaneThroughPoints(pts[0], pts[1], pts[2], vNorm, this.vTemp, new P4());
        return Measure.distanceToPlane(plane, a.getXYZ());
    }

    public int getAtomChirality(Node atom) {
        this.init();
        return this.getAtomChiralityLimited(atom, null, null, 3);
    }

    public int getBondChirality(Edge bond) {
        this.init();
        this.getSmallRings(bond.getOtherAtomNode(null));
        return this.getBondChiralityLimited(bond, 3);
    }

    private void getAtomBondChirality(Node atom, boolean allBonds, int ruleMax, Lst<int[]> lstEZ, BS bsToDo) {
        Edge[] bonds = atom.getEdges();
        int index = atom.getIndex();
        int j = bonds.length;
        while (--j >= 0) {
            Edge bond = bonds[j];
            if (bond.getCovalentOrder() != 2) continue;
            int index2 = bond.getOtherAtomNode(atom).getIndex();
            if (!allBonds && index2 <= index || this.getBondChiralityLimited(bond, ruleMax) == 0) continue;
            lstEZ.addLast(new int[]{index, index2});
        }
    }

    private int getAtomChiralityLimited(Node atom, CIPAtom cipAtom, CIPAtom parent, int ruleMax) {
        int rs = 0;
        boolean isChiral = false;
        boolean isAlkene = false;
        try {
            if (cipAtom == null) {
                this.htPathPoints = new Hashtable<String, Integer>();
                cipAtom = new CIPAtom(atom, null, false, isAlkene);
                int nSubs = atom.getCovalentBondCount();
                int elemNo = atom.getElementNumber();
                isAlkene = nSubs == 3 && elemNo <= 10;
                if (nSubs != (parent == null ? 4 : 3) - (nSubs == 3 && !isAlkene ? 1 : 0)) {
                    return rs;
                }
            } else {
                atom = cipAtom.atom;
                isAlkene = cipAtom.isAlkene;
            }
            this.root = cipAtom;
            cipAtom.parent = parent;
            this.currentRule = 1;
            if (cipAtom.set()) {
                this.currentRule = 1;
                while (this.currentRule <= ruleMax && !isChiral) {
                    int i;
                    if (Logger.debugging) {
                        Logger.info("-Rule " + this.getRuleName() + " CIPChirality for " + cipAtom + "-----");
                    }
                    if (this.currentRule == 4) {
                        cipAtom.resetAuxiliaryChirality();
                        cipAtom.createAuxiliaryRSCenters(true);
                    }
                    isChiral = false;
                    cipAtom.sortSubstituents();
                    isChiral = true;
                    if (Logger.debugging) {
                        Logger.info(this.currentRule + ">>>>" + cipAtom);
                        for (i = 0; i < cipAtom.bondCount; ++i) {
                            if (cipAtom.atoms[i] != null) continue;
                            Logger.info(cipAtom.atoms[i] + " " + Integer.toHexString(cipAtom.prevPriorities[i]));
                        }
                    }
                    if (cipAtom.achiral) {
                        isChiral = false;
                        break;
                    }
                    for (i = 0; i < cipAtom.bondCount - 1; ++i) {
                        if (cipAtom.prevPriorities[i] != cipAtom.prevPriorities[i + 1]) continue;
                        isChiral = false;
                        break;
                    }
                    if (this.currentRule == 5) {
                        cipAtom.isPseudo = cipAtom.canBePseudo;
                    }
                    ++this.currentRule;
                }
                if (isChiral) {
                    int n = !isAlkene ? cipAtom.checkHandedness() : (rs = cipAtom.atoms[0].isDuplicate ? 2 : 1);
                    if (cipAtom.isPseudo && !isAlkene) {
                        rs |= 4;
                    }
                }
                if (Logger.debugging) {
                    Logger.info(atom + " " + rs);
                }
                if (Logger.debugging) {
                    Logger.info("----------------------------------");
                }
            }
        }
        catch (Throwable e) {
            System.out.println(e + " in CIPChirality");
            if (!this.vwr.isJS) {
                e.printStackTrace();
            }
            return 3;
        }
        return rs;
    }

    private int getBondChiralityLimited(Edge bond, int ruleMax) {
        if (Logger.debugging) {
            Logger.info("get Bond Chirality " + bond);
        }
        int ez = 0;
        Atom[] atoms = this.vwr.ms.at;
        if (bond.getCovalentOrder() == 2) {
            Atom b;
            Atom a = atoms[bond.getAtomIndex1()];
            if (!this.couldBeEZ(a, b = atoms[bond.getAtomIndex2()])) {
                return 0;
            }
            this.htPathPoints = new Hashtable<String, Integer>();
            CIPAtom a1 = new CIPAtom(a, null, false, true);
            CIPAtom b1 = new CIPAtom(b, null, false, true);
            int atop = this.getAtomChiralityLimited(a, a1, b1, ruleMax) - 1;
            this.htPathPoints = new Hashtable<String, Integer>();
            CIPAtom a2 = new CIPAtom(a, null, false, true);
            CIPAtom b2 = new CIPAtom(b, null, false, true);
            int btop = this.getAtomChiralityLimited(b, b2, a2, ruleMax) - 1;
            if (atop >= 0 && btop >= 0) {
                int n = ez = this.isCIS(b2.atoms[btop], b2, a1, a1.atoms[atop]) ? 1 : 2;
            }
            if (ez != 0) {
                a.setCIPChirality(ez << 3);
                b.setCIPChirality(ez << 3);
            }
            if (Logger.debugging) {
                Logger.info(bond + " " + (ez == 1 ? "Z" : (ez == 2 ? "E" : "_")));
            }
        }
        return ez;
    }

    boolean isCIS(CIPAtom a, CIPAtom b, CIPAtom c, CIPAtom d) {
        Measure.getNormalThroughPoints(a.atom.getXYZ(), b.atom.getXYZ(), c.atom.getXYZ(), this.vNorm, this.vTemp);
        V3 vNorm2 = new V3();
        Measure.getNormalThroughPoints(b.atom.getXYZ(), c.atom.getXYZ(), d.atom.getXYZ(), vNorm2, this.vTemp);
        return this.vNorm.dot(vNorm2) > 0.0f;
    }

    public int sign(int score) {
        return score < 0 ? -1 : (score > 0 ? 1 : 0);
    }

    private class CIPAtom
    implements Comparable<CIPAtom>,
    Cloneable {
        Node atom;
        private int id;
        CIPAtom parent;
        private CIPAtom rootSubstituent;
        private int elemNo;
        private int massNo;
        private int sphere;
        BS bsPath;
        private String myPath = "";
        private int rootDistance;
        private int nAtoms;
        private int nPriorities;
        private int h1Count;
        private String knownAtomChirality = "~";
        private boolean isSet;
        boolean isDuplicate = true;
        boolean isTerminal;
        boolean isAlkene;
        private boolean isAlkeneAtom2;
        boolean doCheckPseudo;
        public boolean isPseudo;
        boolean achiral;
        public int bondCount;
        CIPAtom[] atoms = new CIPAtom[4];
        private int[] priorities = new int[4];
        int[] prevPriorities = new int[4];
        private String[] rule4List;
        private P3 lonePair;
        private int atomIndex;
        private int auxEZ = -1;
        private CIPAtom auxParentReversed;
        private CIPAtom auxPseudo;
        boolean canBePseudo = true;

        CIPAtom(Node atom, CIPAtom parent, boolean isDuplicate, boolean isAlkene) {
            this.id = ++CIPChirality.this.ptID;
            this.parent = parent;
            if (atom == null) {
                return;
            }
            this.isAlkene = isAlkene;
            this.atom = atom;
            this.elemNo = atom.getElementNumber();
            this.massNo = atom.getNominalMass();
            this.atomIndex = atom.getIndex();
            this.bondCount = atom.getCovalentBondCount();
            if (this.bondCount == 3 && !isAlkene && this.elemNo > 10) {
                this.getLonePair();
            }
            this.canBePseudo = this.bondCount == 4 || this.bondCount == 3 && this.lonePair != null;
            String c = atom.getCIPChirality(false);
            if (c.equals("") || c.equals("r") || c.equals("s")) {
                c = "~";
            } else if (c.equals("E")) {
                c = "T";
            } else if (c.equals("Z")) {
                c = "C";
            }
            this.knownAtomChirality = c;
            if (parent != null) {
                this.sphere = parent.sphere + 1;
            }
            if (this.sphere == 1) {
                this.rootSubstituent = this;
            } else if (parent != null) {
                this.rootSubstituent = parent.rootSubstituent;
            }
            this.bsPath = parent == null ? new BS() : BSUtil.copy(parent.bsPath);
            boolean wasDuplicate = isDuplicate;
            if (parent == null) {
                this.bsPath.set(this.atomIndex);
                this.rootDistance = 0;
            } else if (atom == CIPChirality.this.root.atom) {
                this.rootDistance = 0;
                if (this.sphere > CIPChirality.this.maxRingSize) {
                    CIPChirality.this.maxRingSize = this.sphere;
                }
                isDuplicate = true;
            } else if (this.bsPath.get(this.atomIndex)) {
                isDuplicate = true;
                this.rootDistance = CIPChirality.this.htPathPoints.get(this.rootSubstituent.atom.toString() + atom);
            } else {
                this.bsPath.set(this.atomIndex);
                this.rootDistance = parent.rootDistance + 1;
                CIPChirality.this.htPathPoints.put(this.rootSubstituent.atom.toString() + atom, new Integer(this.rootDistance));
            }
            this.isDuplicate = isDuplicate;
            this.myPath = (parent != null ? parent.myPath + "-" : "") + this;
            if (Logger.debugging) {
                Logger.info("new CIPAtom " + parent + "->" + this);
            }
            if (isDuplicate && !wasDuplicate) {
                this.updateRingList();
            }
        }

        private void getLonePair() {
            float d = CIPChirality.this.getTrigonality(this.atom, CIPChirality.this.vNorm);
            if (Math.abs(d) > 0.2f) {
                this.lonePair = new P3();
                CIPChirality.this.vNorm.scale(d);
                this.lonePair.add2(this.atom.getXYZ(), CIPChirality.this.vNorm);
            }
        }

        private void updateRingList() {
            BS bsRing = BSUtil.newAndSetBit(this.atomIndex);
            CIPAtom p = this;
            int index = -1;
            while ((p = p.parent) != null && index != this.atomIndex) {
                index = p.atomIndex;
                bsRing.set(index);
            }
            if (bsRing.cardinality() < 8) {
                int i = CIPChirality.this.lstSmallRings.size();
                while (--i >= 0) {
                    if (!((BS)CIPChirality.this.lstSmallRings.get(i)).equals(bsRing)) continue;
                    return;
                }
                CIPChirality.this.lstSmallRings.addLast(bsRing);
            }
        }

        boolean set() {
            if (this.isSet) {
                return true;
            }
            this.isSet = true;
            if (this.isDuplicate) {
                return true;
            }
            int nBonds = this.atom.getBondCount();
            Edge[] bonds = this.atom.getEdges();
            if (Logger.debuggingHigh) {
                Logger.info("set " + this);
            }
            int pt = 0;
            block5: for (int i = 0; i < nBonds; ++i) {
                Edge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                Node other = bond.getOtherAtomNode(this.atom);
                boolean isParent = this.parent != null && this.parent.atom == other;
                int order = bond.getCovalentOrder();
                if (order == 2) {
                    if (this.elemNo > 10 || !CIPChirality.this.isFirstRow(other)) {
                        order = 1;
                    } else {
                        this.isAlkene = true;
                        if (isParent) {
                            this.isAlkeneAtom2 = true;
                            this.knownAtomChirality = bond.getCIPChirality(false);
                        }
                    }
                }
                if (nBonds == 1 && order == 1 && isParent) {
                    this.isTerminal = true;
                    return true;
                }
                switch (order) {
                    case 3: {
                        if (this.addAtom(pt++, other, isParent, false) == null) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 2: {
                        if (this.addAtom(pt++, other, order != 2 || isParent, order == 2) == null) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 1: {
                        if (isParent || this.addAtom(pt++, other, order != 1 && this.elemNo <= 10, false) != null) continue block5;
                        this.isTerminal = true;
                        return false;
                    }
                    default: {
                        this.isTerminal = true;
                        return false;
                    }
                }
            }
            this.isTerminal = pt == 0;
            this.nAtoms = pt;
            while (pt < this.atoms.length) {
                this.atoms[pt] = new CIPAtom(null, this, true, false);
                ++pt;
            }
            int ruleNow = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = 1;
            Arrays.sort(this.atoms);
            CIPChirality.this.currentRule = ruleNow;
            return !this.isTerminal;
        }

        CIPAtom addAtom(int i, Node other, boolean isDuplicate, boolean isAlkene) {
            int atomIsotope;
            if (i >= this.atoms.length) {
                if (Logger.debugging) {
                    Logger.info(" too many bonds on " + this.atom);
                }
                return null;
            }
            if (this.parent == null && CIPChirality.this.currentRule != 0 && (atomIsotope = other.getAtomicAndIsotopeNumber()) == 1 && ++this.h1Count > 1) {
                if (Logger.debugging) {
                    Logger.info(" second H atom found on " + this.atom);
                }
                return null;
            }
            this.atoms[i] = new CIPAtom(other, this, isDuplicate, isAlkene);
            if (CIPChirality.this.currentRule > 2) {
                this.prevPriorities[i] = this.getBasePriority(this.atoms[i]);
            }
            return this.atoms[i];
        }

        /*
         * Enabled aggressive block sorting
         */
        void sortSubstituents() {
            if (Logger.debugging) {
                Logger.info(CIPChirality.this.root + "---sortSubstituents---" + this);
                for (int i = 0; i < 4; ++i) {
                    Logger.info(CIPChirality.this.getRuleName() + ": " + this + "[" + i + "]=" + this.atoms[i].myPath + " " + Integer.toHexString(this.prevPriorities[i]));
                }
            }
            int[] indices = new int[4];
            Lst<int[]> ties = null;
            for (int i = 0; i < 4; ++i) {
                this.priorities[i] = 1;
                if (this.prevPriorities[i] != 0 || CIPChirality.this.currentRule <= 1) continue;
                this.prevPriorities[i] = this.getBasePriority(this.atoms[i]);
            }
            boolean checkRule4List = CIPChirality.this.currentRule > 3 && this.rule4List != null;
            int i = 0;
            while (true) {
                CIPAtom a;
                if (i < 4) {
                    a = this.atoms[i];
                } else {
                    int i2;
                    CIPAtom[] newAtoms = new CIPAtom[4];
                    int[] newPriorities = new int[4];
                    int[] newPrevPriorities = new int[4];
                    BS bs = new BS();
                    int shift = PRIORITY_SHIFT[CIPChirality.this.currentRule];
                    for (i2 = 0; i2 < 4; ++i2) {
                        int p;
                        int pt = indices[i2];
                        CIPAtom a2 = newAtoms[pt] = this.atoms[i2];
                        newPriorities[pt] = p = this.priorities[i2];
                        newPrevPriorities[pt] = this.prevPriorities[i2] | p << shift;
                        if (a2.atom == null) continue;
                        bs.set(this.priorities[i2]);
                    }
                    this.atoms = newAtoms;
                    this.priorities = newPriorities;
                    this.prevPriorities = newPrevPriorities;
                    this.nPriorities = bs.cardinality();
                    if (this.nPriorities > CIPChirality.this.nPriorityMax) {
                        CIPChirality.this.nPriorityMax = this.nPriorities;
                    }
                    if (ties != null) {
                        switch (ties.size()) {
                            case 1: {
                                this.checkPseudoHandedness((int[])ties.get(0), indices);
                                break;
                            }
                            case 2: {
                                this.canBePseudo = false;
                                break;
                            }
                        }
                    }
                    if (Logger.debugging) {
                        Logger.info(this.atom + " nPriorities = " + this.nPriorities);
                        for (i2 = 0; i2 < 4; ++i2) {
                            Logger.info(this.myPath + "[" + i2 + "]=" + this.atoms[i2] + " " + this.priorities[i2] + " new");
                        }
                        Logger.info("-------");
                    }
                    return;
                }
                for (int j = i + 1; j < 4; ++j) {
                    int score;
                    CIPAtom b = this.atoms[j];
                    int n = a.atom == null ? 1 : (b.atom == null ? -1 : (this.prevPriorities[i] == this.prevPriorities[j] ? 0 : (score = this.prevPriorities[j] < this.prevPriorities[i] ? 1 : -1)));
                    if (score == 0) {
                        int n2 = score = checkRule4List ? this.checkRule4And5(i, j) : a.compareTo(b);
                    }
                    if (Logger.debuggingHigh) {
                        Logger.info("ordering " + this.id + "." + i + "." + j + " " + this + "-" + a + " vs " + b + " = " + score);
                    }
                    switch (score) {
                        case -2147483648: {
                            if (checkRule4List && this.sphere == 0) {
                                this.achiral = true;
                            }
                            int n3 = i;
                            indices[n3] = indices[n3] + 1;
                            if (!Logger.debuggingHigh) break;
                            Logger.info(this.atom + "." + b + " ends up with tie with " + a);
                            break;
                        }
                        case 1: {
                            int n4 = i;
                            indices[n4] = indices[n4] + 1;
                            int n5 = i;
                            this.priorities[n5] = this.priorities[n5] + 1;
                            if (!Logger.debuggingHigh) break;
                            Logger.info(this + "." + b + " B-beats " + a);
                            break;
                        }
                        case -1: {
                            int n6 = j;
                            indices[n6] = indices[n6] + 1;
                            int n7 = j;
                            this.priorities[n7] = this.priorities[n7] + 1;
                            if (!Logger.debuggingHigh) break;
                            Logger.info(this + "." + a + " A-beats " + b);
                            break;
                        }
                        case 0: {
                            score = a.breakTie(b);
                            switch (CIPChirality.this.sign(score)) {
                                case 0: {
                                    int n8 = i;
                                    indices[n8] = indices[n8] + 1;
                                    if (!Logger.debuggingHigh) break;
                                    Logger.info(this + "." + b + " ends up with tie with " + a);
                                    break;
                                }
                                case 1: {
                                    int n9 = i;
                                    indices[n9] = indices[n9] + 1;
                                    int n10 = i;
                                    this.priorities[n10] = this.priorities[n10] + 1;
                                    if (!Logger.debuggingHigh) break;
                                    Logger.info(this + "." + b + " wins in tie with " + a);
                                    break;
                                }
                                case -1: {
                                    int n11 = j;
                                    indices[n11] = indices[n11] + 1;
                                    int n12 = j;
                                    this.priorities[n12] = this.priorities[n12] + 1;
                                    if (!Logger.debuggingHigh) break;
                                    Logger.info(this + "." + a + " wins in tie with " + b);
                                }
                            }
                            break;
                        }
                    }
                    if (!this.doCheckPseudo) continue;
                    this.doCheckPseudo = false;
                    if (ties == null) {
                        ties = new Lst<int[]>();
                    }
                    ties.addLast(new int[]{i, j});
                }
                ++i;
            }
        }

        private int breakTie(CIPAtom b) {
            int score = this.checkDuplicate(b);
            if (score != 0) {
                return score * this.sphere;
            }
            if (this.atom == null != (b.atom == null)) {
                return (this.atom == null ? 1 : -1) * (this.sphere + 1);
            }
            if (!this.set() || !b.set() || this.isTerminal && b.isTerminal || this.isDuplicate && b.isDuplicate) {
                return 0;
            }
            if (this.isTerminal != b.isTerminal) {
                return (this.isTerminal ? 1 : -1) * (this.sphere + 1);
            }
            if (Logger.debugging) {
                Logger.info("tie for " + this + " and " + b);
            }
            if ((score = this.compareShallow(b)) != 0) {
                return score;
            }
            this.sortSubstituents();
            b.sortSubstituents();
            return this.compareDeep(b);
        }

        private int compareShallow(CIPAtom b) {
            for (int i = 0; i < this.nAtoms; ++i) {
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                if (ai == null || bi == null) {
                    return ai == null ? 1 : (bi == null ? -1 : 0);
                }
                int score = ai.checkCurrentRule(bi);
                if (score == Integer.MIN_VALUE) {
                    score = 0;
                }
                if (score == 0) continue;
                if (Logger.debugging) {
                    Logger.info("compareShallow " + ai + " " + bi + ": " + score * this.sphere);
                }
                return score * this.sphere;
            }
            return 0;
        }

        private int compareDeep(CIPAtom b) {
            int finalScore = this.nAtoms == 0 ? 1 : 0;
            int absScore = Integer.MAX_VALUE;
            for (int i = 0; i < this.nAtoms; ++i) {
                int abs;
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                int score = ai.breakTie(bi);
                if (score == 0 || (abs = Math.abs(score)) >= absScore) continue;
                absScore = abs;
                finalScore = score;
            }
            if (Logger.debugging) {
                Logger.info("compareDeep " + this + " " + b + ": " + finalScore);
            }
            return finalScore;
        }

        @Override
        public int compareTo(CIPAtom b) {
            int score;
            int n = b == null ? -1 : (this.atom == null != (b.atom == null) ? (this.atom == null ? 1 : -1) : ((score = this.checkCurrentRule(b)) == Integer.MIN_VALUE ? 0 : (score != 0 ? score : this.checkDuplicate(b))));
            return n;
        }

        private int checkDuplicate(CIPAtom b) {
            return b.isDuplicate == this.isDuplicate ? 0 : (b.isDuplicate ? -1 : 1);
        }

        public int checkCurrentRule(CIPAtom b) {
            switch (CIPChirality.this.currentRule) {
                default: {
                    return b.atom == this.atom ? 0 : (b.atom == null ? -1 : (this.atom == null ? 1 : 0));
                }
                case 1: {
                    int score = this.checkRule1a(b);
                    return score == 0 ? this.checkRule1b(b) : score;
                }
                case 2: {
                    return this.checkRule2(b);
                }
                case 3: {
                    return this.checkRule3(b);
                }
                case 4: {
                    return 0;
                }
                case 5: 
            }
            return this.checkRule5(b);
        }

        private int checkRule1a(CIPAtom b) {
            return b.atom == this.atom ? 0 : (b.atom == null ? -1 : (this.atom == null ? 1 : (b.elemNo < this.elemNo ? -1 : (b.elemNo > this.elemNo ? 1 : 0))));
        }

        private int checkRule1b(CIPAtom b) {
            return !b.isDuplicate || !this.isDuplicate ? 0 : (b.rootDistance < this.rootDistance ? 1 : (b.rootDistance > this.rootDistance ? -1 : 0));
        }

        private int checkRule2(CIPAtom b) {
            return b.massNo < this.massNo ? -1 : (b.massNo > this.massNo ? 1 : 0);
        }

        private int checkRule3(CIPAtom b) {
            int zb;
            int za;
            return this.parent == null || !this.parent.isAlkeneAtom2 || !b.parent.isAlkeneAtom2 || this.isDuplicate || b.isDuplicate ? Integer.MIN_VALUE : (this.parent == b.parent ? CIPChirality.this.sign(this.breakTie(b)) : ((za = this.parent.getEZaux()) < (zb = b.parent.getEZaux()) ? -1 : (za > zb ? 1 : 0)));
        }

        private int getEZaux() {
            if (this.auxEZ == -1 && (this.auxEZ = this.parent.auxEZ) == -1) {
                CIPAtom winner1 = null;
                CIPAtom winner2 = null;
                CIPAtom atom1 = null;
                this.auxEZ = 3;
                this.sortSubstituents();
                winner2 = this.getTopAtom();
                if (winner2 != null) {
                    if (this.auxParentReversed == null) {
                        if (Logger.debugging) {
                            Logger.info("reversing path for " + this.parent);
                        }
                        atom1 = (CIPAtom)this.parent.clone();
                        atom1.addReturnPath(this, this.parent);
                    } else {
                        atom1 = this.auxParentReversed;
                    }
                    atom1.sortSubstituents();
                    winner1 = atom1.getTopAtom();
                    if (winner1 != null) {
                        int n = this.auxEZ = CIPChirality.this.isCIS(winner2, this, atom1, winner1) ? 1 : 2;
                        if (Logger.debugging) {
                            Logger.info("getZaux " + (this.auxEZ == 1 ? "Z" : "E") + " for " + this.atom + "=" + this.parent.atom + " : " + winner1 + " " + winner2);
                        }
                    }
                }
            }
            this.parent.auxEZ = this.auxEZ;
            return this.auxEZ;
        }

        private Lst<CIPAtom> getReturnPath(CIPAtom a) {
            Lst<CIPAtom> path = new Lst<CIPAtom>();
            while (a.parent != null && a.parent.atoms[0] != null) {
                if (Logger.debugging) {
                    Logger.info("path:" + a.parent.atom + "->" + a.atom);
                }
                a = a.parent;
                path.addLast(a);
            }
            path.addLast(null);
            return path;
        }

        private void addReturnPath(CIPAtom last, CIPAtom fromAtom) {
            Lst<CIPAtom> path = this.getReturnPath(fromAtom);
            CIPAtom thisAtom = this;
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                CIPAtom p = (CIPAtom)path.get(i);
                if (p == null) {
                    p = new CIPAtom(null, this, true, this.isAlkene);
                } else {
                    int s = p.sphere;
                    p = (CIPAtom)p.clone();
                    p.sphere = s + 1;
                }
                thisAtom.replaceParentSubstituent(last, p);
                if (last == null) break;
                last = last.parent;
                thisAtom = p;
            }
        }

        private int checkRule4And5(int i, int j) {
            if (this.rule4List[i] == null && this.rule4List[j] == null) {
                return 0;
            }
            if (this.rule4List[i] == null || this.rule4List[j] == null) {
                return this.rule4List[j] == null ? -1 : 1;
            }
            return this.compareMataPair(i, j);
        }

        private int compareMataPair(int ia, int ib) {
            boolean isRule5 = CIPChirality.this.currentRule == 5;
            String aStr = this.rule4List[ia];
            String bStr = this.rule4List[ib];
            if (aStr != null && aStr.indexOf("?") == 1) {
                aStr = this.getMataList(ia, isRule5);
                bStr = this.getMataList(ib, isRule5);
                if (aStr.length() != bStr.length()) {
                    return aStr.length() < bStr.length() ? -1 : 1;
                }
                if (isRule5) {
                    return aStr.compareTo(bStr);
                }
                if (aStr.indexOf("|") >= 0 || bStr.indexOf("|") >= 0) {
                    String[] aList = PT.split(aStr, "|");
                    String[] bList = PT.split(bStr, "|");
                    int minScore = Integer.MAX_VALUE;
                    int sumScore = 0;
                    aStr = aList[0];
                    bStr = bList[0];
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            int score = this.compareRule4PairStr(aList[i], bList[j], true);
                            sumScore += score;
                            if (score == 0 || Math.abs(score) > minScore) continue;
                            minScore = Math.abs(score);
                            aStr = aList[i];
                            bStr = bList[j];
                        }
                    }
                    if (sumScore == 0) {
                        return 0;
                    }
                }
            } else {
                aStr = PT.rep(aStr.substring(1), "~", "");
                bStr = PT.rep(bStr.substring(1), "~", "");
            }
            return this.compareRule4PairStr(aStr, bStr, false);
        }

        private int compareRule4PairStr(String aStr, String bStr, boolean isRSTest) {
            System.out.println(this + " Rule 4b comparing " + aStr + " " + bStr);
            this.doCheckPseudo = false;
            int n = aStr.length();
            if (n == 0 || n != bStr.length()) {
                return 0;
            }
            char aref = aStr.charAt(0);
            char bref = bStr.charAt(0);
            for (int c = 1; c < n; ++c) {
                boolean blike;
                boolean alike = aref == aStr.charAt(c);
                boolean bl = blike = bref == bStr.charAt(c);
                if (alike == blike) continue;
                return (isRSTest ? c : 1) * (alike ? -1 : 1);
            }
            if (isRSTest) {
                return 0;
            }
            if (aref == bref) {
                return Integer.MIN_VALUE;
            }
            if (!this.canBePseudo) {
                CIPChirality.this.root.canBePseudo = false;
            }
            this.doCheckPseudo = this.canBePseudo && (aref == 'R' || aref == 'S');
            return aref < bref ? -1 : 1;
        }

        private String getMataList(int ia, boolean isRule5) {
            String[] rule4List = this.atoms[ia].rule4List;
            int n = 0;
            int i = rule4List.length;
            while (--i >= 0) {
                if (rule4List[i] == null) continue;
                ++n;
            }
            Object[] listA = new String[n];
            int i2 = rule4List.length;
            while (--i2 >= 0) {
                if (rule4List[i2] == null) continue;
                listA[--n] = rule4List[i2];
            }
            Arrays.sort(listA);
            String aref = isRule5 ? "R" : this.getMataRef((String[])listA);
            switch (aref.length()) {
                default: {
                    System.out.println("???");
                    return "???";
                }
                case 1: {
                    return this.getMataSequence((String[])listA, aref, isRule5);
                }
                case 2: 
            }
            return this.getMataSequence((String[])listA, "R", false) + "|" + this.getMataSequence((String[])listA, "S", false);
        }

        private String getMataSequence(String[] lst, String aref, boolean isRule5) {
            Object[] sorted = isRule5 ? lst : this.getMataSortedList(lst, aref);
            int n = sorted.length;
            int len = 0;
            for (int i = 0; i < n; ++i) {
                String rs = sorted[i];
                if (rs.length() <= len) continue;
                len = rs.length();
            }
            String mlist = "";
            for (int i = 1; i < len; ++i) {
                Object rs;
                int j;
                for (j = 0; j < n; ++j) {
                    char ch;
                    rs = sorted[j];
                    if (i >= ((String)rs).length() || (ch = ((String)rs).charAt(i)) == '~' || ch == ';') continue;
                    mlist = mlist + ch;
                }
                if (!isRule5) continue;
                for (j = 0; j < n; ++j) {
                    rs = sorted[j];
                    if (i >= ((String)rs).length()) continue;
                    sorted[j] = ((String)rs).substring(0, i) + "~" + ((String)rs).substring(i + 1);
                }
                Arrays.sort(sorted);
            }
            return mlist;
        }

        private String[] getMataSortedList(String[] lst, String aref) {
            int i;
            int n = lst.length;
            Object[] sorted = new String[n];
            for (i = 0; i < n; ++i) {
                sorted[i] = PT.rep(lst[i], aref, "A");
            }
            Arrays.sort(sorted);
            for (i = 0; i < n; ++i) {
                sorted[i] = PT.rep((String)sorted[i], "A", aref);
            }
            if (Logger.debuggingHigh) {
                for (i = 0; i < n; ++i) {
                    Logger.info("Sorted Mata list " + i + " " + (String)sorted[i]);
                }
            }
            return sorted;
        }

        private String getMataRef(String[] lst) {
            int pt = Integer.MAX_VALUE;
            for (int i = 0; i < lst.length; ++i) {
                int j;
                String s = lst[i];
                int n = s.length();
                for (j = 1; j < n && s.charAt(j) == '~'; ++j) {
                }
                if (j >= pt) continue;
                pt = j;
            }
            switch (lst.length) {
                case 1: {
                    return lst[0].substring(pt, pt + 1);
                }
                case 2: {
                    char pa = lst[0].charAt(0);
                    char pb = lst[1].charAt(0);
                    char ca = lst[0].charAt(pt);
                    char cb = lst[1].charAt(pt);
                    return ca == cb || cb == '~' || pa < pb && ca != '~' ? "" + ca : (pa == pb ? "RS" : "" + cb);
                }
                case 3: {
                    char p1 = lst[0].charAt(0);
                    char p2 = lst[1].charAt(0);
                    char p3 = lst[2].charAt(0);
                    char c1 = lst[0].charAt(pt);
                    char c2 = lst[1].charAt(pt);
                    char c3 = lst[2].charAt(pt);
                    if (p1 == p2 && p2 == p3) {
                        return c1 == c2 || c2 == '~' ? "" + c1 : (c2 == c3 ? "" + c3 : "RS");
                    }
                    if (p1 == p2) {
                        return p1 == '~' ? "" + c3 : (c1 == c2 || c2 == '~' ? "" + c1 : "RS");
                    }
                    if (p2 == p3) {
                        return p1 != '~' ? "" + c1 : (c2 == c3 || c3 == '~' ? "" + c2 : "RS");
                    }
                    return "" + (c1 != '~' ? c1 : (c2 != '~' ? c2 : c3));
                }
            }
            return "";
        }

        String createAuxiliaryRSCenters(boolean isRoot) {
            if (this.auxParentReversed != null) {
                this.auxParentReversed.createAuxiliaryRSCenters(true);
            }
            if (this.auxPseudo != null) {
                this.auxPseudo.createAuxiliaryRSCenters(true);
            }
            int rs = -1;
            String subRS = "";
            String s = isRoot ? "" : "~";
            boolean done = true;
            if (this.atom != null) {
                CIPAtom atom1;
                this.rule4List = new String[4];
                int[] mataList = new int[4];
                int nRS = 0;
                for (int i = 0; i < 4; ++i) {
                    CIPAtom a = this.atoms[i];
                    if (a == null || a.isDuplicate || a.isTerminal) continue;
                    String ssub = a.createAuxiliaryRSCenters(false);
                    this.rule4List[i] = this.priorities[i] + ssub;
                    if ("sr".indexOf(ssub) >= 0 || ssub.indexOf("R") >= 0 || ssub.indexOf("S") >= 0) {
                        mataList[nRS] = i;
                        ++nRS;
                        subRS = subRS + ssub + ";";
                        continue;
                    }
                    this.rule4List[i] = null;
                }
                int adj = 0;
                switch (nRS) {
                    case 0: {
                        subRS = "";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (isRoot) break;
                        adj = this.compareRule4aEnantiomers(this.rule4List[mataList[0]], this.rule4List[mataList[1]]);
                        switch (adj) {
                            case 0x7FFFFFFF: {
                                done = false;
                                break;
                            }
                            case -2147483648: {
                                done = false;
                                adj = 0;
                                break;
                            }
                            case 0: {
                                subRS = "";
                                break;
                            }
                            case -1: 
                            case 1: {
                                subRS = "";
                            }
                        }
                        break;
                    }
                    case 3: 
                    case 4: {
                        done = false;
                    }
                }
                if (!done) {
                    s = "?" + this.sphere;
                    subRS = "[" + subRS + "]";
                } else if (!isRoot && (this.bondCount == 4 && this.nPriorities >= 3 - Math.abs(adj) || this.bondCount == 3 && this.elemNo > 10 && this.nPriorities >= 2 - Math.abs(adj)) && (atom1 = (CIPAtom)this.clone()).set()) {
                    atom1.addReturnPath(null, this);
                    int thisRule = CIPChirality.this.currentRule;
                    CIPChirality.this.currentRule = 1;
                    atom1.sortSubstituents();
                    CIPChirality.this.currentRule = thisRule;
                    rs = atom1.checkHandedness();
                    String string = rs == 1 ? "R" : (s = rs == 2 ? "S" : "~");
                    if (adj != 0) {
                        s = s.toLowerCase();
                    }
                }
            }
            s = s + subRS;
            System.out.println(this + " creating aux " + s);
            return s;
        }

        private int compareRule4aEnantiomers(String rs1, String rs2) {
            if (rs1.indexOf("R") < 0 && rs1.indexOf("S") < 0 || rs1.charAt(0) != rs2.charAt(0)) {
                return Integer.MIN_VALUE;
            }
            int n = rs1.length();
            if (n != rs2.length()) {
                return Integer.MIN_VALUE;
            }
            if (rs1.equals(rs2)) {
                return 0;
            }
            int finalScore = 0;
            for (int i = 1; i < n; ++i) {
                int i1 = " RS".indexOf(rs1.charAt(i));
                int score = i1 + " RS".indexOf(rs2.charAt(i));
                if (score != 0 && score != 3) {
                    return Integer.MAX_VALUE;
                }
                if (finalScore != 0) continue;
                finalScore = i1 == 1 ? -1 : 1;
            }
            return finalScore;
        }

        private void checkPseudoHandedness(int[] iab, int[] indices) {
            CIPAtom atom1;
            int ia = iab[0];
            int ib = iab[1];
            if (this.auxPseudo == null) {
                atom1 = (CIPAtom)this.clone();
                atom1.atoms[indices[ia]] = new CIPAtom(null, atom1, false, this.isAlkene);
                atom1.atoms[indices[ib]] = new CIPAtom(null, atom1, false, this.isAlkene);
                atom1.addReturnPath(null, this);
            } else {
                atom1 = this.auxPseudo;
            }
            int thisRule = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = 1;
            atom1.sortSubstituents();
            CIPChirality.this.currentRule = thisRule;
            atom1.atoms[this.bondCount - 2] = this.atoms[Math.min(indices[ia], indices[ib])];
            atom1.atoms[this.bondCount - 1] = this.atoms[Math.max(indices[ia], indices[ib])];
            int rs = atom1.checkHandedness();
            if (Logger.debugging) {
                for (int i = 0; i < 4; ++i) {
                    Logger.info("pseudo " + rs + " " + this.priorities[i] + " " + this.atoms[i].myPath);
                }
            }
            if (rs == 1 || rs == 2) {
                this.isPseudo = true;
            }
        }

        private int getBasePriority(CIPAtom a) {
            int code = 0;
            code = a.atom == null ? 524287 << PRIORITY_SHIFT[2] : 127 - a.elemNo << PRIORITY_SHIFT[0] | 255 - a.massNo << PRIORITY_SHIFT[2];
            return code;
        }

        void resetAuxiliaryChirality() {
            this.auxEZ = -1;
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] == null || this.atoms[i].atom == null) continue;
                this.atoms[i].resetAuxiliaryChirality();
            }
            if (this.auxParentReversed != null) {
                this.auxParentReversed.resetAuxiliaryChirality();
            }
            if (this.auxPseudo != null) {
                this.auxPseudo.resetAuxiliaryChirality();
            }
        }

        private void replaceParentSubstituent(CIPAtom newParent, CIPAtom newSub) {
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] != newParent && (newParent != null || this.atoms[i].atom != null)) continue;
                this.atoms[i] = newSub;
                if (Logger.debugging) {
                    Logger.info("replace " + this + "[" + i + "]=" + newSub);
                }
                this.prevPriorities[i] = this.getBasePriority(this.atoms[i]);
                this.parent = newParent;
                break;
            }
        }

        private CIPAtom getTopAtom() {
            int i;
            int n = i = this.atoms[0].isDuplicate ? 1 : 0;
            return this.priorities[i] == this.priorities[i + 1] ? null : (this.priorities[i] < this.priorities[i + 1] ? this.atoms[i] : this.atoms[i + 1]);
        }

        private String getWorkingChirality() {
            return "rs".indexOf(this.knownAtomChirality) >= 0 ? "~" : this.knownAtomChirality;
        }

        private int checkRule5(CIPAtom b) {
            int isRb;
            if (this.isTerminal || this.isDuplicate) {
                return 0;
            }
            int isRa = ";srSR;".indexOf(this.getWorkingChirality());
            return isRa == (isRb = ";srSR;".indexOf(b.getWorkingChirality())) ? 0 : (isRa > isRb ? -1 : 1);
        }

        int checkHandedness() {
            P3 p1 = this.atoms[0].atom.getXYZ();
            P3 p2 = this.atoms[1].atom.getXYZ();
            P3 p3 = this.atoms[2].atom.getXYZ();
            P3 p4 = this.lonePair == null ? this.atoms[3].atom.getXYZ() : this.lonePair;
            float d = Measure.getNormalThroughPoints(p1, p2, p3, CIPChirality.this.vNorm, CIPChirality.this.vTemp);
            return Measure.distanceToPlaneV(CIPChirality.this.vNorm, d, p4) > 0.0f ? 1 : 2;
        }

        public Object clone() {
            CIPAtom a = null;
            try {
                a = (CIPAtom)super.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            a.id = CIPChirality.this.ptID++;
            a.atoms = new CIPAtom[4];
            a.priorities = new int[4];
            a.prevPriorities = new int[4];
            for (int i = 0; i < 4; ++i) {
                a.priorities[i] = this.priorities[i];
                if (this.atoms[i] == null) continue;
                a.atoms[i] = this.atoms[i];
                a.prevPriorities[i] = this.getBasePriority(this.atoms[i]);
            }
            if (Logger.debugging) {
                Logger.info("cloning " + this + " as " + a);
            }
            return a;
        }

        public String toString() {
            return this.atom == null ? "<null>" : "[" + CIPChirality.this.currentRule + "." + this.sphere + "." + this.atom.getAtomName() + (this.isDuplicate ? "*" : "") + "]";
        }
    }
}

