/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.source.Source;
import java.net.URI;
import java.util.Objects;

final class BreakpointLocation
implements Comparable<BreakpointLocation> {
    public static final BreakpointLocation ANY = new BreakpointLocation();
    private final Object key;
    private final int line;
    private final int column;

    BreakpointLocation(Object key, int line) {
        assert (key instanceof Source || key instanceof URI);
        assert (line > 0 || line == -1);
        this.key = key;
        this.line = line;
        this.column = -1;
    }

    BreakpointLocation(Object key, int line, int column) {
        assert (key instanceof Source || key instanceof URI);
        assert (line > 0);
        assert (column > 0);
        this.key = key;
        this.line = line;
        this.column = column;
    }

    private BreakpointLocation() {
        this.key = null;
        this.line = -1;
        this.column = -1;
    }

    Object getKey() {
        return this.key;
    }

    @Override
    public int compareTo(BreakpointLocation o) {
        int lineOrder;
        Object key1 = this.key;
        Object key2 = o.key;
        if (key1 instanceof Source && key2 instanceof Source) {
            int nameOrder = ((Source)key1).getName().compareTo(((Source)key2).getName());
            if (nameOrder != 0) {
                return nameOrder;
            }
        } else if (key1 instanceof URI && key2 instanceof URI) {
            int uriOrder = key1.toString().compareTo(key2.toString());
            if (uriOrder != 0) {
                return uriOrder;
            }
        } else {
            if (key1 instanceof URI) {
                return 1;
            }
            return -1;
        }
        if ((lineOrder = Integer.compare(this.line, o.line)) != 0) {
            return lineOrder;
        }
        int columnOrder = Integer.compare(this.column, o.column);
        if (columnOrder != 0) {
            return columnOrder;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.line, this.column);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointLocation other = (BreakpointLocation)obj;
        if (this.line != other.line) {
            return false;
        }
        if (this.column != other.column) {
            return false;
        }
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        String keyDescription = this.key instanceof Source ? "sourceName=" + ((Source)this.key).getName() : (this.key instanceof URI ? "uri=" + ((URI)this.key).toString() : this.key.toString());
        return keyDescription + ", line=" + this.line + ", column=" + this.column;
    }
}

