/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.vm.PolyglotEngine;

abstract class SymbolInvokerImpl {
    SymbolInvokerImpl() {
    }

    static CallTarget createExecuteSymbol(TruffleLanguage<?> lang, PolyglotEngine engine, Object symbol) {
        Class type = lang != null ? lang.getClass() : TruffleLanguage.class;
        RootNode symbolNode = symbol instanceof String || symbol instanceof Number || symbol instanceof Boolean || symbol instanceof Character ? RootNode.createConstantNode(symbol) : new ForeignExecuteRoot(type, engine, (TruffleObject)symbol);
        return Truffle.getRuntime().createCallTarget(symbolNode);
    }

    public static RootNode createTemporaryRoot(Class<? extends TruffleLanguage> lang, Node foreignAccess, TruffleObject function) {
        return new TemporaryRoot(lang, foreignAccess, function);
    }

    private static final class ConvertNode
    extends Node {
        @Node.Child
        private Node isNull;
        @Node.Child
        private Node isBoxed;
        @Node.Child
        private Node unbox;
        private final ConditionProfile isBoxedProfile = ConditionProfile.createBinaryProfile();

        ConvertNode() {
            this.isNull = Message.IS_NULL.createNode();
            this.isBoxed = Message.IS_BOXED.createNode();
            this.unbox = Message.UNBOX.createNode();
        }

        Object convert(VirtualFrame frame, Object obj) {
            if (obj instanceof TruffleObject) {
                return this.convert(frame, (TruffleObject)obj);
            }
            return obj;
        }

        private Object convert(VirtualFrame frame, TruffleObject obj) {
            boolean isBoxedResult = ForeignAccess.sendIsBoxed(this.isBoxed, frame, obj);
            if (this.isBoxedProfile.profile(isBoxedResult)) {
                try {
                    return ForeignAccess.sendUnbox(this.unbox, frame, obj);
                }
                catch (UnsupportedMessageException e) {
                    return null;
                }
            }
            boolean isNullResult = ForeignAccess.sendIsNull(this.isNull, frame, obj);
            if (isNullResult) {
                return null;
            }
            return obj;
        }
    }

    static final class ForeignExecuteRoot
    extends PolyglotEngine.PolyglotRootNode {
        private final TruffleObject function;
        @Node.Child
        private ConvertNode convert;
        @Node.Child
        private Node foreignAccess;

        ForeignExecuteRoot(Class<? extends TruffleLanguage> language, PolyglotEngine engine, TruffleObject function) {
            super(language, engine);
            this.function = function;
            this.convert = new ConvertNode();
        }

        @Override
        protected Object executeImpl(VirtualFrame frame) {
            Object[] args = frame.getArguments();
            for (int i = 0; i < args.length; ++i) {
                args[i] = JavaInterop.asTruffleValue(args[i]);
            }
            try {
                if (this.foreignAccess == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.foreignAccess = this.insert(Message.createExecute(args.length).createNode());
                }
                Object tmp = ForeignAccess.send(this.foreignAccess, frame, this.function, args);
                return this.convert.convert(frame, tmp);
            }
            catch (ArityException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.foreignAccess = this.insert(Message.createExecute(args.length).createNode());
                return this.execute(frame);
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw e.raise();
            }
        }
    }

    static class TemporaryRoot
    extends RootNode {
        @Node.Child
        private Node foreignAccess;
        @Node.Child
        private ConvertNode convert;
        private final TruffleObject function;
        private final ValueProfile typeProfile = ValueProfile.createClassProfile();

        TemporaryRoot(Class<? extends TruffleLanguage> lang, Node foreignAccess, TruffleObject function) {
            super(lang, null, null);
            this.foreignAccess = foreignAccess;
            this.convert = new ConvertNode();
            this.function = function;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] args = frame.getArguments();
            try {
                Object tmp = ForeignAccess.send(this.foreignAccess, frame, this.function, args);
                return this.convert.convert(frame, this.typeProfile.profile(tmp));
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e);
            }
        }
    }
}

