/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.algorithms;

import java.nio.ByteBuffer;

public class SipHash {
    public static long hash24(long k0, long k1, byte[] data) {
        return SipHash.hash24(k0, k1, data, 0, data.length);
    }

    private static long hash24(long k0, long k1, byte[] src, int offset, int length) {
        int j;
        long m;
        long v0 = 0x736F6D6570736575L ^ k0;
        long v1 = 0x646F72616E646F6DL ^ k1;
        long v2 = 0x6C7967656E657261L ^ k0;
        long v3 = 0x7465646279746573L ^ k1;
        int last = offset + length / 8 * 8;
        int i = offset;
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset + length > src.length) {
            throw new ArrayIndexOutOfBoundsException(src.length);
        }
        ByteBuffer buffer = ByteBuffer.wrap(src, offset, length);
        while (i < last) {
            m = buffer.getLong(i);
            i += 8;
            v0 += v1;
            v2 += (v3 ^= m);
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
            v0 += v1;
            v2 += v3;
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
            v0 ^= m;
        }
        m = 0L;
        for (i = offset + length - 1; i >= last; --i) {
            m <<= 8;
            m |= (long)src[i];
        }
        v3 ^= (m |= (long)length << 56);
        for (j = 0; j < 2; ++j) {
            v0 += v1;
            v2 += v3;
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
        }
        v0 ^= m;
        v2 ^= 0xFFL;
        for (j = 0; j < 4; ++j) {
            v0 += v1;
            v2 += v3;
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
        }
        return v0 ^ v1 ^ v2 ^ v3;
    }
}

