/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.collections.Memo;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.backtrace.Activation;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;
import org.jruby.truffle.language.backtrace.InternalRootNode;
import org.jruby.truffle.language.exceptions.DisablingBacktracesNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;

public class CallStackManager {
    private final RubyContext context;
    private static final Object STOP_ITERATING = new Object();

    public CallStackManager(RubyContext context) {
        this.context = context;
    }

    public FrameInstance getCallerFrameIgnoringSend() {
        return this.getCallerFrameIgnoringSend(0);
    }

    @CompilerDirectives.TruffleBoundary
    public FrameInstance getCallerFrameIgnoringSend(final int skip) {
        Object frame;
        if (skip == 0) {
            FrameInstance callerFrame = Truffle.getRuntime().getCallerFrame();
            if (callerFrame == null) {
                return null;
            }
            InternalMethod method = this.getMethod(callerFrame);
            if (method == null) {
                return null;
            }
            if (!this.context.getCoreLibrary().isSend(method)) {
                return callerFrame;
            }
        }
        if ((frame = Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){
            int depth = 0;
            int skipped = 0;

            @Override
            public Object visitFrame(FrameInstance frameInstance) {
                ++this.depth;
                if (this.depth == 1) {
                    return null;
                }
                InternalMethod method = CallStackManager.this.getMethod(frameInstance);
                if (method == null) {
                    return STOP_ITERATING;
                }
                if (!CallStackManager.this.context.getCoreLibrary().isSend(method)) {
                    if (this.skipped >= skip) {
                        return frameInstance;
                    }
                    ++this.skipped;
                    return null;
                }
                return null;
            }
        })) instanceof FrameInstance) {
            return (FrameInstance)frame;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod getCallingMethodIgnoringSend() {
        return this.getMethod(this.getCallerFrameIgnoringSend());
    }

    @CompilerDirectives.TruffleBoundary
    public Node getTopMostUserCallNode() {
        Memo<Boolean> firstFrame = new Memo<Boolean>(true);
        return Truffle.getRuntime().iterateFrames(frameInstance -> {
            if (((Boolean)firstFrame.get()).booleanValue()) {
                firstFrame.set(false);
                return null;
            }
            SourceSection sourceSection = frameInstance.getCallNode().getEncapsulatingSourceSection();
            if (sourceSection.getSource() == null) {
                return null;
            }
            return frameInstance.getCallNode();
        });
    }

    private InternalMethod getMethod(FrameInstance frame) {
        return RubyArguments.tryGetMethod(frame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
    }

    public Backtrace getBacktrace(Node currentNode, Throwable javaThrowable) {
        return this.getBacktrace(currentNode, 0, false, null, javaThrowable);
    }

    public Backtrace getBacktrace(Node currentNode) {
        return this.getBacktrace(currentNode, 0, false, null, null);
    }

    public Backtrace getBacktrace(Node currentNode, int omit) {
        return this.getBacktrace(currentNode, omit, false, null, null);
    }

    public Backtrace getBacktrace(Node currentNode, int omit, DynamicObject exception) {
        return this.getBacktrace(currentNode, omit, false, exception, null);
    }

    public Backtrace getBacktrace(Node currentNode, int omit, boolean filterNullSourceSection, DynamicObject exception) {
        return this.getBacktrace(currentNode, omit, filterNullSourceSection, exception, null);
    }

    @CompilerDirectives.TruffleBoundary
    public Backtrace getBacktrace(Node currentNode, final int omit, final boolean filterNullSourceSection, DynamicObject exception, Throwable javaThrowable) {
        if (exception != null && this.context.getOptions().BACKTRACES_OMIT_UNUSED && DisablingBacktracesNode.areBacktracesDisabled() && ModuleOperations.assignableTo(Layouts.BASIC_OBJECT.getLogicalClass(exception), this.context.getCoreLibrary().getStandardErrorClass())) {
            return new Backtrace(new Activation[]{Activation.OMITTED_UNUSED}, null);
        }
        final int limit = this.context.getOptions().BACKTRACES_LIMIT;
        final ArrayList<Activation> activations = new ArrayList<Activation>();
        if (omit == 0 && currentNode != null && Truffle.getRuntime().getCurrentFrame() != null) {
            InternalMethod method = RubyArguments.tryGetMethod(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
            activations.add(new Activation(currentNode, method));
        }
        final Memo<Boolean> firstFrame = new Memo<Boolean>(true);
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){
            int depth = 1;

            @Override
            public Object visitFrame(FrameInstance frameInstance) {
                InternalMethod method;
                Node callNode;
                if (((Boolean)firstFrame.get()).booleanValue()) {
                    firstFrame.set(false);
                    return null;
                }
                if (this.depth > limit) {
                    activations.add(Activation.OMITTED_LIMIT);
                    return new Object();
                }
                if (!(CallStackManager.this.ignoreFrame(frameInstance) || this.depth < omit || filterNullSourceSection && CallStackManager.this.hasNullSourceSection(frameInstance) || (callNode = CallStackManager.this.getCallNode(frameInstance, method = RubyArguments.tryGetMethod(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true)))) == null)) {
                    activations.add(new Activation(callNode, method));
                }
                ++this.depth;
                return null;
            }
        });
        if (!activations.isEmpty()) {
            activations.remove(activations.size() - 1);
        }
        if (this.context.getOptions().EXCEPTIONS_STORE_JAVA || this.context.getOptions().BACKTRACES_INTERLEAVE_JAVA) {
            if (javaThrowable == null) {
                javaThrowable = new Exception();
            }
        } else {
            javaThrowable = null;
        }
        return new Backtrace(activations.toArray(new Activation[activations.size()]), javaThrowable);
    }

    private boolean ignoreFrame(FrameInstance frameInstance) {
        Node callNode = frameInstance.getCallNode();
        if (callNode == null) {
            return false;
        }
        RootNode rootNode = callNode.getRootNode();
        if (rootNode instanceof RubyRootNode) {
            SharedMethodInfo sharedMethodInfo = ((RubyRootNode)rootNode).getSharedMethodInfo();
            if (this.context.getCoreLibrary().isTruffleBootMainMethod(sharedMethodInfo)) {
                return true;
            }
        }
        if (rootNode instanceof InternalRootNode) {
            return true;
        }
        return callNode.getEncapsulatingSourceSection() == null;
    }

    private boolean hasNullSourceSection(FrameInstance frameInstance) {
        Node callNode = frameInstance.getCallNode();
        if (callNode == null) {
            return true;
        }
        SourceSection sourceSection = callNode.getEncapsulatingSourceSection();
        return sourceSection == null || sourceSection.getSource() == null;
    }

    private Node getCallNode(FrameInstance frameInstance, InternalMethod method) {
        Node callNode = frameInstance.getCallNode();
        if (callNode == null && method != null && BacktraceFormatter.isCore(this.context, method.getSharedMethodInfo().getSourceSection())) {
            callNode = ((RootCallTarget)method.getCallTarget()).getRootNode();
        }
        return callNode;
    }
}

