/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

public enum ArgumentType {
    key("key", 'k', false),
    keyreq("keyreq", 'K', false),
    keyrest("keyrest", 'e', false),
    block("block", 'b', false),
    opt("opt", 'o', false),
    rest("rest", 'r', false),
    req("req", 'q', false),
    anonreq("req", 'n', true),
    anonopt("opt", 'O', true),
    anonrest("rest", 'R', true),
    anonkeyrest("keyrest", 'N', true);

    public static final String ANONOPT;
    public static final String ANONREST;
    public static final String REQ;
    public final String symbolicName;
    private final char prefix;
    public final boolean anonymous;

    private ArgumentType(String symbolicName, char prefix, boolean anonymous) {
        this.symbolicName = symbolicName;
        this.prefix = prefix;
        this.anonymous = anonymous;
    }

    public static ArgumentType valueOf(char prefix) {
        switch (prefix) {
            case 'k': {
                return key;
            }
            case 'K': {
                return keyreq;
            }
            case 'e': {
                return keyrest;
            }
            case 'b': {
                return block;
            }
            case 'o': {
                return opt;
            }
            case 'r': {
                return rest;
            }
            case 'q': {
                return req;
            }
            case 'n': {
                return anonreq;
            }
            case 'O': {
                return anonopt;
            }
            case 'R': {
                return anonrest;
            }
            case 'N': {
                return anonkeyrest;
            }
        }
        return null;
    }

    public String renderPrefixForm(String name) {
        return this.anonymous ? String.valueOf(this.prefix) : this.prefix + name;
    }

    public ArgumentType anonymousForm() {
        switch (this) {
            case opt: {
                return anonopt;
            }
            case req: {
                return anonreq;
            }
            case rest: {
                return anonrest;
            }
            case keyrest: {
                return anonkeyrest;
            }
        }
        return this;
    }

    static {
        ANONOPT = Character.toString(ArgumentType.anonopt.prefix);
        ANONREST = Character.toString(ArgumentType.anonrest.prefix);
        REQ = Character.toString(ArgumentType.req.prefix);
    }
}

