/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.FiniteStringsIterator;
import org.apache.lucene.util.automaton.Operations;

public final class GraphTokenStreamFiniteStrings {
    private final Automaton.Builder builder = new Automaton.Builder();
    private final Map<BytesRef, Integer> termToID = new HashMap<BytesRef, Integer>();
    private final Map<Integer, BytesRef> idToTerm = new HashMap<Integer, BytesRef>();
    private final Map<Integer, Integer> idToInc = new HashMap<Integer, Integer>();
    private Automaton det;

    private GraphTokenStreamFiniteStrings() {
    }

    public static List<TokenStream> getTokenStreams(TokenStream in) throws IOException {
        GraphTokenStreamFiniteStrings gfs = new GraphTokenStreamFiniteStrings();
        return gfs.process(in);
    }

    private List<TokenStream> process(TokenStream in) throws IOException {
        IntsRef ids;
        this.build(in);
        ArrayList<TokenStream> tokenStreams = new ArrayList<TokenStream>();
        FiniteStringsIterator finiteStrings = new FiniteStringsIterator(this.det);
        while ((ids = finiteStrings.next()) != null) {
            tokenStreams.add(new FiniteStringsTokenStream(IntsRef.deepCopyOf(ids)));
        }
        return tokenStreams;
    }

    private void build(TokenStream in) throws IOException {
        if (this.det != null) {
            throw new IllegalStateException("Automation already built");
        }
        TermToBytesRefAttribute termBytesAtt = in.addAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncAtt = in.addAttribute(PositionIncrementAttribute.class);
        PositionLengthAttribute posLengthAtt = in.addAttribute(PositionLengthAttribute.class);
        in.reset();
        int pos = -1;
        int prevIncr = 1;
        int state = -1;
        while (in.incrementToken()) {
            int currentIncr = posIncAtt.getPositionIncrement();
            if (pos == -1 && currentIncr < 1) {
                throw new IllegalStateException("Malformed TokenStream, start token can't have increment less than 1");
            }
            int incr = Math.min(1, currentIncr);
            if (incr > 0) {
                pos += incr;
            }
            int endPos = pos + posLengthAtt.getPositionLength();
            while (state < endPos) {
                state = this.createState();
            }
            BytesRef term = termBytesAtt.getBytesRef();
            int id = this.getTermID(currentIncr, prevIncr, term);
            this.addTransition(pos, endPos, currentIncr, id);
            if (currentIncr <= 0) continue;
            prevIncr = currentIncr;
        }
        in.end();
        this.setAccept(state, true);
        this.finish();
    }

    private int createState() {
        return this.builder.createState();
    }

    private void setAccept(int state, boolean accept) {
        this.builder.setAccept(state, accept);
    }

    private void addTransition(int source, int dest, int incr, int id) {
        this.builder.addTransition(source, dest, id);
    }

    private void finish() {
        this.finish(10000);
    }

    private void finish(int maxDeterminizedStates) {
        Automaton automaton = this.builder.finish();
        this.det = Operations.removeDeadStates(Operations.determinize(automaton, maxDeterminizedStates));
    }

    private int getTermID(int incr, int prevIncr, BytesRef term) {
        Integer id;
        boolean hasGap;
        assert (term != null);
        boolean isStackedGap = incr == 0 && prevIncr > 1;
        boolean bl = hasGap = incr > 1;
        if (hasGap || isStackedGap) {
            id = this.idToTerm.size();
            this.idToTerm.put(id, BytesRef.deepCopyOf(term));
            if (isStackedGap) {
                this.idToInc.put(id, prevIncr);
            } else {
                this.idToInc.put(id, incr);
            }
        } else {
            id = this.termToID.get(term);
            if (id == null) {
                term = BytesRef.deepCopyOf(term);
                id = this.idToTerm.size();
                this.termToID.put(term, id);
                this.idToTerm.put(id, term);
            }
        }
        return id;
    }

    private class FiniteStringsTokenStream
    extends TokenStream {
        private final BytesTermAttribute termAtt = this.addAttribute(BytesTermAttribute.class);
        private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
        private final IntsRef ids;
        private final int end;
        private int offset;

        FiniteStringsTokenStream(IntsRef ids) {
            assert (ids != null);
            this.ids = ids;
            this.offset = ids.offset;
            this.end = ids.offset + ids.length;
        }

        @Override
        public boolean incrementToken() throws IOException {
            if (this.offset < this.end) {
                this.clearAttributes();
                int id = this.ids.ints[this.offset];
                this.termAtt.setBytesRef((BytesRef)GraphTokenStreamFiniteStrings.this.idToTerm.get(id));
                int incr = 1;
                if (GraphTokenStreamFiniteStrings.this.idToInc.containsKey(id)) {
                    incr = (Integer)GraphTokenStreamFiniteStrings.this.idToInc.get(id);
                }
                this.posIncAtt.setPositionIncrement(incr);
                ++this.offset;
                return true;
            }
            return false;
        }
    }
}

