/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.RemoteClusterService;
import org.elasticsearch.action.search.SearchDfsQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;

public class TransportSearchAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    public static final Setting<Long> SHARD_COUNT_LIMIT_SETTING = Setting.longSetting("action.search.shard_count.limit", 1000L, 1L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final RemoteClusterService remoteClusterService;
    private final SearchPhaseController searchPhaseController;
    private final SearchService searchService;

    @Inject
    public TransportSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, SearchService searchService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/search", threadPool, transportService, actionFilters, indexNameExpressionResolver, SearchRequest::new);
        this.searchPhaseController = searchPhaseController;
        this.searchTransportService = searchTransportService;
        this.remoteClusterService = searchTransportService.getRemoteClusterService();
        SearchTransportService.registerRequestHandler(transportService, searchService);
        this.clusterService = clusterService;
        this.searchService = searchService;
    }

    private Map<String, AliasFilter> buildPerIndexAliasFilter(SearchRequest request, ClusterState clusterState, Index[] concreteIndices, Map<String, AliasFilter> remoteAliasMap) {
        HashMap<String, AliasFilter> aliasFilterMap = new HashMap<String, AliasFilter>();
        for (Index index : concreteIndices) {
            clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index.getName());
            AliasFilter aliasFilter = this.searchService.buildAliasFilter(clusterState, index.getName(), request.indices());
            assert (aliasFilter != null);
            aliasFilterMap.put(index.getUUID(), aliasFilter);
        }
        aliasFilterMap.putAll(remoteAliasMap);
        return aliasFilterMap;
    }

    private Map<String, Float> resolveIndexBoosts(SearchRequest searchRequest, ClusterState clusterState) {
        if (searchRequest.source() == null) {
            return Collections.emptyMap();
        }
        SearchSourceBuilder source = searchRequest.source();
        if (source.indexBoosts() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Float> concreteIndexBoosts = new HashMap<String, Float>();
        for (SearchSourceBuilder.IndexBoost ib : source.indexBoosts()) {
            Index[] concreteIndices;
            for (Index concreteIndex : concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, searchRequest.indicesOptions(), ib.getIndex())) {
                concreteIndexBoosts.putIfAbsent(concreteIndex.getUUID(), Float.valueOf(ib.getBoost()));
            }
        }
        return Collections.unmodifiableMap(concreteIndexBoosts);
    }

    @Override
    protected void doExecute(Task task, SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        String[] localIndices;
        Map<Object, Object> remoteClusterIndices;
        long startTimeInMillis = Math.max(0L, System.currentTimeMillis());
        ClusterState clusterState = this.clusterService.state();
        if (this.remoteClusterService.isCrossClusterSearchEnabled()) {
            remoteClusterIndices = this.remoteClusterService.groupClusterIndices(searchRequest.indices(), idx -> this.indexNameExpressionResolver.hasIndexOrAlias((String)idx, clusterState));
            List remove = (List)remoteClusterIndices.remove("");
            localIndices = remove == null ? Strings.EMPTY_ARRAY : remove.toArray(new String[remove.size()]);
        } else {
            remoteClusterIndices = Collections.emptyMap();
            localIndices = searchRequest.indices();
        }
        if (remoteClusterIndices.isEmpty()) {
            this.executeSearch((SearchTask)task, startTimeInMillis, searchRequest, localIndices, Collections.emptyList(), nodeId -> null, clusterState, Collections.emptyMap(), listener);
        } else {
            this.remoteClusterService.collectSearchShards(searchRequest, remoteClusterIndices, ActionListener.wrap(searchShardsResponses -> {
                ArrayList<ShardIterator> remoteShardIterators = new ArrayList<ShardIterator>();
                HashMap<String, AliasFilter> remoteAliasFilters = new HashMap<String, AliasFilter>();
                Function<String, Transport.Connection> connectionFunction = this.remoteClusterService.processRemoteShards((Map<String, ClusterSearchShardsResponse>)searchShardsResponses, (List<ShardIterator>)remoteShardIterators, (Map<String, AliasFilter>)remoteAliasFilters);
                this.executeSearch((SearchTask)task, startTimeInMillis, searchRequest, localIndices, remoteShardIterators, connectionFunction, clusterState, remoteAliasFilters, listener);
            }, listener::onFailure));
        }
    }

    private void executeSearch(SearchTask task, long startTimeInMillis, SearchRequest searchRequest, String[] localIndices, List<ShardIterator> remoteShardIterators, Function<String, Transport.Connection> remoteConnections, ClusterState clusterState, Map<String, AliasFilter> remoteAliasMap, ActionListener<SearchResponse> listener) {
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        Index[] indices = localIndices.length == 0 && remoteShardIterators.size() > 0 ? Index.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndices(clusterState, searchRequest.indicesOptions(), startTimeInMillis, localIndices);
        Map<String, AliasFilter> aliasFilter = this.buildPerIndexAliasFilter(searchRequest, clusterState, indices, remoteAliasMap);
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, searchRequest.routing(), searchRequest.indices());
        String[] concreteIndices = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            concreteIndices[i] = indices[i].getName();
        }
        GroupShardsIterator localShardsIterator = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, searchRequest.preference());
        GroupShardsIterator shardIterators = TransportSearchAction.mergeShardsIterators(localShardsIterator, remoteShardIterators);
        TransportSearchAction.failIfOverShardCountLimit(this.clusterService, shardIterators.size());
        Map<String, Float> concreteIndexBoosts = this.resolveIndexBoosts(searchRequest, clusterState);
        if (shardIterators.size() == 1) {
            searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
        }
        if (searchRequest.isSuggestOnly()) {
            searchRequest.requestCache(false);
            switch (searchRequest.searchType()) {
                case DFS_QUERY_THEN_FETCH: {
                    searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
                }
            }
        }
        DiscoveryNodes nodes = clusterState.nodes();
        Function<String, Transport.Connection> connectionLookup = nodeId -> {
            DiscoveryNode discoveryNode = nodes.get((String)nodeId);
            Transport.Connection connection = discoveryNode != null ? this.searchTransportService.getConnection(discoveryNode) : (Transport.Connection)remoteConnections.apply((String)nodeId);
            if (connection == null) {
                throw new IllegalStateException("no node found for id: " + nodeId);
            }
            return connection;
        };
        ActionListener<SearchResponse> wrapper = searchRequest.source() != null && searchRequest.source().collapse() != null && searchRequest.source().collapse().getInnerHit() != null ? ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getHits().length == 0) {
                listener.onResponse((SearchResponse)searchResponse);
            } else {
                this.expandCollapsedHits(nodes.getLocalNode(), task, searchRequest, (SearchResponse)searchResponse, listener);
            }
        }, listener::onFailure) : listener;
        this.searchAsyncAction(task, searchRequest, shardIterators, startTimeInMillis, connectionLookup, clusterState.version(), Collections.unmodifiableMap(aliasFilter), concreteIndexBoosts, wrapper).start();
    }

    private static GroupShardsIterator mergeShardsIterators(GroupShardsIterator localShardsIterator, List<ShardIterator> remoteShardIterators) {
        if (remoteShardIterators.isEmpty()) {
            return localShardsIterator;
        }
        ArrayList<ShardIterator> shards = new ArrayList<ShardIterator>();
        for (ShardIterator shardIterator : remoteShardIterators) {
            shards.add(shardIterator);
        }
        for (ShardIterator shardIterator : localShardsIterator) {
            shards.add(shardIterator);
        }
        return new GroupShardsIterator(shards);
    }

    @Override
    protected final void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        throw new UnsupportedOperationException("the task parameter is required");
    }

    private AbstractSearchAsyncAction searchAsyncAction(SearchTask task, SearchRequest searchRequest, GroupShardsIterator shardIterators, long startTime, Function<String, Transport.Connection> connectionLookup, long clusterStateVersion, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, ActionListener<SearchResponse> listener) {
        AbstractSearchAsyncAction searchAsyncAction;
        ExecutorService executor = this.threadPool.executor("search");
        switch (searchRequest.searchType()) {
            case DFS_QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchDfsQueryThenFetchAsyncAction(this.logger, this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, this.searchPhaseController, executor, searchRequest, listener, shardIterators, startTime, clusterStateVersion, task);
                break;
            }
            case QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchQueryThenFetchAsyncAction(this.logger, this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, this.searchPhaseController, executor, searchRequest, listener, shardIterators, startTime, clusterStateVersion, task);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown search type: [" + (Object)((Object)searchRequest.searchType()) + "]");
            }
        }
        return searchAsyncAction;
    }

    private static void failIfOverShardCountLimit(ClusterService clusterService, int shardCount) {
        long shardCountLimit = clusterService.getClusterSettings().get(SHARD_COUNT_LIMIT_SETTING);
        if ((long)shardCount > shardCountLimit) {
            throw new IllegalArgumentException("Trying to query " + shardCount + " shards, which is over the limit of " + shardCountLimit + ". This limit exists because querying many shards at the same time can make the job of the coordinating node very CPU and/or memory intensive. It is usually a better idea to have a smaller number of larger shards. Update [" + SHARD_COUNT_LIMIT_SETTING.getKey() + "] to a greater value if you really want to query that many shards at the same time.");
        }
    }

    void expandCollapsedHits(DiscoveryNode node, SearchTask parentTask, SearchRequest searchRequest, SearchResponse searchResponse, ActionListener<SearchResponse> finalListener) {
        CollapseBuilder collapseBuilder = searchRequest.source().collapse();
        MultiSearchRequest multiRequest = new MultiSearchRequest();
        if (collapseBuilder.getMaxConcurrentGroupRequests() > 0) {
            multiRequest.maxConcurrentSearchRequests(collapseBuilder.getMaxConcurrentGroupRequests());
        }
        for (SearchHit hit : searchResponse.getHits()) {
            BoolQueryBuilder groupQuery = new BoolQueryBuilder();
            Object collapseValue = hit.field(collapseBuilder.getField()).getValue();
            if (collapseValue != null) {
                groupQuery.filter(QueryBuilders.matchQuery(collapseBuilder.getField(), collapseValue));
            } else {
                groupQuery.mustNot(QueryBuilders.existsQuery(collapseBuilder.getField()));
            }
            QueryBuilder origQuery = searchRequest.source().query();
            if (origQuery != null) {
                groupQuery.must(origQuery);
            }
            SearchSourceBuilder sourceBuilder = this.buildExpandSearchSourceBuilder(collapseBuilder.getInnerHit()).query(groupQuery);
            SearchRequest groupRequest = new SearchRequest(searchRequest.indices()).types(searchRequest.types()).source(sourceBuilder);
            multiRequest.add(groupRequest);
        }
        this.searchTransportService.sendExecuteMultiSearch(node, multiRequest, parentTask, ActionListener.wrap(response -> {
            Iterator<MultiSearchResponse.Item> it = response.iterator();
            for (SearchHit hit : searchResponse.getHits()) {
                InternalSearchHit internalHit = (InternalSearchHit)hit;
                MultiSearchResponse.Item item = it.next();
                if (item.isFailure()) {
                    finalListener.onFailure(item.getFailure());
                    return;
                }
                SearchHits innerHits = item.getResponse().getHits();
                if (internalHit.getInnerHits() == null) {
                    internalHit.setInnerHits(new HashMap<String, InternalSearchHits>(1));
                }
                internalHit.getInnerHits().put(collapseBuilder.getInnerHit().getName(), innerHits);
            }
            finalListener.onResponse(searchResponse);
        }, finalListener::onFailure));
    }

    private SearchSourceBuilder buildExpandSearchSourceBuilder(InnerHitBuilder options) {
        SearchSourceBuilder groupSource = new SearchSourceBuilder();
        groupSource.from(options.getFrom());
        groupSource.size(options.getSize());
        if (options.getSorts() != null) {
            options.getSorts().forEach(groupSource::sort);
        }
        if (options.getFetchSourceContext() != null) {
            if (options.getFetchSourceContext().includes() == null && options.getFetchSourceContext().excludes() == null) {
                groupSource.fetchSource(options.getFetchSourceContext().fetchSource());
            } else {
                groupSource.fetchSource(options.getFetchSourceContext().includes(), options.getFetchSourceContext().excludes());
            }
        }
        if (options.getDocValueFields() != null) {
            options.getDocValueFields().forEach(groupSource::docValueField);
        }
        if (options.getStoredFieldsContext() != null && options.getStoredFieldsContext().fieldNames() != null) {
            options.getStoredFieldsContext().fieldNames().forEach(groupSource::storedField);
        }
        if (options.getScriptFields() != null) {
            for (SearchSourceBuilder.ScriptField field : options.getScriptFields()) {
                groupSource.scriptField(field.fieldName(), field.script());
            }
        }
        if (options.getHighlightBuilder() != null) {
            groupSource.highlighter(options.getHighlightBuilder());
        }
        groupSource.explain(options.isExplain());
        groupSource.trackScores(options.isTrackScores());
        return groupSource;
    }
}

