/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.PropertyPlaceholder;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.settings.loader.SettingsLoaderFactory;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.unit.RatioValue;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;

public final class Settings
implements ToXContent {
    public static final Settings EMPTY = new Builder().build();
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(.*)\\.\\d+$");
    private final Map<String, String> settings;
    private final SecureSettings secureSettings;
    private final SetOnce<Set<String>> firstLevelNames = new SetOnce();
    private final SetOnce<Set<String>> keys = new SetOnce();
    public static final Set<String> FORMAT_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("settings_filter", "flat_settings")));

    Settings(Map<String, String> settings, SecureSettings secureSettings) {
        this.settings = Collections.unmodifiableSortedMap(new TreeMap<String, String>(settings));
        this.secureSettings = secureSettings;
    }

    SecureSettings getSecureSettings() {
        return this.secureSettings;
    }

    public Map<String, String> getAsMap() {
        return this.settings;
    }

    public Map<String, Object> getAsStructuredMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            this.processSetting(map, "", entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)((Object)entry.getValue());
            entry.setValue((String)this.convertMapsToArrays(valMap));
        }
        return map;
    }

    private void processSetting(Map<String, Object> map, String prefix, String setting, String value) {
        int prefixLength = setting.indexOf(46);
        if (prefixLength == -1) {
            Map innerMap = (Map)map.get(prefix + setting);
            if (innerMap != null) {
                for (Map.Entry entry : innerMap.entrySet()) {
                    map.put(prefix + setting + "." + (String)entry.getKey(), entry.getValue());
                }
            }
            map.put(prefix + setting, value);
        } else {
            String key = setting.substring(0, prefixLength);
            String rest = setting.substring(prefixLength + 1);
            Object existingValue = map.get(prefix + key);
            if (existingValue == null) {
                HashMap<String, Object> newMap = new HashMap<String, Object>(2);
                this.processSetting(newMap, "", rest, value);
                map.put(key, newMap);
            } else if (existingValue instanceof Map) {
                Map innerMap = (Map)existingValue;
                this.processSetting(innerMap, "", rest, value);
                map.put(key, innerMap);
            } else {
                this.processSetting(map, prefix + key + ".", rest, value);
            }
        }
    }

    private Object convertMapsToArrays(Map<String, Object> map) {
        if (map.isEmpty()) {
            return map;
        }
        boolean isArray = true;
        int maxIndex = -1;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (isArray) {
                try {
                    int index = Integer.parseInt(entry.getKey());
                    if (index >= 0) {
                        maxIndex = Math.max(maxIndex, index);
                    } else {
                        isArray = false;
                    }
                }
                catch (NumberFormatException ex) {
                    isArray = false;
                }
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(this.convertMapsToArrays(valMap));
        }
        if (isArray && maxIndex + 1 == map.size()) {
            ArrayList<Object> newValue = new ArrayList<Object>(maxIndex + 1);
            for (int i = 0; i <= maxIndex; ++i) {
                Object obj = map.get(Integer.toString(i));
                if (obj == null) {
                    return map;
                }
                newValue.add(obj);
            }
            return newValue;
        }
        return map;
    }

    public Settings getByPrefix(String prefix) {
        return new Settings(new FilteredMap(this.settings, k -> k.startsWith(prefix), prefix), this.secureSettings == null ? null : new PrefixedSecureSettings(this.secureSettings, s -> prefix + s, s -> s.startsWith(prefix)));
    }

    public Settings filter(Predicate<String> predicate) {
        return new Settings(new FilteredMap(this.settings, predicate, null), this.secureSettings == null ? null : new PrefixedSecureSettings(this.secureSettings, UnaryOperator.identity(), predicate));
    }

    public Settings getAsSettings(String setting) {
        return this.getByPrefix(setting + ".");
    }

    public String get(String setting) {
        return this.settings.get(setting);
    }

    public String get(String setting, String defaultValue) {
        String retVal = this.get(setting);
        return retVal == null ? defaultValue : retVal;
    }

    public Float getAsFloat(String setting, Float defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Double getAsDouble(String setting, Double defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Integer getAsInt(String setting, Integer defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Long getAsLong(String setting, Long defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        String rawValue = this.get(setting);
        Boolean booleanValue = Booleans.parseBooleanExact(rawValue, defaultValue);
        if (rawValue != null && !Booleans.isStrictlyBoolean(rawValue)) {
            DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(Settings.class));
            deprecationLogger.deprecated("Expected a boolean [true/false] for setting [{}] but got [{}]", setting, rawValue);
        }
        return booleanValue;
    }

    public TimeValue getAsTime(String setting, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.get(setting), defaultValue, setting);
    }

    public ByteSizeValue getAsBytesSize(String setting, ByteSizeValue defaultValue) throws SettingsException {
        return ByteSizeValue.parseBytesSizeValue(this.get(setting), defaultValue, setting);
    }

    public ByteSizeValue getAsMemory(String setting, String defaultValue) throws SettingsException {
        return MemorySizeValue.parseBytesSizeValueOrHeapRatio(this.get(setting, defaultValue), setting);
    }

    public RatioValue getAsRatio(String setting, String defaultValue) throws SettingsException {
        return RatioValue.parseRatioValue(this.get(setting, defaultValue));
    }

    public SizeValue getAsSize(String setting, SizeValue defaultValue) throws SettingsException {
        return SizeValue.parseSizeValue(this.get(setting), defaultValue);
    }

    public String[] getAsArray(String settingPrefix) throws SettingsException {
        return this.getAsArray(settingPrefix, Strings.EMPTY_ARRAY, true);
    }

    public String[] getAsArray(String settingPrefix, String[] defaultArray) throws SettingsException {
        return this.getAsArray(settingPrefix, defaultArray, true);
    }

    public String[] getAsArray(String settingPrefix, String[] defaultArray, Boolean commaDelimited) throws SettingsException {
        String value;
        ArrayList<String> result = new ArrayList<String>();
        String valueFromPrefix = this.get(settingPrefix);
        String valueFromPreifx0 = this.get(settingPrefix + ".0");
        if (valueFromPrefix != null && valueFromPreifx0 != null) {
            String message = String.format(Locale.ROOT, "settings object contains values for [%s=%s] and [%s=%s]", settingPrefix, valueFromPrefix, settingPrefix + ".0", valueFromPreifx0);
            throw new IllegalStateException(message);
        }
        if (this.get(settingPrefix) != null) {
            if (commaDelimited.booleanValue()) {
                String[] strings = Strings.splitStringByCommaToArray(this.get(settingPrefix));
                if (strings.length > 0) {
                    for (String string : strings) {
                        result.add(string.trim());
                    }
                }
            } else {
                result.add(this.get(settingPrefix).trim());
            }
        }
        int counter = 0;
        while ((value = this.get(settingPrefix + '.' + counter++)) != null) {
            result.add(value.trim());
        }
        if (result.isEmpty()) {
            return defaultArray;
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<String, Settings> getGroups(String settingPrefix) throws SettingsException {
        return this.getGroups(settingPrefix, false);
    }

    public Map<String, Settings> getGroups(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        if (!Strings.hasLength(settingPrefix)) {
            throw new IllegalArgumentException("illegal setting prefix " + settingPrefix);
        }
        if (settingPrefix.charAt(settingPrefix.length() - 1) != '.') {
            settingPrefix = settingPrefix + ".";
        }
        return this.getGroupsInternal(settingPrefix, ignoreNonGrouped);
    }

    private Map<String, Settings> getGroupsInternal(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        LinkedHashMap<String, LinkedHashMap<String, String>> map = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (String o : this.settings.keySet()) {
            String setting = o;
            if (!setting.startsWith(settingPrefix)) continue;
            String nameValue = setting.substring(settingPrefix.length());
            int dotIndex = nameValue.indexOf(46);
            if (dotIndex == -1) {
                if (ignoreNonGrouped) continue;
                throw new SettingsException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + setting + "] because of a missing '.'");
            }
            String name = nameValue.substring(0, dotIndex);
            String value = nameValue.substring(dotIndex + 1);
            LinkedHashMap<String, String> groupSettings = (LinkedHashMap<String, String>)map.get(name);
            if (groupSettings == null) {
                groupSettings = new LinkedHashMap<String, String>();
                map.put(name, groupSettings);
            }
            groupSettings.put(value, this.get(setting));
        }
        LinkedHashMap retVal = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            retVal.put(entry.getKey(), new Settings(Collections.unmodifiableMap((Map)entry.getValue()), this.secureSettings));
        }
        return Collections.unmodifiableMap(retVal);
    }

    public Map<String, Settings> getAsGroups() throws SettingsException {
        return this.getAsGroups(false);
    }

    public Map<String, Settings> getAsGroups(boolean ignoreNonGrouped) throws SettingsException {
        return this.getGroupsInternal("", ignoreNonGrouped);
    }

    public Version getAsVersion(String setting, Version defaultVersion) throws SettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultVersion;
        }
        try {
            return Version.fromId(Integer.parseInt(sValue));
        }
        catch (Exception e) {
            throw new SettingsException("Failed to parse version setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> names() {
        SetOnce<Set<String>> setOnce = this.firstLevelNames;
        synchronized (setOnce) {
            if (this.firstLevelNames.get() == null) {
                Stream stream = this.settings.keySet().stream();
                if (this.secureSettings != null) {
                    stream = Stream.concat(stream, this.secureSettings.getSettingNames().stream());
                }
                Set names = stream.map(k -> {
                    int i = k.indexOf(46);
                    if (i < 0) {
                        return k;
                    }
                    return k.substring(0, i);
                }).collect(Collectors.toSet());
                this.firstLevelNames.set(Collections.unmodifiableSet(names));
            }
        }
        return (Set)this.firstLevelNames.get();
    }

    public String toDelimitedString(char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(delimiter);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings that = (Settings)o;
        return !(this.settings != null ? !this.settings.equals(that.settings) : that.settings != null);
    }

    public int hashCode() {
        int result = this.settings != null ? this.settings.hashCode() : 0;
        return result;
    }

    public static Settings readSettingsFromStream(StreamInput in) throws IOException {
        Builder builder = new Builder();
        int numberOfSettings = in.readVInt();
        for (int i = 0; i < numberOfSettings; ++i) {
            builder.put(in.readString(), in.readOptionalString());
        }
        return builder.build();
    }

    public static void writeSettingsToStream(Settings settings, StreamOutput out) throws IOException {
        out.writeVInt(settings.size());
        for (Map.Entry<String, String> entry : settings.getAsMap().entrySet()) {
            out.writeString(entry.getKey());
            out.writeOptionalString(entry.getValue());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Settings settings = SettingsFilter.filterSettings(params, this);
        if (!params.paramAsBoolean("flat_settings", false)) {
            for (Map.Entry<String, Object> entry : settings.getAsStructuredMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : settings.getAsMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    public boolean isEmpty() {
        return this.settings.isEmpty() && (this.secureSettings == null || this.secureSettings.getSettingNames().isEmpty());
    }

    public int size() {
        return this.keySet().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        SetOnce<Set<String>> setOnce = this.keys;
        synchronized (setOnce) {
            if (this.keys.get() == null) {
                if (this.secureSettings == null) {
                    this.keys.set(this.settings.keySet());
                } else {
                    Stream stream = Stream.concat(this.settings.keySet().stream(), this.secureSettings.getSettingNames().stream());
                    this.keys.set(Collections.unmodifiableSet(stream.collect(Collectors.toSet())));
                }
            }
        }
        return (Set)this.keys.get();
    }

    private static class PrefixedSecureSettings
    implements SecureSettings {
        private final SecureSettings delegate;
        private final UnaryOperator<String> keyTransform;
        private final Predicate<String> keyPredicate;
        private final SetOnce<Set<String>> settingNames = new SetOnce();

        PrefixedSecureSettings(SecureSettings delegate, UnaryOperator<String> keyTransform, Predicate<String> keyPredicate) {
            this.delegate = delegate;
            this.keyTransform = keyTransform;
            this.keyPredicate = keyPredicate;
        }

        @Override
        public boolean isLoaded() {
            return this.delegate.isLoaded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> getSettingNames() {
            SetOnce<Set<String>> setOnce = this.settingNames;
            synchronized (setOnce) {
                if (this.settingNames.get() == null) {
                    Set names = this.delegate.getSettingNames().stream().filter(this.keyPredicate).collect(Collectors.toSet());
                    this.settingNames.set(Collections.unmodifiableSet(names));
                }
            }
            return (Set)this.settingNames.get();
        }

        @Override
        public SecureString getString(String setting) throws GeneralSecurityException {
            return this.delegate.getString((String)this.keyTransform.apply(setting));
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static final class FilteredMap
    extends AbstractMap<String, String> {
        private final Map<String, String> delegate;
        private final Predicate<String> filter;
        private final String prefix;
        private int size = -1;

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            final Set<Map.Entry<String, String>> delegateSet = this.delegate.entrySet();
            AbstractSet<Map.Entry<String, String>> filterSet = new AbstractSet<Map.Entry<String, String>>(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    final Iterator iter = delegateSet.iterator();
                    return new Iterator<Map.Entry<String, String>>(){
                        private int numIterated;
                        private Map.Entry<String, String> currentElement;

                        @Override
                        public boolean hasNext() {
                            if (this.currentElement != null) {
                                return true;
                            }
                            if (this.numIterated == size) {
                                assert (size != -1) : "size was never set: " + this.numIterated + " vs. " + FilteredMap.access$400(this);
                                return false;
                            }
                            while (iter.hasNext()) {
                                this.currentElement = (Map.Entry)iter.next();
                                if (!filter.test(this.currentElement.getKey())) continue;
                                ++this.numIterated;
                                return true;
                            }
                            this.currentElement = null;
                            return false;
                        }

                        @Override
                        public Map.Entry<String, String> next() {
                            if (this.currentElement == null && !this.hasNext()) {
                                throw new NoSuchElementException("make sure to call hasNext first");
                            }
                            final Map.Entry<String, String> current = this.currentElement;
                            this.currentElement = null;
                            if (prefix == null) {
                                return current;
                            }
                            return new Map.Entry<String, String>(){

                                @Override
                                public String getKey() {
                                    return ((String)current.getKey()).substring(prefix.length());
                                }

                                @Override
                                public String getValue() {
                                    return (String)current.getValue();
                                }

                                @Override
                                public String setValue(String value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                    };
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
            return filterSet;
        }

        private FilteredMap(Map<String, String> delegate, Predicate<String> filter, String prefix) {
            this.delegate = delegate;
            this.filter = filter;
            this.prefix = prefix;
        }

        @Override
        public String get(Object key) {
            if (key instanceof String) {
                String theKey;
                String string = theKey = this.prefix == null ? (String)key : this.prefix + key;
                if (this.filter.test(theKey)) {
                    return this.delegate.get(theKey);
                }
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                String theKey;
                String string = theKey = this.prefix == null ? (String)key : this.prefix + key;
                if (this.filter.test(theKey)) {
                    return this.delegate.containsKey(theKey);
                }
            }
            return false;
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = Math.toIntExact(this.delegate.keySet().stream().filter(e -> this.filter.test((String)e)).count());
            }
            return this.size;
        }
    }

    public static class Builder {
        public static final Settings EMPTY_SETTINGS = new Builder().build();
        private final Map<String, String> map = new TreeMap<String, String>();
        private SetOnce<SecureSettings> secureSettings = new SetOnce();

        private Builder() {
        }

        public Map<String, String> internalMap() {
            return this.map;
        }

        public String remove(String key) {
            return this.map.remove(key);
        }

        public String get(String key) {
            return this.map.get(key);
        }

        public Builder setSecureSettings(SecureSettings secureSettings) {
            if (!secureSettings.isLoaded()) {
                throw new IllegalStateException("Secure settings must already be loaded");
            }
            this.secureSettings.set((Object)secureSettings);
            return this;
        }

        public Builder put(Object ... settings) {
            if (settings.length == 1) {
                if (settings[0] instanceof Map) {
                    return this.put((Map)settings[0]);
                }
                if (settings[0] instanceof Settings) {
                    return this.put((Settings)settings[0]);
                }
            }
            if (settings.length % 2 != 0) {
                throw new IllegalArgumentException("array settings of key + value order doesn't hold correct number of arguments (" + settings.length + ")");
            }
            for (int i = 0; i < settings.length; ++i) {
                this.put(settings[i++].toString(), settings[i].toString());
            }
            return this;
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder putNull(String key) {
            return this.put(key, (String)null);
        }

        public Builder put(String key, Class clazz) {
            this.map.put(key, clazz.getName());
            return this;
        }

        public Builder put(String setting, boolean value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, int value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, Version version) {
            this.put(setting, version.id);
            return this;
        }

        public Builder put(String setting, long value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, float value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, double value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, long value, TimeUnit timeUnit) {
            this.put(setting, timeUnit.toMillis(value) + "ms");
            return this;
        }

        public Builder put(String setting, long value, ByteSizeUnit sizeUnit) {
            this.put(setting, sizeUnit.toBytes(value) + "b");
            return this;
        }

        public Builder putArray(String setting, String ... values) {
            return this.putArray(setting, Arrays.asList(values));
        }

        public Builder putArray(String setting, List<String> values) {
            String value;
            this.remove(setting);
            int counter = 0;
            while ((value = this.map.remove(setting + '.' + counter++)) != null) {
            }
            for (int i = 0; i < values.size(); ++i) {
                this.put(setting + "." + i, values.get(i));
            }
            return this;
        }

        public Builder extendArray(String setting, String ... values) {
            String oldSingle = this.remove(setting);
            int counter = 0;
            while (this.map.containsKey(setting + '.' + counter)) {
                ++counter;
            }
            if (oldSingle != null) {
                this.put(setting + '.' + counter++, oldSingle);
            }
            for (String value : values) {
                this.put(setting + '.' + counter++, value);
            }
            return this;
        }

        public Builder put(String settingPrefix, String groupName, String[] settings, String[] values) throws SettingsException {
            if (settings.length != values.length) {
                throw new SettingsException("The settings length must match the value length");
            }
            for (int i = 0; i < settings.length; ++i) {
                if (values[i] == null) continue;
                this.put(settingPrefix + "." + groupName + "." + settings[i], values[i]);
            }
            return this;
        }

        public Builder put(Settings settings) {
            this.removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(settings.getAsMap());
            this.map.putAll(settings.getAsMap());
            if (settings.getSecureSettings() != null) {
                this.setSecureSettings(settings.getSecureSettings());
            }
            return this;
        }

        public Builder put(Map<String, String> settings) {
            this.removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(settings);
            this.map.putAll(settings);
            return this;
        }

        private void removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(Map<String, String> settings) {
            ArrayList<String> prefixesToRemove = new ArrayList<String>();
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                Matcher matcher = ARRAY_PATTERN.matcher(entry.getKey());
                if (matcher.matches()) {
                    prefixesToRemove.add(matcher.group(1));
                    continue;
                }
                if (!this.map.keySet().stream().anyMatch(key -> key.startsWith((String)entry.getKey() + "."))) continue;
                prefixesToRemove.add(entry.getKey());
            }
            for (String prefix : prefixesToRemove) {
                Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    if (!entry.getKey().startsWith(prefix + ".") && !entry.getKey().equals(prefix)) continue;
                    iterator.remove();
                }
            }
        }

        public Builder put(Dictionary<Object, Object> properties) {
            for (Object key : Collections.list(properties.keys())) {
                this.map.put(Objects.toString(key), Objects.toString(properties.get(key)));
            }
            return this;
        }

        @Deprecated
        public Builder loadFromSource(String source) {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromSource(source);
            try {
                Map<String, String> loadedSettings = settingsLoader.load(source);
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + source + "]", e);
            }
            return this;
        }

        public Builder loadFromSource(String source, XContentType xContentType) {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromXContentType(xContentType);
            try {
                Map<String, String> loadedSettings = settingsLoader.load(source);
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + source + "]", e);
            }
            return this;
        }

        public Builder loadFromPath(Path path) throws IOException {
            return this.loadFromStream(path.getFileName().toString(), Files.newInputStream(path, new OpenOption[0]));
        }

        public Builder loadFromStream(String resourceName, InputStream is) throws IOException {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromResource(resourceName);
            Map<String, String> loadedSettings = settingsLoader.load(Streams.copyToString(new InputStreamReader(is, StandardCharsets.UTF_8)));
            this.put(loadedSettings);
            return this;
        }

        public Builder putProperties(Map<String, String> esSettings, Predicate<String> keyPredicate, Function<String, String> keyFunction) {
            for (Map.Entry<String, String> esSetting : esSettings.entrySet()) {
                String key = esSetting.getKey();
                if (!keyPredicate.test(key)) continue;
                this.map.put(keyFunction.apply(key), esSetting.getValue());
            }
            return this;
        }

        public Builder replacePropertyPlaceholders() {
            return this.replacePropertyPlaceholders(System::getenv);
        }

        Builder replacePropertyPlaceholders(final Function<String, String> getenv) {
            PropertyPlaceholder propertyPlaceholder = new PropertyPlaceholder("${", "}", false);
            PropertyPlaceholder.PlaceholderResolver placeholderResolver = new PropertyPlaceholder.PlaceholderResolver(){

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    String value = (String)getenv.apply(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    return (String)map.get(placeholderName);
                }

                @Override
                public boolean shouldIgnoreMissing(String placeholderName) {
                    return placeholderName.startsWith("prompt.");
                }

                @Override
                public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                    return !placeholderName.startsWith("prompt.");
                }
            };
            Iterator<Map.Entry<String, String>> entryItr = this.map.entrySet().iterator();
            while (entryItr.hasNext()) {
                Map.Entry<String, String> entry = entryItr.next();
                if (entry.getValue() == null) continue;
                String value = propertyPlaceholder.replacePlaceholders(entry.getValue(), placeholderResolver);
                if (Strings.hasLength(value)) {
                    entry.setValue(value);
                    continue;
                }
                entryItr.remove();
            }
            return this;
        }

        public Builder normalizePrefix(String prefix) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().startsWith(prefix)) continue;
                replacements.put(prefix + entry.getKey(), entry.getValue());
                iterator.remove();
            }
            this.map.putAll(replacements);
            return this;
        }

        public Settings build() {
            return new Settings(this.map, (SecureSettings)this.secureSettings.get());
        }
    }
}

