/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class ParentChildIndexFieldData
extends AbstractIndexFieldData<AtomicParentChildFieldData>
implements IndexParentChildFieldData {
    private final Set<String> parentTypes;
    private final CircuitBreakerService breakerService;

    public ParentChildIndexFieldData(IndexSettings indexSettings, String fieldName, IndexFieldDataCache cache, MapperService mapperService, CircuitBreakerService breakerService) {
        super(indexSettings, fieldName, cache);
        this.breakerService = breakerService;
        HashSet<String> parentTypes = new HashSet<String>();
        for (DocumentMapper mapper : mapperService.docMappers(false)) {
            ParentFieldMapper parentFieldMapper = mapper.parentFieldMapper();
            if (!parentFieldMapper.active()) continue;
            parentTypes.add(parentFieldMapper.type());
        }
        this.parentTypes = parentTypes;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    public AtomicParentChildFieldData load(LeafReaderContext context) {
        final LeafReader reader = context.reader();
        return new AbstractAtomicParentChildFieldData(){

            @Override
            public Set<String> types() {
                return ParentChildIndexFieldData.this.parentTypes;
            }

            @Override
            public SortedDocValues getOrdinalsValues(String type) {
                try {
                    return DocValues.getSorted((LeafReader)reader, (String)ParentFieldMapper.joinField(type));
                }
                catch (IOException e) {
                    throw new IllegalStateException("cannot load join doc values field for type [" + type + "]", e);
                }
            }

            public long ramBytesUsed() {
                return 0L;
            }

            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            @Override
            public void close() throws ElasticsearchException {
            }
        };
    }

    @Override
    public AbstractAtomicParentChildFieldData loadDirect(LeafReaderContext context) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AtomicParentChildFieldData empty(int maxDoc) {
        return AbstractAtomicParentChildFieldData.empty();
    }

    @Override
    public IndexParentChildFieldData loadGlobal(DirectoryReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e);
        }
    }

    private static MultiDocValues.OrdinalMap buildOrdinalMap(AtomicParentChildFieldData[] atomicFD, String parentType) throws IOException {
        SortedDocValues[] ordinals = new SortedDocValues[atomicFD.length];
        for (int i = 0; i < ordinals.length; ++i) {
            ordinals[i] = atomicFD[i].getOrdinalsValues(parentType);
        }
        return MultiDocValues.OrdinalMap.build(null, (SortedDocValues[])ordinals, (float)0.25f);
    }

    @Override
    public IndexParentChildFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        long startTime = System.nanoTime();
        long ramBytesUsed = 0L;
        HashMap<String, OrdinalMapAndAtomicFieldData> perType = new HashMap<String, OrdinalMapAndAtomicFieldData>();
        for (String type : this.parentTypes) {
            AtomicParentChildFieldData[] fieldData = new AtomicParentChildFieldData[indexReader.leaves().size()];
            for (LeafReaderContext context : indexReader.leaves()) {
                fieldData[context.ord] = this.load(context);
            }
            MultiDocValues.OrdinalMap ordMap = ParentChildIndexFieldData.buildOrdinalMap(fieldData, type);
            ramBytesUsed += ordMap.ramBytesUsed();
            perType.put(type, new OrdinalMapAndAtomicFieldData(ordMap, fieldData));
        }
        AtomicParentChildFieldData[] fielddata = new AtomicParentChildFieldData[indexReader.leaves().size()];
        for (int i = 0; i < fielddata.length; ++i) {
            fielddata[i] = new GlobalAtomicFieldData(this.parentTypes, perType, i);
        }
        this.breakerService.getBreaker("fielddata").addWithoutBreaking(ramBytesUsed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("global-ordinals [_parent] took [{}]", (Object)new TimeValue(System.nanoTime() - startTime, TimeUnit.NANOSECONDS));
        }
        return new GlobalFieldData((IndexReader)indexReader, fielddata, ramBytesUsed, perType);
    }

    public static MultiDocValues.OrdinalMap getOrdinalMap(IndexParentChildFieldData indexParentChildFieldData, String type) {
        if (indexParentChildFieldData instanceof GlobalFieldData) {
            return ((OrdinalMapAndAtomicFieldData)((GlobalFieldData)((GlobalFieldData)indexParentChildFieldData)).ordinalMapPerType.get((Object)type)).ordMap;
        }
        return null;
    }

    public class GlobalFieldData
    implements IndexParentChildFieldData,
    Accountable {
        private final Object coreCacheKey;
        private final List<LeafReaderContext> leaves;
        private final AtomicParentChildFieldData[] fielddata;
        private final long ramBytesUsed;
        private final Map<String, OrdinalMapAndAtomicFieldData> ordinalMapPerType;

        GlobalFieldData(IndexReader reader, AtomicParentChildFieldData[] fielddata, long ramBytesUsed, Map<String, OrdinalMapAndAtomicFieldData> ordinalMapPerType) {
            this.coreCacheKey = reader.getCoreCacheKey();
            this.leaves = reader.leaves();
            this.ramBytesUsed = ramBytesUsed;
            this.fielddata = fielddata;
            this.ordinalMapPerType = ordinalMapPerType;
        }

        @Override
        public String getFieldName() {
            return ParentChildIndexFieldData.this.getFieldName();
        }

        @Override
        public AtomicParentChildFieldData load(LeafReaderContext context) {
            assert (context.reader().getCoreCacheKey() == this.leaves.get(context.ord).reader().getCoreCacheKey());
            return this.fielddata[context.ord];
        }

        @Override
        public AtomicParentChildFieldData loadDirect(LeafReaderContext context) throws Exception {
            return this.load(context);
        }

        @Override
        public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
            throw new UnsupportedOperationException("No sorting on global ords");
        }

        @Override
        public void clear() {
            ParentChildIndexFieldData.this.clear();
        }

        @Override
        public Index index() {
            return ParentChildIndexFieldData.this.index();
        }

        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public IndexParentChildFieldData loadGlobal(DirectoryReader indexReader) {
            if (indexReader.getCoreCacheKey() == this.coreCacheKey) {
                return this;
            }
            throw new IllegalStateException();
        }

        @Override
        public IndexParentChildFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
            return this.loadGlobal(indexReader);
        }
    }

    private static class GlobalAtomicFieldData
    extends AbstractAtomicParentChildFieldData {
        private final Set<String> types;
        private final Map<String, OrdinalMapAndAtomicFieldData> atomicFD;
        private final int segmentIndex;

        GlobalAtomicFieldData(Set<String> types, Map<String, OrdinalMapAndAtomicFieldData> atomicFD, int segmentIndex) {
            this.types = types;
            this.atomicFD = atomicFD;
            this.segmentIndex = segmentIndex;
        }

        @Override
        public Set<String> types() {
            return this.types;
        }

        @Override
        public SortedDocValues getOrdinalsValues(String type) {
            OrdinalMapAndAtomicFieldData atomicFD = this.atomicFD.get(type);
            if (atomicFD == null) {
                return DocValues.emptySorted();
            }
            final MultiDocValues.OrdinalMap ordMap = atomicFD.ordMap;
            final SortedDocValues[] allSegmentValues = new SortedDocValues[atomicFD.fieldData.length];
            for (int i = 0; i < allSegmentValues.length; ++i) {
                allSegmentValues[i] = atomicFD.fieldData[i].getOrdinalsValues(type);
            }
            final SortedDocValues segmentValues = allSegmentValues[this.segmentIndex];
            if ((long)segmentValues.getValueCount() == ordMap.getValueCount()) {
                return segmentValues;
            }
            final LongValues globalOrds = ordMap.getGlobalOrds(this.segmentIndex);
            return new SortedDocValues(){

                public BytesRef lookupOrd(int ord) {
                    int segmentIndex = ordMap.getFirstSegmentNumber((long)ord);
                    int segmentOrd = (int)ordMap.getFirstSegmentOrd((long)ord);
                    return allSegmentValues[segmentIndex].lookupOrd(segmentOrd);
                }

                public int getValueCount() {
                    return (int)ordMap.getValueCount();
                }

                public int getOrd(int docID) {
                    int segmentOrd = segmentValues.getOrd(docID);
                    if (segmentOrd >= 0) {
                        return (int)globalOrds.get(segmentOrd);
                    }
                    return segmentOrd;
                }
            };
        }

        public long ramBytesUsed() {
            return 0L;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public void close() {
            ArrayList<AtomicParentChildFieldData> closeables = new ArrayList<AtomicParentChildFieldData>();
            for (OrdinalMapAndAtomicFieldData fds : this.atomicFD.values()) {
                closeables.addAll(Arrays.asList(fds.fieldData));
            }
            Releasables.close(closeables);
        }
    }

    private static class OrdinalMapAndAtomicFieldData {
        final MultiDocValues.OrdinalMap ordMap;
        final AtomicParentChildFieldData[] fieldData;

        OrdinalMapAndAtomicFieldData(MultiDocValues.OrdinalMap ordMap, AtomicParentChildFieldData[] fieldData) {
            this.ordMap = ordMap;
            this.fieldData = fieldData;
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new ParentChildIndexFieldData(indexSettings, fieldType.name(), cache, mapperService, breakerService);
        }
    }
}

