/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.SearchSortValues;
import org.elasticsearch.search.lookup.SourceLookup;

public class InternalSearchHit
implements SearchHit {
    private transient int docId;
    private static final float DEFAULT_SCORE = Float.NEGATIVE_INFINITY;
    private float score = Float.NEGATIVE_INFINITY;
    private Text id;
    private Text type;
    private InternalNestedIdentity nestedIdentity;
    private long version = -1L;
    private BytesReference source;
    private Map<String, SearchHitField> fields = Collections.emptyMap();
    private Map<String, HighlightField> highlightFields = null;
    private SearchSortValues sortValues = SearchSortValues.EMPTY;
    private String[] matchedQueries = Strings.EMPTY_ARRAY;
    private Explanation explanation;
    @Nullable
    private SearchShardTarget shard;
    private transient String index;
    private Map<String, Object> sourceAsMap;
    private byte[] sourceAsBytes;
    private Map<String, InternalSearchHits> innerHits;

    private InternalSearchHit() {
    }

    public InternalSearchHit(int docId) {
        this(docId, null, null, null);
    }

    public InternalSearchHit(int docId, String id, Text type, Map<String, SearchHitField> fields) {
        this(docId, id, type, null, fields);
    }

    public InternalSearchHit(int nestedTopDocId, String id, Text type, InternalNestedIdentity nestedIdentity, Map<String, SearchHitField> fields) {
        this.docId = nestedTopDocId;
        this.id = id != null ? new Text(id) : null;
        this.type = type;
        this.nestedIdentity = nestedIdentity;
        this.fields = fields;
    }

    public int docId() {
        return this.docId;
    }

    public void score(float score) {
        this.score = score;
    }

    @Override
    public float score() {
        return this.score;
    }

    @Override
    public float getScore() {
        return this.score();
    }

    public void version(long version) {
        this.version = version;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public String getIndex() {
        return this.index();
    }

    @Override
    public String id() {
        return this.id != null ? this.id.string() : null;
    }

    @Override
    public String getId() {
        return this.id();
    }

    @Override
    public String type() {
        return this.type != null ? this.type.string() : null;
    }

    @Override
    public String getType() {
        return this.type();
    }

    @Override
    public SearchHit.NestedIdentity getNestedIdentity() {
        return this.nestedIdentity;
    }

    @Override
    public BytesReference sourceRef() {
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public InternalSearchHit sourceRef(BytesReference source) {
        this.source = source;
        this.sourceAsBytes = null;
        this.sourceAsMap = null;
        return this;
    }

    @Override
    public BytesReference getSourceRef() {
        return this.sourceRef();
    }

    @Override
    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = BytesReference.toBytes(this.sourceRef());
        return this.sourceAsBytes;
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    @Override
    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    @Override
    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        try {
            return XContentHelper.convertToJson(this.sourceRef(), false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    @Override
    public String getSourceAsString() {
        return this.sourceAsString();
    }

    @Override
    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    @Override
    public Iterator<SearchHitField> iterator() {
        return this.fields.values().iterator();
    }

    @Override
    public SearchHitField field(String fieldName) {
        return this.fields().get(fieldName);
    }

    @Override
    public Map<String, SearchHitField> fields() {
        return this.fields == null ? Collections.emptyMap() : this.fields;
    }

    public Map<String, SearchHitField> fieldsOrNull() {
        return this.fields;
    }

    @Override
    public Map<String, SearchHitField> getFields() {
        return this.fields();
    }

    public void fields(Map<String, SearchHitField> fields) {
        this.fields = fields;
    }

    @Override
    public Map<String, HighlightField> highlightFields() {
        return this.highlightFields == null ? Collections.emptyMap() : this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> getHighlightFields() {
        return this.highlightFields();
    }

    public void highlightFields(Map<String, HighlightField> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public void sortValues(Object[] sortValues, DocValueFormat[] sortValueFormats) {
        this.sortValues(new SearchSortValues(sortValues, sortValueFormats));
    }

    public void sortValues(SearchSortValues sortValues) {
        this.sortValues = sortValues;
    }

    @Override
    public Object[] sortValues() {
        return this.sortValues.sortValues();
    }

    @Override
    public Object[] getSortValues() {
        return this.sortValues();
    }

    @Override
    public Explanation explanation() {
        return this.explanation;
    }

    @Override
    public Explanation getExplanation() {
        return this.explanation();
    }

    public void explanation(Explanation explanation) {
        this.explanation = explanation;
    }

    @Override
    public SearchShardTarget shard() {
        return this.shard;
    }

    @Override
    public SearchShardTarget getShard() {
        return this.shard();
    }

    public void shard(SearchShardTarget target) {
        this.shard = target;
        if (target != null) {
            this.index = target.getIndex();
        }
    }

    public void matchedQueries(String[] matchedQueries) {
        this.matchedQueries = matchedQueries;
    }

    @Override
    public String[] matchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public String[] getMatchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public Map<String, SearchHits> getInnerHits() {
        return this.innerHits;
    }

    public void setInnerHits(Map<String, InternalSearchHits> innerHits) {
        this.innerHits = innerHits;
    }

    public XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ArrayList<SearchHitField> metaFields = new ArrayList<SearchHitField>();
        ArrayList<SearchHitField> otherFields = new ArrayList<SearchHitField>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (SearchHitField searchHitField : this.fields.values()) {
                if (searchHitField.values().isEmpty()) continue;
                if (searchHitField.isMetadataField()) {
                    metaFields.add(searchHitField);
                    continue;
                }
                otherFields.add(searchHitField);
            }
        }
        if (this.explanation() != null && this.shard != null) {
            builder.field("_shard", this.shard.getShardId());
            builder.field("_node", this.shard.getNodeIdText());
        }
        if (this.nestedIdentity != null) {
            this.nestedIdentity.toXContent(builder, params);
        } else {
            if (this.index != null) {
                builder.field("_index", this.index);
            }
            if (this.type != null) {
                builder.field("_type", this.type);
            }
            if (this.id != null) {
                builder.field("_id", this.id);
            }
        }
        if (this.version != -1L) {
            builder.field("_version", this.version);
        }
        if (Float.isNaN(this.score)) {
            builder.nullField("_score");
        } else {
            builder.field("_score", this.score);
        }
        for (SearchHitField searchHitField : metaFields) {
            Object value = searchHitField.value();
            builder.field(searchHitField.name(), value);
        }
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!otherFields.isEmpty()) {
            builder.startObject("fields");
            for (SearchHitField searchHitField : otherFields) {
                builder.startArray(searchHitField.name());
                for (Object object : searchHitField.getValues()) {
                    builder.value(object);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        if (this.highlightFields != null && !this.highlightFields.isEmpty()) {
            builder.startObject("highlight");
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.toXContent(builder, params);
            }
            builder.endObject();
        }
        this.sortValues.toXContent(builder, params);
        if (this.matchedQueries.length > 0) {
            builder.startArray("matched_queries");
            for (Iterator<Object> iterator : this.matchedQueries) {
                builder.value((String)((Object)iterator));
            }
            builder.endArray();
        }
        if (this.explanation() != null) {
            builder.field("_explanation");
            this.buildExplanation(builder, this.explanation());
        }
        if (this.innerHits != null) {
            builder.startObject("inner_hits");
            for (Map.Entry entry : this.innerHits.entrySet()) {
                builder.startObject((String)entry.getKey());
                ((InternalSearchHits)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public static InternalSearchHit fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        String currentFieldName = null;
        String type = null;
        String id = null;
        String index = null;
        float score = Float.NEGATIVE_INFINITY;
        long version = -1L;
        SearchSortValues sortValues = SearchSortValues.EMPTY;
        InternalNestedIdentity nestedIdentity = null;
        HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
        BytesReference parsedSource = null;
        ArrayList<String> matchedQueries = new ArrayList<String>();
        HashMap<String, SearchHitField> fields = new HashMap<String, SearchHitField>();
        Explanation explanation = null;
        ShardId shardId = null;
        String nodeId = null;
        HashMap<String, InternalSearchHits> innerHits = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("_type".equals(currentFieldName)) {
                    type = parser.text();
                    continue;
                }
                if ("_index".equals(currentFieldName)) {
                    index = parser.text();
                    continue;
                }
                if ("_id".equals(currentFieldName)) {
                    id = parser.text();
                    continue;
                }
                if ("_score".equals(currentFieldName)) {
                    score = parser.floatValue();
                    continue;
                }
                if ("_version".equals(currentFieldName)) {
                    version = parser.longValue();
                    continue;
                }
                if ("_shard".equals(currentFieldName)) {
                    shardId = ShardId.fromString(parser.text());
                    continue;
                }
                if ("_node".equals(currentFieldName)) {
                    nodeId = parser.text();
                    continue;
                }
                if (MapperService.isMetadataField(currentFieldName)) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    values.add(XContentParserUtils.parseStoredFieldsValue(parser));
                    fields.put(currentFieldName, new InternalSearchHitField(currentFieldName, values));
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if ("_score".equals(currentFieldName)) {
                    score = Float.NaN;
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("_source".equals(currentFieldName)) {
                    XContentBuilder builder = XContentBuilder.builder(parser.contentType().xContent());
                    Throwable throwable = null;
                    try {
                        builder.copyCurrentStructure(parser);
                        parsedSource = builder.bytes();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (builder == null) continue;
                        if (throwable != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        builder.close();
                        continue;
                    }
                }
                if ("highlight".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        HighlightField highlightField = HighlightField.fromXContent(parser);
                        highlightFields.put(highlightField.getName(), highlightField);
                    }
                    continue;
                }
                if ("fields".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        String fieldName = parser.currentName();
                        ArrayList<Object> values = new ArrayList<Object>();
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.nextToken(), parser::getTokenLocation);
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            values.add(XContentParserUtils.parseStoredFieldsValue(parser));
                        }
                        fields.put(fieldName, new InternalSearchHitField(fieldName, values));
                    }
                    continue;
                }
                if ("_explanation".equals(currentFieldName)) {
                    explanation = InternalSearchHit.parseExplanation(parser);
                    continue;
                }
                if ("inner_hits".equals(currentFieldName)) {
                    innerHits = new HashMap<String, InternalSearchHits>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
                        String name = parser.currentName();
                        innerHits.put(name, InternalSearchHits.fromXContent(parser));
                        parser.nextToken();
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.currentToken(), parser::getTokenLocation);
                    }
                    continue;
                }
                if ("_nested".equals(currentFieldName)) {
                    nestedIdentity = InternalNestedIdentity.fromXContent(parser);
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("sort".equals(currentFieldName)) {
                    sortValues = SearchSortValues.fromXContent(parser);
                    continue;
                }
                if ("matched_queries".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        matchedQueries.add(parser.text());
                    }
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
        }
        InternalSearchHit internalSearchHit = new InternalSearchHit(-1, id, new Text(type), nestedIdentity, Collections.emptyMap());
        internalSearchHit.index = index;
        internalSearchHit.score(score);
        internalSearchHit.version(version);
        internalSearchHit.sortValues(sortValues);
        internalSearchHit.highlightFields(highlightFields);
        internalSearchHit.sourceRef(parsedSource);
        internalSearchHit.explanation(explanation);
        internalSearchHit.setInnerHits(innerHits);
        if (matchedQueries.size() > 0) {
            internalSearchHit.matchedQueries(matchedQueries.toArray(new String[matchedQueries.size()]));
        }
        if (shardId != null && nodeId != null) {
            internalSearchHit.shard(new SearchShardTarget(nodeId, shardId));
        }
        internalSearchHit.fields(fields);
        return internalSearchHit;
    }

    private static Explanation parseExplanation(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        Float value = null;
        String description = null;
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, () -> parser.getTokenLocation());
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if ("value".equals(currentFieldName)) {
                value = Float.valueOf(parser.floatValue());
                continue;
            }
            if ("description".equals(currentFieldName)) {
                description = parser.textOrNull();
                continue;
            }
            if ("details".equals(currentFieldName)) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, () -> parser.getTokenLocation());
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    details.add(InternalSearchHit.parseExplanation(parser));
                }
                continue;
            }
            XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
        }
        if (value == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing explanation value", new Object[0]);
        }
        if (description == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing explanation description", new Object[0]);
        }
        return Explanation.match((float)value.floatValue(), description, details);
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.startObject();
        builder.field("value", explanation.getValue());
        builder.field("description", explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray("details");
            for (Explanation exp : innerExps) {
                this.buildExplanation(builder, exp);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static InternalSearchHit readSearchHit(StreamInput in) throws IOException {
        InternalSearchHit hit = new InternalSearchHit();
        hit.readFrom(in);
        return hit;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        int size;
        this.score = in.readFloat();
        this.id = in.readOptionalText();
        this.type = in.readOptionalText();
        this.nestedIdentity = in.readOptionalWriteable(InternalNestedIdentity::new);
        this.version = in.readLong();
        this.source = in.readBytesReference();
        if (this.source.length() == 0) {
            this.source = null;
        }
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if ((size = in.readVInt()) == 0) {
            this.fields = Collections.emptyMap();
        } else if (size == 1) {
            InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
            this.fields = Collections.singletonMap(hitField.name(), hitField);
        } else {
            HashMap<String, InternalSearchHitField> fields = new HashMap<String, InternalSearchHitField>();
            for (i = 0; i < size; ++i) {
                InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
                fields.put(hitField.name(), hitField);
            }
            this.fields = Collections.unmodifiableMap(fields);
        }
        size = in.readVInt();
        if (size == 0) {
            this.highlightFields = Collections.emptyMap();
        } else if (size == 1) {
            HighlightField field = HighlightField.readHighlightField(in);
            this.highlightFields = Collections.singletonMap(field.name(), field);
        } else {
            HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
            for (i = 0; i < size; ++i) {
                HighlightField field = HighlightField.readHighlightField(in);
                highlightFields.put(field.name(), field);
            }
            this.highlightFields = Collections.unmodifiableMap(highlightFields);
        }
        this.sortValues = new SearchSortValues(in);
        size = in.readVInt();
        if (size > 0) {
            this.matchedQueries = new String[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.matchedQueries[i2] = in.readString();
            }
        }
        this.shard(in.readOptionalWriteable(SearchShardTarget::new));
        size = in.readVInt();
        if (size > 0) {
            this.innerHits = new HashMap<String, InternalSearchHits>(size);
            for (int i3 = 0; i3 < size; ++i3) {
                String key = in.readString();
                InternalSearchHits value = InternalSearchHits.readSearchHits(in);
                this.innerHits.put(key, value);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.score);
        out.writeOptionalText(this.id);
        out.writeOptionalText(this.type);
        out.writeOptionalWriteable(this.nestedIdentity);
        out.writeLong(this.version);
        out.writeBytesReference(this.source);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.size());
            for (SearchHitField searchHitField : this.fields().values()) {
                searchHitField.writeTo(out);
            }
        }
        if (this.highlightFields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.highlightFields.size());
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.writeTo(out);
            }
        }
        this.sortValues.writeTo(out);
        if (this.matchedQueries.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.matchedQueries.length);
            for (Iterator<Streamable> iterator : this.matchedQueries) {
                out.writeString((String)((Object)iterator));
            }
        }
        out.writeOptionalWriteable(this.shard);
        if (this.innerHits == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.innerHits.size());
            for (Map.Entry entry : this.innerHits.entrySet()) {
                out.writeString((String)entry.getKey());
                ((InternalSearchHits)entry.getValue()).writeTo(out);
            }
        }
    }

    public static final class InternalNestedIdentity
    implements SearchHit.NestedIdentity,
    Writeable,
    ToXContent {
        private Text field;
        private int offset;
        private InternalNestedIdentity child;
        private static final ConstructingObjectParser<InternalNestedIdentity, Void> PARSER = new ConstructingObjectParser("nested_identity", ctorArgs -> new InternalNestedIdentity((String)ctorArgs[0], (Integer)ctorArgs[1], (InternalNestedIdentity)ctorArgs[2]));

        public InternalNestedIdentity(String field, int offset, InternalNestedIdentity child) {
            this.field = new Text(field);
            this.offset = offset;
            this.child = child;
        }

        InternalNestedIdentity(StreamInput in) throws IOException {
            this.field = in.readOptionalText();
            this.offset = in.readInt();
            this.child = in.readOptionalWriteable(InternalNestedIdentity::new);
        }

        @Override
        public Text getField() {
            return this.field;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public SearchHit.NestedIdentity getChild() {
            return this.child;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalText(this.field);
            out.writeInt(this.offset);
            out.writeOptionalWriteable(this.child);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("_nested");
            return this.innerToXContent(builder, params);
        }

        XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.field != null) {
                builder.field("field", this.field);
            }
            if (this.offset != -1) {
                builder.field("offset", this.offset);
            }
            if (this.child != null) {
                builder = this.child.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public static InternalNestedIdentity fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InternalNestedIdentity other = (InternalNestedIdentity)obj;
            return Objects.equals(this.field, other.field) && Objects.equals(this.offset, other.offset) && Objects.equals(this.child, other.child);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.offset, this.child);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("field", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("offset", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), PARSER, new ParseField("_nested", new String[0]));
        }

        public static class Fields {
            static final String _NESTED = "_nested";
            static final String _NESTED_FIELD = "field";
            static final String _NESTED_OFFSET = "offset";
        }
    }

    public static class Fields {
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";
        static final String _VERSION = "_version";
        static final String _SCORE = "_score";
        static final String FIELDS = "fields";
        static final String HIGHLIGHT = "highlight";
        static final String SORT = "sort";
        static final String MATCHED_QUERIES = "matched_queries";
        static final String _EXPLANATION = "_explanation";
        static final String VALUE = "value";
        static final String DESCRIPTION = "description";
        static final String DETAILS = "details";
        static final String INNER_HITS = "inner_hits";
        static final String _SHARD = "_shard";
        static final String _NODE = "_node";
    }
}

