/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.script.expression.FieldDataValueSource;
import org.elasticsearch.search.MultiValueMode;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;

class DateObjectValueSource
extends FieldDataValueSource {
    final String methodName;
    final ToIntFunction<ReadableDateTime> function;

    DateObjectValueSource(IndexFieldData<?> indexFieldData, MultiValueMode multiValueMode, String methodName, ToIntFunction<ReadableDateTime> function) {
        super(indexFieldData, multiValueMode);
        Objects.requireNonNull(methodName);
        this.methodName = methodName;
        this.function = function;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        AtomicNumericFieldData leafData = (AtomicNumericFieldData)this.fieldData.load(leaf);
        final MutableDateTime joda = new MutableDateTime(0L, DateTimeZone.UTC);
        final NumericDoubleValues docValues = this.multiValueMode.select(leafData.getDoubleValues(), 0.0);
        return new DoubleDocValues(this){

            public double doubleVal(int docId) {
                long millis = (long)docValues.get(docId);
                joda.setMillis(millis);
                return DateObjectValueSource.this.function.applyAsInt((ReadableDateTime)joda);
            }
        };
    }

    @Override
    public String description() {
        return this.methodName + ": field(" + this.fieldData.getFieldName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateObjectValueSource that = (DateObjectValueSource)((Object)o);
        return this.methodName.equals(that.methodName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.methodName.hashCode();
        return result;
    }
}

