/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.svggen.DefaultCachedImageHandler;
import org.apache.batik.svggen.ImageCacher;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class CachedImageHandlerJPEGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_JPEG_PREFIX = "jpegImage";
    public static final String CACHED_JPEG_SUFFIX = ".jpg";
    protected String refPrefix = "";

    public CachedImageHandlerJPEGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        this.refPrefix = string2 + "/";
        this.setImageCacher(new ImageCacher.External(string, CACHED_JPEG_PREFIX, CACHED_JPEG_SUFFIX));
    }

    @Override
    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        imageWriterParams.setJPEGQuality(1.0f, false);
        imageWriter.writeImage(bufferedImage, outputStream, imageWriterParams);
    }

    @Override
    public int getBufferedImageType() {
        return 1;
    }

    @Override
    public String getRefPrefix() {
        return this.refPrefix;
    }
}

