/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.write.bytes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.exceptions.RangeException;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.string.UTF8Operations;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class WriteUTF8CharacterNode
extends FormatNode {
    @Specialization(guards={"value >= 0", "value <= 0x7f"})
    public Object writeSingleByte(VirtualFrame frame, long value, @Cached(value="createBinaryProfile()") ConditionProfile rangeProfile) {
        this.writeByte(frame, (byte)value);
        if (rangeProfile.profile(UTF8Operations.isUTF8ValidOneByte((byte)value))) {
            this.setStringCodeRange(frame, CodeRange.CR_7BIT);
        } else {
            this.setStringCodeRange(frame, CodeRange.CR_BROKEN);
        }
        return null;
    }

    @Specialization(guards={"value > 0x7f", "value <= 0x7ff"})
    public Object writeTwoBytes(VirtualFrame frame, long value, @Cached(value="createBinaryProfile()") ConditionProfile rangeProfile) {
        byte[] bytes = new byte[]{(byte)(value >>> 6 & 0xFFL | 0xC0L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        this.increaseStringLength(frame, -1);
        if (rangeProfile.profile(UTF8Operations.isUTF8ValidTwoBytes(bytes))) {
            this.setStringCodeRange(frame, CodeRange.CR_VALID);
        } else {
            this.setStringCodeRange(frame, CodeRange.CR_BROKEN);
        }
        return null;
    }

    @Specialization(guards={"value > 0x7ff", "value <= 0xffff"})
    public Object writeThreeBytes(VirtualFrame frame, long value, @Cached(value="createBinaryProfile()") ConditionProfile rangeProfile) {
        byte[] bytes = new byte[]{(byte)(value >>> 12 & 0xFFL | 0xE0L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        this.increaseStringLength(frame, -2);
        if (rangeProfile.profile(UTF8Operations.isUTF8ValidThreeBytes(bytes))) {
            this.setStringCodeRange(frame, CodeRange.CR_VALID);
        } else {
            this.setStringCodeRange(frame, CodeRange.CR_BROKEN);
        }
        return null;
    }

    @Specialization(guards={"value > 0xffff", "value <= 0x1fffff"})
    public Object writeFourBytes(VirtualFrame frame, long value, @Cached(value="createBinaryProfile()") ConditionProfile rangeProfile) {
        byte[] bytes = new byte[]{(byte)(value >>> 18 & 0xFFL | 0xF0L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        this.increaseStringLength(frame, -3);
        if (rangeProfile.profile(UTF8Operations.isUTF8ValidFourBytes(bytes))) {
            this.setStringCodeRange(frame, CodeRange.CR_VALID);
        } else {
            this.setStringCodeRange(frame, CodeRange.CR_BROKEN);
        }
        return null;
    }

    @Specialization(guards={"value > 0x1fffff", "value <= 0x3ffffff"})
    public Object writeFiveBytes(VirtualFrame frame, long value, @Cached(value="createBinaryProfile()") ConditionProfile rangeProfile) {
        byte[] bytes = new byte[]{(byte)(value >>> 24 & 0xFFL | 0xF8L), (byte)(value >>> 18 & 0x3FL | 0x80L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        this.increaseStringLength(frame, -4);
        if (rangeProfile.profile(UTF8Operations.isUTF8ValidFiveBytes(bytes))) {
            this.setStringCodeRange(frame, CodeRange.CR_VALID);
        } else {
            this.setStringCodeRange(frame, CodeRange.CR_BROKEN);
        }
        return null;
    }

    @Specialization(guards={"value > 0x3ffffff", "value <= 0x7fffffff"})
    public Object writeSixBytes(VirtualFrame frame, long value, @Cached(value="createBinaryProfile()") ConditionProfile rangeProfile) {
        byte[] bytes = new byte[]{(byte)(value >>> 30 & 0xFFL | 0xFCL), (byte)(value >>> 24 & 0x3FL | 0x80L), (byte)(value >>> 18 & 0x3FL | 0x80L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L)};
        this.writeBytes(frame, bytes);
        this.increaseStringLength(frame, -5);
        if (rangeProfile.profile(UTF8Operations.isUTF8ValidSixBytes(bytes))) {
            this.setStringCodeRange(frame, CodeRange.CR_VALID);
        } else {
            this.setStringCodeRange(frame, CodeRange.CR_BROKEN);
        }
        return null;
    }

    @Specialization(guards={"value < 0"})
    public Object writeNegative(long value) {
        throw new RangeException("pack(U): value out of range");
    }

    @Specialization(guards={"value > 0x7fffffff"})
    public Object writeOutOfRange(long value) {
        throw new RangeException("pack(U): value out of range");
    }
}

