/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.debug.TruffleDebugNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=TruffleDebugNodes.class)
public final class TruffleDebugNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(BreakNodeFactory.getInstance(), RemoveNodeFactory.getInstance(), JavaClassOfNodeFactory.getInstance(), SimpleShellNodeFactory.getInstance(), PrintBacktraceNodeFactory.getInstance(), ASTNodeFactory.getInstance(), ObjectTypeOfNodeFactory.getInstance(), ShapeNodeFactory.getInstance(), ArrayStorageNodeFactory.getInstance(), IsSharedNodeFactory.getInstance());
    }

    @GeneratedBy(value=TruffleDebugNodes.IsSharedNode.class)
    public static final class IsSharedNodeFactory
    implements NodeFactory<TruffleDebugNodes.IsSharedNode> {
        private static IsSharedNodeFactory isSharedNodeFactoryInstance;

        private IsSharedNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.IsSharedNode> getNodeClass() {
            return TruffleDebugNodes.IsSharedNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.IsSharedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IsSharedNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.IsSharedNode> getInstance() {
            if (isSharedNodeFactoryInstance == null) {
                isSharedNodeFactoryInstance = new IsSharedNodeFactory();
            }
            return isSharedNodeFactoryInstance;
        }

        public static TruffleDebugNodes.IsSharedNode create(RubyNode[] arguments) {
            return new IsSharedNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.IsSharedNode.class)
        public static final class IsSharedNodeGen
        extends TruffleDebugNodes.IsSharedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private IsSharedNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isShared(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.ArrayStorageNode.class)
    public static final class ArrayStorageNodeFactory
    implements NodeFactory<TruffleDebugNodes.ArrayStorageNode> {
        private static ArrayStorageNodeFactory arrayStorageNodeFactoryInstance;

        private ArrayStorageNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.ArrayStorageNode> getNodeClass() {
            return TruffleDebugNodes.ArrayStorageNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.ArrayStorageNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ArrayStorageNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.ArrayStorageNode> getInstance() {
            if (arrayStorageNodeFactoryInstance == null) {
                arrayStorageNodeFactoryInstance = new ArrayStorageNodeFactory();
            }
            return arrayStorageNodeFactoryInstance;
        }

        public static TruffleDebugNodes.ArrayStorageNode create(RubyNode[] arguments) {
            return new ArrayStorageNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.ArrayStorageNode.class)
        public static final class ArrayStorageNodeGen
        extends TruffleDebugNodes.ArrayStorageNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ArrayStorageNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyArray(arguments0Value_)) {
                    return this.arrayStorage(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.ShapeNode.class)
    public static final class ShapeNodeFactory
    implements NodeFactory<TruffleDebugNodes.ShapeNode> {
        private static ShapeNodeFactory shapeNodeFactoryInstance;

        private ShapeNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.ShapeNode> getNodeClass() {
            return TruffleDebugNodes.ShapeNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.ShapeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ShapeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.ShapeNode> getInstance() {
            if (shapeNodeFactoryInstance == null) {
                shapeNodeFactoryInstance = new ShapeNodeFactory();
            }
            return shapeNodeFactoryInstance;
        }

        public static TruffleDebugNodes.ShapeNode create(RubyNode[] arguments) {
            return new ShapeNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.ShapeNode.class)
        public static final class ShapeNodeGen
        extends TruffleDebugNodes.ShapeNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ShapeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.shape(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.ObjectTypeOfNode.class)
    public static final class ObjectTypeOfNodeFactory
    implements NodeFactory<TruffleDebugNodes.ObjectTypeOfNode> {
        private static ObjectTypeOfNodeFactory objectTypeOfNodeFactoryInstance;

        private ObjectTypeOfNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.ObjectTypeOfNode> getNodeClass() {
            return TruffleDebugNodes.ObjectTypeOfNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.ObjectTypeOfNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ObjectTypeOfNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.ObjectTypeOfNode> getInstance() {
            if (objectTypeOfNodeFactoryInstance == null) {
                objectTypeOfNodeFactoryInstance = new ObjectTypeOfNodeFactory();
            }
            return objectTypeOfNodeFactoryInstance;
        }

        public static TruffleDebugNodes.ObjectTypeOfNode create(RubyNode[] arguments) {
            return new ObjectTypeOfNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.ObjectTypeOfNode.class)
        public static final class ObjectTypeOfNodeGen
        extends TruffleDebugNodes.ObjectTypeOfNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ObjectTypeOfNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.objectTypeOf(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.ASTNode.class)
    public static final class ASTNodeFactory
    implements NodeFactory<TruffleDebugNodes.ASTNode> {
        private static ASTNodeFactory aSTNodeFactoryInstance;

        private ASTNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.ASTNode> getNodeClass() {
            return TruffleDebugNodes.ASTNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.ASTNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ASTNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.ASTNode> getInstance() {
            if (aSTNodeFactoryInstance == null) {
                aSTNodeFactoryInstance = new ASTNodeFactory();
            }
            return aSTNodeFactoryInstance;
        }

        public static TruffleDebugNodes.ASTNode create(RubyNode[] arguments) {
            return new ASTNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.ASTNode.class)
        public static final class ASTNodeGen
        extends TruffleDebugNodes.ASTNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ASTNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="astProc(DynamicObject)", value=TruffleDebugNodes.ASTNode.class)
            private static final class AstProcNode_
            extends BaseNode_ {
                AstProcNode_(ASTNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyProc(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.astProc(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new AstProcNode_(root);
                }
            }

            @GeneratedBy(methodName="astUnboundMethod(DynamicObject)", value=TruffleDebugNodes.ASTNode.class)
            private static final class AstUnboundMethodNode_
            extends BaseNode_ {
                AstUnboundMethodNode_(ASTNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyUnboundMethod(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.astUnboundMethod(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new AstUnboundMethodNode_(root);
                }
            }

            @GeneratedBy(methodName="astMethod(DynamicObject)", value=TruffleDebugNodes.ASTNode.class)
            private static final class AstMethodNode_
            extends BaseNode_ {
                AstMethodNode_(ASTNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyMethod(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.astMethod(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new AstMethodNode_(root);
                }
            }

            @GeneratedBy(value=TruffleDebugNodes.ASTNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ASTNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TruffleDebugNodes.ASTNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ASTNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TruffleDebugNodes.ASTNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ASTNodeGen root;

                BaseNode_(ASTNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ASTNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyMethod(arguments0Value_)) {
                            return AstMethodNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyUnboundMethod(arguments0Value_)) {
                            return AstUnboundMethodNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyProc(arguments0Value_)) {
                            return AstProcNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.PrintBacktraceNode.class)
    public static final class PrintBacktraceNodeFactory
    implements NodeFactory<TruffleDebugNodes.PrintBacktraceNode> {
        private static PrintBacktraceNodeFactory printBacktraceNodeFactoryInstance;

        private PrintBacktraceNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.PrintBacktraceNode> getNodeClass() {
            return TruffleDebugNodes.PrintBacktraceNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Object[0]));
        }

        @Override
        public TruffleDebugNodes.PrintBacktraceNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return PrintBacktraceNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.PrintBacktraceNode> getInstance() {
            if (printBacktraceNodeFactoryInstance == null) {
                printBacktraceNodeFactoryInstance = new PrintBacktraceNodeFactory();
            }
            return printBacktraceNodeFactoryInstance;
        }

        public static TruffleDebugNodes.PrintBacktraceNode create() {
            return new PrintBacktraceNodeGen();
        }

        @GeneratedBy(value=TruffleDebugNodes.PrintBacktraceNode.class)
        public static final class PrintBacktraceNodeGen
        extends TruffleDebugNodes.PrintBacktraceNode {
            private PrintBacktraceNodeGen() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.printBacktrace();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.SimpleShellNode.class)
    public static final class SimpleShellNodeFactory
    implements NodeFactory<TruffleDebugNodes.SimpleShellNode> {
        private static SimpleShellNodeFactory simpleShellNodeFactoryInstance;

        private SimpleShellNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.SimpleShellNode> getNodeClass() {
            return TruffleDebugNodes.SimpleShellNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.SimpleShellNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SimpleShellNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.SimpleShellNode> getInstance() {
            if (simpleShellNodeFactoryInstance == null) {
                simpleShellNodeFactoryInstance = new SimpleShellNodeFactory();
            }
            return simpleShellNodeFactoryInstance;
        }

        public static TruffleDebugNodes.SimpleShellNode create(RubyNode[] arguments) {
            return new SimpleShellNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.SimpleShellNode.class)
        public static final class SimpleShellNodeGen
        extends TruffleDebugNodes.SimpleShellNode {
            private SimpleShellNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.simpleShell();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.JavaClassOfNode.class)
    public static final class JavaClassOfNodeFactory
    implements NodeFactory<TruffleDebugNodes.JavaClassOfNode> {
        private static JavaClassOfNodeFactory javaClassOfNodeFactoryInstance;

        private JavaClassOfNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.JavaClassOfNode> getNodeClass() {
            return TruffleDebugNodes.JavaClassOfNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.JavaClassOfNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return JavaClassOfNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.JavaClassOfNode> getInstance() {
            if (javaClassOfNodeFactoryInstance == null) {
                javaClassOfNodeFactoryInstance = new JavaClassOfNodeFactory();
            }
            return javaClassOfNodeFactoryInstance;
        }

        public static TruffleDebugNodes.JavaClassOfNode create(RubyNode[] arguments) {
            return new JavaClassOfNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.JavaClassOfNode.class)
        public static final class JavaClassOfNodeGen
        extends TruffleDebugNodes.JavaClassOfNode {
            @Node.Child
            private RubyNode arguments0_;

            private JavaClassOfNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.javaClassOf(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.RemoveNode.class)
    public static final class RemoveNodeFactory
    implements NodeFactory<TruffleDebugNodes.RemoveNode> {
        private static RemoveNodeFactory removeNodeFactoryInstance;

        private RemoveNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.RemoveNode> getNodeClass() {
            return TruffleDebugNodes.RemoveNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.RemoveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return RemoveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.RemoveNode> getInstance() {
            if (removeNodeFactoryInstance == null) {
                removeNodeFactoryInstance = new RemoveNodeFactory();
            }
            return removeNodeFactoryInstance;
        }

        public static TruffleDebugNodes.RemoveNode create(RubyNode[] arguments) {
            return new RemoveNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.RemoveNode.class)
        public static final class RemoveNodeGen
        extends TruffleDebugNodes.RemoveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private RemoveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isHandle(arguments0Value_)) {
                    return this.remove(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TruffleDebugNodes.BreakNode.class)
    public static final class BreakNodeFactory
    implements NodeFactory<TruffleDebugNodes.BreakNode> {
        private static BreakNodeFactory breakNodeFactoryInstance;

        private BreakNodeFactory() {
        }

        @Override
        public Class<TruffleDebugNodes.BreakNode> getNodeClass() {
            return TruffleDebugNodes.BreakNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public TruffleDebugNodes.BreakNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BreakNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleDebugNodes.BreakNode> getInstance() {
            if (breakNodeFactoryInstance == null) {
                breakNodeFactoryInstance = new BreakNodeFactory();
            }
            return breakNodeFactoryInstance;
        }

        public static TruffleDebugNodes.BreakNode create(RubyNode[] arguments) {
            return new BreakNodeGen(arguments);
        }

        @GeneratedBy(value=TruffleDebugNodes.BreakNode.class)
        public static final class BreakNodeGen
        extends TruffleDebugNodes.BreakNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BreakNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="setBreak(DynamicObject, int, DynamicObject)", value=TruffleDebugNodes.BreakNode.class)
            private static final class SetBreakNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                SetBreakNode_(BreakNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetBreakNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    DynamicObject arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments0Value_)) {
                        return this.root.setBreak(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return this.root.setBreak(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(BreakNodeGen root, Object arguments1Value) {
                    return new SetBreakNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=TruffleDebugNodes.BreakNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BreakNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(BreakNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TruffleDebugNodes.BreakNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BreakNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(BreakNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TruffleDebugNodes.BreakNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected BreakNodeGen root;

                BaseNode_(BreakNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (BreakNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && arguments2Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return SetBreakNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }
}

