/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class FileContentImpl
extends UserDataHolderBase
implements FileContent {
    protected final VirtualFile myFile;
    protected final String myFileName;
    protected final FileType myFileType;
    protected final Charset myCharset;
    protected byte[] myContent;
    protected CharSequence myContentAsText;
    protected final long myStamp;
    private boolean myLighterASTShouldBeThreadSafe;
    private static final Key<PsiFile> CACHED_PSI = Key.create("cached psi from content");

    public Project getProject() {
        return this.getUserData(IndexingDataKeys.PROJECT);
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psi = this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            psi = this.createFileFromText(this.getContentAsText());
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getPsiFile"));
        }
        return psiFile;
    }

    @NotNull
    public LighterAST getLighterASTForPsiDependentIndex() {
        LighterAST lighterAST = this.getUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY);
        if (lighterAST == null) {
            FileASTNode node = this.getPsiFileForPsiDependentIndex().getNode();
            lighterAST = this.myLighterASTShouldBeThreadSafe ? new TreeBackedLighterAST(node) : node.getLighterAST();
            this.putUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY, lighterAST);
        }
        LighterAST lighterAST2 = lighterAST;
        if (lighterAST2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getLighterASTForPsiDependentIndex"));
        }
        return lighterAST2;
    }

    public PsiFile createFileFromText(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/indexing/FileContentImpl", "createFileFromText"));
        }
        Project project = this.getProject();
        if (project == null) {
            project = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        return FileContentImpl.createFileFromText(project, text2, (LanguageFileType)this.getFileTypeWithoutSubstitution(), this.myFile, this.myFileName);
    }

    @NotNull
    public static PsiFile createFileFromText(@NotNull Project project, @NotNull CharSequence text2, @NotNull LanguageFileType fileType, @NotNull VirtualFile file2, @NotNull String fileName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileContentImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/indexing/FileContentImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/util/indexing/FileContentImpl", "createFileFromText"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileContentImpl", "createFileFromText"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/util/indexing/FileContentImpl", "createFileFromText"));
        }
        Language language = fileType.getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, file2, project);
        PsiFile psiFile = PsiFileFactory.getInstance(project).createFileFromText(fileName, substitutedLanguage, text2, false, false, true, file2);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "createFileFromText"));
        }
        return psiFile;
    }

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull byte[] content) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        this(file2, null, content, LoadTextUtil.detectCharsetAndSetBOM(file2, content), -1L);
    }

    private FileContentImpl(@NotNull VirtualFile file2, CharSequence contentAsText, byte[] content, Charset charset, long stamp) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileContentImpl", "<init>"));
        }
        this.myFile = file2;
        this.myContentAsText = contentAsText;
        this.myContent = content;
        this.myCharset = charset;
        this.myFileType = file2.getFileType();
        this.myFileName = file2.getName();
        this.myStamp = stamp;
    }

    @NotNull
    public FileType getSubstitutedFileType() {
        FileType fileType = SubstitutedFileType.substituteFileType(this.myFile, this.myFileType, this.getProject());
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getSubstitutedFileType"));
        }
        return fileType;
    }

    public FileType getFileTypeWithoutSubstitution() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getSubstitutedFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getFileType"));
        }
        return fileType;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getFileName"));
        }
        return string;
    }

    @Override
    public byte[] getContent() {
        if (this.myContent == null && this.myContentAsText != null) {
            try {
                this.myContent = this.myCharset != null ? this.myContentAsText.toString().getBytes(this.myCharset.name()) : this.myContentAsText.toString().getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.myContent;
    }

    @Override
    @NotNull
    public CharSequence getContentAsText() {
        if (this.myFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + this.myFileType.getDescription());
        }
        CharSequence content = this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            CharSequence charSequence = content;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getContentAsText"));
            }
            return charSequence;
        }
        if (this.myContentAsText == null && this.myContent != null) {
            this.myContentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myCharset);
            this.myContent = null;
        }
        CharSequence charSequence = this.myContentAsText;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getContentAsText"));
        }
        return charSequence;
    }

    public String toString() {
        return this.myFileName;
    }

    @NotNull
    public PsiFile getPsiFileForPsiDependentIndex() {
        PsiFile existingPsi;
        PsiDocumentManager psiDocumentManager;
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.getFile());
        PsiFile psi = null;
        if (document != null && (psiDocumentManager = PsiDocumentManager.getInstance(this.getProject())).isUncommited(document) && (existingPsi = psiDocumentManager.getPsiFile(document)) != null) {
            psi = existingPsi;
        }
        if (psi == null) {
            psi = this.getPsiFile();
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileContentImpl", "getPsiFileForPsiDependentIndex"));
        }
        return psiFile;
    }

    public static class IllegalDataException
    extends RuntimeException {
        public IllegalDataException(String message) {
            super(message);
        }
    }
}

