/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;

public abstract class AbstractBranch
extends AbstractNode
implements Branch {
    protected static final OutputFormat outputFormat = new OutputFormat();
    protected static final int DEFAULT_CONTENT_LIST_SIZE = 5;

    public void add(Comment comment) {
        this.addNode(comment);
    }

    public void add(Element element) {
        this.addNode(element);
    }

    public void add(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.add((Element)node);
                break;
            }
            case 8: {
                this.add((Comment)node);
                break;
            }
            case 7: {
                this.add((ProcessingInstruction)node);
                break;
            }
            default: {
                this.invalidNodeTypeAddException(node);
            }
        }
    }

    public void add(ProcessingInstruction pi) {
        this.addNode(pi);
    }

    public Element addElement(String name) {
        Element node = this.getDocumentFactory().createElement(name);
        this.add(node);
        return node;
    }

    public Element addElement(String qualifiedName, String namespaceURI) {
        Element node = this.getDocumentFactory().createElement(qualifiedName, namespaceURI);
        this.add(node);
        return node;
    }

    public Element addElement(String name, String prefix, String uri) {
        Namespace namespace = Namespace.get(prefix, uri);
        QName qName = this.getDocumentFactory().createQName(name, namespace);
        return this.addElement(qName);
    }

    public Element addElement(QName qname) {
        Element node = this.getDocumentFactory().createElement(qname);
        this.add(node);
        return node;
    }

    protected abstract void addNode(Node var1);

    public void appendContent(Branch branch) {
        int i = 0;
        int size = branch.nodeCount();
        while (i < size) {
            Node node = branch.node(i);
            this.add((Node)node.clone());
            ++i;
        }
    }

    protected abstract void childAdded(Node var1);

    protected abstract void childRemoved(Node var1);

    public abstract void clearContent();

    public List content() {
        List backingList = this.contentList();
        return new ContentListFacade(this, backingList);
    }

    protected abstract List contentList();

    protected void contentRemoved() {
        List content = this.contentList();
        int i = 0;
        int size = content.size();
        while (i < size) {
            Object object = content.get(i);
            if (object instanceof Node) {
                this.childRemoved((Node)object);
            }
            ++i;
        }
    }

    protected List createContentList() {
        return new ArrayList(5);
    }

    protected List createContentList(int size) {
        return new ArrayList(size);
    }

    protected List createEmptyList() {
        return new BackedList(this, this.contentList(), 0);
    }

    protected BackedList createResultList() {
        return new BackedList(this, this.contentList());
    }

    protected List createSingleResultList(Object result) {
        BackedList list = new BackedList(this, this.contentList(), 1);
        list.addLocal(result);
        return list;
    }

    public Element elementByID(String elementID) {
        int i = 0;
        int size = this.nodeCount();
        while (i < size) {
            Node node = this.node(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                String id = this.elementID(element);
                if (id != null && id.equals(elementID)) {
                    return element;
                }
                if ((element = element.elementByID(elementID)) != null) {
                    return element;
                }
            }
            ++i;
        }
        return null;
    }

    protected String elementID(Element element) {
        return element.attributeValue("ID");
    }

    protected String getContentAsStringValue(Object content) {
        if (content instanceof Node) {
            Node node = (Node)content;
            switch (node.getNodeType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return node.getStringValue();
                }
                default: {
                    return "";
                }
            }
        }
        if (content instanceof String) {
            return (String)content;
        }
        return "";
    }

    protected String getContentAsText(Object content) {
        if (content instanceof Node) {
            Node node = (Node)content;
            switch (node.getNodeType()) {
                case 3: 
                case 4: 
                case 5: {
                    return node.getText();
                }
                default: {
                    return "";
                }
            }
        }
        if (content instanceof String) {
            return (String)content;
        }
        return "";
    }

    public String getText() {
        int size;
        List content = this.contentList();
        if (content != null && (size = content.size()) >= 1) {
            Object first = content.get(0);
            String firstText = this.getContentAsText(first);
            if (size == 1) {
                return firstText;
            }
            StringBuffer buffer = new StringBuffer(firstText);
            int i = 1;
            while (i < size) {
                Object node = content.get(i);
                buffer.append(this.getContentAsText(node));
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    public String getTextTrim() {
        String text = this.getText();
        StringBuffer textContent = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            textContent.append(str);
            if (!tokenizer.hasMoreTokens()) continue;
            textContent.append(" ");
        }
        return textContent.toString();
    }

    public boolean hasContent() {
        return this.nodeCount() > 0;
    }

    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    protected void invalidNodeTypeAddException(Node node) {
        throw new IllegalAddException("Invalid node type. Cannot add node: " + node + " to this branch: " + this);
    }

    public boolean isReadOnly() {
        return false;
    }

    public Node node(int index) {
        Object object = this.contentList().get(index);
        if (object instanceof Node) {
            return (Node)object;
        }
        if (object instanceof String) {
            return this.getDocumentFactory().createText(object.toString());
        }
        return null;
    }

    public int nodeCount() {
        return this.contentList().size();
    }

    public Iterator nodeIterator() {
        return this.contentList().iterator();
    }

    public abstract void normalize();

    public abstract ProcessingInstruction processingInstruction(String var1);

    public abstract List processingInstructions();

    public abstract List processingInstructions(String var1);

    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    public boolean remove(Element element) {
        return this.removeNode(element);
    }

    public boolean remove(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return this.remove((Element)node);
            }
            case 8: {
                return this.remove((Comment)node);
            }
            case 7: {
                return this.remove((ProcessingInstruction)node);
            }
        }
        this.invalidNodeTypeAddException(node);
        return false;
    }

    public boolean remove(ProcessingInstruction pi) {
        return this.removeNode(pi);
    }

    protected abstract boolean removeNode(Node var1);

    public abstract boolean removeProcessingInstruction(String var1);

    public abstract void setContent(List var1);

    public void setProcessingInstructions(List listOfPIs) {
        Iterator iter = listOfPIs.iterator();
        while (iter.hasNext()) {
            ProcessingInstruction pi = (ProcessingInstruction)iter.next();
            this.addNode(pi);
        }
    }
}

