'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _jsonReporter;

function _load_jsonReporter() {
  return _jsonReporter = _interopRequireDefault(require('./json-reporter.js'));
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BufferReporter extends (_jsonReporter || _load_jsonReporter()).default {
  constructor(opts) {
    super(opts);
    this._buffer = [];
  }

  _dump(type, data, error) {
    this._buffer.push({
      type: type,
      data: data,
      error: !!error
    });
  }

  getBuffer() {
    return this._buffer;
  }
}
exports.default = BufferReporter;