/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.Environment;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class XMLDataObjectInfoParser
extends DefaultHandler
implements FileChangeListener,
LexicalHandler,
LookupListener {
    private static final StopSaxException STOP = new StopSaxException();
    private static XMLReader sharedParserImpl = null;
    private static final String NULL = "";
    private Reference<XMLDataObject> xml;
    private String parsedId;
    private Lookup lookup;
    private Lookup.Result result;
    private ThreadLocal<Class<?>> QUERY = new ThreadLocal();

    XMLDataObjectInfoParser(XMLDataObject xMLDataObject) {
        this.xml = new WeakReference<XMLDataObject>(xMLDataObject);
    }

    public String getPublicId() {
        String string;
        String string2 = this.waitFinished();
        return string2 == (string = NULL) ? null : string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupCookie(Class<?> clazz) {
        if (this.QUERY.get() == clazz) {
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Cyclic deps on queried class: " + clazz + " for " + this.getXml());
            }
            return null;
        }
        Class<?> clazz2 = this.QUERY.get();
        try {
            Lookup lookup;
            Object object;
            String string;
            block19: {
                this.QUERY.set(clazz);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Will do query for class: " + clazz + " for " + this.getXml());
                }
                do {
                    string = this.waitFinished();
                    object = this;
                    synchronized (object) {
                        lookup = this.lookup != null ? this.lookup : null;
                    }
                    if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                        XMLDataObject.ERR.fine("Lookup is " + lookup + " for id: " + string);
                    }
                    if (lookup == null) {
                        lookup = this.updateLookup(this.getXml(), null, string);
                        if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                            XMLDataObject.ERR.fine("Updating lookup: " + lookup);
                        }
                    }
                    if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                        XMLDataObject.ERR.fine("Wait lookup is over: " + lookup + this.getXml());
                    }
                    if (lookup != null) break block19;
                } while (this.parsedId != null);
                lookup = Lookup.EMPTY;
            }
            if ((string = this.result) != null) {
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Querying the result: " + string);
                }
            } else if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("No result for lookup: " + this.lookup);
            }
            object = lookup.lookup(clazz);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Returning value: " + object + " for " + this.getXml());
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.QUERY.set(clazz2);
        }
    }

    public String waitFinished() {
        return this.waitFinished(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String waitFinished(String string) {
        InputStream inputStream;
        String string2;
        String string3;
        XMLDataObject xMLDataObject;
        block73: {
            Object object;
            FileObject fileObject;
            XMLReader xMLReader;
            block72: {
                String string4;
                if (sharedParserImpl == null) {
                    XMLDataObject.ERR.fine("No sharedParserImpl, exiting");
                    return NULL;
                }
                xMLReader = sharedParserImpl;
                xMLDataObject = this.getXml();
                if (xMLDataObject == null) {
                    return NULL;
                }
                fileObject = xMLDataObject.getPrimaryFile();
                string3 = null;
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Going to read parsedId for " + xMLDataObject);
                }
                object = this;
                // MONITORENTER : object
                string2 = this.parsedId;
                // MONITOREXIT : object
                if (string2 != null) {
                    if (!XMLDataObject.ERR.isLoggable(Level.FINE)) return string2;
                    XMLDataObject.ERR.fine("Has already been parsed: " + this.parsedId + " for " + xMLDataObject);
                    return string2;
                }
                object = null;
                inputStream = null;
                try {
                    object = fileObject.getURL();
                }
                catch (IOException iOException) {
                    this.warning(iOException, "I/O exception while retrieving xml FileObject URL.");
                    return NULL;
                }
                XMLDataObjectInfoParser xMLDataObjectInfoParser = this;
                // MONITORENTER : xMLDataObjectInfoParser
                try {
                    if (fileObject.isValid()) break block72;
                    if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                        XMLDataObject.ERR.fine("Invalid file object: " + fileObject);
                    }
                    string4 = NULL;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        XMLDataObject.ERR.log(Level.WARNING, null, iOException);
                    }
                    throw throwable;
                }
                try {
                    if (inputStream == null) return string4;
                    inputStream.close();
                    return string4;
                }
                catch (IOException iOException) {
                    XMLDataObject.ERR.log(Level.WARNING, null, iOException);
                }
                return string4;
            }
            this.parsedId = NULL;
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("parsedId set to NULL for " + xMLDataObject);
            }
            try {
                inputStream = fileObject.getInputStream();
            }
            catch (IOException iOException) {
                this.warning(iOException, "I/O exception while opening " + fileObject);
                String string5 = NULL;
                try {
                    if (inputStream == null) return string5;
                    inputStream.close();
                    return string5;
                }
                catch (IOException iOException2) {
                    XMLDataObject.ERR.log(Level.WARNING, null, iOException2);
                }
                return string5;
            }
            try {
                XMLReader xMLReader2 = sharedParserImpl;
                // MONITORENTER : xMLReader2
                this.configureParser(xMLReader, false, this);
                xMLReader.setContentHandler(this);
                xMLReader.setErrorHandler(this);
                InputSource inputSource = new InputSource(((URL)object).toExternalForm());
                inputSource.setByteStream(inputStream);
                xMLReader.parse(inputSource);
                // MONITOREXIT : xMLReader2
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Parse finished for " + xMLDataObject);
                }
            }
            catch (StopSaxException stopSaxException) {
                string3 = this.parsedId;
                XMLDataObject.ERR.fine("Parsing successfully stopped: " + this.parsedId + " for " + xMLDataObject);
            }
            catch (SAXException sAXException) {
                if (STOP.getMessage().equals(sAXException.getMessage())) {
                    string3 = this.parsedId;
                    XMLDataObject.ERR.fine("Parsing stopped with STOP message: " + this.parsedId + " for " + xMLDataObject);
                    break block73;
                }
                String string6 = "Thread:" + Thread.currentThread().getName();
                XMLDataObject.ERR.warning("DocListener should not throw SAXException but STOP one.\n" + string6);
                XMLDataObject.ERR.log(Level.WARNING, null, sAXException);
                Exception exception = sAXException.getException();
                if (exception != null) {
                    XMLDataObject.ERR.log(Level.WARNING, null, exception);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                XMLDataObject.ERR.log(Level.INFO, null, fileNotFoundException);
            }
            catch (IOException iOException) {
                XMLDataObject.ERR.log(Level.INFO, null, iOException);
            }
            finally {
                if (Boolean.getBoolean("netbeans.profile.memory")) {
                    xMLReader.setContentHandler(XMLDataObject.NullHandler.INSTANCE);
                    xMLReader.setErrorHandler(XMLDataObject.NullHandler.INSTANCE);
                    try {
                        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", XMLDataObject.NullHandler.INSTANCE);
                    }
                    catch (SAXException sAXException) {}
                    try {
                        xMLReader.parse((InputSource)null);
                    }
                    catch (Exception exception) {}
                }
                xMLReader = null;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            XMLDataObject.ERR.log(Level.WARNING, null, iOException);
        }
        // MONITOREXIT : xMLDataObjectInfoParser
        if (string != null && string.equals(string3)) {
            if (!XMLDataObject.ERR.isLoggable(Level.FINE)) return string3;
            XMLDataObject.ERR.fine("No update to ID: " + string + " for " + xMLDataObject);
            return string3;
        }
        if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
            XMLDataObject.ERR.fine("New id: " + string3 + " for " + xMLDataObject);
        }
        if (string3 == null) return string3;
        this.updateLookup(xMLDataObject, string2, string3);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup updateLookup(XMLDataObject xMLDataObject, String string, String string2) {
        if (xMLDataObject == null) {
            return this.lookup;
        }
        XMLDataObjectInfoParser xMLDataObjectInfoParser = this;
        synchronized (xMLDataObjectInfoParser) {
            if (string != null && string.equals(string2) && this.lookup != null) {
                XMLDataObject.ERR.fine("No need to update lookup: " + string2 + " for " + xMLDataObject);
                return this.lookup;
            }
        }
        XMLDataObject.Info info = XMLDataObject.getRegisteredInfo(string2);
        if (info != null) {
            xMLDataObjectInfoParser = XMLDataObject.createInfoLookup(xMLDataObject, info);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Lookup from info: " + xMLDataObjectInfoParser + " for " + xMLDataObject);
            }
        } else {
            xMLDataObjectInfoParser = Environment.findForOne(xMLDataObject);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Lookup from env: " + xMLDataObjectInfoParser + " for " + xMLDataObject);
            }
            if (xMLDataObjectInfoParser == null) {
                xMLDataObjectInfoParser = Lookup.EMPTY;
            }
        }
        XMLDataObjectInfoParser xMLDataObjectInfoParser2 = this;
        synchronized (xMLDataObjectInfoParser2) {
            Lookup.Result result = this.result;
            this.lookup = xMLDataObjectInfoParser;
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Shared lookup updated: " + this.lookup + " for " + xMLDataObject);
            }
            this.result = this.lookup.lookupResult(Node.Cookie.class);
            this.result.addLookupListener((LookupListener)this);
            if (result != null) {
                result.removeLookupListener((LookupListener)this);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Firing property change for " + xMLDataObject);
                }
                xMLDataObject.firePropertyChange("cookie", null, null);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Firing done for " + xMLDataObject);
                }
            }
            return xMLDataObjectInfoParser;
        }
    }

    private void configureParser(XMLReader xMLReader, boolean bl, LexicalHandler lexicalHandler) {
        try {
            xMLReader.setFeature("http://xml.org/sax/features/validation", bl);
        }
        catch (SAXException sAXException) {
            XMLDataObject.ERR.fine("Warning: XML parser does not support validation feature.");
        }
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        }
        catch (SAXException sAXException) {
            XMLDataObject.ERR.fine("Warning: XML parser does not support lexical-handler feature.");
        }
    }

    public void warning(Throwable throwable) {
        this.warning(throwable, null);
    }

    public void warning(Throwable throwable, String string) {
        XMLDataObject.ERR.log(Level.INFO, string, throwable);
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.parsedId = string2 == null ? NULL : string2;
        XMLDataObject.ERR.fine("Parsed to " + this.parsedId);
        this.stop();
    }

    @Override
    public void endDTD() throws SAXException {
        this.stop();
    }

    @Override
    public void startEntity(String string) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startEntity {0}", string);
    }

    @Override
    public void endEntity(String string) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endEntity {0}", string);
    }

    @Override
    public void startCDATA() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startCDATA");
    }

    @Override
    public void endCDATA() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endCDATA");
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "comment len: {0}", n2);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.stop();
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.stop();
    }

    @Override
    public void endDocument() throws SAXException {
        this.stop();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stop();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "characters len: {0}", n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endElement: {0}", string3);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endPrefix: {0}", string);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "ignorableWhitespace: {0}", n2);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "notationDecl: {0}", string);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "processingInstruction: {0}", string);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "resolveEntity: {0}", string);
        return super.resolveEntity(string, string2);
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "skippedEntity: {0}", string);
    }

    @Override
    public void startDocument() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startDocument");
    }

    @Override
    public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startElement: {0}", string3);
        this.stop();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startPrefixMapping: {0}", string);
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "unparsedEntityDecl: {0}", string);
    }

    private void stop() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "stop");
        throw STOP;
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    private void fileCreated(FileObject fileObject) {
    }

    public void fileChanged(FileEvent fileEvent) {
        XMLDataObject xMLDataObject = this.getXml();
        if (xMLDataObject == null) {
            return;
        }
        if (xMLDataObject.getPrimaryFile().equals(fileEvent.getFile())) {
            xMLDataObject.clearDocument();
            String string = this.parsedId;
            this.parsedId = null;
            XMLDataObject.ERR.fine("cleared parsedId");
            this.waitFinished(string);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void resultChanged(LookupEvent lookupEvent) {
        XMLDataObject xMLDataObject = this.getXml();
        if (xMLDataObject == null) {
            return;
        }
        xMLDataObject.firePropertyChange("cookie", null, null);
        Node node = xMLDataObject.getNodeDelegateOrNull();
        if (node instanceof XMLDataObject.XMLNode) {
            ((XMLDataObject.XMLNode)node).update();
        }
    }

    private XMLDataObject getXml() {
        return this.xml.get();
    }

    static {
        try {
            sharedParserImpl = XMLUtil.createXMLReader();
            sharedParserImpl.setEntityResolver(new EmptyEntityResolver());
        }
        catch (SAXException sAXException) {
            Exceptions.attachLocalizedMessage((Throwable)sAXException, (String)"System does not contain JAXP 1.1 compliant parser!");
            Logger.getLogger(XMLDataObject.class.getName()).log(Level.WARNING, null, sAXException);
        }
        try {
            Properties properties = System.getProperties();
            if (properties.getProperty("org.xml.sax.driver") == null) {
                properties.put("org.xml.sax.driver", sharedParserImpl.getClass().getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        EmptyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = new InputSource(new StringReader(XMLDataObjectInfoParser.NULL));
            inputSource.setSystemId("StringReader");
            return inputSource;
        }
    }

    private static class StopSaxException
    extends SAXException {
        public StopSaxException() {
            super("STOP");
        }
    }
}

