/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.avg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalAvg
extends InternalNumericMetricsAggregation.SingleValue
implements Avg {
    private final double sum;
    private final long count;

    public InternalAvg(String name, double sum, long count, DocValueFormat format, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.sum = sum;
        this.count = count;
        this.format = format;
    }

    public InternalAvg(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.sum = in.readDouble();
        this.count = in.readVLong();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.sum);
        out.writeVLong(this.count);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.sum / (double)this.count;
    }

    @Override
    public String getWriteableName() {
        return "avg";
    }

    @Override
    public InternalAvg doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long count = 0L;
        double sum = 0.0;
        for (InternalAggregation aggregation : aggregations) {
            count += ((InternalAvg)aggregation).count;
            sum += ((InternalAvg)aggregation).sum;
        }
        return new InternalAvg(this.getName(), sum, count, this.format, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("value", this.count != 0L ? Double.valueOf(this.getValue()) : null);
        if (this.count != 0L && this.format != DocValueFormat.RAW) {
            builder.field("value_as_string", this.format.format(this.getValue()));
        }
        return builder;
    }
}

