

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Remove unreliable points with high hdop or vdop (discard){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Remove unreliable points with high hdop or vdop (discard)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_position.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_reverse.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_discard"></a>Remove unreliable points with high hdop or vdop (discard)</h2></div></div></div><p>
This filter is used to "fix" unreliable GPS data by discarding points
that are believed to be unreliable.  You may specify an 
HDOP and/or VDOP above a specified limit, a minimum number of satellites
that must have been in view for a fix to be considered, or both.
</p><p>
HDOP and VDOP are measures of the best possible horizontal or vertical precision for a given configuration of GPS satellites.   Higher numbers indicate a higher dilution of precision and therefore mathematically less useful.
</p><p>
</p><div class="example"><a id="example_discard_filter"></a><p class="title"><strong>Example 4.19. Using the discard filter for HDOP and VDOP. </strong></p><div class="example-contents"><p><strong class="userinput"><code> gpsbabel -i gpx -f in.gpx -x discard,hdop=10,vdop=20,hdopandvdop -o gpx -F out.gpx</code></strong></p></div></div><p><br class="example-break" />
</p><p>
You may specify a minimum number of  satellites.  
</p><p>
</p><div class="example"><a id="example_discard_filter_sats"></a><p class="title"><strong>Example 4.20. Using the discard filter to require at least three satellites. </strong></p><div class="example-contents"><p><strong class="userinput"><code> gpsbabel -i gpx -f in.gpx -x discard,sat=3 -o gpx -F out.gpx</code></strong></p></div></div><p><br class="example-break" />
</p><p> Contributed by Tobias Minich and Serge Droz. </p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_hdop"></a>hdop option</h3></div></div></div><p>
      Suppress points with higher hdop.
    </p><p>
This option specifies the maximum allowable Horizontal Dilution of 
Precision (HDOP).  By default, any point with an HDOP in excess of 
this value will be discarded regardless of its VDOP, but see 
<code class="option">hdopandvdop</code>.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_vdop"></a>vdop option</h3></div></div></div><p>
      Suppress points with higher vdop.
    </p><p>
This option specifies the maximum allowable Vertical Dilution of 
Precision (VDOP).  By default, any point with an VDOP in excess of 
this value will be discarded regardless of its HDOP, but see 
<code class="option">hdopandvdop</code>.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_hdopandvdop"></a>hdopandvdop option</h3></div></div></div><p>
      Link hdop and vdop supression with AND.
    </p><p>
If this option is used, only points that exceed both the maximum 
allowable HDOP and the maximum allowable VDOP will be discarded.  This
option requires that both the <code class="option">hdop</code> and 
<code class="option">vdop</code> options be specified.  
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_sat"></a>sat option</h3></div></div></div><p>
      Minimium sats to keep points.
    </p><p>
This option specifies the minimum required number of satellites.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_fixnone"></a>fixnone option</h3></div></div></div><p>
      Suppress points without fix.
    </p><p>
  This option is similar to the 'sat' option.   There are times when
  some GPSes will know how many satellites are in view, but not yet computed
  a valid fix.  This option allows you to discard those points.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_fixunknown"></a>fixunknown option</h3></div></div></div><p>
      Suppress points with unknown fix.
    </p><p>
  This option is similar to the 'sat' option. Some GPSes will log
  points with a fix value of 'unknown'.
  This option allows you to discard those points.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_elemin"></a>elemin option</h3></div></div></div><p>
      Suppress points below given elevation in meters.
    </p><p>
This option drops waypoints with an altitude lower than the specified 
value (in meters).   Although GPS altitude isn't very accurate, 
GPS devices may log faulty waypoints from time to time, such as when 
near tall buildings.  Elevation values that are way off may signify such waypoints.  Use this option to the filter to toss known rogue points.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_elemax"></a>elemax option</h3></div></div></div><p>
      Suppress points above given elevation in meters.
    </p><p>
This option drops waypoints with an altitude higher than the specified value (in meters).   See elemin for an explanation why this may be useful.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_matchname"></a>matchname option</h3></div></div></div><p>
      Suppress points where name matches given name.
    </p><p>
This option discards points that have shortnames that match the 
provided regular expresision.
</p><div class="example"><a id="discarding_points_with_names"></a><p class="title"><strong>Example 4.21. Discarding specific point by regular expression</strong></p><div class="example-contents"><p>
For example geocaches typically have names starting with GC followed
by an alphanumeric sequence of variable length.  To remove all six character
long IDs that between (and including) GC1000 and GC2FFF, you could use
</p><p><strong class="userinput"><code>
gpsbabel -i geo -f geocaching.loc -x discard,matchname=GC[1-2]...
</code></strong>
to discard all GCs followed by exactly three characters.
</p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_matchdesc"></a>matchdesc option</h3></div></div></div><p>
      Suppress points where description matches given name.
    </p><p>
Like <code class="option">matchname</code>, but instead matches on the description.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_matchcmt"></a>matchcmt option</h3></div></div></div><p>
      Suppress points where comment matches given name.
    </p><p>
Like <code class="option">matchname</code>, but instead matches on the comment.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_discard_o_matchicon"></a>matchicon option</h3></div></div></div><p>
      Suppress points where type matches given name.
    </p><p>
Like <code class="option">matchname</code>, but instead matches on the icon description.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_position.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_reverse.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Remove Points Within Distance (position) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Reverse stops within routes (reverse)</td></tr></table></div>
  
      {/literal}{/block}
  