/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.ClassFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProviderFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;

public class ClassFileViewProviderFactory
implements FileViewProviderFactory {
    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, Language language, @NotNull PsiManager manager, boolean eventSystemEnabled) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
        }
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file2);
        if (decompiler instanceof ClassFileDecompilers.Full) {
            FileViewProvider fileViewProvider = ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file2, manager, eventSystemEnabled);
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
            }
            return fileViewProvider;
        }
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(manager, file2, eventSystemEnabled);
        if (classFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
        }
        return classFileViewProvider;
    }
}

