/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jline.console.history;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jetbrains.kotlin.jline.console.history.History;
import org.jetbrains.kotlin.jline.internal.Preconditions;

public class MemoryHistory
implements History {
    private final LinkedList<CharSequence> items = new LinkedList();
    private int maxSize = 500;
    private boolean ignoreDuplicates = true;
    private boolean autoTrim = false;
    private int offset = 0;
    private int index = 0;

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public boolean isAutoTrim() {
        return this.autoTrim;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public int index() {
        return this.offset + this.index;
    }

    @Override
    public CharSequence get(int index2) {
        return this.items.get(index2 - this.offset);
    }

    @Override
    public void add(CharSequence item) {
        Preconditions.checkNotNull(item);
        if (this.isAutoTrim()) {
            item = String.valueOf(item).trim();
        }
        if (this.isIgnoreDuplicates() && !this.items.isEmpty() && item.equals(this.items.getLast())) {
            return;
        }
        this.internalAdd(item);
    }

    protected void internalAdd(CharSequence item) {
        this.items.add(item);
        this.maybeResize();
    }

    private void maybeResize() {
        while (this.size() > this.getMaxSize()) {
            this.items.removeFirst();
            ++this.offset;
        }
        this.index = this.size();
    }

    @Override
    public ListIterator<History.Entry> entries(int index2) {
        return new EntriesIterator(index2 - this.offset);
    }

    public ListIterator<History.Entry> entries() {
        return this.entries(this.offset);
    }

    @Override
    public Iterator<History.Entry> iterator() {
        return this.entries();
    }

    @Override
    public boolean moveToLast() {
        int lastEntry = this.size() - 1;
        if (lastEntry >= 0 && lastEntry != this.index) {
            this.index = this.size() - 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(int index2) {
        if ((index2 -= this.offset) >= 0 && index2 < this.size()) {
            this.index = index2;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToFirst() {
        if (this.size() > 0 && this.index != 0) {
            this.index = 0;
            return true;
        }
        return false;
    }

    @Override
    public void moveToEnd() {
        this.index = this.size();
    }

    @Override
    public CharSequence current() {
        if (this.index >= this.size()) {
            return "";
        }
        return this.items.get(this.index);
    }

    @Override
    public boolean previous() {
        if (this.index <= 0) {
            return false;
        }
        --this.index;
        return true;
    }

    @Override
    public boolean next() {
        if (this.index >= this.size()) {
            return false;
        }
        ++this.index;
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (History.Entry e : this) {
            sb.append(e.toString() + "\n");
        }
        return sb.toString();
    }

    private class EntriesIterator
    implements ListIterator<History.Entry> {
        private final ListIterator<CharSequence> source;

        private EntriesIterator(int index2) {
            this.source = MemoryHistory.this.items.listIterator(index2);
        }

        @Override
        public History.Entry next() {
            if (!this.source.hasNext()) {
                throw new NoSuchElementException();
            }
            return new EntryImpl(MemoryHistory.this.offset + this.source.nextIndex(), this.source.next());
        }

        @Override
        public History.Entry previous() {
            if (!this.source.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return new EntryImpl(MemoryHistory.this.offset + this.source.previousIndex(), this.source.previous());
        }

        @Override
        public int nextIndex() {
            return MemoryHistory.this.offset + this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return MemoryHistory.this.offset + this.source.previousIndex();
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(History.Entry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(History.Entry entry) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EntryImpl
    implements History.Entry {
        private final int index;
        private final CharSequence value;

        public EntryImpl(int index2, CharSequence value) {
            this.index = index2;
            this.value = value;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public CharSequence value() {
            return this.value;
        }

        public String toString() {
            return String.format("%d: %s", this.index, this.value);
        }
    }
}

