/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public class DestructuringDeclarationTranslator
extends AbstractTranslator {
    @NotNull
    private final KtDestructuringDeclaration multiDeclaration;
    @NotNull
    private final JsName multiObjectName;
    @Nullable
    private final JsExpression initializer;

    @NotNull
    public static JsVars translate(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull JsName multiObjectName, @Nullable JsExpression initializer2, @NotNull TranslationContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator", "translate"));
        }
        if (multiObjectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiObjectName", "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator", "translate"));
        }
        JsVars jsVars = new DestructuringDeclarationTranslator(multiDeclaration, multiObjectName, initializer2, context).translate();
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator", "translate"));
        }
        return jsVars;
    }

    private DestructuringDeclarationTranslator(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull JsName multiObjectName, @Nullable JsExpression initializer2, @NotNull TranslationContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator", "<init>"));
        }
        if (multiObjectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiObjectName", "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator", "<init>"));
        }
        super(context);
        this.multiDeclaration = multiDeclaration;
        this.multiObjectName = multiObjectName;
        this.initializer = initializer2;
    }

    private JsVars translate() {
        ArrayList<JsVars.JsVar> jsVars = new ArrayList<JsVars.JsVar>();
        if (this.initializer != null) {
            jsVars.add(new JsVars.JsVar(this.multiObjectName, this.initializer));
        }
        JsNameRef multiObjNameRef = this.multiObjectName.makeRef();
        for (KtDestructuringDeclarationEntry entry : this.multiDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> entryInitCall = this.context().bindingContext().get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            assert (entryInitCall != null) : "Entry init call must be not null";
            JsExpression entryInitializer = CallTranslator.translate(this.context(), entryInitCall, multiObjNameRef);
            FunctionDescriptor candidateDescriptor = entryInitCall.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(candidateDescriptor)) {
                InlineUtils.setInlineCallMetadata(entryInitializer, entry, entryInitCall, this.context());
            }
            VariableDescriptor descriptor2 = BindingContextUtils.getNotNull(this.context().bindingContext(), BindingContext.VARIABLE, entry);
            JsName name2 = this.context().getNameForDescriptor(descriptor2);
            jsVars.add(new JsVars.JsVar(name2, entryInitializer));
        }
        return new JsVars(jsVars, true);
    }
}

