/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.notations.ModuleIdentifierNotationConverter;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.rules.DefaultRuleActionAdapter;
import org.gradle.internal.rules.DefaultRuleActionValidator;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionAdapter;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

public class DefaultComponentSelectionRules
implements ComponentSelectionRulesInternal {
    private static final String INVALID_SPEC_ERROR = "Could not add a component selection rule for module '%s'.";
    private static final NotationParser<Object, ModuleIdentifier> MODULE_IDENTIFIER_NOTATION_PARSER = NotationParserBuilder.toType(ModuleIdentifier.class).converter((NotationConverter)new ModuleIdentifierNotationConverter()).toComposite();
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private Set<SpecRuleAction<? super ComponentSelection>> rules;
    private final RuleActionAdapter<ComponentSelection> ruleActionAdapter;
    private final NotationParser<Object, ModuleIdentifier> moduleIdentifierNotationParser;

    public DefaultComponentSelectionRules() {
        this(DefaultComponentSelectionRules.createAdapter(), DefaultComponentSelectionRules.createModuleIdentifierNotationParser());
    }

    protected DefaultComponentSelectionRules(RuleActionAdapter<ComponentSelection> ruleActionAdapter, NotationParser<Object, ModuleIdentifier> moduleIdentifierNotationParser) {
        this.ruleActionAdapter = ruleActionAdapter;
        this.moduleIdentifierNotationParser = moduleIdentifierNotationParser;
    }

    public void setMutationValidator(MutationValidator mutationValidator) {
        this.mutationValidator = mutationValidator;
    }

    private static NotationParser<Object, ModuleIdentifier> createModuleIdentifierNotationParser() {
        return MODULE_IDENTIFIER_NOTATION_PARSER;
    }

    private static RuleActionAdapter<ComponentSelection> createAdapter() {
        DefaultRuleActionValidator ruleActionValidator = new DefaultRuleActionValidator(Lists.newArrayList((Object[])new Class[]{ComponentMetadata.class, IvyModuleDescriptor.class}));
        return new DefaultRuleActionAdapter<ComponentSelection>(ruleActionValidator, "ComponentSelectionRules");
    }

    @Override
    public Collection<SpecRuleAction<? super ComponentSelection>> getRules() {
        return this.rules != null ? this.rules : Collections.emptySet();
    }

    public ComponentSelectionRules all(Action<? super ComponentSelection> selectionAction) {
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromAction(selectionAction)));
    }

    public ComponentSelectionRules all(Closure<?> closure) {
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromClosure(ComponentSelection.class, closure)));
    }

    public ComponentSelectionRules all(Object ruleSource) {
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromRuleSource(ComponentSelection.class, ruleSource)));
    }

    public ComponentSelectionRules withModule(Object id, Action<? super ComponentSelection> selectionAction) {
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromAction(selectionAction)));
    }

    public ComponentSelectionRules withModule(Object id, Closure<?> closure) {
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromClosure(ComponentSelection.class, closure)));
    }

    public ComponentSelectionRules withModule(Object id, Object ruleSource) {
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromRuleSource(ComponentSelection.class, ruleSource)));
    }

    @Override
    public ComponentSelectionRules addRule(SpecRuleAction<? super ComponentSelection> specRuleAction) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        if (this.rules == null) {
            this.rules = new HashSet<SpecRuleAction<? super ComponentSelection>>();
        }
        this.rules.add(specRuleAction);
        return this;
    }

    @Override
    public ComponentSelectionRules addRule(RuleAction<? super ComponentSelection> specRuleAction) {
        return this.addRule(this.createAllSpecRulesAction(specRuleAction));
    }

    private SpecRuleAction<? super ComponentSelection> createSpecRuleActionFromId(Object id, RuleAction<? super ComponentSelection> ruleAction) {
        ModuleIdentifier moduleIdentifier;
        try {
            moduleIdentifier = (ModuleIdentifier)this.moduleIdentifierNotationParser.parseNotation(id);
        }
        catch (UnsupportedNotationException e) {
            throw new InvalidUserCodeException(String.format(INVALID_SPEC_ERROR, id == null ? "null" : id.toString()), (Throwable)e);
        }
        ComponentSelectionMatchingSpec spec = new ComponentSelectionMatchingSpec(moduleIdentifier);
        return new SpecRuleAction<ComponentSelection>(ruleAction, spec);
    }

    private SpecRuleAction<? super ComponentSelection> createAllSpecRulesAction(RuleAction<? super ComponentSelection> ruleAction) {
        return new SpecRuleAction<ComponentSelection>(ruleAction, Specs.satisfyAll());
    }

    static class ComponentSelectionMatchingSpec
    implements Spec<ComponentSelection> {
        final ModuleIdentifier target;

        private ComponentSelectionMatchingSpec(ModuleIdentifier target) {
            this.target = target;
        }

        public boolean isSatisfiedBy(ComponentSelection selection) {
            return selection.getCandidate().getGroup().equals(this.target.getGroup()) && selection.getCandidate().getModule().equals(this.target.getName());
        }
    }
}

