/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.DefaultStatusBarFormatter;
import org.gradle.internal.logging.console.Label;
import org.gradle.internal.logging.console.ProgressOperation;
import org.gradle.internal.logging.console.ProgressOperations;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.time.TimeProvider;

public class ConsoleBackedProgressRenderer
implements OutputEventListener {
    private final OutputEventListener listener;
    private final Console console;
    private final ProgressOperations operations = new ProgressOperations();
    private final DefaultStatusBarFormatter statusBarFormatter;
    private final ScheduledExecutorService executor;
    private final TimeProvider timeProvider;
    private final int throttleMs;
    private final Object lock = new Object();
    private long lastUpdate;
    private final List<OutputEvent> queue = new ArrayList<OutputEvent>();
    private ProgressOperation mostRecentOperation;
    private Label statusBar;

    public ConsoleBackedProgressRenderer(OutputEventListener listener, Console console, DefaultStatusBarFormatter statusBarFormatter, TimeProvider timeProvider) {
        this(listener, console, statusBarFormatter, Integer.getInteger("org.gradle.console.throttle", 85), Executors.newSingleThreadScheduledExecutor(), timeProvider);
    }

    ConsoleBackedProgressRenderer(OutputEventListener listener, Console console, DefaultStatusBarFormatter statusBarFormatter, int throttleMs, ScheduledExecutorService executor, TimeProvider timeProvider) {
        this.throttleMs = throttleMs;
        this.listener = listener;
        this.console = console;
        this.statusBarFormatter = statusBarFormatter;
        this.executor = executor;
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent newEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(newEvent);
            if (newEvent instanceof EndOutputEvent) {
                this.renderNow(this.timeProvider.getCurrentTime());
                this.executor.shutdown();
                return;
            }
            if (this.queue.size() > 1) {
                return;
            }
            long now = this.timeProvider.getCurrentTime();
            if (now - this.lastUpdate >= (long)this.throttleMs) {
                this.renderNow(now);
                return;
            }
            this.executor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = ConsoleBackedProgressRenderer.this.lock;
                    synchronized (object) {
                        ConsoleBackedProgressRenderer.this.renderNow(ConsoleBackedProgressRenderer.this.timeProvider.getCurrentTime());
                    }
                }
            }, (long)this.throttleMs, TimeUnit.MILLISECONDS);
        }
    }

    private void renderNow(long now) {
        if (this.queue.isEmpty()) {
            return;
        }
        ProgressOperation lastOp = this.mostRecentOperation;
        for (OutputEvent event : this.queue) {
            try {
                if (event instanceof ProgressStartEvent) {
                    ProgressStartEvent startEvent = (ProgressStartEvent)event;
                    lastOp = this.operations.start(startEvent.getShortDescription(), startEvent.getStatus(), startEvent.getOperationId(), startEvent.getParentId());
                } else if (event instanceof ProgressCompleteEvent) {
                    ProgressOperation op = this.operations.complete(((ProgressCompleteEvent)event).getOperationId());
                    lastOp = op.getParent();
                } else if (event instanceof ProgressEvent) {
                    ProgressEvent progressEvent = (ProgressEvent)event;
                    lastOp = this.operations.progress(progressEvent.getStatus(), progressEvent.getOperationId());
                }
                this.listener.onOutput(event);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to process incoming event '" + event + "' (" + event.getClass().getSimpleName() + ")", e);
            }
        }
        if (lastOp != null) {
            this.getStatusBar().setText(this.statusBarFormatter.format(lastOp));
        } else if (this.mostRecentOperation != null) {
            this.getStatusBar().setText("");
        }
        this.mostRecentOperation = lastOp;
        this.queue.clear();
        this.lastUpdate = now;
        this.console.flush();
    }

    private Label getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = this.console.getStatusBar();
        }
        return this.statusBar;
    }
}

