/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskExecutionSnapshot;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.TaskHistoryStore;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.AsyncCacheAccessContext;
import org.gradle.internal.Cast;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private static final int MAX_HISTORY_ENTRIES = 3;
    private final FileSnapshotRepository snapshotRepository;
    private final PersistentIndexedCache<String, ImmutableList<TaskExecutionSnapshot>> taskHistoryCache;
    private final TaskExecutionListSerializer serializer;
    private final StringInterner stringInterner;

    public CacheBackedTaskHistoryRepository(TaskHistoryStore cacheAccess, FileSnapshotRepository snapshotRepository, StringInterner stringInterner) {
        this.snapshotRepository = snapshotRepository;
        this.stringInterner = stringInterner;
        this.serializer = new TaskExecutionListSerializer(stringInterner);
        this.taskHistoryCache = cacheAccess.createCache("taskHistory", String.class, this.serializer, 2000, false);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task) {
        final TaskExecutionList previousExecutions = this.loadPreviousExecutions(task);
        final LazyTaskExecution currentExecution = new LazyTaskExecution();
        currentExecution.snapshotRepository = this.snapshotRepository;
        currentExecution.setOutputPropertyNamesForCacheKey(this.getOutputPropertyNamesForCacheKey(task));
        currentExecution.setDeclaredOutputFilePaths(this.getDeclaredOutputFilePaths(task));
        final LazyTaskExecution previousExecution = this.findBestMatchingPreviousExecution(currentExecution, previousExecutions.executions);
        if (previousExecution != null) {
            previousExecution.snapshotRepository = this.snapshotRepository;
        }
        return new TaskHistoryRepository.History(){

            public TaskExecution getPreviousExecution() {
                return previousExecution;
            }

            public TaskExecution getCurrentExecution() {
                return currentExecution;
            }

            public void update() {
                ImmutableSortedMap.Builder builder;
                previousExecutions.executions.addFirst(currentExecution);
                if (currentExecution.inputFilesSnapshotIds == null && currentExecution.inputFilesSnapshot != null) {
                    builder = ImmutableSortedMap.naturalOrder();
                    for (Map.Entry entry : currentExecution.inputFilesSnapshot.entrySet()) {
                        builder.put(entry.getKey(), (Object)CacheBackedTaskHistoryRepository.this.snapshotRepository.add((FileCollectionSnapshot)entry.getValue()));
                    }
                    currentExecution.inputFilesSnapshotIds = builder.build();
                }
                if (currentExecution.outputFilesSnapshotIds == null && currentExecution.outputFilesSnapshot != null) {
                    builder = ImmutableSortedMap.naturalOrder();
                    for (Map.Entry entry : currentExecution.outputFilesSnapshot.entrySet()) {
                        builder.put(entry.getKey(), (Object)CacheBackedTaskHistoryRepository.this.snapshotRepository.add((FileCollectionSnapshot)entry.getValue()));
                    }
                    currentExecution.outputFilesSnapshotIds = builder.build();
                }
                if (currentExecution.discoveredFilesSnapshotId == null && currentExecution.discoveredFilesSnapshot != null) {
                    currentExecution.discoveredFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.discoveredFilesSnapshot);
                }
                while (previousExecutions.executions.size() > 3) {
                    LazyTaskExecution execution = (LazyTaskExecution)previousExecutions.executions.removeLast();
                    if (execution.inputFilesSnapshotIds != null) {
                        for (Long id : execution.inputFilesSnapshotIds.values()) {
                            CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(id);
                        }
                    }
                    if (execution.outputFilesSnapshotIds != null) {
                        for (Long id : execution.outputFilesSnapshotIds.values()) {
                            CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(id);
                        }
                    }
                    if (execution.discoveredFilesSnapshotId == null) continue;
                    CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.discoveredFilesSnapshotId);
                }
                CacheBackedTaskHistoryRepository.this.taskHistoryCache.put(task.getPath(), previousExecutions.snapshot());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskExecutionList loadPreviousExecutions(TaskInternal task) {
        boolean contextCreated = AsyncCacheAccessContext.createWhenMissing();
        ClassLoader projectClassLoader = ((ProjectInternal)Cast.cast(ProjectInternal.class, (Object)task.getProject())).getClassLoaderScope().getLocalClassLoader();
        try {
            this.serializer.setClassLoader(projectClassLoader);
            List history = (List)this.taskHistoryCache.get(task.getPath());
            TaskExecutionList result = new TaskExecutionList();
            if (history != null) {
                for (TaskExecutionSnapshot taskExecutionSnapshot : history) {
                    result.executions.add(new LazyTaskExecution(taskExecutionSnapshot));
                }
            }
            TaskExecutionList taskExecutionList = result;
            return taskExecutionList;
        }
        finally {
            this.serializer.setClassLoader(null);
            if (contextCreated) {
                AsyncCacheAccessContext.remove();
            }
        }
    }

    private Iterable<String> getOutputPropertyNamesForCacheKey(TaskInternal task) {
        Iterable outputPropertiesForCacheKey = Iterables.filter(task.getOutputs().getFileProperties(), (Predicate)new Predicate<TaskOutputFilePropertySpec>(){

            public boolean apply(TaskOutputFilePropertySpec propertySpec) {
                if (propertySpec instanceof CacheableTaskOutputFilePropertySpec) {
                    CacheableTaskOutputFilePropertySpec cacheablePropertySpec = (CacheableTaskOutputFilePropertySpec)propertySpec;
                    return cacheablePropertySpec.getOutputFile() != null;
                }
                return false;
            }
        });
        return Iterables.transform((Iterable)outputPropertiesForCacheKey, (Function)new Function<TaskOutputFilePropertySpec, String>(){

            public String apply(TaskOutputFilePropertySpec propertySpec) {
                return propertySpec.getPropertyName();
            }
        });
    }

    private ImmutableSet<String> getDeclaredOutputFilePaths(TaskInternal task) {
        ImmutableSet.Builder declaredOutputFilePaths = ImmutableSet.builder();
        for (File file : task.getOutputs().getFiles()) {
            declaredOutputFilePaths.add((Object)this.stringInterner.intern(file.getAbsolutePath()));
        }
        return declaredOutputFilePaths.build();
    }

    private LazyTaskExecution findBestMatchingPreviousExecution(TaskExecution currentExecution, Collection<LazyTaskExecution> previousExecutions) {
        ImmutableSet<String> declaredOutputFilePaths = currentExecution.getDeclaredOutputFilePaths();
        LazyTaskExecution bestMatch = null;
        int bestMatchOverlap = 0;
        for (LazyTaskExecution previousExecution : previousExecutions) {
            ImmutableSet<String> previousDeclaredOutputFilePaths = previousExecution.getDeclaredOutputFilePaths();
            if (declaredOutputFilePaths.isEmpty() && previousDeclaredOutputFilePaths.isEmpty()) {
                bestMatch = previousExecution;
                break;
            }
            Sets.SetView intersection = Sets.intersection(declaredOutputFilePaths, previousDeclaredOutputFilePaths);
            int overlap = intersection.size();
            if (overlap > bestMatchOverlap) {
                bestMatch = previousExecution;
                bestMatchOverlap = overlap;
            }
            if (bestMatchOverlap != declaredOutputFilePaths.size()) continue;
            break;
        }
        return bestMatch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyTaskExecution
    extends TaskExecution {
        private ImmutableSortedMap<String, Long> inputFilesSnapshotIds;
        private ImmutableSortedMap<String, Long> outputFilesSnapshotIds;
        private Long discoveredFilesSnapshotId;
        private FileSnapshotRepository snapshotRepository;
        private Map<String, FileCollectionSnapshot> inputFilesSnapshot;
        private Map<String, FileCollectionSnapshot> outputFilesSnapshot;
        private FileCollectionSnapshot discoveredFilesSnapshot;

        LazyTaskExecution(TaskExecutionSnapshot taskExecutionSnapshot) {
            this.setTaskClass(taskExecutionSnapshot.getTaskClass());
            this.setTaskClassLoaderHash(taskExecutionSnapshot.getTaskClassLoaderHash());
            this.setTaskActionsClassLoaderHash(taskExecutionSnapshot.getTaskActionsClassLoaderHash());
            this.setInputProperties(new HashMap<String, Object>(taskExecutionSnapshot.getInputProperties()));
            this.setOutputPropertyNamesForCacheKey((Iterable<String>)taskExecutionSnapshot.getCacheableOutputProperties());
            this.setDeclaredOutputFilePaths(taskExecutionSnapshot.getDeclaredOutputFilePaths());
            this.inputFilesSnapshotIds = taskExecutionSnapshot.getInputFilesSnapshotIds();
            this.outputFilesSnapshotIds = taskExecutionSnapshot.getOutputFilesSnapshotIds();
            this.discoveredFilesSnapshotId = taskExecutionSnapshot.getDiscoveredFilesSnapshotId();
        }

        LazyTaskExecution() {
        }

        @Override
        public Map<String, FileCollectionSnapshot> getInputFilesSnapshot() {
            if (this.inputFilesSnapshot == null) {
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (Map.Entry entry : this.inputFilesSnapshotIds.entrySet()) {
                    builder.put(entry.getKey(), (Object)this.snapshotRepository.get((Long)entry.getValue()));
                }
                this.inputFilesSnapshot = builder.build();
            }
            return this.inputFilesSnapshot;
        }

        @Override
        public void setInputFilesSnapshot(Map<String, FileCollectionSnapshot> inputFilesSnapshot) {
            this.inputFilesSnapshot = inputFilesSnapshot;
            this.inputFilesSnapshotIds = null;
        }

        @Override
        public FileCollectionSnapshot getDiscoveredInputFilesSnapshot() {
            if (this.discoveredFilesSnapshot == null) {
                this.discoveredFilesSnapshot = this.snapshotRepository.get(this.discoveredFilesSnapshotId);
            }
            return this.discoveredFilesSnapshot;
        }

        @Override
        public void setDiscoveredInputFilesSnapshot(FileCollectionSnapshot discoveredFilesSnapshot) {
            this.discoveredFilesSnapshot = discoveredFilesSnapshot;
            this.discoveredFilesSnapshotId = null;
        }

        @Override
        public Map<String, FileCollectionSnapshot> getOutputFilesSnapshot() {
            if (this.outputFilesSnapshot == null) {
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (Map.Entry entry : this.outputFilesSnapshotIds.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    builder.put((Object)propertyName, (Object)this.snapshotRepository.get((Long)entry.getValue()));
                }
                this.outputFilesSnapshot = builder.build();
            }
            return this.outputFilesSnapshot;
        }

        @Override
        public void setOutputFilesSnapshot(Map<String, FileCollectionSnapshot> outputFilesSnapshot) {
            this.outputFilesSnapshot = outputFilesSnapshot;
            this.outputFilesSnapshotIds = null;
        }

        public TaskExecutionSnapshot snapshot() {
            return new TaskExecutionSnapshot(this.getTaskClass(), this.getOutputPropertyNamesForCacheKey(), this.getDeclaredOutputFilePaths(), this.getTaskClassLoaderHash(), this.getTaskActionsClassLoaderHash(), new HashMap<String, Object>(this.getInputProperties()), this.inputFilesSnapshotIds, this.discoveredFilesSnapshotId, this.outputFilesSnapshotIds);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TaskExecutionSnapshotSerializer
        implements Serializer<TaskExecutionSnapshot> {
            private final InputPropertiesSerializer inputPropertiesSerializer;
            private final StringInterner stringInterner;

            TaskExecutionSnapshotSerializer(ClassLoader classLoader, StringInterner stringInterner) {
                this.inputPropertiesSerializer = new InputPropertiesSerializer(classLoader);
                this.stringInterner = stringInterner;
            }

            public TaskExecutionSnapshot read(Decoder decoder) throws Exception {
                ImmutableSortedMap<String, Long> inputFilesSnapshotIds = TaskExecutionSnapshotSerializer.readSnapshotIds(decoder);
                ImmutableSortedMap<String, Long> outputFilesSnapshotIds = TaskExecutionSnapshotSerializer.readSnapshotIds(decoder);
                Long discoveredFilesSnapshotId = decoder.readLong();
                String taskClass = decoder.readString();
                HashCode taskClassLoaderHash = null;
                if (decoder.readBoolean()) {
                    taskClassLoaderHash = HashCode.fromBytes((byte[])decoder.readBinary());
                }
                HashCode taskActionsClassLoaderHash = null;
                if (decoder.readBoolean()) {
                    taskActionsClassLoaderHash = HashCode.fromBytes((byte[])decoder.readBinary());
                }
                int cacheableOutputPropertiesCount = decoder.readSmallInt();
                ImmutableSet.Builder cacheableOutputPropertiesBuilder = ImmutableSet.builder();
                for (int j = 0; j < cacheableOutputPropertiesCount; ++j) {
                    cacheableOutputPropertiesBuilder.add((Object)decoder.readString());
                }
                ImmutableSet cacheableOutputProperties = cacheableOutputPropertiesBuilder.build();
                int outputFilesCount = decoder.readSmallInt();
                ImmutableSet.Builder declaredOutputFilePathsBuilder = ImmutableSet.builder();
                for (int j = 0; j < outputFilesCount; ++j) {
                    declaredOutputFilePathsBuilder.add((Object)this.stringInterner.intern(decoder.readString()));
                }
                ImmutableSet declaredOutputFilePaths = declaredOutputFilePathsBuilder.build();
                boolean hasInputProperties = decoder.readBoolean();
                Object inputProperties = hasInputProperties ? this.inputPropertiesSerializer.read(decoder) : ImmutableMap.of();
                return new TaskExecutionSnapshot(taskClass, (ImmutableSet<String>)cacheableOutputProperties, (ImmutableSet<String>)declaredOutputFilePaths, taskClassLoaderHash, taskActionsClassLoaderHash, (Map<String, Object>)inputProperties, inputFilesSnapshotIds, discoveredFilesSnapshotId, outputFilesSnapshotIds);
            }

            public void write(Encoder encoder, TaskExecutionSnapshot execution) throws Exception {
                TaskExecutionSnapshotSerializer.writeSnapshotIds(encoder, execution.getInputFilesSnapshotIds());
                TaskExecutionSnapshotSerializer.writeSnapshotIds(encoder, execution.getOutputFilesSnapshotIds());
                encoder.writeLong(execution.getDiscoveredFilesSnapshotId().longValue());
                encoder.writeString((CharSequence)execution.getTaskClass());
                HashCode classLoaderHash = execution.getTaskClassLoaderHash();
                if (classLoaderHash == null) {
                    encoder.writeBoolean(false);
                } else {
                    encoder.writeBoolean(true);
                    encoder.writeBinary(classLoaderHash.asBytes());
                }
                HashCode actionsClassLoaderHash = execution.getTaskActionsClassLoaderHash();
                if (actionsClassLoaderHash == null) {
                    encoder.writeBoolean(false);
                } else {
                    encoder.writeBoolean(true);
                    encoder.writeBinary(actionsClassLoaderHash.asBytes());
                }
                encoder.writeSmallInt(execution.getCacheableOutputProperties().size());
                for (String outputFile : execution.getCacheableOutputProperties()) {
                    encoder.writeString((CharSequence)outputFile);
                }
                encoder.writeSmallInt(execution.getDeclaredOutputFilePaths().size());
                for (String outputFile : execution.getDeclaredOutputFilePaths()) {
                    encoder.writeString((CharSequence)outputFile);
                }
                if (execution.getInputProperties() == null || execution.getInputProperties().isEmpty()) {
                    encoder.writeBoolean(false);
                } else {
                    encoder.writeBoolean(true);
                    this.inputPropertiesSerializer.write(encoder, execution.getInputProperties());
                }
            }

            private static ImmutableSortedMap<String, Long> readSnapshotIds(Decoder decoder) throws IOException {
                int count = decoder.readSmallInt();
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (int snapshotIdx = 0; snapshotIdx < count; ++snapshotIdx) {
                    String property = decoder.readString();
                    long id = decoder.readLong();
                    builder.put((Object)property, (Object)id);
                }
                return builder.build();
            }

            private static void writeSnapshotIds(Encoder encoder, Map<String, Long> ids) throws IOException {
                encoder.writeSmallInt(ids.size());
                for (Map.Entry<String, Long> entry : ids.entrySet()) {
                    encoder.writeString((CharSequence)entry.getKey());
                    encoder.writeLong(entry.getValue().longValue());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskExecutionList {
        private final Deque<LazyTaskExecution> executions = new ArrayDeque<LazyTaskExecution>();

        private TaskExecutionList() {
        }

        public String toString() {
            return super.toString() + "[" + this.executions.size() + "]";
        }

        public ImmutableList<TaskExecutionSnapshot> snapshot() {
            ArrayList<TaskExecutionSnapshot> snapshots = new ArrayList<TaskExecutionSnapshot>(this.executions.size());
            for (LazyTaskExecution execution : this.executions) {
                snapshots.add(execution.snapshot());
            }
            return ImmutableList.copyOf(snapshots);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskExecutionListSerializer
    extends AbstractSerializer<ImmutableList<TaskExecutionSnapshot>> {
        private static final String CONTEXT_KEY_FOR_CLASSLOADER = AsyncCacheAccessContext.createKey(TaskExecutionListSerializer.class, "classLoader");
        private final StringInterner stringInterner;

        TaskExecutionListSerializer(StringInterner stringInterner) {
            this.stringInterner = stringInterner;
        }

        public ImmutableList<TaskExecutionSnapshot> read(Decoder decoder) throws Exception {
            int count = decoder.readByte();
            ArrayList<TaskExecutionSnapshot> executions = new ArrayList<TaskExecutionSnapshot>(count);
            LazyTaskExecution.TaskExecutionSnapshotSerializer executionSerializer = new LazyTaskExecution.TaskExecutionSnapshotSerializer(this.getClassLoader(), this.stringInterner);
            for (int i = 0; i < count; ++i) {
                TaskExecutionSnapshot exec = executionSerializer.read(decoder);
                executions.add(exec);
            }
            return ImmutableList.copyOf(executions);
        }

        public void write(Encoder encoder, ImmutableList<TaskExecutionSnapshot> value) throws Exception {
            int size = value.size();
            encoder.writeByte((byte)size);
            LazyTaskExecution.TaskExecutionSnapshotSerializer executionSerializer = new LazyTaskExecution.TaskExecutionSnapshotSerializer(this.getClassLoader(), this.stringInterner);
            for (TaskExecutionSnapshot execution : value) {
                executionSerializer.write(encoder, execution);
            }
        }

        public ClassLoader getClassLoader() {
            AsyncCacheAccessContext context = AsyncCacheAccessContext.current();
            if (context != null) {
                return context.get(CONTEXT_KEY_FOR_CLASSLOADER, ClassLoader.class);
            }
            return ((Object)((Object)this)).getClass().getClassLoader();
        }

        public void setClassLoader(ClassLoader classLoader) {
            AsyncCacheAccessContext context = AsyncCacheAccessContext.current();
            if (context != null) {
                context.put(CONTEXT_KEY_FOR_CLASSLOADER, classLoader);
            }
        }
    }
}

