/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.tasks.compile.ApiClassExtractor;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.internal.Java9ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmClassHasher {
    private static final byte[] SIGNATURE = Hashing.md5().hashString((CharSequence)JvmClassHasher.class.getName(), Charsets.UTF_8).asBytes();
    private static final HashCode MALFORMED_JAR = Hashing.md5().hashString((CharSequence)(JvmClassHasher.class.getName() + " : malformed jar"), Charsets.UTF_8);
    private final PersistentIndexedCache<HashCode, HashCode> persistentCache;

    public JvmClassHasher(PersistentIndexedCache<HashCode, HashCode> persistentCache) {
        this.persistentCache = persistentCache;
    }

    @Nullable
    public HashCode hashClassFile(FileDetails fileDetails) {
        byte[] src;
        HashCode signature = this.persistentCache.get(fileDetails.getContent().getContentMd5());
        if (signature != null) {
            return signature;
        }
        File file = new File(fileDetails.getPath());
        Hasher hasher = this.createHasher();
        try {
            src = Files.toByteArray((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        try {
            if (!this.hashClassBytes(hasher, src)) {
                return null;
            }
            signature = hasher.hash();
        }
        catch (Exception e) {
            signature = hasher.putBytes(src).hash();
            DeprecationLogger.nagUserWith((String)("Malformed class file [" + file.getName() + "] found on compile classpath, which means that this class will cause a compile error if referenced in a source file. Gradle 5.0 will no longer allow malformed classes on compile classpath."));
        }
        this.persistentCache.put(fileDetails.getContent().getContentMd5(), signature);
        return signature;
    }

    private boolean hashClassBytes(Hasher hasher, byte[] classBytes) {
        Java9ClassReader reader;
        ApiClassExtractor extractor = new ApiClassExtractor(Collections.<String>emptySet());
        if (!extractor.shouldExtractApiClassFrom(reader = new Java9ClassReader(classBytes))) {
            return false;
        }
        byte[] signature = extractor.extractApiClassFrom(reader);
        if (signature == null) {
            return false;
        }
        hasher.putBytes(signature);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashCode hashJarFile(FileDetails fileDetails) {
        HashCode signature = this.persistentCache.get(fileDetails.getContent().getContentMd5());
        if (signature != null) {
            return signature;
        }
        File file = new File(fileDetails.getPath());
        Hasher hasher = this.createHasher();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            TreeMap<String, ZipEntry> entriesByName = new TreeMap<String, ZipEntry>();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class")) continue;
                entriesByName.put(zipEntry.getName(), zipEntry);
            }
            for (ZipEntry zipEntry : entriesByName.values()) {
                this.visit(zipFile, zipEntry, hasher);
            }
        }
        catch (Exception e) {
            try {
                signature = MALFORMED_JAR;
                DeprecationLogger.nagUserWith((String)("Malformed jar [" + file.getName() + "] found on compile classpath. Gradle 5.0 will no longer allow malformed jars on compile classpath."));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)zipFile);
        }
        IOUtils.closeQuietly((Closeable)zipFile);
        signature = signature != null ? signature : hasher.hash();
        this.persistentCache.put(fileDetails.getContent().getContentMd5(), signature);
        return signature;
    }

    private Hasher createHasher() {
        Hasher hasher = Hashing.md5().newHasher();
        hasher.putBytes(SIGNATURE);
        return hasher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visit(ZipFile zipFile, ZipEntry zipEntry, Hasher hasher) {
        InputStream inputStream = null;
        byte[] src = new byte[]{};
        try {
            inputStream = zipFile.getInputStream(zipEntry);
            try {
                src = ByteStreams.toByteArray((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
            this.hashClassBytes(hasher, src);
        }
        catch (Exception e) {
            hasher.putBytes(src);
            DeprecationLogger.nagUserWith((String)("Malformed class file [" + zipEntry.getName() + "] in jar [" + zipFile.getName() + "] found on classpath, which means that this class will cause a compile error if referenced in a source file. Gradle 5.0 will no longer allow malformed classes on compile classpath."));
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

