/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Group;
import org.jmol.modelset.TickInfo;
import org.jmol.script.ContextToken;
import org.jmol.script.FileLoadThread;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptDelayThread;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptExpr;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptInterruption;
import org.jmol.script.ScriptManager;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.T;
import org.jmol.thread.JmolThread;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Txt;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class ScriptEval
extends ScriptExpr {
    private static final String saveList = "bonds? context? coordinates? orientation? rotation? selection? state? structure?";
    private static int iProcess;
    public ShapeManager sm;
    public boolean isJS;
    private JmolThread scriptDelayThread;
    private JmolThread fileLoadThread;
    public boolean allowJSThreads = true;
    private boolean isFuncReturn;
    public boolean historyDisabled;
    private boolean debugScript;
    private boolean isCmdLine_C_Option;
    private boolean isCmdLine_c_or_C_Option;
    private boolean listCommands;
    public boolean tQuiet;
    private boolean executionStopped;
    private boolean executionPaused;
    private boolean executionStepping;
    private boolean executing;
    private long timeBeginExecution;
    private long timeEndExecution;
    private boolean mustResumeEval;
    private Thread currentThread = Thread.currentThread();
    public ScriptCompiler compiler;
    public SB outputBuffer;
    private String contextPath = "";
    public String scriptFileName;
    public String functionName;
    public boolean isStateScript;
    public int scriptLevel;
    public static int commandHistoryLevelMax;
    private static int contextDepthMax;
    private static int scriptReportingLevel;
    public T[][] aatoken;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private String script;
    private String scriptExtensions;
    protected int pc;
    public String thisCommand;
    public String fullCommand;
    private int lineEnd;
    private int pcEnd;
    private boolean forceNoAddHydrogens;
    private JmolParallelProcessor parallelProcessor;
    private int pcResume = -1;

    @Override
    public boolean getAllowJSThreads() {
        return this.allowJSThreads;
    }

    public boolean doReport() {
        return !this.tQuiet && this.scriptLevel <= scriptReportingLevel;
    }

    @Override
    public boolean isStateScript() {
        return this.isStateScript;
    }

    @Override
    public int setStatic(int tok, int ival) {
        switch (tok) {
            case 553648167: {
                if (ival >= 10) {
                    contextDepthMax = ival;
                }
                return contextDepthMax;
            }
            case 553648148: {
                if (ival >= 0) {
                    commandHistoryLevelMax = ival;
                }
                return commandHistoryLevelMax;
            }
            case 553648168: {
                if (ival >= 0) {
                    scriptReportingLevel = ival;
                }
                return scriptReportingLevel;
            }
        }
        return 0;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public ScriptEval setViewer(Viewer vwr) {
        this.vwr = vwr;
        this.compiler = this.compiler == null ? (ScriptCompiler)vwr.compiler : this.compiler;
        this.isJS = vwr.isSingleThreaded;
        return this;
    }

    @Override
    public void setCompiler() {
        this.compiler = new ScriptCompiler(this.vwr);
        this.vwr.compiler = this.compiler;
    }

    @Override
    public boolean compileScriptString(String script, boolean tQuiet) {
        this.clearState(tQuiet);
        this.contextPath = "[script]";
        return this.compileScript(null, script, this.debugScript);
    }

    @Override
    public boolean compileScriptFile(String filename, boolean tQuiet) {
        this.clearState(tQuiet);
        this.contextPath = filename;
        return this.compileScriptFileInternal(filename, null, null, null);
    }

    @Override
    public void evaluateCompiledScript(boolean isCmdLine_c_or_C_Option, boolean isCmdLine_C_Option, boolean historyDisabled, boolean listCommands, SB outputBuffer, boolean allowThreads) {
        boolean tempOpen = this.isCmdLine_C_Option;
        this.isCmdLine_C_Option = isCmdLine_C_Option;
        this.chk = this.isCmdLine_c_or_C_Option = isCmdLine_c_or_C_Option;
        this.historyDisabled = historyDisabled;
        this.outputBuffer = outputBuffer;
        this.currentThread = Thread.currentThread();
        this.allowJSThreads = allowThreads;
        this.listCommands = listCommands;
        this.timeBeginExecution = System.currentTimeMillis();
        this.executionPaused = false;
        this.executionStopped = false;
        this.executionStepping = false;
        this.executing = true;
        this.vwr.pushHoldRepaintWhy("runEval");
        this.setScriptExtensions();
        this.executeCommands(false, true);
        this.isCmdLine_C_Option = tempOpen;
        if (this.isStateScript) {
            ScriptManager.setStateScriptVersion(this.vwr, null);
        }
    }

    public boolean useThreads() {
        return !this.chk && !this.vwr.headless && !this.vwr.autoExit && this.vwr.haveDisplay && this.outputBuffer == null && this.allowJSThreads;
    }

    private void executeCommands(boolean isTry, boolean reportCompletion) {
        boolean haveError = false;
        try {
            if (!this.dispatchCommands(false, false, isTry)) {
                return;
            }
        }
        catch (Error er) {
            this.vwr.handleError(er, false);
            this.setErrorMessage("" + er + " " + this.vwr.getShapeErrorState());
            this.errorMessageUntranslated = "" + er;
            this.report(this.errorMessage, true);
            haveError = true;
        }
        catch (ScriptException e) {
            if (!(!(e instanceof ScriptInterruption) || isTry && e.isError)) {
                return;
            }
            if (isTry) {
                this.vwr.setStringProperty("_errormessage", "" + e);
                return;
            }
            this.setErrorMessage(e.toString());
            this.errorMessageUntranslated = e.getErrorMessageUntranslated();
            this.report(this.errorMessage, true);
            this.vwr.notifyError(this.errorMessage != null && this.errorMessage.indexOf("java.lang.OutOfMemoryError") >= 0 ? "Error" : "ScriptException", this.errorMessage, this.errorMessageUntranslated);
            haveError = true;
        }
        if (haveError || !this.isJS || !this.allowJSThreads) {
            this.vwr.setTainted(true);
            this.vwr.popHoldRepaint("executeCommands " + (this.scriptLevel > 0 ? "\u0001## REPAINT_IGNORE ##" : ""));
        }
        this.timeEndExecution = System.currentTimeMillis();
        if (this.errorMessage == null && this.executionStopped) {
            this.setErrorMessage("execution interrupted");
        } else if (!this.tQuiet && reportCompletion) {
            this.vwr.scriptStatus("Script completed");
        }
        this.historyDisabled = false;
        this.isCmdLine_c_or_C_Option = false;
        this.chk = false;
        this.executing = false;
        String msg = this.getErrorMessageUntranslated();
        this.vwr.setErrorMessage(this.errorMessage, msg);
        if (!this.tQuiet && reportCompletion) {
            this.vwr.setScriptStatus("Jmol script terminated", this.errorMessage, 1 + (int)(this.timeEndExecution - this.timeBeginExecution), msg);
        }
    }

    @Override
    public void resumeEval(ScriptContext sc) {
        this.setErrorMessage(null);
        if (this.executionStopped || sc == null || !sc.mustResumeEval) {
            this.resumeViewer("resumeEval");
            return;
        }
        if (!this.executionPaused) {
            ++sc.pc;
        }
        this.thisContext = sc;
        if (sc.scriptLevel > 0) {
            this.scriptLevel = sc.scriptLevel - 1;
        }
        this.restoreScriptContext(sc, true, false, false);
        this.pcResume = sc.pc;
        this.executeCommands(sc.isTryCatch, this.scriptLevel <= 0);
        this.pcResume = -1;
    }

    private void resumeViewer(String why) {
        this.vwr.setTainted(true);
        this.vwr.popHoldRepaint(why + (this.chk ? "\u0001## REPAINT_IGNORE ##" : ""));
        this.vwr.queueOnHold = false;
    }

    @Override
    public void runScript(String script) throws ScriptException {
        if (!this.vwr.isPreviewOnly) {
            this.runScriptBuffer(script, this.outputBuffer, false);
        }
    }

    @Override
    public void runScriptBuffer(String script, SB outputBuffer, boolean isFuncReturn) throws ScriptException {
        this.pushContext(null, "runScriptBuffer");
        this.contextPath = this.contextPath + " >> script() ";
        this.outputBuffer = outputBuffer;
        this.allowJSThreads = false;
        boolean fret = this.isFuncReturn;
        this.isFuncReturn |= isFuncReturn;
        if (this.compileScript(null, script + "\u0001## EDITOR_IGNORE ##" + "\u0001## REPAINT_IGNORE ##", false)) {
            this.dispatchCommands(false, false, false);
        }
        this.popContext(false, false);
        this.isFuncReturn = fret;
    }

    @Override
    public ScriptContext checkScriptSilent(String script) {
        ScriptContext sc = this.compiler.compile(null, script, false, true, false, true);
        if (sc.errorType != null) {
            return sc;
        }
        this.restoreScriptContext(sc, false, false, false);
        this.chk = true;
        this.isCmdLine_C_Option = false;
        this.isCmdLine_c_or_C_Option = false;
        this.pc = 0;
        try {
            this.dispatchCommands(false, false, false);
        }
        catch (ScriptException e) {
            this.setErrorMessage(e.toString());
            sc = this.getScriptContext("checkScriptSilent");
        }
        this.chk = false;
        return sc;
    }

    static SB getContextTrace(Viewer vwr, ScriptContext sc, SB sb, boolean isTop) {
        if (sb == null) {
            sb = new SB();
        }
        int pc = Math.min(sc.pc, sc.lineNumbers[sc.lineNumbers.length - 1]);
        sb.append(ScriptEval.getErrorLineMessage(sc.functionName, sc.scriptFileName, sc.lineNumbers[pc], pc, ScriptEval.statementAsString(vwr, sc.statement, isTop ? sc.iToken : 9999, false)));
        if (sc.parentContext != null) {
            ScriptEval.getContextTrace(vwr, sc.parentContext, sb, false);
        }
        return sb;
    }

    @Override
    public void setDebugging() {
        this.debugScript = this.vwr.getBoolean(603979825);
        this.debugHigh = this.debugScript && Logger.debugging;
    }

    @Override
    public void haltExecution() {
        this.resumePausedExecution();
        this.executionStopped = true;
    }

    @Override
    public void pauseExecution(boolean withDelay) {
        if (this.chk || this.vwr.headless) {
            return;
        }
        if (withDelay && !this.isJS) {
            this.delayScript(-100);
        }
        this.vwr.popHoldRepaint("pauseExecution " + withDelay);
        this.executionStepping = false;
        this.executionPaused = true;
    }

    @Override
    public void stepPausedExecution() {
        this.executionStepping = true;
        this.executionPaused = false;
    }

    @Override
    public void resumePausedExecution() {
        this.executionPaused = false;
        this.executionStepping = false;
    }

    @Override
    public boolean isExecuting() {
        return this.executing && !this.executionStopped;
    }

    @Override
    public boolean isPaused() {
        return this.executionPaused;
    }

    @Override
    public boolean isStepping() {
        return this.executionStepping;
    }

    @Override
    public boolean isStopped() {
        return this.executionStopped || !this.isJS && this.currentThread != Thread.currentThread();
    }

    @Override
    public String getNextStatement() {
        return this.pc < this.aatoken.length ? ScriptEval.getErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEval.statementAsString(this.vwr, this.aatoken[this.pc], -9999, this.debugHigh)) : "";
    }

    private String getCommand(int pc, boolean allThisLine, boolean addSemi) {
        if (pc >= this.lineIndices.length) {
            return "";
        }
        if (allThisLine) {
            String s;
            int pt0 = -1;
            int pt1 = this.script.length();
            for (int i = 0; i < this.lineNumbers.length; ++i) {
                if (this.lineNumbers[i] == this.lineNumbers[pc]) {
                    if (pt0 < 0) {
                        pt0 = this.lineIndices[i][0];
                    }
                    pt1 = this.lineIndices[i][1];
                    continue;
                }
                if (this.lineNumbers[i] == 0 || this.lineNumbers[i] > this.lineNumbers[pc]) break;
            }
            if ((s = this.script).indexOf(1) >= 0) {
                s = s.substring(0, s.indexOf(1));
            }
            if (pt1 == s.length() - 1 && s.endsWith("}")) {
                ++pt1;
            }
            return pt0 == s.length() || pt1 < pt0 ? "" : s.substring(Math.max(pt0, 0), Math.min(s.length(), pt1));
        }
        int ichBegin = this.lineIndices[pc][0];
        int ichEnd = this.lineIndices[pc][1];
        String s = "";
        if (ichBegin < 0 || ichEnd <= ichBegin || ichEnd > this.script.length()) {
            return "";
        }
        try {
            s = this.script.substring(ichBegin, ichEnd);
            if (s.indexOf("\\\n") >= 0) {
                s = PT.rep(s, "\\\n", "  ");
            }
            if (s.indexOf("\\\r") >= 0) {
                s = PT.rep(s, "\\\r", "  ");
            }
            if (s.length() > 0 && !s.endsWith(";")) {
                s = s + ";";
            }
        }
        catch (Exception e) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + ichBegin + " ichEnd=" + ichEnd + " len = " + this.script.length() + "\n" + e);
        }
        return s;
    }

    private void logDebugScript(T[] st, int ifLevel) {
        this.iToken = -9999;
        if (this.debugHigh) {
            if (st.length > 0) {
                Logger.debug(st[0].toString());
            }
            for (int i = 1; i < st.length; ++i) {
                if (st[i] == null) continue;
                Logger.debug(st[i].toString());
            }
            SB strbufLog = new SB();
            String s = ifLevel > 0 ? "                          ".substring(0, ifLevel * 2) : "";
            strbufLog.append(s).append(ScriptEval.statementAsString(this.vwr, st, this.iToken, this.debugHigh));
            this.vwr.scriptStatus(strbufLog.toString());
        } else {
            String cmd = this.getCommand(this.pc, false, false);
            if (cmd != "") {
                this.vwr.scriptStatus(cmd);
            }
        }
    }

    @Override
    public Object evaluateExpression(Object expr, boolean asVariable, boolean compileOnly) {
        ScriptEval e = new ScriptEval().setViewer(this.vwr);
        try {
            e.thisContext = this.thisContext;
            e.contextVariables = this.contextVariables;
            e.pushContext(null, "evalExp");
            e.allowJSThreads = false;
        }
        catch (ScriptException e1) {
            // empty catch block
        }
        boolean exec0 = this.executing;
        Object o = e.evaluate(expr, asVariable, compileOnly);
        this.executing = exec0;
        return o;
    }

    private Object evaluate(Object expr, boolean asVariable, boolean compileOnly) {
        try {
            if (expr instanceof String) {
                if (this.compileScript(null, "e_x_p_r_e_s_s_i_o_n = " + expr, false)) {
                    if (compileOnly) {
                        return this.aatoken[0];
                    }
                    this.setStatement(this.aatoken[0], 1);
                    return asVariable ? this.parameterExpressionList(2, -1, false).get(0) : this.parameterExpressionString(2, 0);
                }
            } else {
                if (expr instanceof T[]) {
                    BS bs = this.atomExpression((T[])expr, 0, 0, true, false, null, false);
                    return asVariable ? SV.newV(10, bs) : bs;
                }
                if (expr instanceof T[][]) {
                    this.setStatement(((T[][])expr)[0], 1);
                    return asVariable ? this.parameterExpressionList(0, -1, false).get(0) : this.parameterExpressionString(0, -1);
                }
            }
        }
        catch (Exception ex) {
            Logger.error("Error evaluating: " + expr + "\n" + ex);
        }
        return asVariable ? SV.getVariable("ERROR") : "ERROR";
    }

    @Override
    public boolean checkSelect(Map<String, SV> h, T[] where) {
        boolean ok = false;
        try {
            this.pushContext(null, "checkSelect");
            ok = this.parameterExpressionSelect(h, where);
        }
        catch (Exception ex) {
            Logger.error("checkSelect " + ex);
        }
        this.popContext(false, false);
        return ok;
    }

    @Override
    public BS getAtomBitSet(Object atomExpression) {
        if (atomExpression instanceof BS) {
            return (BS)atomExpression;
        }
        BS bs = new BS();
        try {
            this.pushContext(null, "getAtomBitSet");
            String scr = "select (" + atomExpression + ")";
            scr = PT.replaceAllCharacters(scr, "\n\r", "),(");
            scr = PT.rep(scr, "()", "(none)");
            if (this.compileScript(null, scr, false)) {
                this.st = this.aatoken[0];
                this.setStatement(this.st, 0);
                bs = this.atomExpression(this.st, 1, 0, false, false, null, true);
            }
            this.popContext(false, false);
        }
        catch (Exception ex) {
            Logger.error("getAtomBitSet " + atomExpression + "\n" + ex);
        }
        return bs;
    }

    public boolean compileScript(String filename, String strScript, boolean debugCompiler) {
        this.scriptFileName = filename;
        strScript = this.fixScriptPath(strScript, filename);
        this.restoreScriptContext(this.compiler.compile(filename, strScript, false, false, debugCompiler && Logger.debugging, false), false, false, false);
        this.isStateScript = this.compiler.isStateScript;
        this.forceNoAddHydrogens = this.isStateScript && this.script.indexOf("pdbAddHydrogens") < 0;
        String s = this.script;
        this.pc = this.setScriptExtensions();
        if (!this.chk && this.vwr.scriptEditorVisible && strScript.indexOf("\u0001## EDITOR_IGNORE ##") < 0) {
            this.vwr.scriptStatus("");
        }
        this.script = s;
        return !this.error;
    }

    private String fixScriptPath(String strScript, String filename) {
        if (filename != null && strScript.indexOf("$SCRIPT_PATH$") >= 0) {
            String path = filename;
            int pt = Math.max(filename.lastIndexOf("|"), filename.lastIndexOf("/"));
            path = path.substring(0, pt + 1);
            strScript = PT.rep(strScript, "$SCRIPT_PATH$/", path);
            strScript = PT.rep(strScript, "$SCRIPT_PATH$", path);
        }
        return strScript;
    }

    private int setScriptExtensions() {
        String extensions = this.scriptExtensions;
        if (extensions == null) {
            return 0;
        }
        int pt = extensions.indexOf("##SCRIPT_STEP");
        if (pt >= 0) {
            this.executionStepping = true;
        }
        if ((pt = extensions.indexOf("##SCRIPT_START=")) < 0) {
            return 0;
        }
        if ((pt = PT.parseInt(extensions.substring(pt + 15))) == Integer.MIN_VALUE) {
            return 0;
        }
        this.pc = 0;
        while (this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] <= pt && this.lineIndices[this.pc][1] < pt) {
            ++this.pc;
        }
        if (this.pc > 0 && this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] > pt) {
            --this.pc;
        }
        return this.pc;
    }

    private boolean compileScriptFileInternal(String filename, String localPath, String remotePath, String scriptPath) {
        if (filename.toLowerCase().indexOf("javascript:") == 0) {
            return this.compileScript(filename, this.vwr.jsEval(filename.substring(11)), this.debugScript);
        }
        String[] data = new String[2];
        data[0] = filename;
        if (!this.vwr.fm.getFileDataAsString(data, -1, false, true, false)) {
            this.setErrorMessage("io error reading " + data[0] + ": " + data[1]);
            return false;
        }
        if (("\n" + data[1]).indexOf("\nJmolManifest.txt\n") >= 0) {
            String path;
            if (filename.endsWith(".all.pngj") || filename.endsWith(".all.png")) {
                path = "|state.spt";
                filename = filename + "|";
            } else {
                data[0] = filename = filename + "|JmolManifest.txt";
                if (!this.vwr.fm.getFileDataAsString(data, -1, false, true, false)) {
                    this.setErrorMessage("io error reading " + data[0] + ": " + data[1]);
                    return false;
                }
                path = FileManager.getManifestScriptPath(data[1]);
            }
            if (path != null && path.length() > 0) {
                data[0] = filename = filename.substring(0, filename.lastIndexOf("|")) + path;
                if (!this.vwr.fm.getFileDataAsString(data, -1, false, true, false)) {
                    this.setErrorMessage("io error reading " + data[0] + ": " + data[1]);
                    return false;
                }
            }
        }
        this.scriptFileName = filename;
        data[1] = FileManager.getEmbeddedScript(data[1]);
        String script = this.fixScriptPath(data[1], data[0]);
        if (scriptPath == null) {
            scriptPath = this.vwr.fm.getFilePath(filename, false, false);
            scriptPath = scriptPath.substring(0, Math.max(scriptPath.lastIndexOf("|"), scriptPath.lastIndexOf("/")));
        }
        script = FileManager.setScriptFileReferences(script, localPath, remotePath, scriptPath);
        return this.compileScript(filename, script, this.debugScript);
    }

    @Override
    public float evalFunctionFloat(Object func, Object params, float[] values) {
        try {
            Lst p = (Lst)params;
            for (int i = 0; i < values.length; ++i) {
                ((SV)p.get((int)i)).value = Float.valueOf(values[i]);
            }
            ScriptFunction f = (ScriptFunction)func;
            return SV.fValue(this.runFunctionAndRet(f, f.name, p, null, true, false, false));
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    public SV getUserFunctionResult(String name, Lst<SV> params, SV tokenAtom) throws ScriptException {
        return this.runFunctionAndRet(null, name, params, tokenAtom, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SV runFunctionAndRet(JmolScriptFunction function, String name, Lst<SV> params, SV tokenAtom, boolean getReturn, boolean setContextPath, boolean allowThreads) throws ScriptException {
        boolean isTry;
        if (function == null) {
            function = this.vwr.getFunction(name = name.toLowerCase());
            if (function == null) {
                return null;
            }
            if (setContextPath) {
                this.contextPath = this.contextPath + " >> function " + name;
            }
        } else if (setContextPath) {
            this.contextPath = this.contextPath + " >> " + name;
        }
        this.pushContext(null, "runFunctionAndRet ");
        if (this.allowJSThreads) {
            this.allowJSThreads = allowThreads;
        }
        this.thisContext.isTryCatch = isTry = function.getTok() == 364558;
        this.thisContext.isFunction = !isTry;
        this.functionName = name;
        if (isTry) {
            this.resetError();
            this.thisContext.displayLoadErrorsSave = this.vwr.displayLoadErrors;
            this.thisContext.tryPt = ++this.vwr.tryPt;
            this.vwr.displayLoadErrors = false;
            this.restoreFunction(function, params, tokenAtom);
            this.contextVariables.put("_breakval", SV.newI(Integer.MAX_VALUE));
            this.contextVariables.put("_errorval", SV.newS(""));
            Map cv = this.contextVariables;
            this.executeCommands(true, false);
            while (this.thisContext.tryPt > this.vwr.tryPt) {
                this.popContext(false, false);
            }
            this.processTry(cv);
            return null;
        }
        if (function instanceof JmolParallelProcessor) {
            JmolScriptFunction cv = function;
            synchronized (cv) {
                this.parallelProcessor = (JmolParallelProcessor)((Object)function);
                this.restoreFunction(function, params, tokenAtom);
                this.dispatchCommands(false, true, false);
                ((JmolParallelProcessor)((Object)function)).runAllProcesses(this.vwr);
            }
        } else {
            this.restoreFunction(function, params, tokenAtom);
            this.dispatchCommands(false, true, false);
        }
        SV v = getReturn ? this.getContextVariableAsVariable("_retval", false) : null;
        this.popContext(false, false);
        return v;
    }

    private void processTry(Map<String, SV> cv) throws ScriptException {
        int iBreak;
        this.vwr.displayLoadErrors = this.thisContext.displayLoadErrorsSave;
        this.popContext(false, false);
        String err = (String)this.vwr.getP("_errormessage");
        if (err.length() > 0) {
            cv.put("_errorval", SV.newS(err));
            this.resetError();
        }
        cv.put("_tryret", cv.get("_retval"));
        SV ret = cv.get("_tryret");
        if (ret.value != null || ret.intValue != Integer.MAX_VALUE) {
            this.cmdReturn(ret);
            return;
        }
        String errMsg = (String)cv.get((Object)"_errorval").value;
        if (errMsg.length() == 0 && (iBreak = cv.get((Object)"_breakval").intValue) != Integer.MAX_VALUE) {
            this.breakAt(this.pc - iBreak);
            return;
        }
        if (this.pc + 1 < this.aatoken.length && this.aatoken[this.pc + 1][0].tok == 102412) {
            ContextToken ct = (ContextToken)this.aatoken[this.pc + 1][0];
            if (ct.contextVariables != null && ct.name0 != null) {
                ct.contextVariables.put(ct.name0, SV.newS(errMsg));
            }
            ct.intValue = (errMsg.length() > 0 ? 1 : -1) * Math.abs(ct.intValue);
        }
    }

    private void breakAt(int pt) {
        if (pt < 0) {
            this.getContextVariableAsVariable((String)"_breakval", (boolean)false).intValue = -pt;
            this.pcEnd = this.pc;
            return;
        }
        int ptEnd = Math.abs(this.aatoken[pt][0].intValue);
        int tok = this.aatoken[pt][0].tok;
        if (tok == 102411 || tok == 102413) {
            this.theToken = this.aatoken[ptEnd--][0];
            int ptNext = Math.abs(this.theToken.intValue);
            if (this.theToken.tok != 102409) {
                this.theToken.intValue = -ptNext;
            }
        } else {
            this.pc = -1;
            while (this.pc != pt && this.thisContext != null) {
                while (this.thisContext != null && !ScriptCompiler.isBreakableContext(this.thisContext.token.tok)) {
                    this.popContext(true, false);
                }
                this.pc = this.thisContext.pc;
                this.popContext(true, false);
            }
        }
        this.pc = ptEnd;
    }

    private void restoreFunction(JmolScriptFunction f, Lst<SV> params, SV tokenAtom) throws ScriptException {
        ScriptFunction function = (ScriptFunction)f;
        this.aatoken = function.aatoken;
        this.lineNumbers = function.lineNumbers;
        this.lineIndices = function.lineIndices;
        this.script = function.script;
        this.pc = 0;
        if (function.names != null) {
            this.contextVariables = new Hashtable();
            function.setVariables(this.contextVariables, params);
        }
        if (tokenAtom != null) {
            this.contextVariables.put("_x", tokenAtom);
        }
    }

    public void clearDefinedVariableAtomSets() {
        this.vwr.definedAtomSets.remove("# variable");
    }

    private void defineSets() {
        String definition;
        int i;
        if (!this.vwr.definedAtomSets.containsKey("# static")) {
            for (i = 0; i < JC.predefinedStatic.length; ++i) {
                this.defineAtomSet(JC.predefinedStatic[i]);
            }
            this.defineAtomSet("# static");
        }
        if (this.vwr.definedAtomSets.containsKey("# variable")) {
            return;
        }
        for (i = 0; i < JC.predefinedVariable.length; ++i) {
            this.defineAtomSet(JC.predefinedVariable[i]);
        }
        i = Elements.elementNumberMax;
        while (--i >= 0) {
            definition = " elemno=" + i;
            this.defineAtomSet("@" + Elements.elementNameFromNumber(i) + definition);
            this.defineAtomSet("@_" + Elements.elementSymbolFromNumber(i) + definition);
        }
        i = 4;
        while (--i >= 0) {
            definition = "@" + Elements.altElementNameFromIndex(i) + " _e=" + Elements.altElementNumberFromIndex(i);
            this.defineAtomSet(definition);
        }
        i = Elements.altElementMax;
        while (--i >= 4) {
            int e;
            int ei = Elements.altElementNumberFromIndex(i);
            String def = " _e=" + ei;
            String definition2 = "@_" + Elements.altElementSymbolFromIndex(i);
            this.defineAtomSet(definition2 + def);
            definition2 = "@_" + Elements.altIsotopeSymbolFromIndex(i);
            this.defineAtomSet(definition2 + def);
            definition2 = "@_" + Elements.altIsotopeSymbolFromIndex2(i);
            this.defineAtomSet(definition2 + def);
            definition2 = "@" + Elements.altElementNameFromIndex(i);
            if (definition2.length() > 1) {
                this.defineAtomSet(definition2 + def);
            }
            if ((ei = Elements.getNaturalIsotope(e = Elements.getElementNumber(ei))) <= 0) continue;
            def = Elements.elementSymbolFromNumber(e);
            this.defineAtomSet("@_" + def + ei + " _e=" + e);
            this.defineAtomSet("@_" + ei + def + " _e=" + e);
        }
        this.defineAtomSet("# variable");
    }

    private void defineAtomSet(String script) {
        if (script.indexOf("#") == 0) {
            this.vwr.definedAtomSets.put(script, Boolean.TRUE);
            return;
        }
        ScriptContext sc = this.compiler.compile("#predefine", script, true, false, false, false);
        if (sc.errorType != null) {
            this.vwr.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + script + "\ncompile error:" + sc.errorMessageUntranslated);
            return;
        }
        if (sc.getTokenCount() != 1) {
            this.vwr.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + script);
            return;
        }
        T[] statement = sc.getToken(0);
        if (statement.length <= 2) {
            this.vwr.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + script);
            return;
        }
        int tok = statement[1].tok;
        if (!T.tokAttr(tok, 0x40000000) && !T.tokAttr(tok, 0x200000)) {
            this.vwr.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + script);
            return;
        }
        String name = ((String)statement[1].value).toLowerCase();
        if (name.startsWith("dynamic_")) {
            name = "!" + name.substring(8);
        }
        this.vwr.definedAtomSets.put(name, statement);
    }

    public BS lookupIdentifierValue(String identifier) throws ScriptException {
        BS bs = this.lookupValue(identifier, false);
        if (bs != null) {
            return BSUtil.copy(bs);
        }
        bs = this.getAtomBits(0x40000000, identifier);
        return bs == null ? new BS() : bs;
    }

    private BS lookupValue(String setName, boolean plurals) throws ScriptException {
        if (this.chk) {
            return new BS();
        }
        this.defineSets();
        setName = setName.toLowerCase();
        Object value = this.vwr.definedAtomSets.get(setName);
        boolean isDynamic = false;
        if (value == null) {
            value = this.vwr.definedAtomSets.get("!" + setName);
            boolean bl = isDynamic = value != null;
        }
        if (value instanceof BS) {
            return (BS)value;
        }
        if (value instanceof T[]) {
            this.pushContext(null, "lookupValue");
            BS bs = this.atomExpression((T[])value, -2, 0, true, false, null, true);
            this.popContext(false, false);
            if (!isDynamic) {
                this.vwr.definedAtomSets.put(setName, bs);
            }
            return bs;
        }
        if (setName.equals("water")) {
            BS bs = this.vwr.ms.getAtoms(1612709912, null);
            if (!isDynamic) {
                this.vwr.definedAtomSets.put(setName, bs);
            }
            return bs;
        }
        if (plurals) {
            return null;
        }
        int len = setName.length();
        if (len < 5) {
            return null;
        }
        if (setName.charAt(len - 1) != 's') {
            return null;
        }
        setName = setName.endsWith("ies") ? setName.substring(0, len - 3) + 'y' : setName.substring(0, len - 1);
        return this.lookupValue(setName, true);
    }

    @Override
    public void deleteAtomsInVariables(BS bsDeleted) {
        for (Map.Entry<String, Object> entry : this.vwr.definedAtomSets.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof BS)) continue;
            BSUtil.deleteBits((BS)value, bsDeleted);
            if (entry.getKey().startsWith("!")) continue;
            this.vwr.g.setUserVariable("@" + entry.getKey(), SV.newV(10, value));
        }
    }

    @Override
    public ScriptContext getThisContext() {
        return this.thisContext;
    }

    private void clearState(boolean tQuiet) {
        this.thisContext = null;
        this.scriptLevel = 0;
        this.setErrorMessage(null);
        this.contextPath = "";
        this.tQuiet = tQuiet;
    }

    @Override
    public void pushContextDown(String why) {
        --this.scriptLevel;
        this.pushContext2(null, why);
    }

    private void pushContext(ContextToken token, String why) throws ScriptException {
        if (this.scriptLevel == contextDepthMax) {
            this.error(44);
        }
        this.pushContext2(token, why);
    }

    private void pushContext2(ContextToken token, String why) {
        this.thisContext = this.getScriptContext(why);
        this.thisContext.token = token;
        if (token == null) {
            this.scriptLevel = ++this.thisContext.scriptLevel;
        } else {
            this.thisContext.scriptLevel = -1;
            this.contextVariables = new Hashtable();
            if (token.contextVariables != null) {
                for (String key : token.contextVariables.keySet()) {
                    ScriptCompiler.addContextVariable(this.contextVariables, key);
                }
            }
        }
        if (this.debugHigh || this.isCmdLine_c_or_C_Option) {
            Logger.info("-->>----------------------".substring(0, Math.min(15, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " " + token + " " + this.thisContext.id + " " + why + " path=" + this.thisContext.contextPath);
        }
    }

    @Override
    public ScriptContext getScriptContext(String why) {
        ScriptContext context = new ScriptContext();
        if (this.debugHigh) {
            Logger.info("creating context " + context.id + " for " + why + " path=" + this.contextPath);
        }
        context.scriptLevel = this.scriptLevel;
        context.parentContext = this.thisContext;
        context.contextPath = this.contextPath;
        context.scriptFileName = this.scriptFileName;
        context.parallelProcessor = this.parallelProcessor;
        context.functionName = this.functionName;
        context.script = this.script;
        context.lineNumbers = this.lineNumbers;
        context.lineIndices = this.lineIndices;
        context.saveTokens(this.aatoken);
        context.statement = this.st;
        context.statementLength = this.slen;
        context.pc = context.pc0 = this.pc;
        context.lineEnd = this.lineEnd;
        context.pcEnd = this.pcEnd;
        context.iToken = this.iToken;
        context.theToken = this.theToken;
        context.theTok = this.theTok;
        context.outputBuffer = this.outputBuffer;
        context.vars = this.contextVariables;
        context.isStateScript = this.isStateScript;
        context.errorMessage = this.errorMessage;
        context.errorType = this.errorType;
        context.iCommandError = this.iCommandError;
        context.chk = this.chk;
        context.executionStepping = this.executionStepping;
        context.executionPaused = this.executionPaused;
        context.scriptExtensions = this.scriptExtensions;
        context.mustResumeEval = this.mustResumeEval;
        context.allowJSThreads = this.allowJSThreads;
        return context;
    }

    void popContext(boolean isFlowCommand, boolean statementOnly) {
        if (this.thisContext == null) {
            return;
        }
        if (this.thisContext.scriptLevel > 0) {
            this.scriptLevel = this.thisContext.scriptLevel - 1;
        }
        ScriptContext scTemp = isFlowCommand ? this.getScriptContext("popFlow") : null;
        this.restoreScriptContext(this.thisContext, true, isFlowCommand, statementOnly);
        if (scTemp != null) {
            this.restoreScriptContext(scTemp, true, false, true);
        }
        if (this.debugHigh || this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<------------".substring(0, Math.min(15, this.scriptLevel + 5)) + (this.scriptLevel + 1) + " " + this.scriptFileName + " isFlow " + isFlowCommand + " thisContext=" + (this.thisContext == null ? "" : "" + this.thisContext.id) + " pc=" + this.pc + "-->" + this.pc + " path=" + (this.thisContext == null ? "" : this.thisContext.contextPath));
        }
    }

    public void restoreScriptContext(ScriptContext context, boolean isPopContext, boolean isFlowCommand, boolean statementOnly) {
        boolean bl = this.executing = !this.chk;
        if (context == null) {
            return;
        }
        if (!isFlowCommand) {
            this.st = context.statement;
            this.slen = context.statementLength;
            this.pc = context.pc;
            this.lineEnd = context.lineEnd;
            this.pcEnd = context.pcEnd;
            if (statementOnly) {
                return;
            }
        }
        this.mustResumeEval = context.mustResumeEval;
        this.script = context.script;
        this.lineNumbers = context.lineNumbers;
        this.lineIndices = context.lineIndices;
        this.aatoken = context.restoreTokens();
        this.contextVariables = context.vars;
        this.scriptExtensions = context.scriptExtensions;
        if (isPopContext) {
            int pt;
            this.contextPath = context.contextPath;
            int n = pt = this.contextPath == null ? -1 : this.contextPath.indexOf(" >> ");
            if (pt >= 0) {
                this.contextPath = this.contextPath.substring(0, pt);
            }
            this.scriptFileName = context.scriptFileName;
            this.parallelProcessor = context.parallelProcessor;
            this.functionName = context.functionName;
            this.iToken = context.iToken;
            this.theToken = context.theToken;
            this.theTok = context.theTok;
            this.outputBuffer = context.outputBuffer;
            this.isStateScript = context.isStateScript;
            this.thisContext = context.parentContext;
            this.allowJSThreads = context.allowJSThreads;
            if (this.debugHigh || this.isCmdLine_c_or_C_Option) {
                Logger.info("--r------------".substring(0, Math.min(15, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " isPop " + isPopContext + " isFlow " + isFlowCommand + " context.id=" + context.id + " pc=" + this.pc + "-->" + context.pc + " " + this.contextPath);
            }
        } else {
            this.error = context.errorType != null;
            this.errorMessage = context.errorMessage;
            this.errorMessageUntranslated = context.errorMessageUntranslated;
            this.iCommandError = context.iCommandError;
            this.errorType = context.errorType;
        }
    }

    public void setException(ScriptException sx, String msg, String untranslated) {
        sx.untranslated = untranslated == null ? msg : untranslated;
        boolean isThrown = "!".equals(untranslated);
        this.errorType = msg;
        this.iCommandError = this.pc;
        if (sx.message == null) {
            sx.message = "";
            return;
        }
        String s = ScriptEval.getContextTrace(this.vwr, this.getScriptContext("setException"), null, true).toString();
        while (this.thisContext != null && !this.thisContext.isTryCatch) {
            this.popContext(false, false);
        }
        if (sx.message.indexOf(s) < 0) {
            sx.message = sx.message + s;
            sx.untranslated = sx.untranslated + s;
        }
        this.resumeViewer(isThrown ? "throw context" : "scriptException");
        if (isThrown || this.thisContext != null || this.chk || msg.indexOf("NOTE: file recognized as a script file: ") >= 0) {
            return;
        }
        Logger.error("eval ERROR: " + s + this.toString());
        if (this.vwr.autoExit) {
            this.vwr.exitJmol();
        }
    }

    public static String statementAsString(Viewer vwr, T[] statement, int iTok, boolean doLogMessages) {
        if (statement.length == 0) {
            return "";
        }
        SB sb = new SB();
        int tok = statement[0].tok;
        switch (tok) {
            case 0: {
                return (String)statement[0].value;
            }
            case 102409: {
                if (statement.length != 2 || statement[1].tok != 134320141 && statement[1].tok != 102436) break;
                return ((ScriptFunction)statement[1].value).toString();
            }
        }
        boolean useBraces = true;
        boolean inBrace = false;
        boolean inClauseDefine = false;
        boolean setEquals = statement.length > 1 && tok == 36867 && statement[0].value.equals("") && (statement[0].intValue == 61 || statement[0].intValue == 35) && statement[1].tok != 1073742325;
        int len = statement.length;
        block33: for (int i = 0; i < len; ++i) {
            T token = statement[i];
            if (token == null) {
                len = i;
                break;
            }
            if (iTok == i - 1) {
                sb.append(" <<");
            }
            if (i != 0) {
                sb.appendC(' ');
            }
            if (i == 2 && setEquals && ((setEquals = token.tok != 268435860) || statement[0].intValue == 35)) {
                sb.append(setEquals ? "= " : "== ");
                if (!setEquals) continue;
            }
            if (iTok == i && token.tok != 1073742326) {
                sb.append("<<<<");
            }
            switch (token.tok) {
                case 1073742325: {
                    if (!useBraces) continue block33;
                    sb.append("{");
                    continue block33;
                }
                case 1073742326: {
                    if (inClauseDefine && i == statement.length - 1) {
                        useBraces = false;
                    }
                    if (!useBraces) continue block33;
                    sb.append("}");
                    continue block33;
                }
                case 0x10000040: 
                case 0x10000041: {
                    break;
                }
                case 1073742332: 
                case 0x40000202: {
                    inBrace = token.tok == 1073742332;
                    break;
                }
                case 12290: {
                    if (i <= 0 || !((String)token.value).equals("define")) break;
                    sb.append("@");
                    if (i + 1 >= statement.length || statement[i + 1].tok != 1073742325) continue block33;
                    if (!useBraces) {
                        inClauseDefine = true;
                    }
                    useBraces = true;
                    continue block33;
                }
                case 1073742335: {
                    sb.append("true");
                    continue block33;
                }
                case 1073742334: {
                    sb.append("false");
                    continue block33;
                }
                case 1275082245: {
                    break;
                }
                case 2: {
                    sb.appendI(token.intValue);
                    continue block33;
                }
                case 8: 
                case 9: 
                case 10: {
                    sb.append(SV.sValue(token));
                    continue block33;
                }
                case 6: {
                    if (Boolean.TRUE == ((Map)token.value).get("$_BINARY_$")) {
                        sb.append("<BINARY DATA>");
                        continue block33;
                    }
                }
                case 7: {
                    sb.append(((SV)token).escape());
                    continue block33;
                }
                case 5: {
                    sb.appendC('^');
                    continue block33;
                }
                case 1073742363: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        sb.appendI(token.intValue);
                    } else {
                        sb.append(Group.getSeqcodeStringFor(ScriptEval.getSeqCode(token)));
                    }
                    token = statement[++i];
                    sb.appendC(' ');
                    sb.append(inBrace ? "-" : "- ");
                }
                case 1073742362: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        sb.appendI(token.intValue);
                        continue block33;
                    }
                    sb.append(Group.getSeqcodeStringFor(ScriptEval.getSeqCode(token)));
                    continue block33;
                }
                case 1073742357: {
                    sb.append("*:");
                    sb.append(vwr.getChainIDStr(token.intValue));
                    continue block33;
                }
                case 1073742355: {
                    sb.append("*%");
                    if (token.value == null) continue block33;
                    sb.append(token.value.toString());
                    continue block33;
                }
                case 1073742358: {
                    sb.append("*/");
                }
                case 3: 
                case 1073742359: {
                    if (token.intValue < Integer.MAX_VALUE) {
                        sb.append(Escape.escapeModelFileNumber(token.intValue));
                        continue block33;
                    }
                    sb.append("" + token.value);
                    continue block33;
                }
                case 1073742361: {
                    sb.appendC('[');
                    int ptr = token.intValue * 6 + 1;
                    sb.append(Group.standardGroupList.substring(ptr, ptr + 3).trim());
                    sb.appendC(']');
                    continue block33;
                }
                case 1073742360: {
                    sb.appendC('[');
                    sb.appendO(token.value);
                    sb.appendC(']');
                    continue block33;
                }
                case 1073742356: {
                    sb.append("*.");
                    break;
                }
                case 1094713349: {
                    if (!(token.value instanceof P3)) break;
                    P3 pt = (P3)token.value;
                    sb.append("cell=").append(Escape.eP(pt));
                    continue block33;
                }
                case 4: {
                    sb.append("\"").appendO(token.value).append("\"");
                    continue block33;
                }
                case 0x10000190: 
                case 0x10000191: 
                case 268435858: 
                case 268435859: 
                case 268435860: 
                case 268435861: {
                    if (token.intValue == 1715472409) {
                        sb.append((String)statement[++i].value).append(" ");
                        break;
                    }
                    if (token.intValue == Integer.MAX_VALUE) break;
                    sb.append(T.nameOf(token.intValue)).append(" ");
                    break;
                }
                case 364558: {
                    continue block33;
                }
                case 102409: {
                    sb.append("end");
                    continue block33;
                }
                default: {
                    if (T.tokAttr(token.tok, 0x40000000) || !doLogMessages) break;
                    sb.appendC('\n').append(token.toString()).appendC('\n');
                    continue block33;
                }
            }
            if (token.value == null) continue;
            sb.append(token.value.toString());
        }
        return sb.toString();
    }

    @Override
    public String setObjectPropSafe(String id, int tokCommand) {
        try {
            return this.setObjectProp(id, tokCommand, -1);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    protected void setAtomProp(String prop, Object value, BS bs) {
        this.setShapePropertyBs(0, prop, value, bs);
    }

    public void restrictSelected(boolean isBond, boolean doInvert) {
        if (!this.chk) {
            this.sm.restrictSelected(isBond, doInvert);
        }
    }

    public void showString(String str) {
        this.showStringPrint(str, false);
    }

    @Override
    public void showStringPrint(String s, boolean mustDo) {
        if (this.chk || s == null) {
            return;
        }
        if (this.outputBuffer == null) {
            this.vwr.showString(s, mustDo);
        } else {
            this.appendBuffer(s, mustDo);
        }
    }

    public void report(String s, boolean isError) {
        if (this.chk) {
            return;
        }
        if (this.outputBuffer == null) {
            this.vwr.scriptStatus(s);
        } else {
            this.appendBuffer(s, isError);
        }
    }

    private void appendBuffer(String str, boolean mustDo) {
        if (mustDo || this.isFuncReturn || Logger.isActiveLevel(4)) {
            this.outputBuffer.append(str).appendC('\n');
        }
    }

    private void addProcess(Lst<T[]> vProcess, int pc, int pt) {
        if (this.parallelProcessor == null) {
            return;
        }
        T[][] statements = new T[pt][];
        for (int i = 0; i < vProcess.size(); ++i) {
            statements[i + 1 - pc] = (T[])vProcess.get(i);
        }
        ScriptContext context = this.getScriptContext("addProcess");
        context.saveTokens(statements);
        context.pc = 1 - pc;
        context.pcEnd = pt;
        this.parallelProcessor.addProcess("p" + ++iProcess, context);
    }

    private boolean checkContinue() throws ScriptException {
        if (this.executionStopped) {
            return false;
        }
        if (this.executionStepping && this.isCommandDisplayable(this.pc)) {
            this.vwr.setScriptStatus("Next: " + this.getNextStatement(), "stepping -- type RESUME to continue", 0, null);
            this.executionPaused = true;
        } else if (!this.executionPaused) {
            return true;
        }
        if (Logger.debugging) {
            Logger.debug("script execution paused at command " + (this.pc + 1) + " level " + this.scriptLevel + ": " + this.thisCommand);
        }
        this.refresh(false);
        while (this.executionPaused) {
            this.vwr.popHoldRepaint("pause \u0001## REPAINT_IGNORE ##");
            String script = this.vwr.getInsertedCommand();
            if (script.length() > 0) {
                this.resumePausedExecution();
                this.setErrorMessage(null);
                ScriptContext scSave = this.getScriptContext("script insertion");
                --this.pc;
                try {
                    this.runScript(script);
                }
                catch (Exception e) {
                    this.setErrorMessage("" + e);
                }
                catch (Error er) {
                    this.setErrorMessage("" + er);
                }
                if (this.error) {
                    this.report(this.errorMessage, true);
                    this.setErrorMessage(null);
                }
                this.restoreScriptContext(scSave, true, false, false);
                this.pauseExecution(false);
            }
            this.doDelay(-100);
            this.vwr.pushHoldRepaintWhy("pause");
        }
        this.notifyResumeStatus();
        return !this.error && !this.executionStopped;
    }

    public void delayScript(int millis) {
        if (this.vwr.autoExit) {
            return;
        }
        this.stopScriptThreads();
        this.scriptDelayThread = new ScriptDelayThread(this, this.vwr, millis);
        this.scriptDelayThread.run();
    }

    private void doDelay(int millis) throws ScriptException {
        if (!this.useThreads()) {
            return;
        }
        if (this.isJS) {
            throw new ScriptInterruption(this, "delay", millis);
        }
        this.delayScript(millis);
    }

    @Override
    public boolean evalParallel(ScriptContext context, ShapeManager shapeManager) {
        return this.getCmdExt().evalParallel(context, shapeManager);
    }

    private boolean isCommandDisplayable(int i) {
        if (i >= this.aatoken.length || i >= this.pcEnd || this.aatoken[i] == null) {
            return false;
        }
        return this.lineIndices[i][1] > this.lineIndices[i][0];
    }

    @Override
    public void loadFileResourceAsync(String fileName) throws ScriptException {
        this.loadFileAsync(null, fileName, -Math.abs(fileName.hashCode()), false);
    }

    public String loadFileAsync(String prefix, String filename, int i, boolean doClear) throws ScriptException {
        String cacheName;
        if (this.vwr.fm.cacheGet(filename, false) != null) {
            return filename;
        }
        if (prefix != null) {
            prefix = "cache://local" + prefix;
        }
        String key = this.pc + "_" + i + "_" + filename;
        if (this.thisContext == null || this.thisContext.htFileCache == null) {
            this.pushContext(null, "loadFileAsync");
            this.thisContext.htFileCache = new Hashtable<String, String>();
        }
        if ((cacheName = this.thisContext.htFileCache.get(key)) != null && cacheName.length() > 0) {
            this.fileLoadThread = null;
            this.popContext(false, false);
            this.vwr.queueOnHold = false;
            if ("#CANCELED#".equals(cacheName) || "#CANCELED#".equals(this.vwr.fm.cacheGet(cacheName, false))) {
                this.evalError("#CANCELED#", null);
            }
            return cacheName;
        }
        cacheName = prefix + System.currentTimeMillis();
        this.thisContext.htFileCache.put(key, cacheName);
        if (doClear) {
            this.vwr.cacheFileByName(prefix + "*", false);
        }
        this.fileLoadThread = new FileLoadThread(this, this.vwr, filename, key, cacheName);
        if (this.vwr.testAsync) {
            this.fileLoadThread.start();
        } else {
            this.fileLoadThread.run();
        }
        if (i < 0) {
            this.fileLoadThread = null;
        }
        throw new ScriptInterruption(this, "load", 1);
    }

    private void logLoadInfo(String msg) {
        if (msg.length() > 0) {
            Logger.info(msg);
        }
        SB sb = new SB();
        int modelCount = this.vwr.ms.mc;
        if (modelCount > 1) {
            sb.append((this.vwr.am.isMovie ? this.vwr.am.getFrameCount() + " frames" : modelCount + " models") + "\n");
        }
        for (int i = 0; i < modelCount; ++i) {
            Map moData = (Map)this.vwr.ms.getInfo(i, "moData");
            if (moData == null || !moData.containsKey("mos")) continue;
            sb.appendI(((Lst)moData.get("mos")).size()).append(" molecular orbitals in model ").append(this.vwr.getModelNumberDotted(i)).append("\n");
        }
        if (sb.length() > 0) {
            this.vwr.showString(sb.toString(), false);
        }
    }

    @Override
    public void notifyResumeStatus() {
        if (!(this.chk || this.executionStopped || this.executionStepping)) {
            this.vwr.scriptStatus("script execution " + (this.error || this.executionStopped ? "interrupted" : "resumed"));
        }
        if (Logger.debugging) {
            Logger.debug("script execution resumed");
        }
    }

    public void refresh(boolean doDelay) throws ScriptException {
        if (this.chk) {
            return;
        }
        this.vwr.setTainted(true);
        this.vwr.requestRepaintAndWait("refresh cmd");
        if (this.isJS && doDelay) {
            this.doDelay(10);
        }
    }

    @Override
    public void stopScriptThreads() {
        if (this.scriptDelayThread != null) {
            this.scriptDelayThread.interrupt();
            this.scriptDelayThread = null;
        }
        if (this.fileLoadThread != null) {
            this.fileLoadThread.interrupt();
            this.fileLoadThread.resumeEval();
            if (this.thisContext != null) {
                this.popContext(false, false);
            }
            this.fileLoadThread = null;
        }
    }

    public String getErrorLineMessage2() {
        return ScriptEval.getErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEval.statementAsString(this.vwr, this.st, -9999, this.debugHigh));
    }

    public int getLinenumber(ScriptContext c) {
        return c == null ? this.lineNumbers[this.pc] : c.lineNumbers[c.pc];
    }

    public boolean dispatchCommands(boolean isSpt, boolean fromFunc, boolean isTry) throws ScriptException {
        if (this.sm == null) {
            this.sm = this.vwr.shm;
        }
        this.debugHigh = false;
        this.debugScript = false;
        if (!this.chk) {
            this.setDebugging();
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        if (this.aatoken == null) {
            return true;
        }
        if (!this.tQuiet) {
            this.tQuiet = this.vwr.getInt(0x2000000A) < 0;
        }
        boolean allowJSInterrupt = this.isJS && !fromFunc && this.useThreads() && this.vwr.getInt(0x2000000A) >= 0;
        this.commandLoop(allowJSInterrupt);
        if (this.chk) {
            return true;
        }
        String script = this.vwr.getInsertedCommand();
        if (!"".equals(script)) {
            this.runScriptBuffer(script, null, false);
        } else if (isSpt && this.debugScript && this.vwr.getBoolean(603979880)) {
            this.vwr.getChimeMessenger().update(null);
        }
        if (!this.mustResumeEval && !allowJSInterrupt || fromFunc) {
            return true;
        }
        if (!isTry && this.mustResumeEval || this.thisContext == null) {
            boolean done = this.thisContext == null;
            this.resumeEval(this.thisContext);
            this.mustResumeEval = false;
            return done;
        }
        return true;
    }

    private void commandLoop(boolean allowJSInterrupt) throws ScriptException {
        String lastCommand = "";
        boolean isForCheck = false;
        Lst<T[]> vProcess = null;
        long lastTime = System.currentTimeMillis();
        if (this.debugScript && this.debugHigh && !this.chk) {
            for (int i = this.pc; i < this.aatoken.length && i < this.pcEnd; ++i) {
                Logger.info("Command " + i);
                if (!this.debugScript) continue;
                this.logDebugScript(this.aatoken[i], 0);
            }
            Logger.info("-----");
        }
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd) {
            block26: {
                block29: {
                    block28: {
                        block27: {
                            block25: {
                                String script;
                                if (allowJSInterrupt) {
                                    if (!this.executionPaused && System.currentTimeMillis() - lastTime > 1000L) {
                                        --this.pc;
                                        this.doDelay(-1);
                                    }
                                    lastTime = System.currentTimeMillis();
                                }
                                if (!this.chk && !this.checkContinue() || this.pc >= this.lineNumbers.length || this.lineNumbers[this.pc] > this.lineEnd) break;
                                if (this.debugHigh) {
                                    long timeBegin = 0L;
                                    timeBegin = System.currentTimeMillis();
                                    this.vwr.scriptStatus("Eval.dispatchCommands():" + timeBegin);
                                    this.vwr.scriptStatus(this.script);
                                }
                                if (this.debugScript && !this.chk) {
                                    Logger.info("Command " + this.pc + (this.thisContext == null ? "" : " path=" + this.thisContext.contextPath));
                                }
                                T t = this.theToken = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                                if (!(this.historyDisabled || this.chk || this.scriptLevel > commandHistoryLevelMax || this.tQuiet)) {
                                    String cmdLine = this.getCommand(this.pc, true, true);
                                    if (!(this.theToken == null || cmdLine.length() <= 0 || cmdLine.equals(lastCommand) || this.theToken.tok != 134320141 && this.theToken.tok != 102436 && T.tokAttr(this.theToken.tok, 102400))) {
                                        lastCommand = cmdLine;
                                        this.vwr.addCommand(lastCommand);
                                    }
                                }
                                if (!this.chk && allowJSInterrupt && !"".equals(script = this.vwr.getInsertedCommand())) {
                                    this.runScript(script);
                                }
                                if (this.setStatement(this.aatoken[this.pc], 1)) break block25;
                                Logger.info(this.getCommand(this.pc, true, false) + " -- STATEMENT CONTAINING @{} SKIPPED");
                                break block26;
                            }
                            this.thisCommand = this.getCommand(this.pc, false, true);
                            if (this.debugHigh || this.debugScript) {
                                Logger.info(this.thisCommand);
                            }
                            String nextCommand = this.getCommand(this.pc + 1, false, true);
                            this.fullCommand = this.thisCommand + (nextCommand.startsWith("#") ? nextCommand : "");
                            this.getToken(0);
                            this.iToken = 0;
                            if ((this.listCommands || !this.chk && this.scriptLevel > 0) && !this.isJS) {
                                int milliSecDelay = this.vwr.getInt(0x2000000A);
                                if (this.listCommands || milliSecDelay > 0) {
                                    if (milliSecDelay > 0) {
                                        this.delayScript(-milliSecDelay);
                                    }
                                    this.vwr.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                                }
                            }
                            if (vProcess == null || this.theTok == 102409 && this.slen >= 2 && this.st[1].tok == 102439) break block27;
                            vProcess.addLast(this.st);
                            break block26;
                        }
                        if (!this.chk) break block28;
                        if (this.isCmdLine_c_or_C_Option) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.slen != 1 || this.st[0].tok == 134320141 || this.st[0].tok == 102436) break block29;
                        break block26;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(this.st, 0);
                    }
                    if (this.scriptLevel == 0 && this.vwr.g.logCommands) {
                        this.vwr.log(this.thisCommand);
                    }
                    if (this.debugHigh && this.theToken != null) {
                        Logger.debug(this.theToken.toString());
                    }
                }
                if (this.theToken != null) {
                    int tok = this.theToken.tok;
                    switch (tok) {
                        case 36867: {
                            this.cmdSet();
                            break;
                        }
                        case 134320648: {
                            isForCheck = this.cmdFor(tok, isForCheck);
                            break;
                        }
                        case 102439: {
                            this.pushContext((ContextToken)this.theToken, "PROCESS");
                            if (this.parallelProcessor == null) break;
                            vProcess = new Lst<T[]>();
                            break;
                        }
                        default: {
                            if (T.tokAttr(tok, 102400)) {
                                isForCheck = this.cmdFlow(tok, isForCheck, vProcess);
                                if (this.theTok != 102439) break;
                                vProcess = null;
                                break;
                            }
                            this.processCommand(tok);
                            this.setCursorWait(false);
                            if (!this.executionStepping) break;
                            this.executionPaused = this.isCommandDisplayable(this.pc + 1);
                        }
                    }
                }
            }
            ++this.pc;
        }
    }

    private void processCommand(int tok) throws ScriptException {
        if (T.tokAttr(this.theToken.tok, 135168)) {
            this.processShapeCommand(tok);
            return;
        }
        switch (tok) {
            case 0: {
                if (this.chk || !this.vwr.getBoolean(603979880)) break;
                this.vwr.getChimeMessenger().showHash(this.outputBuffer, (String)this.theToken.value);
                break;
            }
            case 1275335685: {
                this.pushContext((ContextToken)this.theToken, "PUSH");
                break;
            }
            case 1275334681: {
                this.popContext(true, false);
                break;
            }
            case 0x10000022: {
                break;
            }
            case 4097: {
                this.cmdAnimation();
                break;
            }
            case 1610616835: {
                this.cmdBackground(1);
                break;
            }
            case 4100: {
                this.cmdBind();
                break;
            }
            case 4101: {
                this.cmdBondorder();
                break;
            }
            case 20488: {
                this.cmdCD();
                break;
            }
            case 12289: {
                this.cmdCenter(1);
                break;
            }
            case 1765808134: {
                this.cmdColor();
                break;
            }
            case 12290: {
                this.cmdDefine();
                break;
            }
            case 528397: {
                this.cmdDelay();
                break;
            }
            case 12291: {
                this.cmdDelete();
                break;
            }
            case 554176526: {
                this.cmdSlab(true);
                break;
            }
            case 1610625028: {
                this.cmdDisplay(true);
                break;
            }
            case 266255: 
            case 266281: {
                if (this.chk) break;
                if (this.pc > 0 && this.theToken.tok == 266255 && !this.vwr.autoExit) {
                    this.vwr.clearScriptQueue();
                }
                this.executionStopped = this.pc > 0 || !this.vwr.g.useScriptQueue;
                break;
            }
            case 266256: {
                if (this.chk) {
                    return;
                }
                if (this.outputBuffer != null) {
                    Logger.warn(this.outputBuffer.toString());
                }
                this.vwr.exitJmol();
                break;
            }
            case 1228935687: {
                this.cmdFile();
                break;
            }
            case 12293: {
                this.cmdFixed();
                break;
            }
            case 4114: {
                this.cmdFont(-1, 0.0f);
                break;
            }
            case 4115: 
            case 1094717454: {
                this.cmdModel(1);
                break;
            }
            case 0x40000000: {
                this.cmdFunc();
                break;
            }
            case 1275072526: {
                this.cmdGetProperty();
                break;
            }
            case 20500: {
                if (this.vwr.headless) break;
                this.cmdGoto(true);
                break;
            }
            case 20482: {
                this.cmdHelp();
                break;
            }
            case 12294: {
                this.cmdDisplay(false);
                break;
            }
            case 1613238294: {
                this.cmdHbond();
                break;
            }
            case 1610616855: {
                this.cmdHistory(1);
                break;
            }
            case 544771: {
                this.cmdHover();
                break;
            }
            case 266265: {
                if (this.chk) break;
                this.vwr.initialize(!this.isStateScript, false);
                break;
            }
            case 4122: {
                this.cmdInvertSelected();
                break;
            }
            case 134238732: {
                this.cmdScript(134238732, null, null);
                break;
            }
            case 134222849: {
                this.cmdLoad();
                break;
            }
            case 36869: {
                this.cmdLog();
                break;
            }
            case 528411: {
                this.cmdLoop();
                break;
            }
            case 20485: {
                this.cmdMessage();
                break;
            }
            case 4128: {
                this.cmdMove();
                break;
            }
            case 4129: {
                this.cmdMoveto();
                break;
            }
            case 20487: {
                this.cmdPause();
                break;
            }
            case 36865: {
                this.cmdPrint();
                break;
            }
            case 134256131: {
                this.cmdPrompt();
                break;
            }
            case 4139: 
            case 4165: {
                this.cmdUndoRedoMove();
                break;
            }
            case 266284: {
                this.refresh(true);
                break;
            }
            case 4141: {
                this.cmdReset();
                break;
            }
            case 12295: {
                this.cmdRestrict();
                break;
            }
            case 4143: {
                if (this.slen == 0) {
                    if (this.chk) break;
                    this.resumePausedExecution();
                    break;
                }
            }
            case 4142: {
                this.cmdRestore();
                break;
            }
            case 36866: {
                this.cmdReturn(null);
                break;
            }
            case 528432: {
                this.cmdRotate(false, false);
                break;
            }
            case 4145: {
                this.cmdRotate(false, true);
                break;
            }
            case 4146: {
                this.cmdSave();
                break;
            }
            case 134222850: {
                this.cmdScript(134222850, null, null);
                break;
            }
            case 1275082245: {
                this.cmdSelect(1);
                break;
            }
            case 1611141171: {
                this.cmdSelectionHalos(1);
                break;
            }
            case 554176565: {
                this.cmdSlab(false);
                break;
            }
            case 1611141175: {
                this.cmdRotate(true, false);
                break;
            }
            case 1611141176: {
                this.cmdSsbond();
                break;
            }
            case 266298: {
                if (!this.cmdPause()) break;
                this.stepPausedExecution();
                break;
            }
            case 1639976963: {
                this.cmdStructure();
                break;
            }
            case 2109448: {
                this.cmdSubset();
                break;
            }
            case 4156: {
                this.cmdSync();
                break;
            }
            case 36870: {
                this.cmdThrow();
                break;
            }
            case 536875070: {
                this.cmdTimeout(1);
                break;
            }
            case 4160: {
                this.cmdTranslate(false);
                break;
            }
            case 4162: {
                this.cmdTranslate(true);
                break;
            }
            case 4164: {
                this.cmdUnbind();
                break;
            }
            case 36868: {
                break;
            }
            case 4166: {
                this.cmdVibration();
                break;
            }
            case 12297: {
                this.cmdZap(true);
                break;
            }
            case 4168: {
                this.cmdZoom(false);
                break;
            }
            case 4170: {
                this.cmdZoom(true);
                break;
            }
            default: {
                this.checkExtension(this.theToken.tok);
            }
        }
    }

    private void checkExtension(int tok) throws ScriptException {
        switch (tok) {
            case 4098: 
            case 4102: 
            case 4103: 
            case 4105: 
            case 4106: 
            case 4120: 
            case 4124: 
            case 4125: 
            case 4126: 
            case 4130: 
            case 4131: 
            case 4133: 
            case 4138: 
            case 528395: 
            case 528443: 
            case 134221829: 
            case 134221831: 
            case 134221834: 
            case 134221850: 
            case 134221856: 
            case 134222350: 
            case 1094717448: 
            case 1275072532: 
            case 1613238294: {
                this.getCmdExt().dispatch(tok, false, this.st);
                break;
            }
            default: {
                System.out.println(T.nameOf(tok) + " is not a command");
                this.error(47);
            }
        }
    }

    private void processShapeCommand(int tok) throws ScriptException {
        int iShape = 0;
        switch (tok) {
            case 1611272194: {
                iShape = 34;
                break;
            }
            case 1114249217: {
                iShape = 9;
                break;
            }
            case 1678381065: {
                iShape = 32;
                break;
            }
            case 1112152066: {
                iShape = 11;
                break;
            }
            case 135174: {
                iShape = 23;
                break;
            }
            case 134353926: {
                iShape = 25;
                break;
            }
            case 135175: {
                iShape = 17;
                break;
            }
            case 1112150019: {
                iShape = 16;
                break;
            }
            case 135176: {
                iShape = 22;
                break;
            }
            case 537022465: {
                iShape = 31;
                break;
            }
            case 1112150020: {
                iShape = 20;
                break;
            }
            case 1611272202: {
                iShape = 36;
                break;
            }
            case 1112150021: {
                iShape = 19;
                break;
            }
            case 1112152070: {
                iShape = 8;
                break;
            }
            case 135180: {
                iShape = 24;
                break;
            }
            case 1825200146: {
                iShape = 5;
                break;
            }
            case 135182: {
                iShape = 26;
                break;
            }
            case 0x20021010: 
            case 1745489939: {
                iShape = 6;
                break;
            }
            case 1112152071: {
                iShape = 13;
                break;
            }
            case 1073877010: {
                iShape = 27;
                break;
            }
            case 1073877011: {
                iShape = 28;
                break;
            }
            case 135190: {
                iShape = 30;
                break;
            }
            case 135188: {
                iShape = 29;
                break;
            }
            case 1275203608: {
                iShape = 21;
                break;
            }
            case 1112152073: {
                iShape = 14;
                break;
            }
            case 1112152074: {
                iShape = 15;
                break;
            }
            case 1112152075: {
                iShape = 0;
                break;
            }
            case 1112152076: {
                iShape = 7;
                break;
            }
            case 1649022989: {
                iShape = 12;
                break;
            }
            case 659482: {
                iShape = 4;
                break;
            }
            case 1112152078: {
                iShape = 10;
                break;
            }
            case 1814695966: {
                iShape = 33;
                break;
            }
            case 135198: {
                iShape = 18;
                break;
            }
            case 659488: {
                iShape = 1;
                break;
            }
            default: {
                this.error(47);
            }
        }
        if (this.sm.getShape(iShape) == null && this.slen == 2) {
            switch (this.st[1].tok) {
                case 12291: 
                case 1073742333: 
                case 1073742334: {
                    return;
                }
            }
        }
        switch (tok) {
            case 1112152066: 
            case 1112152071: 
            case 1112152073: 
            case 1112152074: 
            case 1112152078: 
            case 1114249217: 
            case 1649022989: {
                this.setSizeBio(iShape);
                return;
            }
            case 1112150019: 
            case 1112150021: {
                this.cmdDots(iShape);
                return;
            }
            case 1112152070: 
            case 1112152075: 
            case 1112152076: {
                this.setSize(iShape, tok == 1112152070 ? -1000.0f : 1.0f);
                return;
            }
            case 1825200146: {
                this.cmdLabel(1, null);
                return;
            }
            case 135198: {
                this.cmdVector();
                return;
            }
            case 659488: {
                this.cmdWireframe();
                return;
            }
        }
        switch (tok) {
            case 1611272194: {
                this.cmdAxes(1);
                return;
            }
            case 1678381065: {
                this.cmdBoundbox(1);
                return;
            }
            case 537022465: {
                this.cmdEcho(1);
                return;
            }
            case 1611272202: {
                this.cmdFrank(1);
                return;
            }
            case 1814695966: {
                this.cmdUnitcell(1);
                return;
            }
            case 659482: 
            case 0x20021010: 
            case 1112150020: 
            case 1275203608: 
            case 1745489939: {
                this.getCmdExt().dispatch(iShape, false, this.st);
                return;
            }
            case 135174: 
            case 135175: 
            case 135176: 
            case 135180: 
            case 135182: 
            case 135188: 
            case 135190: 
            case 134353926: 
            case 1073877010: 
            case 1073877011: {
                this.getIsoExt().dispatch(iShape, false, this.st);
                return;
            }
        }
    }

    private void cmdAnimation() throws ScriptException {
        boolean animate = false;
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                animate = true;
            }
            case 1073742334: {
                if (this.chk) break;
                this.vwr.setAnimationOn(animate);
                break;
            }
            case 1073742029: {
                int morphCount = (int)this.floatParameter(2);
                if (this.chk) break;
                this.vwr.am.setMorphCount(Math.abs(morphCount));
                break;
            }
            case 1610625028: {
                this.iToken = 2;
                BS bs = this.tokAt(2) == 1073742327 ? null : this.atomExpressionAt(2);
                this.checkLength(this.iToken + 1);
                if (!this.chk) {
                    this.vwr.setAnimDisplay(bs);
                }
                return;
            }
            case 4115: {
                if (this.isArrayParameter(2)) {
                    this.setFrameSet(2);
                    break;
                }
                this.cmdModel(2);
                break;
            }
            case 1073742024: {
                float startDelay = 1.0f;
                float endDelay = 1.0f;
                if (this.slen > 5) {
                    this.bad();
                }
                int animationMode = T.getTokFromName(this.paramAsStr(2));
                switch (animationMode) {
                    case 1073742070: {
                        endDelay = 0.0f;
                        startDelay = 0.0f;
                        break;
                    }
                    case 528411: 
                    case 1073742082: {
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                if (this.slen >= 4) {
                    startDelay = endDelay = this.floatParameter(3);
                    if (this.slen == 5) {
                        endDelay = this.floatParameter(4);
                    }
                }
                if (this.chk) break;
                this.vwr.am.setAnimationReplayMode(animationMode, startDelay, endDelay);
                break;
            }
            case 1073741918: {
                int i = 2;
                int direction = 0;
                switch (this.tokAt(i)) {
                    case 0x100000A0: {
                        direction = -this.intParameter(++i);
                        break;
                    }
                    case 0x100000A1: {
                        direction = this.intParameter(++i);
                        break;
                    }
                    case 2: {
                        direction = this.intParameter(i);
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                this.checkLength(++i);
                if (direction != 1 && direction != -1) {
                    this.errorStr2(35, "-1", "1");
                }
                if (this.chk) break;
                this.vwr.am.setAnimationDirection(direction);
                break;
            }
            case 1073741950: {
                this.setIntProperty("animationFps", this.intParameter(this.checkLast(2)));
                break;
            }
            default: {
                this.frameControl(1);
            }
        }
    }

    private void setFrameSet(int i) throws ScriptException {
        int[] frames = this.expandFloatArray(this.floatParameterSet(i, 0, Integer.MAX_VALUE), 1);
        this.checkLength(this.iToken + 1);
        if (this.chk) {
            return;
        }
        Hashtable<String, Object> movie = new Hashtable<String, Object>();
        if (frames.length > 0) {
            movie.put("frames", frames);
        }
        movie.put("currentFrame", 0);
        this.vwr.am.setMovie(movie);
    }

    private void cmdAxes(int index) throws ScriptException {
        TickInfo tickInfo = this.tickParamAsStr(index, true, true, false);
        index = this.iToken + 1;
        int tok = this.tokAt(index);
        String type = this.optParameterAsString(index).toLowerCase();
        if (this.slen == index + 1 && PT.isOneOf(type, ";window;unitcell;molecular;")) {
            this.setBooleanProperty("axes" + type, true);
            return;
        }
        switch (tok) {
            case 1073742066: {
                this.setFloatProperty("axisOffset", this.floatParameter(++index));
                this.checkLast(this.iToken);
                return;
            }
            case 12289: {
                this.setShapeProperty(34, "origin", this.centerParameter(index + 1, null));
                this.checkLast(this.iToken);
                return;
            }
            case 0x44000008: {
                String s = this.stringParameter(index + 1);
                if (!PT.isOneOf(s, ";a;b;c;ab;ac;bc;abc;")) {
                    s = null;
                }
                this.setShapeProperty(34, "type", s);
                this.checkLast(this.iToken);
                return;
            }
            case 1073742138: {
                this.setFloatProperty("axesScale", this.floatParameter(this.checkLast(++index)));
                return;
            }
            case 1825200146: {
                tok = this.tokAt(index + 1);
                switch (tok) {
                    case 1073742334: 
                    case 1073742335: {
                        this.checkLength(index + 2);
                        this.setShapeProperty(34, "labels" + (tok == 1073742335 ? "On" : "Off"), null);
                        return;
                    }
                }
                String sOrigin = null;
                switch (this.slen - index) {
                    case 7: {
                        this.setShapeProperty(34, "labels", new String[]{this.paramAsStr(++index), this.paramAsStr(++index), this.paramAsStr(++index), this.paramAsStr(++index), this.paramAsStr(++index), this.paramAsStr(++index)});
                        break;
                    }
                    case 5: {
                        sOrigin = this.paramAsStr(index + 4);
                    }
                    case 4: {
                        this.setShapeProperty(34, "labels", new String[]{this.paramAsStr(++index), this.paramAsStr(++index), this.paramAsStr(++index), sOrigin});
                        break;
                    }
                    default: {
                        this.bad();
                    }
                }
                return;
            }
        }
        if (type.equals("position")) {
            P3 xyp;
            if (this.tokAt(++index) == 1073742334) {
                xyp = new P3();
            } else {
                xyp = this.xypParameter(index);
                if (xyp == null) {
                    this.invArg();
                }
                index = this.iToken;
            }
            this.setShapeProperty(34, "position", xyp);
            return;
        }
        int mad10 = this.getSetAxesTypeMad10(index);
        if (this.chk || mad10 == Integer.MAX_VALUE) {
            return;
        }
        this.setObjectMad10(34, "axes", mad10);
        if (tickInfo != null) {
            this.setShapeProperty(34, "tickInfo", tickInfo);
        }
    }

    private void cmdBackground(int i) throws ScriptException {
        this.getToken(i);
        if (this.theTok == 4120) {
            Object o = null;
            switch (this.tokAt(++i)) {
                case 6: 
                case 15: {
                    o = this.getToken((int)i).value;
                    break;
                }
                default: {
                    String file = this.paramAsStr(this.checkLast(i));
                    if (this.chk) {
                        return;
                    }
                    if (file.equalsIgnoreCase("none") || file.length() == 0) {
                        this.vwr.setBackgroundImage(null, null);
                        return;
                    }
                    o = file.startsWith(";base64,") ? new BArray(Base64.decodeBase64(file)) : file;
                }
            }
            if (this.vwr.fm.loadImage(o, null, !this.useThreads())) {
                throw new ScriptInterruption(this, "backgroundImage", 1);
            }
            return;
        }
        if (this.theTok == 1073742333 || this.isColorParam(i)) {
            int argb = this.getArgbParamLast(i, true);
            if (this.chk) {
                return;
            }
            this.setObjectArgb("background", argb);
            this.vwr.setBackgroundImage(null, null);
            return;
        }
        int iShape = this.getShapeType(this.theTok);
        this.colorShape(iShape, i + 1, true);
    }

    private void cmdBind() throws ScriptException {
        String mouseAction = this.stringParameter(1);
        String name = this.paramAsStr(2);
        this.checkLength(3);
        if (!this.chk) {
            this.vwr.bindAction(mouseAction, name);
        }
    }

    private void cmdBondorder() throws ScriptException {
        this.checkLength(-3);
        int order = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                order = Edge.getBondOrderFromFloat(this.floatParameter(1));
                if (order != 131071) break;
                this.invArg();
                break;
            }
            default: {
                order = ScriptEval.getBondOrderFromString(this.paramAsStr(1));
                if (order == 131071) {
                    this.invArg();
                }
                if (order != 33 || this.tokAt(2) != 3) break;
                order = ScriptEval.getPartialBondOrderFromFloatEncodedInt(this.st[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", order);
    }

    private void cmdBoundbox(int index) throws ScriptException {
        boolean byCorner;
        TickInfo tickInfo = this.tickParamAsStr(index, false, true, false);
        index = this.iToken + 1;
        float scale = 1.0f;
        if (this.tokAt(index) == 1073742138) {
            scale = this.floatParameter(++index);
            if (!this.chk && scale == 0.0f) {
                this.invArg();
            }
            if (++index == this.slen) {
                if (!this.chk) {
                    this.vwr.ms.setBoundBox(null, null, true, scale);
                }
                return;
            }
        }
        boolean bl = byCorner = this.tokAt(index) == 0x4000004E;
        if (byCorner) {
            ++index;
        }
        if (this.isCenterParameter(index)) {
            Object[] ret = new Object[1];
            int index0 = index;
            P3 pt1 = this.centerParameter(index, ret);
            index = this.iToken + 1;
            if (byCorner || this.isCenterParameter(index)) {
                P3 pt2 = byCorner ? this.centerParameter(index, ret) : this.getPoint3f(index, true);
                index = this.iToken + 1;
                if (!this.chk) {
                    this.vwr.ms.setBoundBox(pt1, pt2, byCorner, scale);
                }
            } else if (ret[0] != null && ret[0] instanceof BS) {
                if (!this.chk) {
                    this.vwr.calcBoundBoxDimensions((BS)ret[0], scale);
                }
            } else if (ret[0] == null && this.tokAt(index0) == 1073742330) {
                P3[] bbox;
                if (this.chk) {
                    return;
                }
                if ((bbox = this.getObjectBoundingBox(this.objectNameParameter(++index0))) == null) {
                    this.invArg();
                }
                this.vwr.ms.setBoundBox(bbox[0], bbox[1], true, scale);
                index = this.iToken + 1;
            } else {
                this.invArg();
            }
            if (index == this.slen) {
                return;
            }
        }
        int mad10 = this.getSetAxesTypeMad10(index);
        if (this.chk || mad10 == Integer.MAX_VALUE) {
            return;
        }
        if (tickInfo != null) {
            this.setShapeProperty(32, "tickInfo", tickInfo);
        }
        this.setObjectMad10(32, "boundbox", mad10);
    }

    private void cmdCD() throws ScriptException {
        if (this.chk) {
            return;
        }
        String dir = this.slen == 1 ? null : this.paramAsStr(1);
        this.showString(this.vwr.cd(dir));
    }

    private void cmdCenter(int i) throws ScriptException {
        if (this.slen == 1) {
            this.vwr.setNewRotationCenter(null);
            return;
        }
        P3 center = this.centerParameter(i, null);
        if (center == null) {
            this.invArg();
        }
        if (!this.chk) {
            this.vwr.setNewRotationCenter(center);
        }
    }

    private void cmdColor() throws ScriptException {
        String strColor;
        int i = 1;
        String string = strColor = this.tokAt(1) == 4 ? this.stringParameter(1) : null;
        if (this.isColorParam(1)) {
            this.theTok = 0x44000001;
        } else {
            int argb = 0;
            i = 2;
            int tok = this.getToken((int)1).tok;
            if (tok == 4 && (tok = T.getTokFromName(strColor)) == 0) {
                tok = 4;
            }
            switch (tok) {
                case 1073742330: {
                    this.setObjectProperty();
                    return;
                }
                case 0x200002: 
                case 0x20000E: 
                case 603979967: 
                case 1073741946: 
                case 1073741991: 
                case 1073742074: 
                case 1073742110: 
                case 1073742116: 
                case 0x40000140: 
                case 1073742186: 
                case 1073742333: 
                case 1086324739: 
                case 1086324742: 
                case 1086324746: 
                case 1086326788: 
                case 0x41400010: 
                case 0x41400011: 
                case 1094713362: 
                case 1111490574: 
                case 1111490575: 
                case 1111492619: 
                case 1111492620: 
                case 1112152075: 
                case 1113589786: 
                case 1631586315: 
                case 1639976963: 
                case 1648363544: 
                case 1715472409: {
                    this.theTok = 0x44000001;
                    i = 1;
                    break;
                }
                case 4: {
                    boolean isTranslucent;
                    i = 2;
                    if (this.isArrayParameter(i)) {
                        strColor = strColor + "=" + SV.sValue(SV.getVariableAS(this.stringParameterSet(i))).replace('\n', ' ');
                        i = this.iToken + 1;
                    }
                    boolean bl = isTranslucent = this.tokAt(i) == 603979967;
                    if (!this.chk) {
                        this.vwr.setPropertyColorScheme(strColor, isTranslucent, true);
                    }
                    if (isTranslucent) {
                        ++i;
                    }
                    if (this.tokAt(i) == 1073742114 || this.tokAt(i) == 0x40000002) {
                        float min = this.floatParameter(++i);
                        float max = this.floatParameter(++i);
                        if (!this.chk) {
                            this.vwr.cm.setPropertyColorRange(min, max);
                        }
                    }
                    return;
                }
                case 0x40000002: 
                case 1073742114: {
                    float min = this.floatParameter(2);
                    float max = this.floatParameter(this.checkLast(3));
                    if (!this.chk) {
                        this.vwr.cm.setPropertyColorRange(min, max);
                    }
                    return;
                }
                case 1610616835: {
                    argb = this.getArgbParamLast(2, true);
                    if (!this.chk) {
                        this.setObjectArgb("background", argb);
                    }
                    return;
                }
                case 10: 
                case 1073742325: {
                    i = -1;
                    this.theTok = 0x44000001;
                    break;
                }
                case 1073742134: {
                    argb = this.getArgbParamLast(2, false);
                    if (!this.chk) {
                        this.vwr.cm.setRubberbandArgb(argb);
                    }
                    return;
                }
                case 0x20000008: 
                case 1611141171: {
                    i = 2;
                    if (this.tokAt(2) == 1073742074) {
                        ++i;
                    }
                    argb = this.getArgbParamLast(i, true);
                    if (this.chk) {
                        return;
                    }
                    this.sm.loadShape(8);
                    this.setShapeProperty(8, tok == 1611141171 ? "argbSelection" : "argbHighlight", argb);
                    return;
                }
                case 0x40000000: 
                case 1611272194: 
                case 1612709900: 
                case 1678381065: 
                case 1814695966: {
                    String str = this.paramAsStr(1);
                    if (this.checkToken(2)) {
                        argb = this.getToken((int)2).tok;
                        switch (argb) {
                            case 1073742333: {
                                argb = 1073741991;
                                break;
                            }
                            case 1073741991: 
                            case 1073742110: 
                            case 1073742116: {
                                break;
                            }
                            default: {
                                argb = this.getArgbParam(2);
                            }
                        }
                    }
                    if (argb == 0) {
                        this.error(9);
                    }
                    this.checkLast(this.iToken);
                    if (str.equalsIgnoreCase("axes") || StateManager.getObjectIdFromName(str) >= 0) {
                        this.setObjectArgb(str, argb);
                        return;
                    }
                    if (this.setElementColor(str, argb)) {
                        return;
                    }
                    this.invArg();
                    break;
                }
                case 135180: 
                case 134353926: {
                    this.setShapeProperty(JC.shapeTokenIndex(tok), "thisID", "+PREVIOUS_MESH+");
                }
            }
        }
        this.colorShape(this.getShapeType(this.theTok), i, false);
    }

    private void cmdDefine() throws ScriptException {
        boolean isDynamic;
        String setName;
        if (this.slen < 3 || !(this.getToken((int)1).value instanceof String)) {
            this.invArg();
        }
        if (PT.parseInt(setName = ((String)this.getToken((int)1).value).toLowerCase()) != Integer.MIN_VALUE) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        boolean isSite = setName.startsWith("site_");
        boolean bl = isDynamic = setName.indexOf("dynamic_") == 0;
        if (isDynamic || isSite) {
            T[] code = new T[this.slen];
            int i = this.slen;
            while (--i >= 0) {
                code[i] = this.st[i];
            }
            this.vwr.definedAtomSets.put("!" + (isSite ? setName : setName.substring(8)), code);
        } else {
            BS bs = this.atomExpressionAt(2);
            this.vwr.definedAtomSets.put(setName, bs);
            if (!this.chk) {
                this.vwr.g.setUserVariable("@" + setName, SV.newV(10, bs));
            }
        }
    }

    private void cmdDelay() throws ScriptException {
        int millis = 0;
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                millis = 1;
                break;
            }
            case 2: {
                millis = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                millis = (int)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(34);
            }
        }
        this.refresh(false);
        this.doDelay(Math.abs(millis));
    }

    private void cmdDelete() throws ScriptException {
        BS bs;
        if (this.tokAt(1) == 1073742330) {
            if (this.slen == 4 && this.optParameterAsString(2).equals("saved") && this.slen == 4) {
                this.vwr.stm.deleteSaved(this.optParameterAsString(3));
                if (this.doReport()) {
                    this.report(GT.o(GT._("show saved: {0}"), this.vwr.stm.listSavedStates()), false);
                }
                return;
            }
            this.setObjectProperty();
            return;
        }
        BS bS = bs = this.slen == 1 ? null : this.atomExpression(this.st, 1, 0, true, false, null, false);
        if (this.chk) {
            return;
        }
        if (bs == null) {
            bs = this.vwr.getAllAtoms();
        }
        int nDeleted = this.vwr.deleteAtoms(bs, false);
        if (this.doReport()) {
            this.report(GT.i(GT._("{0} atoms deleted"), nDeleted), false);
        }
    }

    private void cmdDisplay(boolean isDisplay) throws ScriptException {
        boolean isGroup;
        BS bs = null;
        int addRemove = 0;
        int i = 1;
        int tok = this.tokAt(1);
        switch (tok) {
            case 1073742119: 
            case 1275069441: {
                addRemove = tok;
                tok = this.tokAt(++i);
            }
        }
        boolean bl = isGroup = tok == 1086324742;
        if (isGroup) {
            tok = this.tokAt(++i);
        }
        switch (tok) {
            case 1073742330: {
                this.setObjectProperty();
                return;
            }
            case 0: {
                break;
            }
            default: {
                bs = this.slen == 4 && this.tokAt(2) == 1677721602 ? BondSet.newBS(BSUtil.newBitSet2(0, this.vwr.ms.bondCount), null) : this.atomExpressionAt(i);
            }
        }
        if (this.chk) {
            return;
        }
        if (bs instanceof BondSet) {
            this.vwr.ms.displayBonds((BondSet)bs, isDisplay);
            return;
        }
        this.vwr.displayAtoms(bs, isDisplay, isGroup, addRemove, this.tQuiet);
    }

    private void cmdDots(int iShape) throws ScriptException {
        RadiusData rd;
        if (!this.chk) {
            this.sm.loadShape(iShape);
        }
        this.setShapeProperty(iShape, "init", null);
        float value = Float.NaN;
        RadiusData.EnumType type = RadiusData.EnumType.ABSOLUTE;
        int ipt = 1;
        block7: while (true) {
            switch (this.getToken((int)ipt).tok) {
                case 1073742072: {
                    this.restrictSelected(false, false);
                }
                case 1073742335: {
                    value = 1.0f;
                    type = RadiusData.EnumType.FACTOR;
                    break block7;
                }
                case 1073742334: {
                    value = 0.0f;
                    break block7;
                }
                case 1073741976: {
                    this.setShapeProperty(iShape, "ignore", this.atomExpressionAt(ipt + 1));
                    ipt = this.iToken + 1;
                    continue block7;
                }
                case 2: {
                    int dotsParam = this.intParameter(ipt);
                    if (this.tokAt(ipt + 1) != 1665140738) break block7;
                    ++ipt;
                    this.setShapeProperty(iShape, "atom", dotsParam);
                    this.setShapeProperty(iShape, "radius", Float.valueOf(this.floatParameter(++ipt)));
                    if (this.tokAt(++ipt) == 1765808134) {
                        this.setShapeProperty(iShape, "colorRGB", this.getArgbParam(++ipt));
                        ++ipt;
                    }
                    if (this.getToken((int)ipt).tok != 10) {
                        this.invArg();
                    }
                    this.setShapeProperty(iShape, "dots", this.st[ipt].value);
                    return;
                }
            }
            break;
        }
        RadiusData radiusData = rd = Float.isNaN(value) ? this.encodeRadiusParameter(ipt, false, true) : new RadiusData(null, value, type, VDW.AUTO);
        if (rd == null) {
            return;
        }
        if (Float.isNaN(rd.value)) {
            this.invArg();
        }
        this.setShapeSize(iShape, rd);
    }

    private void cmdEcho(int index) throws ScriptException {
        if (this.chk) {
            return;
        }
        String text = this.optParameterAsString(index);
        boolean doRefresh = true;
        if (this.vwr.ms.getEchoStateActive()) {
            if (text.startsWith("\u0001")) {
                text = text.substring(1);
                doRefresh = false;
            }
            if (text != null) {
                this.setShapeProperty(31, "text", text);
            }
        }
        if (doRefresh && this.vwr.getRefreshing()) {
            this.showString(Txt.formatText(this.vwr, text));
        }
    }

    private void cmdFile() throws ScriptException {
        int file = this.intParameter(this.checkLast(1));
        if (this.chk) {
            return;
        }
        int modelIndex = this.vwr.ms.getModelNumberIndex(file * 1000000 + 1, false, false);
        int modelIndex2 = -1;
        if (modelIndex >= 0) {
            modelIndex2 = this.vwr.ms.getModelNumberIndex((file + 1) * 1000000 + 1, false, false);
            if (modelIndex2 < 0) {
                modelIndex2 = this.vwr.ms.mc;
            }
            --modelIndex2;
        }
        this.vwr.setAnimationOn(false);
        this.vwr.am.setAnimationDirection(1);
        this.vwr.setAnimationRange(modelIndex, modelIndex2);
        this.vwr.setCurrentModelIndex(-1);
    }

    private void cmdFixed() throws ScriptException {
        BS bs;
        BS bS = bs = this.slen == 1 ? null : this.atomExpressionAt(1);
        if (this.chk) {
            return;
        }
        this.vwr.setMotionFixedAtoms(bs);
    }

    private boolean cmdFor(int tok, boolean isForCheck) throws ScriptException {
        ContextToken cmdToken = (ContextToken)this.theToken;
        int pt = this.st[0].intValue;
        SV[] forVars = cmdToken.forVars;
        int[] pts = new int[2];
        Object[] bsOrList = null;
        SV forVal = null;
        SV forVar = null;
        int inTok = 0;
        boolean isOK = true;
        boolean isMinusMinus = false;
        int j = 0;
        String key = null;
        if (isForCheck && forVars != null) {
            tok = 1275068432;
            forVar = forVars[0];
            forVal = forVars[1];
            bsOrList = forVars[1].value;
            j = ++forVal.intValue;
            if (forVal.tok == 2) {
                isMinusMinus = j < 0;
                int i1 = ((int[])bsOrList)[0];
                int i2 = ((int[])bsOrList)[1];
                boolean bl = i1 != i2 && i2 < i1 == isMinusMinus ? true : (isOK = false);
                if (isOK) {
                    int n = i1 + (isMinusMinus ? -1 : 1);
                    ((int[])bsOrList)[0] = n;
                    forVar.intValue = n;
                }
                j = -1;
            } else if (forVal.tok == 7) {
                boolean bl = isOK = j <= ((Lst)bsOrList).size();
                if (isOK) {
                    forVar.setv(SV.selectItemVar(forVal));
                }
                j = -1;
            } else {
                this.isBondSet = bsOrList instanceof BondSet;
                isOK = (j = ((BS)bsOrList).nextSetBit(j)) >= 0;
            }
        } else {
            boolean isLocal = false;
            int nSkip = 0;
            block11: for (int i = 1; i < this.slen && j < 2; ++i) {
                tok = this.tokAt(i);
                switch (tok) {
                    case 36868: {
                        isLocal = true;
                        continue block11;
                    }
                    case 1073742339: {
                        if (nSkip > 0) {
                            --nSkip;
                            continue block11;
                        }
                        pts[j++] = i;
                        continue block11;
                    }
                    case 0x40000080: 
                    case 1275068432: {
                        key = this.paramAsStr(i - 1);
                        nSkip -= 2;
                        if (this.tokAt(++i) == 1073742325 || this.tokAt(i) == 10) {
                            inTok = 10;
                            bsOrList = this.atomExpressionAt(i);
                            if (this.isBondSet) {
                                bsOrList = BondSet.newBS((BS)bsOrList, null);
                            }
                            isOK = ((BS)bsOrList).nextSetBit(0) >= 0;
                        } else {
                            Lst<SV> what = this.parameterExpressionList(-i, 1, false);
                            if (what == null || what.size() < 1) {
                                this.invArg();
                            }
                            SV vl = (SV)what.get(0);
                            inTok = vl.tok;
                            switch (inTok) {
                                case 10: {
                                    bsOrList = vl.value;
                                    isOK = !((BS)bsOrList).isEmpty();
                                    break;
                                }
                                case 7: {
                                    Object[] v = vl.getList();
                                    j = v.size();
                                    boolean bl = isOK = j > 0;
                                    if (isOK && tok == 0x40000080) {
                                        int[] i12 = new int[]{SV.iValue((T)v.get(0)), SV.iValue((T)v.get(j - 1))};
                                        isMinusMinus = i12[1] < i12[0];
                                        bsOrList = i12;
                                        tok = 1275068432;
                                        inTok = 2;
                                        break;
                                    }
                                    bsOrList = v;
                                    break;
                                }
                                case 6: {
                                    Map<String, SV> m = vl.getMap();
                                    int n = m.keySet().size();
                                    boolean bl = isOK = n > 0;
                                    if (!isOK) break;
                                    Object[] keys = new String[n];
                                    m.keySet().toArray(keys);
                                    Arrays.sort(keys);
                                    bsOrList = keys;
                                    break;
                                }
                                default: {
                                    this.invArg();
                                }
                            }
                        }
                        i = this.iToken;
                        continue block11;
                    }
                    case 1275082245: {
                        nSkip += 2;
                    }
                }
            }
            if (!isForCheck) {
                this.pushContext(cmdToken, "FOR");
                this.thisContext.forVars = forVars;
                forVars = null;
            }
            if (key == null) {
                j = isForCheck ? (bsOrList == null ? pts[1] + 1 : 2) : 2;
                if (this.tokAt(j) == 36868) {
                    ++j;
                }
                boolean bl = isMinusMinus = (key = this.paramAsStr(j)).equals("--") || key.equals("++");
                if (isMinusMinus) {
                    key = this.paramAsStr(++j);
                }
            }
            if (isOK) {
                if (tok == 1275068432) {
                    forVar = this.getContextVariableAsVariable(key, isLocal);
                    if (forVar == null && !isLocal) {
                        forVar = this.vwr.g.getAndSetNewVariable(key, false);
                    }
                    if (forVar == null || forVar.myName == null) {
                        if (key.startsWith("_")) {
                            this.invArg();
                        }
                        if (isLocal) {
                            forVar = SV.newI(0);
                            this.contextVariables.put(key.toLowerCase(), forVar);
                        } else {
                            forVar = this.vwr.g.getAndSetNewVariable(key, true);
                        }
                    }
                    if (inTok == 2) {
                        forVar.tok = 2;
                        forVar.intValue = ((int[])bsOrList)[0];
                        forVal = SV.newV(2, bsOrList);
                        forVal.intValue = isMinusMinus ? Integer.MIN_VALUE : 0;
                        j = -1;
                    } else {
                        forVal = SV.getVariable(bsOrList);
                        if (inTok == 10) {
                            j = ((BS)bsOrList).nextSetBit(0);
                            forVal.intValue = 0;
                        } else {
                            forVal.intValue = 1;
                            forVar.setv(SV.selectItemVar(forVal));
                            j = -1;
                        }
                    }
                    if (forVars == null) {
                        forVars = cmdToken.forVars = new SV[2];
                    }
                    forVars[0] = forVar;
                    forVars[1] = forVal;
                } else {
                    int vtok = this.tokAt(j);
                    if (vtok != 1073742339 && (T.tokAttr(vtok, 0x40000000) || (forVal = this.getContextVariableAsVariable(key, false)) != null)) {
                        if (!isMinusMinus && this.getToken((int)(++j)).tok != 268435860) {
                            this.invArg();
                        }
                        if (isMinusMinus) {
                            j -= 2;
                        }
                        this.setVariable(++j, this.slen - 1, key, false);
                    }
                    boolean bl = isOK = pts[0] + 1 == pts[1] || this.parameterExpressionBoolean(pts[0] + 1, pts[1]);
                }
            }
        }
        if (isOK && tok == 1275068432 && j >= 0) {
            forVal.intValue = j;
            forVar.tok = 10;
            if (this.isBondSet) {
                forVar.value = new BondSet();
                ((BondSet)forVar.value).set(j);
            } else {
                forVar.value = BSUtil.newAndSetBit(j);
            }
        }
        ++pt;
        if (!isOK) {
            cmdToken.forVars = this.thisContext.forVars;
            this.popContext(true, false);
        }
        isForCheck = false;
        if (!isOK && !this.chk) {
            this.pc = Math.abs(pt) - 1;
        }
        return isForCheck;
    }

    private boolean cmdFlow(int tok, boolean isForCheck, Lst<T[]> vProcess) throws ScriptException {
        boolean continuing;
        int pt;
        block35: {
            pt = this.st[0].intValue;
            boolean isDone = pt < 0 && !this.chk;
            continuing = true;
            int ptNext = 0;
            block0 : switch (tok) {
                case 102436: 
                case 134320141: {
                    this.cmdFunc();
                    return isForCheck;
                }
                case 364558: {
                    return isForCheck;
                }
                case 102412: {
                    ContextToken ct = (ContextToken)this.theToken;
                    this.pushContext(ct, "CATCH");
                    if (!isDone && ct.name0 != null) {
                        this.contextVariables.put(ct.name0, ct.contextVariables.get(ct.name0));
                    }
                    continuing = !isDone;
                    this.st[0].intValue = -Math.abs(pt);
                    break;
                }
                case 102410: 
                case 102411: 
                case 102413: {
                    ptNext = Math.abs(this.aatoken[Math.abs((int)pt)][0].intValue);
                    switch (isDone ? 0 : this.cmdFlowSwitch((ContextToken)this.theToken, tok)) {
                        case 0: {
                            ptNext = -ptNext;
                            continuing = false;
                            break;
                        }
                        case -1: {
                            continuing = false;
                            break;
                        }
                    }
                    this.aatoken[this.pc][0].intValue = Math.abs(pt);
                    this.theToken = this.aatoken[Math.abs(pt)][0];
                    if (this.theToken.tok == 102409) break;
                    this.theToken.intValue = ptNext;
                    break;
                }
                case 102402: 
                case 134320649: {
                    boolean bl = continuing = !isDone && this.parameterExpressionBoolean(1, 0);
                    if (this.chk) break;
                    ptNext = Math.abs(this.aatoken[Math.abs((int)pt)][0].intValue);
                    this.aatoken[Math.abs((int)pt)][0].intValue = ptNext = isDone || continuing ? -ptNext : ptNext;
                    if (tok != 102412) break;
                    this.aatoken[this.pc][0].intValue = -pt;
                    break;
                }
                case 364547: {
                    this.checkLength(1);
                    if (pt >= 0 || this.chk) break;
                    this.pc = -pt - 1;
                    break;
                }
                case 364548: {
                    this.checkLength(1);
                    break;
                }
                case 102406: {
                    if (!isForCheck) {
                        this.pushContext((ContextToken)this.theToken, "WHILE");
                    }
                    isForCheck = false;
                    if (this.parameterExpressionBoolean(1, 0) || this.chk) break;
                    this.pc = pt;
                    this.popContext(true, false);
                    break;
                }
                case 102407: {
                    if (!this.chk) {
                        this.breakAt(pt);
                        break;
                    }
                    if (this.slen == 1) break;
                    int n = this.intParameter(this.checkLast(1));
                    if (this.chk) break;
                    for (int i = 0; i < n; ++i) {
                        this.popContext(true, false);
                    }
                    break;
                }
                case 102408: {
                    isForCheck = true;
                    if (!this.chk) {
                        this.pc = pt - 1;
                    }
                    if (this.slen <= 1) break;
                    this.intParameter(this.checkLast(1));
                    break;
                }
                case 102409: {
                    switch (this.getToken((int)this.checkLast((int)1)).tok) {
                        case 364558: {
                            ScriptFunction trycmd = (ScriptFunction)this.getToken((int)1).value;
                            if (this.chk) {
                                return false;
                            }
                            this.runFunctionAndRet(trycmd, "try", null, null, true, true, true);
                            return false;
                        }
                        case 102436: 
                        case 134320141: {
                            this.vwr.addFunction((ScriptFunction)this.theToken.value);
                            return isForCheck;
                        }
                        case 102412: {
                            this.popContext(true, false);
                            break block0;
                        }
                        case 102439: {
                            this.addProcess(vProcess, pt, this.pc);
                            this.popContext(true, false);
                            break block0;
                        }
                        case 102410: {
                            if (pt > 0 && this.cmdFlowSwitch((ContextToken)this.aatoken[pt][0], 0) == -1) {
                                while (pt < this.pc && ((tok = this.aatoken[pt][0].tok) == 102413 || tok == 102411)) {
                                    ++pt;
                                }
                                continuing = this.pc == pt;
                                break block0;
                            }
                            break block35;
                        }
                        case 134320649: {
                            break block0;
                        }
                        case 102406: 
                        case 134320648: {
                            continuing = false;
                            isForCheck = true;
                        }
                    }
                }
            }
        }
        if (!continuing && !this.chk) {
            this.pc = Math.abs(pt) - 1;
        }
        return isForCheck;
    }

    private int cmdFlowSwitch(ContextToken c, int tok) throws ScriptException {
        SV var;
        if (tok == 102410) {
            c.addName("_var");
        }
        if ((var = c.contextVariables.get("_var")) == null) {
            return 1;
        }
        if (tok == 0) {
            c.contextVariables.remove("_var");
            return -1;
        }
        if (tok == 102413) {
            return -1;
        }
        SV v = this.parameterExpressionToken(1);
        if (tok == 102411) {
            boolean isOK = SV.areEqual(var, v);
            if (isOK) {
                c.contextVariables.remove("_var");
            }
            return isOK ? 1 : -1;
        }
        c.contextVariables.put("_var", v);
        return 1;
    }

    private void cmdFont(int shapeType, float fontsize) throws ScriptException {
        String fontface = "SansSerif";
        String fontstyle = "Plain";
        int sizeAdjust = 0;
        float scaleAngstromsPerPixel = -1.0f;
        this.iToken = this.slen;
        switch (this.iToken) {
            case 6: {
                scaleAngstromsPerPixel = this.floatParameter(5);
                if (scaleAngstromsPerPixel >= 5.0f) {
                    scaleAngstromsPerPixel = this.vwr.tm.getZoomSetting() / scaleAngstromsPerPixel / this.vwr.getScalePixelsPerAngstrom(false);
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 0x40000000) {
                    this.invArg();
                }
                fontstyle = this.paramAsStr(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 0x40000000) {
                    this.invArg();
                }
                fontface = this.paramAsStr(3);
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                fontsize = this.floatParameter(2);
                shapeType = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                if (shapeType == -1) {
                    shapeType = this.getShapeType(this.getToken((int)1).tok);
                    fontsize = this.floatParameter(2);
                    break;
                }
                if (!(fontsize >= 1.0f)) break;
                sizeAdjust = 5;
                fontsize += (float)5;
                break;
            }
            default: {
                if (shapeType == 5) {
                    fontsize = 13.0f;
                    break;
                }
                this.bad();
            }
        }
        if (shapeType == 5) {
            if (fontsize < 0.0f || fontsize >= 1.0f && (fontsize < 6.0f || fontsize > 63.0f)) {
                this.integerOutOfRange(6 - sizeAdjust, 63 - sizeAdjust);
                return;
            }
            this.setShapeProperty(5, "setDefaults", this.vwr.slm.noneSelected);
        }
        if (this.chk) {
            return;
        }
        if (Font.getFontStyleID(fontface) >= 0) {
            fontstyle = fontface;
            fontface = "SansSerif";
        }
        Font font3d = this.vwr.getFont3D(fontface, fontstyle, fontsize);
        this.sm.loadShape(shapeType);
        this.setShapeProperty(shapeType, "font", font3d);
        if (scaleAngstromsPerPixel >= 0.0f) {
            this.setShapeProperty(shapeType, "scalereference", Float.valueOf(scaleAngstromsPerPixel));
        }
    }

    private void cmdFrank(int i) throws ScriptException {
        boolean b = true;
        if (this.slen > i) {
            switch (this.getToken((int)this.checkLast((int)i)).tok) {
                case 1073742335: {
                    break;
                }
                case 1073742334: {
                    b = false;
                    break;
                }
                default: {
                    this.error(5);
                }
            }
        }
        this.setBooleanProperty("frank", b);
    }

    private void cmdFunc() throws ScriptException {
        Lst<SV> params;
        if (this.chk && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        String name = ((String)this.getToken((int)0).value).toLowerCase();
        if (!this.vwr.isFunction(name)) {
            this.error(10);
        }
        Lst<SV> lst = params = this.slen == 1 || this.slen == 3 && this.tokAt(1) == 0x10000010 && this.tokAt(2) == 0x10000011 ? null : this.parameterExpressionList(1, -1, false);
        if (this.chk) {
            return;
        }
        this.runFunctionAndRet(null, name, params, null, false, true, true);
    }

    private void cmdGetProperty() throws ScriptException {
        if (this.chk) {
            return;
        }
        String retValue = "";
        String property = this.optParameterAsString(1);
        String name = property;
        if (name.indexOf(".") >= 0) {
            name = name.substring(0, name.indexOf("."));
        }
        if (name.indexOf("[") >= 0) {
            name = name.substring(0, name.indexOf("["));
        }
        int propertyID = this.vwr.getPropertyNumber(name);
        Object param = "";
        switch (this.tokAt(2)) {
            default: {
                param = this.optParameterAsString(2);
                break;
            }
            case 10: 
            case 1073742325: {
                param = this.atomExpressionAt(2);
                if (!property.equalsIgnoreCase("bondInfo")) break;
                switch (this.tokAt(++this.iToken)) {
                    case 10: 
                    case 1073742325: {
                        param = new BS[]{(BS)param, this.atomExpressionAt(this.iToken)};
                    }
                }
            }
        }
        if (property.length() > 0 && propertyID < 0) {
            property = "";
            param = "";
        } else if (propertyID >= 0 && this.slen < 3) {
            param = this.vwr.getDefaultPropertyParam(propertyID);
            if (param.equals("(visible)")) {
                param = this.vwr.ms.getVisibleSet(true);
            }
        } else if (propertyID == this.vwr.getPropertyNumber("fileContents")) {
            String s = param.toString();
            for (int i = 3; i < this.slen; ++i) {
                s = s + this.paramAsStr(i);
            }
            param = s;
        }
        retValue = (String)this.vwr.getProperty("readable", property, param);
        this.showString(retValue);
    }

    private void cmdGoto(boolean isCmd) throws ScriptException {
        String strTo = isCmd ? this.paramAsStr(this.checkLast(1)) : null;
        int pcTo = strTo == null ? this.aatoken.length - 1 : -1;
        String s = null;
        block11: for (int i = pcTo + 1; i < this.aatoken.length; ++i) {
            T[] tokens = this.aatoken[i];
            int tok = tokens[0].tok;
            switch (tok) {
                case 0: 
                case 20485: {
                    s = (String)tokens[tokens.length - 1].value;
                    if (tok != 0) break;
                    s = s.substring(s.startsWith("#") ? 1 : 2);
                    break;
                }
                default: {
                    continue block11;
                }
            }
            if (!s.equalsIgnoreCase(strTo)) continue;
            pcTo = i;
            break;
        }
        if (pcTo < 0) {
            this.invArg();
        }
        if (strTo == null) {
            pcTo = 0;
        }
        int di = pcTo < this.pc ? 1 : -1;
        int nPush = 0;
        block12: for (int i = pcTo; i != this.pc; i += di) {
            switch (this.aatoken[i][0].tok) {
                case 102406: 
                case 102412: 
                case 102439: 
                case 134320648: 
                case 1275335685: {
                    ++nPush;
                    continue block12;
                }
                case 1275334681: {
                    --nPush;
                    continue block12;
                }
                case 102409: {
                    switch (this.aatoken[i][1].tok) {
                        case 102406: 
                        case 102412: 
                        case 102439: 
                        case 134320648: {
                            --nPush;
                        }
                    }
                }
            }
        }
        if (strTo == null) {
            pcTo = Integer.MAX_VALUE;
            while (nPush > 0) {
                this.popContext(false, false);
                --nPush;
            }
        }
        if (nPush != 0) {
            this.invArg();
        }
        if (!this.chk) {
            this.pc = pcTo - 1;
        }
    }

    private void cmdHbond() throws ScriptException {
        if (this.slen == 2 && this.getToken((int)1).tok == 4102) {
            if (this.chk) {
                return;
            }
            int n = this.vwr.autoHbond(null, null, false);
            this.report(GT.i(GT._("{0} hydrogen bonds"), Math.abs(n)), false);
            return;
        }
        if (this.slen == 2 && this.getToken((int)1).tok == 12291) {
            if (this.chk) {
                return;
            }
            this.checkExtension(1613238294);
            return;
        }
        int mad = this.getMadParameter();
        if (mad == Integer.MAX_VALUE) {
            return;
        }
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSizeBs(1, mad, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void cmdHelp() throws ScriptException {
        if (this.chk) {
            return;
        }
        String what = this.optParameterAsString(1).toLowerCase();
        int pt = 0;
        if (what.startsWith("mouse") && (pt = what.indexOf(" ")) >= 0 && pt == what.lastIndexOf(" ")) {
            this.showString(this.vwr.getBindingInfo(what.substring(pt + 1)));
            return;
        }
        if (T.tokAttr(T.getTokFromName(what), 4096)) {
            what = "?command=" + what;
        }
        this.vwr.getHelp(what);
    }

    private void cmdHistory(int pt) throws ScriptException {
        if (this.slen == 1) {
            this.showString(this.vwr.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (pt == 2) {
            int n = this.intParameter(this.checkLast(2));
            if (n < 0) {
                this.invArg();
            }
            if (!this.chk) {
                this.vwr.getSetHistory(n == 0 ? 0 : -2 - n);
            }
            return;
        }
        switch (this.getToken((int)this.checkLast((int)1)).tok) {
            case 1073741882: 
            case 1073742335: {
                if (!this.chk) {
                    this.vwr.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 1073742334: {
                if (this.chk) break;
                this.vwr.getSetHistory(0);
                break;
            }
            default: {
                this.errorStr(24, "ON, OFF, CLEAR");
            }
        }
    }

    private void cmdHover() throws ScriptException {
        String strLabel;
        if (this.chk) {
            return;
        }
        String string = strLabel = this.slen == 1 ? "on" : this.paramAsStr(1);
        if (strLabel.equalsIgnoreCase("on")) {
            strLabel = "%U";
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.vwr.setHoverLabel(strLabel);
    }

    private void cmdInvertSelected() throws ScriptException {
        P3 pt = null;
        P4 plane = null;
        BS bs = null;
        int iAtom = Integer.MIN_VALUE;
        switch (this.tokAt(1)) {
            case 0: {
                if (this.chk) {
                    return;
                }
                bs = this.vwr.bsA();
                pt = this.vwr.ms.getAtomSetCenter(bs);
                this.vwr.invertAtomCoordPt(pt, bs);
                return;
            }
            case 528443: {
                iAtom = this.atomExpressionAt(2).nextSetBit(0);
                bs = this.atomExpressionAt(this.iToken + 1);
                break;
            }
            case 134217751: {
                pt = this.centerParameter(2, null);
                break;
            }
            case 134217750: {
                plane = this.planeParameter(1);
                break;
            }
            case 134219265: {
                plane = this.hklParameter(2);
                break;
            }
            case 0x44000001: {
                bs = this.atomExpressionAt(2);
                if (!this.chk) {
                    int i = bs.nextSetBit(0);
                    while (i >= 0) {
                        this.vwr.invertRingAt(i, false);
                        i = bs.nextSetBit(i + 1);
                    }
                }
                return;
            }
        }
        this.checkLengthErrorPt(this.iToken + 1, 1);
        if (plane == null && pt == null && iAtom == Integer.MIN_VALUE) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (iAtom == -1) {
            return;
        }
        this.vwr.invertSelected(pt, plane, iAtom, bs);
    }

    private void cmdLabel(int index, BS bs) throws ScriptException {
        if (this.chk) {
            return;
        }
        this.sm.loadShape(5);
        Object strLabel = null;
        switch (this.getToken((int)index).tok) {
            case 1073742335: {
                strLabel = this.vwr.getStandardLabelFormat(0);
                break;
            }
            case 1073742334: {
                break;
            }
            case 12294: 
            case 1610625028: {
                this.setShapeProperty(5, "display", this.theTok == 1610625028 ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 7: {
                strLabel = this.theToken.value;
                break;
            }
            default: {
                strLabel = this.paramAsStr(index);
            }
        }
        this.sm.setLabel(strLabel, bs == null ? this.vwr.bsA() : bs);
    }

    public void cmdLoad() throws ScriptException {
        int tok;
        boolean doLoadFiles = !this.chk || this.isCmdLine_C_Option;
        boolean isAppend = false;
        boolean isInline = false;
        boolean isSmiles = false;
        boolean isMutate = false;
        boolean isData = false;
        boolean isAsync = this.vwr.async;
        boolean isConcat = false;
        boolean doOrient = false;
        boolean appendNew = this.vwr.getBoolean(603979792);
        String filename = null;
        int i = this.tokAt(0) == 134221834 ? 0 : 1;
        String filter = null;
        int modelCount0 = this.vwr.ms.mc - (this.vwr.fm.getFileName().equals("zapped") ? 1 : 0);
        int ac0 = this.vwr.ms.ac;
        SB loadScript = new SB().append("load");
        int nFiles = 1;
        Hashtable<String, Object> htParams = new Hashtable<String, Object>();
        if (this.isStateScript) {
            htParams.put("isStateScript", Boolean.TRUE);
            if (this.forceNoAddHydrogens) {
                htParams.put("doNotAddHydrogens", Boolean.TRUE);
            }
        }
        String modelName = null;
        String[] filenames = null;
        String[] tempFileInfo = null;
        String errMsg = null;
        SB sOptions = new SB();
        int tokType = 0;
        if (this.slen == 1) {
            i = 0;
        } else {
            modelName = this.paramAsStr(i);
            if (this.slen == 2 && !this.chk && (modelName.endsWith(".spt") || modelName.endsWith(".png") || modelName.endsWith(".pngj"))) {
                this.cmdScript(0, modelName, null);
                return;
            }
            tok = this.tokAt(i);
            switch (tok) {
                case 36868: {
                    String var = this.paramAsStr(++i);
                    filename = "@" + var;
                    Object o = this.getVarParameter(var, false);
                    if (!(o instanceof Map)) break;
                    this.checkLength(3);
                    this.loadPNGJVar(filename, o, htParams);
                    return;
                }
                case 1073742015: 
                case 1073877011: 
                case 1610616855: {
                    String m = this.paramAsStr(this.checkLast(2));
                    if (!this.chk) {
                        switch (tok) {
                            case 1073877011: {
                                htParams.put("service", "nbo");
                                htParams.put("mode", 1);
                                htParams.put("action", "load");
                                htParams.put("value", m);
                                htParams.put("sync", Boolean.TRUE);
                                this.vwr.sm.processService(htParams);
                                this.runScript((String)htParams.get("ret"));
                                break;
                            }
                            case 1610616855: {
                                this.vwr.setHistory(m);
                                break;
                            }
                            case 1073742015: {
                                this.vwr.setMenu(m, true);
                            }
                        }
                    }
                    return;
                }
                case 4130: {
                    isAppend = true;
                    isMutate = true;
                    appendNew = false;
                    loadScript.append(" mutate");
                    modelName = this.optParameterAsString(++i);
                    tok = T.getTokFromName(modelName);
                    break;
                }
                case 0x4000000F: {
                    isAppend = true;
                    loadScript.append(" append");
                    modelName = this.optParameterAsString(++i);
                    tok = T.getTokFromName(modelName);
                    break;
                }
                case 1073742077: {
                    doOrient = true;
                    loadScript.append(" orientation");
                    this.vwr.stm.saveOrientation("preload", null);
                    modelName = this.optParameterAsString(++i);
                    tok = T.getTokFromName(modelName);
                    break;
                }
                case 1073741851: {
                    if (!this.chk) {
                        this.vwr.playAudio(this.optParameterAsString(++i));
                    }
                    return;
                }
                case 0x40000000: {
                    ++i;
                    loadScript.append(" " + modelName);
                    int n = tokType = tok == 0x40000000 && PT.isOneOf(modelName.toLowerCase(), ";xyz;vxyz;vibration;temperature;occupancy;partialcharge;") ? T.getTokFromName(modelName) : 0;
                    if (tokType == 0) break;
                    htParams.put("atomDataOnly", Boolean.TRUE);
                    htParams.put("modelNumber", 1);
                    if (tokType == 4166) {
                        tokType = 1145047055;
                    }
                    tempFileInfo = this.vwr.fm.getFileInfo();
                    isAppend = true;
                }
            }
            block14 : switch (tok) {
                case 1228935687: {
                    loadScript.append(" " + modelName);
                    if (this.optParameterAsString(++i).equals("+")) {
                        isConcat = true;
                        ++i;
                        loadScript.append(" +");
                    }
                    if (this.tokAt(i) != 7) break;
                    filenames = this.stringParameterSet(i);
                    i = this.iToken;
                    if (i + 1 != this.slen) {
                        this.invArg();
                    }
                    if (filenames == null) break;
                    nFiles = filenames.length;
                    break;
                }
                case 1073741983: {
                    isInline = true;
                    ++i;
                    loadScript.append(" " + modelName);
                    break;
                }
                case 134218757: {
                    isSmiles = true;
                    ++i;
                    break;
                }
                case 1073741849: {
                    isAsync = true;
                    htParams.put("async", Boolean.TRUE);
                    ++i;
                    break;
                }
                case 0x2000000E: 
                case 1094717454: {
                    ++i;
                    loadScript.append(" " + modelName);
                    if (tok == 0x2000000E) {
                        htParams.put("isTrajectory", Boolean.TRUE);
                    }
                    if (this.isPoint3f(i)) {
                        P3 pt = this.getPoint3f(i, false);
                        i = this.iToken + 1;
                        htParams.put("firstLastStep", new int[]{(int)pt.x, (int)pt.y, (int)pt.z});
                        loadScript.append(" " + Escape.eP(pt));
                        break;
                    }
                    switch (this.tokAt(i)) {
                        case 10: {
                            BS bsModels = (BS)this.getToken((int)i++).value;
                            htParams.put("bsModels", bsModels);
                            loadScript.append(" " + Escape.eBS(bsModels));
                            break block14;
                        }
                    }
                    htParams.put("firstLastStep", new int[]{0, -1, 1});
                    break;
                }
                case 0x40000000: {
                    break;
                }
                case 134221834: {
                    String key = this.stringParameter(++i).toLowerCase();
                    isAppend = key.startsWith("append");
                    doOrient = key.indexOf("orientation") >= 0;
                    i = this.addLoadData(loadScript, key, htParams, i);
                    isData = true;
                    break;
                }
                default: {
                    modelName = "fileset";
                }
            }
            if (filename == null && filenames == null && this.getToken((int)i).tok != 4) {
                this.error(16);
            }
        }
        int filePt = i;
        int ptAs = i + 1;
        String localName = null;
        if (this.tokAt(ptAs) == 1073741848) {
            i = ptAs + 1;
            localName = this.stringParameter(i);
            if (this.vwr.fm.getPathForAllFiles() != "") {
                localName = null;
                filePt = i;
            }
        }
        String appendedData = null;
        String appendedKey = null;
        if (this.slen == i + 1) {
            if (filename == null && (i == 0 || filenames == null && (filename = this.paramAsStr(filePt)).length() == 0)) {
                filename = this.getFullPathName();
            }
            if (filename == null && filenames == null) {
                this.cmdZap(false);
                return;
            }
            if (filenames == null && !isInline) {
                if (isSmiles) {
                    filename = "$" + filename;
                } else {
                    if (filename.equals("String[]")) {
                        return;
                    }
                    if (filename.indexOf("[") == 0 && (filenames = Escape.unescapeStringArray(filename)) != null) {
                        if (i == 1) {
                            loadScript.append(" files");
                        }
                        nFiles = filenames.length;
                    }
                }
            }
            if (filenames != null) {
                for (int j = 0; j < nFiles; ++j) {
                    loadScript.append(" /*file*/").append(PT.esc(filenames[j]));
                }
            }
        } else if (this.isLoadOption(this.getToken((int)(i + 1)).tok)) {
            if (filename == null && (filename = this.paramAsStr(filePt)).length() == 0 && (filename = this.getFullPathName()) == null) {
                this.cmdZap(false);
                return;
            }
            if (filePt == i || localName != null) {
                ++i;
            }
            if (filename.equals("String[]")) {
                return;
            }
            tok = this.tokAt(i);
            if (tok == 1073742010) {
                String manifest = this.stringParameter(++i);
                htParams.put("manifest", manifest);
                sOptions.append(" MANIFEST " + PT.esc(manifest));
                tok = this.tokAt(++i);
            }
            switch (tok) {
                case 2: 
                case 7: 
                case 0x10000040: 
                case 1073742195: {
                    i = this.getLoadModelIndex(i, sOptions, htParams);
                }
            }
            i = this.getCmdExt().getLoadSymmetryParams(i, sOptions, htParams);
            if (this.tokAt(i) == 0x4000000F) {
                if (this.tokAt(++i) == 134221834) {
                    i += 2;
                    appendedData = (String)this.getToken((int)i++).value;
                    appendedKey = this.stringParameter(++i);
                    ++i;
                } else {
                    appendedKey = this.stringParameter(i++);
                    appendedData = this.stringParameter(i++);
                }
                htParams.put(appendedKey, appendedData);
            }
            if (this.tokAt(i) == 0x40000074) {
                filter = this.stringParameter(++i);
            }
        } else {
            Lst<String> fNames = new Lst<String>();
            if (i == 1) {
                if (this.tokAt(i + 1) == 0x100000A1) {
                    modelName = "files";
                } else {
                    ++i;
                }
                loadScript.append(" " + modelName);
            }
            filter = this.getLoadFilesList(i, loadScript, sOptions, htParams, fNames);
            nFiles = fNames.size();
            filenames = fNames.toArray(new String[nFiles]);
            if (!isConcat && loadScript.indexOf("/*concat*/") >= 0) {
                isConcat = true;
            }
        }
        if (!doLoadFiles) {
            return;
        }
        if (filenames != null) {
            filename = "fileSet";
        }
        if (appendedData != null) {
            sOptions.append(" APPEND data \"" + appendedKey + "\"\n" + appendedData + (appendedData.endsWith("\n") ? "" : "\n") + "end \"" + appendedKey + "\"");
        }
        if (filter == null) {
            filter = this.vwr.g.defaultLoadFilter;
        }
        if (filter.length() > 0) {
            if (filter.toUpperCase().indexOf("DOCACHE") >= 0 && !this.isStateScript && !isAppend) {
                this.vwr.cacheClear();
            }
            htParams.put("filter", filter);
            if (filter.equalsIgnoreCase("2d")) {
                filter = "2D-noMin";
            }
            sOptions.append(" FILTER " + PT.esc(filter));
        }
        boolean isVariable = false;
        if (filenames == null) {
            if (filename.equals("string") && this.vwr.am.cmi >= 0) {
                filename = this.vwr.getCurrentFileAsString(null);
                loadScript = new SB().append("load inline ");
                isInline = true;
            }
            if (isInline) {
                htParams.put("fileData", filename);
            } else if (filename.startsWith("@") && filename.length() > 1) {
                Object o = this.getVarParameter(filename.substring(1), false);
                if (o instanceof Map) {
                    this.checkLength(i + 1);
                    this.loadPNGJVar(filename, o, htParams);
                    return;
                }
                isVariable = true;
                o = "" + o;
                loadScript = new SB().append("{\n    var ").append(filename.substring(1)).append(" = ").append(PT.esc((String)o)).append(";\n    ").appendSB(loadScript);
                htParams.put("fileData", o);
            } else if ((this.vwr.testAsync || this.vwr.isJS) && (isAsync || filename.startsWith("?")) || this.vwr.apiPlatform.forceAsyncLoad(filename)) {
                localName = null;
                filename = this.loadFileAsync("LOAD" + (isAppend ? "_APPEND_" : "_"), filename, i, !isAppend && this.pc != this.pcResume);
            }
        }
        OC out = null;
        if (localName != null) {
            String[] fullPath;
            if (localName.equals(".")) {
                localName = this.vwr.fm.getFilePath(filename, false, true);
            }
            if (localName.length() == 0 || this.vwr.fm.getFilePath(localName, false, false).equalsIgnoreCase(this.vwr.fm.getFilePath(filename, false, false))) {
                this.invArg();
            }
            if ((out = this.vwr.getOutputChannel(localName, fullPath = new String[]{localName})) == null) {
                Logger.error("Could not create output stream for " + fullPath[0]);
            } else {
                htParams.put("outputChannel", out);
            }
        }
        if (filenames == null && tokType == 0) {
            loadScript.append(" ");
            if (isVariable || isInline) {
                loadScript.append(filename.indexOf(10) >= 0 || isVariable ? PT.esc(filename) : filename);
            } else if (!isData) {
                if (localName != null) {
                    localName = this.vwr.fm.getFilePath(localName, false, false);
                }
                if (!filename.equals("String[]")) {
                    loadScript.append("/*file*/").append(localName != null ? PT.esc(localName) : "$FILENAME$");
                }
            }
            if (!isConcat && (filename.startsWith("=") || filename.startsWith("*")) && filename.indexOf("/") > 0) {
                String id;
                isConcat = true;
                int pt = filename.indexOf("/");
                if (pt == 1 && this.vwr.ms.getInfo(this.vwr.am.cmi, "isPDB") == Boolean.TRUE) {
                    id = (String)this.vwr.ms.getInfo(this.vwr.am.cmi, "modelName");
                    filename = filename.substring(0, 1) + id + filename.substring(1);
                    pt = filename.indexOf("/");
                } else {
                    id = filename.substring(1, pt);
                }
                String ext = filename.substring(pt + 1);
                filename = filename.substring(0, pt);
                pt = filename.indexOf(".");
                if (pt >= 0) {
                    filename = filename.substring(0, pt);
                }
                if (";dssr;rna3d;dom;val;".indexOf(";" + ext + ";") >= 0 || ext.startsWith("dssr--")) {
                    String[] stringArray;
                    if (filename.startsWith("=")) {
                        filename = filename + ".cif";
                    }
                    if (ext.equals("all")) {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = filename;
                        stringArray2[1] = "*dom/" + id;
                        stringArray = stringArray2;
                        stringArray2[2] = "*val/" + id;
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = filename;
                        stringArray = stringArray3;
                        stringArray3[1] = "*" + ext + "/" + id;
                    }
                    filenames = stringArray;
                    filename = "fileSet";
                    loadScript = null;
                    isVariable = false;
                    sOptions.setLength(0);
                } else {
                    filename = filename + "/" + ext;
                }
            }
            if (sOptions.length() > 0) {
                loadScript.append(" /*options*/ ").append(sOptions.toString());
            }
            if (isVariable) {
                loadScript.append("\n  }");
            }
            if (loadScript != null) {
                htParams.put("loadScript", loadScript);
            }
        }
        this.setCursorWait(true);
        boolean timeMsg = this.vwr.getBoolean(603979934);
        if (timeMsg) {
            Logger.startTimer("load");
        }
        if (!this.isStateScript && !isAppend) {
            this.vwr.setBooleanProperty("legacyJavaFloat", false);
        }
        if (isMutate) {
            htParams.put("isMutate", Boolean.TRUE);
        }
        htParams.put("eval", this);
        errMsg = this.vwr.loadModelFromFile(null, filename, filenames, null, isAppend, htParams, loadScript, sOptions, tokType, isConcat);
        if (timeMsg) {
            this.showString(Logger.getTimerMsg("load", 0));
        }
        if (out != null) {
            this.vwr.fm.setFileInfo(new String[]{localName});
            Logger.info(GT.o(GT._("file {0} created"), localName));
            this.showString(this.vwr.fm.getFilePath(localName, false, false) + " created");
            out.closeChannel();
        }
        if (tokType > 0) {
            this.vwr.fm.setFileInfo(tempFileInfo);
            if (errMsg != null && !this.isCmdLine_c_or_C_Option) {
                this.evalError(errMsg, null);
            }
            return;
        }
        if (errMsg != null && !this.isCmdLine_c_or_C_Option) {
            if (errMsg.indexOf("NOTE: file recognized as a script file: ") == 0) {
                filename = errMsg.substring("NOTE: file recognized as a script file: ".length()).trim();
                this.cmdScript(0, filename, null);
                return;
            }
            if (this.vwr.async && errMsg.startsWith(JC.READER_NOT_FOUND)) {
                throw new ScriptInterruption(this, "async", 1);
            }
            this.evalError(errMsg, null);
        }
        if (this.debugHigh) {
            this.report("Successfully loaded:" + (filenames == null ? htParams.get("fullPathName") : modelName), false);
        }
        this.finalizeLoad(isAppend, appendNew, isConcat, doOrient, nFiles, ac0, modelCount0);
    }

    private int addLoadData(SB loadScript, String key, Map<String, Object> htParams, int i) throws ScriptException {
        loadScript.append(" /*data*/ data");
        int ptVar = key.indexOf("@");
        if (ptVar >= 0) {
            key = key.replace('@', '_');
        }
        loadScript.append(" ").append(PT.esc(key));
        String strModel = ptVar >= 0 ? "" + this.getParameter(key.substring(ptVar + 1), 4, true) : this.paramAsStr(++i);
        strModel = Viewer.fixInlineString(strModel, this.vwr.getInlineChar());
        htParams.put("fileData", strModel);
        htParams.put("isData", Boolean.TRUE);
        loadScript.appendC('\n').append(strModel).append(" end ").append(PT.esc(key));
        if (ptVar < 0) {
            i += 2;
        }
        return i;
    }

    private void loadPNGJVar(String varName, Object o, Map<String, Object> htParams) throws ScriptException {
        T[] av = new SV[]{SV.newV(6, o)};
        this.getCmdExt().dispatch(1073741866, false, av);
        htParams.put("imageData", ((SV)av[0]).value);
        OC out = this.vwr.getOutputChannel(null, null);
        htParams.put("outputChannel", out);
        this.vwr.createZip("", "BINARY", htParams);
        String modelName = "cache://VAR_" + varName;
        this.vwr.cacheFileByName("cache://VAR_*", false);
        this.vwr.cachePut(modelName, out.toByteArray());
        this.cmdScript(0, modelName, null);
    }

    private String getLoadFilesList(int i, SB loadScript, SB sOptions, Map<String, Object> htParams, Lst<String> fNames) throws ScriptException {
        Lst<Object> firstLastSteps = null;
        String filter = null;
        P3 pt = null;
        BS bs = null;
        block7: while (i < this.slen) {
            switch (this.tokAt(i)) {
                case 0x100000A1: {
                    loadScript.append("/*concat*/ +");
                    ++i;
                    continue block7;
                }
                case 2: 
                case 7: 
                case 0x10000040: 
                case 1073742195: {
                    i = this.getLoadModelIndex(i, sOptions, htParams);
                    continue block7;
                }
                case 0x40000074: {
                    filter = this.stringParameter(++i);
                    ++i;
                    continue block7;
                }
                case 1073742329: {
                    htParams.remove("isTrajectory");
                    if (firstLastSteps == null) {
                        firstLastSteps = new Lst<Object>();
                        pt = P3.new3(0.0f, -1.0f, 1.0f);
                    }
                    if (this.isPoint3f(++i)) {
                        pt = this.getPoint3f(i, false);
                        i = this.iToken + 1;
                        break;
                    }
                    if (this.tokAt(i) != 10) break;
                    bs = (BS)this.getToken((int)i).value;
                    pt = null;
                    i = this.iToken + 1;
                    break;
                }
                case 0x40000000: {
                    this.invArg();
                }
            }
            fNames.addLast(this.paramAsStr(i++));
            if (pt != null) {
                firstLastSteps.addLast(new int[]{(int)pt.x, (int)pt.y, (int)pt.z});
                loadScript.append(" COORD " + Escape.eP(pt));
            } else if (bs != null) {
                firstLastSteps.addLast(bs);
                loadScript.append(" COORD " + Escape.eBS(bs));
            }
            loadScript.append(" /*file*/$FILENAME" + fNames.size() + "$");
        }
        if (firstLastSteps != null) {
            htParams.put("firstLastSteps", firstLastSteps);
        }
        return filter;
    }

    private boolean isLoadOption(int tok) {
        switch (tok) {
            case 2: 
            case 7: 
            case 8: 
            case 134221834: 
            case 0x10000040: 
            case 0x4000000F: 
            case 1073741938: 
            case 1073742010: 
            case 1073742066: 
            case 0x40000100: 
            case 1073742114: 
            case 1073742152: 
            case 1073742163: 
            case 1073742195: 
            case 1073742332: 
            case 1094713350: 
            case 1814695966: {
                return true;
            }
            case 0x40000000: 
            case 0x40000074: {
                return this.tokAt(this.iToken + 2) != 1073742329;
            }
        }
        return false;
    }

    private int getLoadModelIndex(int i, SB sOptions, Map<String, Object> htParams) throws ScriptException {
        switch (this.tokAt(i)) {
            case 2: {
                htParams.remove("firstLastStep");
                htParams.remove("bsModel");
                htParams.put("useFileModelNumbers", Boolean.TRUE);
                int n = this.intParameter(i);
                sOptions.append(" ").appendI(n);
                if (n < 0) {
                    htParams.put("vibrationNumber", -n);
                    break;
                }
                htParams.put("modelNumber", n);
                break;
            }
            case 7: 
            case 0x10000040: 
            case 1073742195: {
                htParams.remove("firstLastStep");
                float[] data = this.floatParameterSet(i, 1, Integer.MAX_VALUE);
                BS bs = new BS();
                int[] iArray = new int[data.length];
                for (int j = 0; j < data.length; ++j) {
                    int n = (int)data[j];
                    if (data[j] >= 1.0f && data[j] == (float)n) {
                        bs.set(n - 1);
                    } else {
                        this.invArg();
                    }
                    iArray[j] = n;
                }
                sOptions.append(" " + Escape.eAI(iArray));
                htParams.put("bsModels", bs);
                htParams.put("useFileModelNumbers", Boolean.TRUE);
            }
        }
        return this.iToken + 1;
    }

    private void finalizeLoad(boolean isAppend, boolean appendNew, boolean isConcat, boolean doOrient, int nFiles, int ac0, int modelCount0) throws ScriptException {
        String siteScript;
        String embeddedScript;
        Map<String, Object> info;
        Object centroid;
        String msg;
        if (isAppend && (appendNew || nFiles > 1)) {
            this.vwr.setAnimationRange(-1, -1);
            this.vwr.setCurrentModelIndex(modelCount0);
        }
        if (this.scriptLevel == 0 && !isAppend && (isConcat || nFiles < 2) && (msg = (String)this.vwr.ms.getInfoM("modelLoadNote")) != null) {
            this.vwr.showString(msg, false);
        }
        if (AU.isAI(centroid = this.vwr.ms.getInfoM("centroidMinMax")) && this.vwr.ms.ac > 0) {
            BS bs = BSUtil.newBitSet2(isAppend ? ac0 : 0, this.vwr.ms.ac);
            this.vwr.ms.setCentroid(bs, (int[])centroid);
        }
        String script = this.vwr.g.defaultLoadScript;
        msg = "";
        if (script.length() > 0) {
            msg = msg + "\nUsing defaultLoadScript: " + script;
        }
        if ((info = this.vwr.ms.msInfo) != null && this.vwr.allowEmbeddedScripts() && (embeddedScript = (String)info.remove("jmolscript")) != null && embeddedScript.length() > 0) {
            msg = msg + "\nAdding embedded #jmolscript: " + embeddedScript;
            script = script + ";" + embeddedScript;
            this.setStringProperty("_loadScript", script);
            script = "allowEmbeddedScripts = false;try{" + script + "} allowEmbeddedScripts = true;";
        } else {
            this.setStringProperty("_loadScript", "");
        }
        this.logLoadInfo(msg);
        String string = siteScript = info == null ? null : (String)info.remove("sitescript");
        if (siteScript != null) {
            script = siteScript + ";" + script;
        }
        if (doOrient) {
            script = script + ";restore orientation preload";
        }
        if (script.length() > 0 && !this.isCmdLine_c_or_C_Option) {
            this.runScript(script);
        }
    }

    private void cmdLog() throws ScriptException {
        if (this.slen == 1) {
            this.bad();
        }
        if (this.chk) {
            return;
        }
        String s = this.parameterExpressionString(1, 0);
        if (this.tokAt(1) == 1073742334) {
            this.setStringProperty("logFile", "");
        } else {
            this.vwr.log(s);
        }
    }

    private void cmdLoop() throws ScriptException {
        if (this.vwr.headless) {
            return;
        }
        if (!this.chk) {
            this.pc = -1;
        }
        this.cmdDelay();
    }

    private void cmdMessage() throws ScriptException {
        String text = this.paramAsStr(this.checkLast(1));
        if (this.chk) {
            return;
        }
        String s = Txt.formatText(this.vwr, text);
        if (this.outputBuffer == null && !this.vwr.isPrintOnly) {
            Logger.warn(s);
        }
        if (!s.startsWith("_")) {
            this.report(s, false);
        }
    }

    private void cmdModel(int offset) throws ScriptException {
        int i;
        boolean isFrame = this.theTok == 4115 || this.vwr.ms.mc > 1;
        int[] frameList = new int[]{-1, -1};
        int nFrames = 0;
        boolean useModelNumber = true;
        int modelIndex = -1;
        if (this.slen == 1 && offset == 1) {
            int m;
            modelIndex = this.vwr.am.cmi;
            if (!this.chk && modelIndex >= 0 && (m = this.vwr.ms.getJmolDataSourceFrame(modelIndex)) >= 0) {
                this.vwr.setCurrentModelIndex(m == modelIndex ? Integer.MIN_VALUE : m);
            }
            return;
        }
        switch (this.tokAt(1)) {
            case 2: {
                if (!isFrame || this.slen != 2) break;
                if (!this.chk) {
                    this.vwr.am.setFrame(this.intParameter(1) - 1);
                }
                return;
            }
            case 10: 
            case 1073742325: {
                modelIndex = this.atomExpressionAt(1).nextSetBit(0);
                if (this.chk || modelIndex < 0 || modelIndex >= this.vwr.ms.ac) {
                    return;
                }
                modelIndex = this.vwr.ms.at[modelIndex].mi;
                if (this.iToken + 1 == this.slen) {
                    this.vwr.setCurrentModelIndex(modelIndex);
                    return;
                }
                frameList[nFrames++] = modelIndex;
                offset = this.iToken + 1;
                useModelNumber = false;
                break;
            }
            case 0x40000050: {
                this.iToken = 1;
                int n = this.tokAt(2) == 2 ? this.intParameter(++this.iToken) : 1;
                this.checkLength(this.iToken + 1);
                if (!this.chk && n > 0) {
                    this.vwr.ms.createModels(n);
                }
                return;
            }
            case 1073741974: {
                this.checkLength(3);
                String id = this.stringParameter(2);
                if (!this.chk) {
                    this.vwr.setCurrentModelID(id);
                }
                return;
            }
            case 528397: {
                long millis = 0L;
                this.checkLength(3);
                switch (this.getToken((int)2).tok) {
                    case 2: 
                    case 3: {
                        millis = (long)(this.floatParameter(2) * 1000.0f);
                        break;
                    }
                    default: {
                        this.error(20);
                    }
                }
                if (!this.chk) {
                    this.vwr.setFrameDelayMs(millis);
                }
                return;
            }
            case 1073742166: {
                if (this.checkLength23() > 0 && !this.chk) {
                    this.vwr.setFrameTitleObj(this.slen == 2 ? "@{_modelName}" : (this.tokAt(2) == 7 ? SV.strListValue(this.st[2]) : this.paramAsStr(2)));
                }
                return;
            }
            case 1073742077: {
                if (this.tokAt(2) != 3 || this.tokAt(3) != 12) break;
                modelIndex = this.vwr.ms.getModelNumberIndex(this.getToken((int)2).intValue, false, false);
                M4 mat4 = (M4)this.getToken((int)3).value;
                if (modelIndex >= 0) {
                    this.vwr.ms.am[modelIndex].mat4 = mat4;
                }
                return;
            }
            case 0x40000008: {
                BS bs;
                boolean isNone = this.tokAt(2) == 1073742333;
                BS bS = bs = this.slen == 2 || isNone ? null : this.atomExpressionAt(2);
                if (isNone) {
                    this.iToken = 2;
                }
                boolean isFixed = this.tokAt(this.iToken + 1) == 12293;
                this.checkLength(this.iToken + (isFixed ? 2 : 1));
                if (!this.chk) {
                    this.vwr.setFrameOffsets(bs, isFixed);
                }
                return;
            }
        }
        if (this.getToken((int)offset).tok == 0x100000A0) {
            if (this.getToken((int)this.checkLast((int)(++offset))).tok != 2 || this.intParameter(offset) != 1) {
                this.invArg();
            }
            if (!this.chk) {
                this.vwr.setAnimation(1073742108);
            }
            return;
        }
        boolean isPlay = false;
        boolean isRange = false;
        String propName = null;
        Object prop = null;
        boolean isAll = false;
        boolean isHyphen = false;
        float fFrame = 0.0f;
        P3 frameAlign = null;
        boolean haveFileSet = this.vwr.haveFileSet();
        if (this.isArrayParameter(1)) {
            this.setFrameSet(1);
            isAll = true;
        } else {
            block24: for (i = offset; i < this.slen; ++i) {
                switch (this.getToken((int)i).tok) {
                    case 0x40000008: {
                        if (i != 2) {
                            this.invArg();
                        }
                        frameAlign = this.centerParameter(3, null);
                        i = this.iToken + 1;
                        this.checkLength(i);
                        continue block24;
                    }
                    case 0x100000B1: 
                    case 1073742327: {
                        this.checkLength(offset + (isRange ? 2 : 1));
                        isAll = true;
                        continue block24;
                    }
                    case 0x100000A0: {
                        if (nFrames != 1) {
                            this.invArg();
                        }
                        isHyphen = true;
                        continue block24;
                    }
                    case 1073742333: {
                        this.checkLength(offset + 1);
                        continue block24;
                    }
                    case 3: {
                        float f;
                        useModelNumber = false;
                        fFrame = this.floatParameter(i);
                        if (f < 0.0f) {
                            this.checkLength(i + 1);
                            if (!this.chk) {
                                this.vwr.am.morph(-fFrame);
                            }
                            return;
                        }
                    }
                    case 2: 
                    case 4: {
                        int iFrame;
                        if (nFrames == 2) {
                            this.invArg();
                        }
                        int n = iFrame = this.theTok == 4 ? ScriptEval.getFloatEncodedInt((String)this.theToken.value) : this.theToken.intValue;
                        if (iFrame < 0 && nFrames == 1) {
                            isHyphen = true;
                            iFrame = -iFrame;
                            if (haveFileSet && iFrame < 1000000) {
                                iFrame *= 1000000;
                            }
                        }
                        if (this.theTok == 3 && haveFileSet && fFrame == (float)((int)fFrame)) {
                            iFrame = (int)fFrame * 1000000;
                        }
                        if (iFrame == Integer.MAX_VALUE) {
                            useModelNumber = false;
                            frameList[nFrames++] = this.chk || i != 1 ? 0 : this.vwr.getModelIndexFromId(this.theToken.value.toString());
                            continue block24;
                        }
                        if (iFrame == -1) {
                            this.checkLength(offset + 1);
                            if (!this.chk) {
                                this.vwr.setAnimation(1073742108);
                            }
                            return;
                        }
                        if (iFrame >= 1000 && iFrame < 1000000 && haveFileSet) {
                            iFrame = iFrame / 1000 * 1000000 + iFrame % 1000;
                        }
                        if (!useModelNumber && iFrame == 0 && nFrames == 0) {
                            isAll = true;
                        }
                        if (iFrame >= 1000000) {
                            useModelNumber = false;
                        }
                        frameList[nFrames++] = iFrame;
                        continue block24;
                    }
                    case 0x40000110: {
                        isPlay = true;
                        continue block24;
                    }
                    case 1073742114: {
                        isRange = true;
                        continue block24;
                    }
                    case 1715472409: {
                        propName = this.paramAsStr(++i);
                        SV sv = this.setVariable(++i, -1, "", false);
                        if (sv != null && !this.chk) {
                            if (propName.equalsIgnoreCase("DSSR")) {
                                this.loadDssr(modelIndex, (String)sv.value);
                                return;
                            }
                            prop = SV.oValue(sv);
                        }
                        i = this.slen;
                        continue block24;
                    }
                    default: {
                        this.frameControl(offset);
                        return;
                    }
                }
            }
        }
        if (this.chk) {
            return;
        }
        if (isRange && nFrames == 0) {
            isAll = true;
        }
        if (isAll) {
            this.vwr.setAnimationOn(false);
            this.vwr.setAnimationRange(-1, -1);
            if (!isRange) {
                this.vwr.setCurrentModelIndex(-1);
            }
            return;
        }
        if (nFrames == 2 && !isRange) {
            isHyphen = true;
        }
        if (haveFileSet) {
            useModelNumber = false;
        } else if (useModelNumber) {
            for (i = 0; i < nFrames; ++i) {
                if (frameList[i] < 0) continue;
                int n = i;
                frameList[n] = frameList[n] % 1000000;
            }
        }
        modelIndex = this.vwr.ms.getModelNumberIndex(frameList[0], useModelNumber, false);
        if (frameAlign != null) {
            if (modelIndex >= 0) {
                this.vwr.ms.translateModel(modelIndex, null);
                this.vwr.ms.translateModel(modelIndex, frameAlign);
            }
            return;
        }
        int modelIndex2 = -1;
        if (haveFileSet && modelIndex < 0 && frameList[0] != 0) {
            if (frameList[0] < 1000000) {
                frameList[0] = frameList[0] * 1000000;
            }
            if (nFrames == 2 && frameList[1] < 1000000) {
                frameList[1] = frameList[1] * 1000000;
            }
            if (frameList[0] % 1000000 == 0) {
                frameList[0] = frameList[0] + 1;
                modelIndex = this.vwr.ms.getModelNumberIndex(frameList[0], false, false);
                if (modelIndex >= 0) {
                    int i2 = nFrames == 1 ? frameList[0] + 1000000 : (frameList[1] == 0 ? -1 : (frameList[1] % 1000000 == 0 ? frameList[1] + 1000001 : frameList[1] + 1));
                    modelIndex2 = this.vwr.ms.getModelNumberIndex(i2, false, false);
                    if (modelIndex2 < 0) {
                        modelIndex2 = this.vwr.ms.mc;
                    }
                    --modelIndex2;
                    if (isRange) {
                        nFrames = 2;
                    } else if (!isHyphen && modelIndex2 != modelIndex) {
                        isHyphen = true;
                    }
                    isRange = isRange || modelIndex == modelIndex2;
                }
            } else {
                return;
            }
        }
        if (propName != null) {
            if (modelIndex >= 0) {
                this.vwr.ms.setInfo(modelIndex, propName, prop);
            }
            return;
        }
        if (!isPlay && !isRange || modelIndex >= 0) {
            this.vwr.setCurrentModelIndexClear(modelIndex, false);
        }
        if (isPlay && nFrames == 2 || isRange || isHyphen) {
            if (modelIndex2 < 0) {
                modelIndex2 = this.vwr.ms.getModelNumberIndex(frameList[1], useModelNumber, false);
            }
            this.vwr.setAnimationOn(false);
            this.vwr.am.setAnimationDirection(1);
            this.vwr.setAnimationRange(modelIndex, modelIndex2);
            this.vwr.setCurrentModelIndexClear(isHyphen && !isRange ? -1 : (modelIndex >= 0 ? modelIndex : 0), false);
        }
        if (isPlay) {
            this.vwr.setAnimation(4143);
        }
    }

    private void loadDssr(int modelIndex, String data) throws ScriptException {
        if (modelIndex < 0 && (modelIndex = this.vwr.am.cmi) < 0) {
            this.errorStr(30, "load <dssr file>");
        }
        if (!data.startsWith("{")) {
            data = this.vwr.getFileAsString3(data, true, "script");
        }
        this.clearDefinedVariableAtomSets();
        Map<String, Object> map = this.vwr.parseJSON(data);
        this.showString(this.vwr.getAnnotationParser(true).fixDSSRJSONMap(map));
        this.vwr.ms.setInfo(modelIndex, "dssr", map);
    }

    private void cmdMove() throws ScriptException {
        int fps;
        this.checkLength(-11);
        V3 dRot = V3.new3(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float dZoom = this.floatParameter(4);
        V3 dTrans = V3.new3(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float dSlab = this.floatParameter(8);
        float floatSecondsTotal = this.floatParameter(9);
        int n = fps = this.slen == 11 ? this.intParameter(10) : 30;
        if (this.chk) {
            return;
        }
        this.refresh(false);
        if (!this.useThreads()) {
            floatSecondsTotal = 0.0f;
        }
        this.vwr.move(this, dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
        if (floatSecondsTotal > 0.0f && this.isJS) {
            throw new ScriptInterruption(this, "move", 1);
        }
    }

    private void cmdMoveto() throws ScriptException {
        Object[] ret;
        if (this.slen == 2 && this.tokAt(1) == 1073742162) {
            if (!this.chk) {
                this.vwr.tm.stopMotion();
            }
            return;
        }
        if (this.slen == 2 && this.isFloatParameter(1)) {
            float floatSecondsTotal = this.floatParameter(1);
            if (this.chk) {
                return;
            }
            if (!this.useThreads()) {
                floatSecondsTotal = 0.0f;
            }
            if (floatSecondsTotal > 0.0f) {
                this.refresh(false);
            }
            this.vwr.moveTo(this, floatSecondsTotal, null, JC.axisZ, 0.0f, null, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
            if (this.isJS && floatSecondsTotal > 0.0f && this.vwr.g.waitForMoveTo) {
                throw new ScriptInterruption(this, "moveTo", 1);
            }
            return;
        }
        V3 axis = V3.new3(Float.NaN, 0.0f, 0.0f);
        P3 center = null;
        int i = 1;
        float floatSecondsTotal = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
        float degrees = 90.0f;
        BS bsCenter = null;
        boolean isChange = true;
        boolean isMolecular = false;
        float xTrans = 0.0f;
        float yTrans = 0.0f;
        float zoom = Float.NaN;
        float rotationRadius = Float.NaN;
        float zoom0 = this.vwr.tm.getZoomSetting();
        P3 navCenter = null;
        float xNav = Float.NaN;
        float yNav = Float.NaN;
        float navDepth = Float.NaN;
        float cameraDepth = Float.NaN;
        float cameraX = Float.NaN;
        float cameraY = Float.NaN;
        float[] pymolView = null;
        Quat q = null;
        block0 : switch (this.getToken((int)i).tok) {
            case 1073742110: {
                pymolView = this.floatParameterSet(++i, 18, 21);
                i = this.iToken + 1;
                if (!this.chk || this.checkLength(i) <= 0) break;
                return;
            }
            case 134221850: {
                if (this.tokAt(++i) == 0x400000CC) {
                    isMolecular = true;
                    ++i;
                }
                if (this.tokAt(i) == 10 || this.tokAt(i) == 1073742325) {
                    isMolecular = true;
                    ret = new Object[1];
                    center = this.centerParameter(i, ret);
                    if (!(ret[0] instanceof BS)) {
                        this.invArg();
                    }
                    bsCenter = (BS)ret[0];
                    q = this.chk ? new Quat() : this.vwr.ms.getQuaternion(bsCenter.nextSetBit(0), this.vwr.getQuaternionFrame());
                } else {
                    q = this.getQuaternionParameter(i);
                }
                i = this.iToken + 1;
                if (q != null) break;
                this.invArg();
                break;
            }
            case 8: 
            case 9: 
            case 1073742332: {
                if (this.isPoint3f(i)) {
                    axis.setT(this.getPoint3f(i, true));
                    i = this.iToken + 1;
                    degrees = this.floatParameter(i++);
                    break;
                }
                P4 pt4 = this.getPoint4f(i);
                i = this.iToken + 1;
                axis.set(pt4.x, pt4.y, pt4.z);
                degrees = pt4.x == 0.0f && pt4.y == 0.0f && pt4.z == 0.0f ? Float.NaN : pt4.w;
                break;
            }
            case 1073741954: {
                axis.set(1.0f, 0.0f, 0.0f);
                degrees = 0.0f;
                this.checkLength(++i);
                break;
            }
            case 0x40000022: {
                axis.set(0.0f, 1.0f, 0.0f);
                degrees = 180.0f;
                this.checkLength(++i);
                break;
            }
            case 1073741996: {
                axis.set(0.0f, 1.0f, 0.0f);
                this.checkLength(++i);
                break;
            }
            case 1073742126: {
                axis.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++i);
                break;
            }
            case 1073742172: {
                axis.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++i);
                break;
            }
            case 1073741871: {
                axis.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++i);
                break;
            }
            case 1073741854: {
                String abc = this.paramAsStr(++i);
                if (abc.equals("-")) {
                    abc = abc + this.paramAsStr(++i);
                }
                this.checkLength(++i);
                switch ("xyz".indexOf(abc)) {
                    case 0: {
                        q = Quat.new4(0.5f, 0.5f, 0.5f, -0.5f);
                        break block0;
                    }
                    case 1: {
                        q = Quat.new4(0.5f, 0.5f, 0.5f, 0.5f);
                        break block0;
                    }
                    case 2: {
                        q = Quat.new4(0.0f, 0.0f, 0.0f, 1.0f);
                        break block0;
                    }
                }
                SymmetryInterface uc = this.vwr.getCurrentUnitCell();
                if (uc == null) {
                    uc = this.vwr.getSymTemp();
                    uc.setUnitCell(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, false);
                }
                if ((q = uc.getQuaternionRotation(abc)) != null) break;
                this.invArg();
                break;
            }
            default: {
                axis = V3.new3(this.floatParameter(i++), this.floatParameter(i++), this.floatParameter(i++));
                degrees = this.floatParameter(i++);
            }
        }
        if (q != null) {
            A4 aa = q.toAxisAngle4f();
            axis.set(aa.x, aa.y, aa.z);
            degrees = (float)(isMolecular ? -1 : 1) * (float)((double)aa.angle * 180.0 / Math.PI);
        }
        if (Float.isNaN(axis.x) || Float.isNaN(axis.y) || Float.isNaN(axis.z)) {
            axis.set(0.0f, 0.0f, 0.0f);
        } else if (axis.length() == 0.0f && degrees == 0.0f) {
            degrees = Float.NaN;
        }
        boolean bl = isChange = !this.vwr.tm.isInPosition(axis, degrees);
        if (this.isFloatParameter(i)) {
            zoom = this.floatParameter(i++);
        }
        if (this.isFloatParameter(i) && !this.isCenterParameter(i)) {
            xTrans = this.floatParameter(i++);
            yTrans = this.floatParameter(i++);
            if (!isChange && Math.abs(xTrans - this.vwr.tm.getTranslationXPercent()) >= 1.0f) {
                isChange = true;
            }
            if (!isChange && Math.abs(yTrans - this.vwr.tm.getTranslationYPercent()) >= 1.0f) {
                isChange = true;
            }
        }
        if (bsCenter == null && i != this.slen) {
            ret = new Object[1];
            center = this.centerParameter(i, ret);
            if (ret[0] instanceof BS) {
                bsCenter = (BS)ret[0];
            }
            i = this.iToken + 1;
        }
        if (center != null) {
            if (!isChange && (double)center.distance(this.vwr.tm.fixedRotationCenter) >= 0.1) {
                isChange = true;
            }
            if (this.isFloatParameter(i)) {
                rotationRadius = this.floatParameter(i++);
            }
            if (!this.isCenterParameter(i)) {
                if ((rotationRadius == 0.0f || Float.isNaN(rotationRadius)) && (zoom == 0.0f || Float.isNaN(zoom))) {
                    float newZoom = Math.abs(this.getZoom(0, i, bsCenter, zoom == 0.0f ? 0.0f : zoom0));
                    i = this.iToken + 1;
                    zoom = newZoom;
                } else if (!isChange && (double)Math.abs(rotationRadius - this.vwr.getFloat(0x2200002C)) >= 0.1) {
                    isChange = true;
                }
            }
            if (zoom == 0.0f || Float.isNaN(zoom)) {
                zoom = 100.0f;
            }
            if (Float.isNaN(rotationRadius)) {
                rotationRadius = 0.0f;
            }
            if (!isChange && Math.abs(zoom - zoom0) >= 1.0f) {
                isChange = true;
            }
            if (i != this.slen) {
                navCenter = this.centerParameter(i, null);
                i = this.iToken + 1;
                if (i != this.slen) {
                    xNav = this.floatParameter(i++);
                    yNav = this.floatParameter(i++);
                }
                if (i != this.slen) {
                    navDepth = this.floatParameter(i++);
                }
                if (i != this.slen) {
                    cameraDepth = this.floatParameter(i++);
                    if (!isChange && Math.abs(cameraDepth - this.vwr.tm.getCameraDepth()) >= 0.01f) {
                        isChange = true;
                    }
                }
                if (i + 1 < this.slen) {
                    cameraX = this.floatParameter(i++);
                    cameraY = this.floatParameter(i++);
                    if (!isChange && Math.abs(cameraX - this.vwr.tm.camera.x) >= 0.01f) {
                        isChange = true;
                    }
                    if (!isChange && Math.abs(cameraY - this.vwr.tm.camera.y) >= 0.01f) {
                        isChange = true;
                    }
                }
            }
        }
        this.checkLength(i);
        if (this.chk) {
            return;
        }
        if (!isChange) {
            floatSecondsTotal = 0.0f;
        }
        if (floatSecondsTotal > 0.0f) {
            this.refresh(false);
        }
        if (!this.useThreads()) {
            floatSecondsTotal = 0.0f;
        }
        if (cameraDepth == 0.0f) {
            cameraY = Float.NaN;
            cameraX = Float.NaN;
            cameraDepth = Float.NaN;
        }
        if (pymolView != null) {
            this.vwr.tm.moveToPyMOL(this, floatSecondsTotal, pymolView);
        } else {
            this.vwr.moveTo(this, floatSecondsTotal, center, axis, degrees, null, zoom, xTrans, yTrans, rotationRadius, navCenter, xNav, yNav, navDepth, cameraDepth, cameraX, cameraY);
        }
        if (this.isJS && floatSecondsTotal > 0.0f && this.vwr.g.waitForMoveTo) {
            throw new ScriptInterruption(this, "moveTo", 1);
        }
    }

    private boolean cmdPause() throws ScriptException {
        if (this.chk || this.isJS && !this.allowJSThreads) {
            return false;
        }
        String msg = this.optParameterAsString(1);
        if (!this.vwr.getBooleanProperty("_useCommandThread")) {
            // empty if block
        }
        if (this.vwr.autoExit || !this.vwr.haveDisplay && !this.vwr.isWebGL) {
            return false;
        }
        if (this.scriptLevel == 0 && this.pc == this.aatoken.length - 1) {
            this.vwr.scriptStatus("nothing to pause: " + msg);
            return false;
        }
        msg = msg.length() == 0 ? ": RESUME to continue." : ": " + Txt.formatText(this.vwr, msg);
        this.pauseExecution(true);
        this.vwr.scriptStatusMsg("script execution paused" + msg, "script paused for RESUME");
        return true;
    }

    private void cmdPrint() throws ScriptException {
        if (this.slen == 1) {
            if (!this.chk) {
                this.showStringPrint("\u0000", true);
            }
            return;
        }
        this.showStringPrint(this.parameterExpressionString(1, 0), true);
    }

    private void cmdPrompt() throws ScriptException {
        String msg = null;
        if (this.slen == 1) {
            if (!this.chk) {
                msg = ScriptEval.getContextTrace(this.vwr, this.getScriptContext("prompt"), null, true).toString();
            }
        } else {
            msg = this.parameterExpressionString(1, 0);
        }
        if (!this.chk) {
            this.vwr.prompt(msg, "OK", null, true);
        }
    }

    private void cmdReset() throws ScriptException {
        if (this.slen == 3 && this.tokAt(1) == 134320141) {
            if (!this.chk) {
                this.vwr.removeFunction(this.stringParameter(2));
            }
            return;
        }
        this.checkLength(-2);
        if (this.chk) {
            return;
        }
        if (this.slen == 1) {
            this.vwr.reset(false);
            return;
        }
        switch (this.tokAt(1)) {
            case 36865: {
                if (!this.chk && this.outputBuffer != null) {
                    this.outputBuffer.setLength(0);
                }
                return;
            }
            case 134221829: {
                this.vwr.cacheClear();
                return;
            }
            case 1073741935: {
                this.resetError();
                return;
            }
            case 1073741995: {
                this.vwr.stm.resetLighting();
                return;
            }
            case 0x40C0000C: {
                this.vwr.resetShapes(true);
                return;
            }
            case 134320141: {
                this.vwr.clearFunctions();
                return;
            }
            case 1639976963: {
                BS bsModified = new BS();
                this.runScript(this.vwr.ms.getDefaultStructure(this.vwr.bsA(), bsModified));
                this.vwr.shm.resetBioshapes(bsModified);
                return;
            }
            case 1648363544: {
                this.vwr.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0, 0, 0);
                return;
            }
            case 1075838996: {
                this.vwr.ms.resetAromatic();
                return;
            }
            case 1611141175: {
                this.vwr.reset(true);
                return;
            }
        }
        String var = this.paramAsStr(1);
        if (var.charAt(0) == '_') {
            this.invArg();
        }
        this.vwr.unsetProperty(var);
    }

    private void resetError() {
        this.vwr.g.removeParam("_errormessage");
    }

    private void cmdRestrict() throws ScriptException {
        boolean isBond = this.tokAt(1) == 1677721602;
        this.cmdSelect(isBond ? 2 : 1);
        this.restrictSelected(isBond, true);
    }

    private void cmdReturn(SV tv) throws ScriptException {
        if (this.chk) {
            return;
        }
        SV t = this.getContextVariableAsVariable("_retval", false);
        if (t != null) {
            SV v;
            SV sV = v = tv != null || this.slen == 1 ? null : this.parameterExpressionToken(1);
            if (tv == null) {
                tv = v == null ? SV.newI(0) : v;
            }
            t.value = tv.value;
            t.intValue = tv.intValue;
            t.tok = tv.tok;
        }
        this.cmdGoto(false);
    }

    private void cmdRotate(boolean isSpin, boolean isSelected) throws ScriptException {
        boolean requiresThread;
        float rate;
        if (this.slen == 2) {
            switch (this.getToken((int)1).tok) {
                case 1073742335: {
                    if (!this.chk) {
                        this.vwr.tm.setSpinOn();
                    }
                    return;
                }
                case 1073742334: {
                    if (!this.chk) {
                        this.vwr.tm.setSpinOff();
                    }
                    return;
                }
            }
        }
        BS bsAtoms = null;
        float degreesPerSecond = Float.MIN_VALUE;
        int nPoints = 0;
        float endDegrees = Float.MAX_VALUE;
        boolean isMolecular = false;
        boolean haveRotation = false;
        float[] dihedralList = null;
        Lst<P3> ptsA = null;
        P3[] points = new P3[2];
        V3 rotAxis = V3.new3(0.0f, 1.0f, 0.0f);
        V3 translation = null;
        M4 m4 = null;
        M3 m3 = null;
        boolean is4x4 = false;
        int direction = 1;
        Quat q = null;
        boolean helicalPath = false;
        Lst<P3> ptsB = null;
        BS bsCompare = null;
        P3 invPoint = null;
        P4 invPlane = null;
        boolean axesOrientationRasmol = this.vwr.getBoolean(603979806);
        block25: for (int i = 1; i < this.slen; ++i) {
            int tok = this.getToken((int)i).tok;
            switch (tok) {
                case 8: 
                case 10: 
                case 1073742325: 
                case 1073742330: 
                case 1073742332: {
                    if (!(tok != 10 && tok != 1073742325 || translation == null && q == null && nPoints != 2)) {
                        bsAtoms = this.atomExpressionAt(i);
                        ptsB = null;
                        isSelected = true;
                        break;
                    }
                    haveRotation = true;
                    if (nPoints == 2) {
                        nPoints = 0;
                    }
                    P3 pt1 = this.centerParameterForModel(i, this.vwr.am.cmi, null);
                    if (!this.chk && tok == 1073742330 && this.tokAt(i + 2) != 0x10000040) {
                        Object[] data;
                        isMolecular = true;
                        rotAxis = this.getShapePropertyData(22, "getSpinAxis", data = new Object[]{this.objectNameParameter(++i), this.vwr.am.cmi, null}) ? (V3)data[2] : null;
                    }
                    points[nPoints++] = pt1;
                    break;
                }
                case 1611141175: {
                    isSpin = true;
                    continue block25;
                }
                case 0x400000A4: 
                case 0x400000CC: {
                    isMolecular = true;
                    continue block25;
                }
                case 1113589787: {
                    isSelected = true;
                    break;
                }
                case 0x10000030: {
                    continue block25;
                }
                case 2: 
                case 3: {
                    if (isSpin) {
                        if (degreesPerSecond == Float.MIN_VALUE) {
                            degreesPerSecond = this.floatParameter(i);
                            continue block25;
                        }
                        if (endDegrees == Float.MAX_VALUE) {
                            endDegrees = degreesPerSecond;
                            degreesPerSecond = this.floatParameter(i);
                            continue block25;
                        }
                    } else {
                        if (endDegrees == Float.MAX_VALUE) {
                            endDegrees = this.floatParameter(i);
                            continue block25;
                        }
                        if (degreesPerSecond == Float.MIN_VALUE) {
                            degreesPerSecond = this.floatParameter(i);
                            isSpin = true;
                            continue block25;
                        }
                    }
                    this.invArg();
                    break;
                }
                case 0x100000A0: {
                    direction = -1;
                    continue block25;
                }
                case 1111492629: {
                    haveRotation = true;
                    rotAxis.set(direction, 0.0f, 0.0f);
                    continue block25;
                }
                case 1111492630: {
                    haveRotation = true;
                    rotAxis.set(0.0f, direction, 0.0f);
                    continue block25;
                }
                case 1111492631: {
                    haveRotation = true;
                    rotAxis.set(0.0f, 0.0f, axesOrientationRasmol && !isMolecular ? -direction : direction);
                    continue block25;
                }
                case 9: 
                case 134221850: 
                case 1073741864: {
                    if (tok == 134221850) {
                        ++i;
                    }
                    haveRotation = true;
                    q = this.getQuaternionParameter(i);
                    if (q == null) break;
                    if (tok == 1073741864 && !(isMolecular = isSelected)) {
                        q = q.div(this.vwr.tm.getRotationQ());
                    }
                    rotAxis.setT(q.getNormal());
                    endDegrees = q.getTheta();
                    break;
                }
                case 134217750: {
                    P3[] pts;
                    int n;
                    if (this.paramAsStr(i + 1).equalsIgnoreCase("picked")) {
                        ++i;
                        Lst lst = (Lst)this.vwr.getPOrNull("pickedList");
                        n = lst.size();
                        if (n < 3) {
                            return;
                        }
                        pts = new P3[3];
                        for (int j = 0; j < 3; ++j) {
                            pts[j] = this.vwr.ms.getAtomSetCenter(SV.getBitSet((SV)lst.get(n - 3 + j), false));
                        }
                    } else if (this.isArrayParameter(i + 1)) {
                        pts = this.getPointArray(++i, -1, false);
                        i = this.iToken;
                    } else {
                        pts = new P3[3];
                        for (int j = 0; j < 3; ++j) {
                            pts[j] = this.centerParameter(++i, null);
                            i = this.iToken;
                        }
                    }
                    n = pts.length;
                    if (n < 3) {
                        return;
                    }
                    q = Quat.getQuaternionFrame(pts[n - 3], pts[n - 2], pts[n - 1]);
                    q = Quat.new4(1.0f, 0.0f, 0.0f, 0.0f).mulQ(q.inv().div(this.vwr.tm.getRotationQ()));
                    rotAxis.setT(q.getNormal());
                    endDegrees = q.getTheta();
                    break;
                }
                case 0x8000003: {
                    haveRotation = true;
                    if (this.isPoint3f(++i)) {
                        rotAxis.setT(this.centerParameter(i, null));
                        break;
                    }
                    P4 p4 = this.getPoint4f(i);
                    rotAxis.set(p4.x, p4.y, p4.z);
                    endDegrees = p4.w;
                    q = Quat.newVA(rotAxis, endDegrees);
                    break;
                }
                case 1073742328: {
                    isSelected = true;
                    isMolecular = true;
                    haveRotation = true;
                    if (this.isArrayParameter(++i)) {
                        dihedralList = this.floatParameterSet(i, 6, Integer.MAX_VALUE);
                        i = this.iToken;
                        break;
                    }
                    int iAtom1 = this.atomExpressionAt(i).nextSetBit(0);
                    int iAtom2 = this.atomExpressionAt(++this.iToken).nextSetBit(0);
                    if (iAtom1 < 0 || iAtom2 < 0) {
                        return;
                    }
                    bsAtoms = this.vwr.getBranchBitSet(iAtom2, iAtom1, true);
                    points[0] = this.vwr.ms.at[iAtom1];
                    points[1] = this.vwr.ms.at[iAtom2];
                    nPoints = 2;
                    break;
                }
                case 4160: {
                    translation = V3.newV(this.centerParameter(++i, null));
                    isSelected = true;
                    isMolecular = true;
                    break;
                }
                case 136314895: {
                    helicalPath = true;
                    continue block25;
                }
                case 1296041986: {
                    Object[] op;
                    int symop = this.intParameter(++i);
                    if (this.chk) continue block25;
                    Map<String, Object> info = this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, null, -1);
                    Object[] objectArray = op = info == null ? null : (Object[])info.get("operations");
                    if (symop == 0 || op == null || op.length < Math.abs(symop)) {
                        this.invArg();
                    }
                    op = (Object[])op[Math.abs(symop) - 1];
                    translation = (V3)op[5];
                    invPoint = (P3)op[6];
                    points[0] = (P3)op[7];
                    if (op[8] != null) {
                        rotAxis = (V3)op[8];
                    }
                    endDegrees = ((Integer)op[9]).intValue();
                    if (symop < 0) {
                        endDegrees = -endDegrees;
                        if (translation != null) {
                            translation.scale(-1.0f);
                        }
                    }
                    if (endDegrees == 0.0f && points[0] != null) {
                        rotAxis.normalize();
                        invPlane = new P4();
                        Measure.getPlaneThroughPoint(points[0], rotAxis, invPlane);
                    }
                    q = Quat.newVA(rotAxis, endDegrees);
                    nPoints = points[0] == null ? 0 : 1;
                    isMolecular = true;
                    haveRotation = true;
                    isSelected = true;
                    continue block25;
                }
                case 134221831: {
                    float stddev;
                    bsCompare = this.atomExpressionAt(++i);
                    ptsA = this.vwr.ms.getAtomPointVector(bsCompare);
                    if (ptsA == null) {
                        this.iToken = i;
                        this.invArg();
                    }
                    i = this.iToken;
                    if ((ptsB = this.getPointVector(this.getToken(++i), i)) == null || ptsA.size() != ptsB.size()) {
                        this.iToken = i;
                        this.invArg();
                    }
                    m4 = new M4();
                    points[0] = new P3();
                    nPoints = 1;
                    Interface.getInterface("javajs.util.Eigen", this.vwr, "script");
                    float f = stddev = this.chk ? 0.0f : Measure.getTransformMatrix4(ptsA, ptsB, m4, points[0]);
                    if ((double)stddev > 0.001) {
                        ptsB = null;
                    }
                }
                case 11: 
                case 12: {
                    haveRotation = true;
                    m3 = new M3();
                    if (tok == 12) {
                        is4x4 = true;
                        m4 = (M4)this.theToken.value;
                    }
                    if (m4 != null) {
                        translation = new V3();
                        m4.getTranslation(translation);
                        m4.getRotationScale(m3);
                    } else {
                        m3 = (M3)this.theToken.value;
                    }
                    q = this.chk ? new Quat() : Quat.newM(m3);
                    rotAxis.setT(q.getNormal());
                    endDegrees = q.getTheta();
                    isMolecular = true;
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            i = this.iToken;
        }
        if (this.chk) {
            return;
        }
        if (dihedralList != null && endDegrees != Float.MAX_VALUE) {
            isSpin = true;
            degreesPerSecond = endDegrees;
        }
        if (isSelected && bsAtoms == null) {
            bsAtoms = this.vwr.bsA();
        }
        if (bsCompare != null) {
            isSelected = true;
            if (bsAtoms == null) {
                bsAtoms = bsCompare;
            }
        }
        float f = degreesPerSecond == Float.MIN_VALUE ? 10.0f : (endDegrees == Float.MAX_VALUE ? degreesPerSecond : (rate = degreesPerSecond < 0.0f == endDegrees > 0.0f ? -endDegrees / degreesPerSecond : degreesPerSecond));
        if (dihedralList != null) {
            if (!isSpin) {
                this.vwr.setDihedrals(dihedralList, null, 1.0f);
                return;
            }
            translation = null;
        }
        if (q != null) {
            if (nPoints == 0 && translation != null && !is4x4) {
                points[0] = this.vwr.ms.getAtomSetCenter(bsAtoms != null ? bsAtoms : (isSelected ? this.vwr.bsA() : this.vwr.getAllAtoms()));
            }
            if (helicalPath && translation != null) {
                points[1] = P3.newP(points[0]);
                points[1].add(translation);
                T3[] ret = Measure.computeHelicalAxis(points[0], points[1], q);
                points[0] = (P3)ret[0];
                float theta = ((P3)ret[3]).x;
                if (theta != 0.0f) {
                    translation = (V3)ret[1];
                    rotAxis = V3.newV(translation);
                    if (theta < 0.0f) {
                        rotAxis.scale(-1.0f);
                    }
                }
                m4 = null;
            }
            if (isSpin && m4 == null) {
                m4 = ScriptMathProcessor.getMatrix4f(q.getMatrix(), translation);
            }
            if (points[0] != null) {
                nPoints = 1;
            }
        }
        if (invPoint != null) {
            this.vwr.invertAtomCoordPt(invPoint, bsAtoms);
            if (rotAxis == null) {
                return;
            }
        }
        if (invPlane != null) {
            this.vwr.invertAtomCoordPlane(invPlane, bsAtoms);
            if (rotAxis == null) {
                return;
            }
        }
        boolean bl = requiresThread = isSpin && (!this.vwr.headless || endDegrees == Float.MAX_VALUE);
        if (isSpin && !requiresThread) {
            isSpin = false;
        }
        if (nPoints < 2 && dihedralList == null) {
            if (!isMolecular) {
                if (requiresThread && bsAtoms == null && !this.useThreads()) {
                    isSpin = false;
                    if (endDegrees == Float.MAX_VALUE) {
                        return;
                    }
                }
                if (this.vwr.rotateAxisAngleAtCenter(this, points[0], rotAxis, rate, endDegrees, isSpin, bsAtoms) && this.isJS && isSpin && bsAtoms == null && this.vwr.g.waitForMoveTo && endDegrees != Float.MAX_VALUE) {
                    throw new ScriptInterruption(this, "rotate", 1);
                }
                return;
            }
            if (nPoints == 0) {
                points[0] = new P3();
            }
            points[1] = P3.newP(points[0]);
            points[1].add(rotAxis);
            nPoints = 2;
        }
        if (nPoints == 0) {
            points[0] = new P3();
        }
        if (nPoints < 2 || points[0].distance(points[1]) == 0.0f) {
            points[1] = P3.newP(points[0]);
            points[1].y = (float)((double)points[1].y + 1.0);
        }
        if (endDegrees == Float.MAX_VALUE) {
            endDegrees = 0.0f;
        }
        if (endDegrees != 0.0f && translation != null && !haveRotation) {
            translation.scale(endDegrees / translation.length());
        }
        if (isSpin && translation != null && (endDegrees == 0.0f || degreesPerSecond == 0.0f)) {
            endDegrees = 0.01f;
            rate = degreesPerSecond == Float.MIN_VALUE ? 0.01f : (degreesPerSecond < 0.0f ? -endDegrees / degreesPerSecond : degreesPerSecond * 0.01f / translation.length());
            degreesPerSecond = 0.01f;
        }
        if (bsAtoms != null && isSpin && ptsB == null && m4 != null) {
            ptsA = this.vwr.ms.getAtomPointVector(bsAtoms);
            ptsB = Measure.transformPoints(ptsA, m4, points[0]);
        }
        if (bsAtoms != null && !isSpin && ptsB != null) {
            this.vwr.setAtomCoords(bsAtoms, 1145047050, ptsB);
        } else {
            if (requiresThread && !this.useThreads()) {
                return;
            }
            if (this.vwr.rotateAboutPointsInternal(this, points[0], points[1], rate, endDegrees, isSpin, bsAtoms, translation, ptsB, dihedralList, is4x4 ? m4 : null) && this.isJS && isSpin) {
                throw new ScriptInterruption(this, "rotate", 1);
            }
        }
    }

    private void cmdRestore() throws ScriptException {
        if (this.slen > 1) {
            String saveName = this.optParameterAsString(2);
            int tok = this.tokAt(1);
            switch (tok) {
                case 1814695966: {
                    if (!this.chk) {
                        this.setCurrentCagePts(null, null);
                    }
                    return;
                }
                case 1073742077: 
                case 1073742132: 
                case 1073742139: {
                    float floatSecondsTotal;
                    float f = floatSecondsTotal = this.slen > 3 ? this.floatParameter(3) : 0.0f;
                    if (floatSecondsTotal < 0.0f) {
                        this.invArg();
                    }
                    if (this.chk) {
                        return;
                    }
                    String type = "";
                    switch (tok) {
                        case 1073742077: {
                            type = "Orientation";
                            this.vwr.stm.restoreOrientation(saveName, floatSecondsTotal, true);
                            break;
                        }
                        case 1073742132: {
                            type = "Rotation";
                            this.vwr.stm.restoreOrientation(saveName, floatSecondsTotal, false);
                            break;
                        }
                        case 1073742139: {
                            type = "Scene";
                            this.vwr.stm.restoreScene(saveName, floatSecondsTotal);
                        }
                    }
                    if (this.isJS && floatSecondsTotal > 0.0f && this.vwr.g.waitForMoveTo) {
                        throw new ScriptInterruption(this, "restore" + type, 1);
                    }
                    return;
                }
            }
            this.checkLength23();
            switch (tok) {
                case 1677721602: {
                    if (!this.chk) {
                        this.vwr.stm.restoreBonds(saveName);
                    }
                    return;
                }
                case 14: {
                    if (this.chk) {
                        return;
                    }
                    ScriptContext sc = (ScriptContext)this.vwr.stm.getContext(saveName);
                    if (sc != null) {
                        this.restoreScriptContext(sc, true, false, false);
                        if (this.thisContext != null) {
                            this.thisContext.setMustResume();
                            this.mustResumeEval = true;
                            this.tQuiet = true;
                        }
                    }
                    return;
                }
                case 1073742329: {
                    if (this.chk) {
                        return;
                    }
                    String script = this.vwr.stm.getSavedCoordinates(saveName);
                    if (script == null) {
                        this.invArg();
                    }
                    this.runScript(script);
                    this.vwr.checkCoordinatesChanged();
                    return;
                }
                case 1073742140: {
                    if (!this.chk) {
                        this.vwr.stm.restoreSelection(saveName);
                    }
                    return;
                }
                case 1073742158: {
                    if (this.chk) {
                        return;
                    }
                    String state = this.vwr.stm.getSavedState(saveName);
                    if (state == null) {
                        this.invArg();
                    }
                    this.runScript(state);
                    return;
                }
                case 1639976963: {
                    if (this.chk) {
                        return;
                    }
                    String shape = this.vwr.stm.getSavedStructure(saveName);
                    if (shape == null) {
                        this.invArg();
                    }
                    this.runScript(shape);
                    return;
                }
            }
        }
        this.errorStr2(53, "RESTORE", saveList);
    }

    private void cmdSave() throws ScriptException {
        if (this.slen > 1) {
            String saveName = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 1677721602: {
                    if (!this.chk) {
                        this.vwr.stm.saveBonds(saveName);
                    }
                    return;
                }
                case 14: {
                    if (!this.chk) {
                        this.saveContext(saveName);
                    }
                    return;
                }
                case 1073742329: {
                    if (!this.chk) {
                        this.vwr.stm.saveCoordinates(saveName, this.vwr.bsA());
                    }
                    return;
                }
                case 1073742077: 
                case 1073742132: {
                    if (!this.chk) {
                        this.vwr.stm.saveOrientation(saveName, null);
                    }
                    return;
                }
                case 1073742140: {
                    if (!this.chk) {
                        this.vwr.stm.saveSelection(saveName, this.vwr.bsA());
                        this.vwr.stm.restoreSelection(saveName);
                    }
                    return;
                }
                case 1073742158: {
                    if (!this.chk) {
                        this.vwr.stm.saveState(saveName);
                    }
                    return;
                }
                case 1639976963: {
                    if (!this.chk) {
                        this.vwr.stm.saveStructure(saveName);
                    }
                    return;
                }
            }
        }
        this.errorStr2(53, "SAVE", saveList);
    }

    public void cmdScript(int tok, String filename, String theScript) throws ScriptException {
        if (tok == 134238732) {
            this.checkLength(2);
            if (!this.chk) {
                this.vwr.jsEval(this.paramAsStr(1));
            }
            return;
        }
        boolean loadCheck = true;
        boolean isCheck = false;
        boolean doStep = false;
        boolean isAsync = this.vwr.async;
        int lineNumber = 0;
        int pc = 0;
        int lineEnd = 0;
        int pcEnd = 0;
        int i = 1;
        String localPath = null;
        String remotePath = null;
        String scriptPath = null;
        Lst<SV> params = null;
        if (tok == 4124) {
            i = -2;
        }
        if (filename == null && theScript == null) {
            tok = this.tokAt(i);
            if (tok != 4) {
                this.error(16);
            }
            if ((filename = this.paramAsStr(i)).equalsIgnoreCase("async")) {
                isAsync = true;
                filename = this.paramAsStr(++i);
            }
            if (filename.equalsIgnoreCase("applet")) {
                String appID = this.paramAsStr(++i);
                theScript = this.parameterExpressionString(++i, 0);
                this.checkLast(this.iToken);
                if (this.chk) {
                    return;
                }
                if (appID.length() == 0 || appID.equals("all")) {
                    appID = "*";
                }
                if (!appID.equals(".")) {
                    this.vwr.jsEval(appID + "\u0001" + theScript);
                    if (!appID.equals("*")) {
                        return;
                    }
                }
            } else {
                tok = this.tokAt(this.slen - 1);
                boolean bl = doStep = tok == 266298;
                if (filename.equalsIgnoreCase("inline")) {
                    theScript = this.parameterExpressionString(++i, doStep ? this.slen - 1 : 0);
                    i = this.iToken;
                }
                while (filename.equalsIgnoreCase("localPath") || filename.equalsIgnoreCase("remotePath") || filename.equalsIgnoreCase("scriptPath")) {
                    if (filename.equalsIgnoreCase("localPath")) {
                        localPath = this.paramAsStr(++i);
                    } else if (filename.equalsIgnoreCase("scriptPath")) {
                        scriptPath = this.paramAsStr(++i);
                    } else {
                        remotePath = this.paramAsStr(++i);
                    }
                    filename = this.paramAsStr(++i);
                }
                if ((this.vwr.isJS || this.vwr.testAsync) && (isAsync || filename.startsWith("?"))) {
                    filename = this.loadFileAsync("SCRIPT_", filename, i, true);
                }
                if ((tok = this.tokAt(++i)) == 1073741878) {
                    isCheck = true;
                    tok = this.tokAt(++i);
                }
                if (tok == 1073742050) {
                    loadCheck = false;
                    tok = this.tokAt(++i);
                }
                if (tok == 1073741998 || tok == 0x44000004) {
                    int n = ++i;
                    lineEnd = lineNumber = Math.max(this.intParameter(n), 0);
                    if (this.checkToken(++i) && (lineEnd = this.getToken((int)i).tok == 0x100000A0 ? (this.checkToken(++i) ? this.intParameter(i++) : 0) : -this.intParameter(i++)) <= 0) {
                        this.invArg();
                    }
                } else if (tok == 0x40000042 || tok == 0x40000044) {
                    int n = ++i;
                    pc = Math.max(this.intParameter(n) - 1, 0);
                    pcEnd = pc + 1;
                    if (this.checkToken(++i) && (pcEnd = this.getToken((int)i).tok == 0x100000A0 ? (this.checkToken(++i) ? this.intParameter(i++) : 0) : -this.intParameter(i++)) <= 0) {
                        this.invArg();
                    }
                }
                i = -i;
            }
        } else if (filename != null && isAsync) {
            filename = this.loadFileAsync("SCRIPT_", filename, i, true);
        }
        if (i < 0) {
            if (this.tokAt(i = -i) == 0x10000010) {
                params = this.parameterExpressionList(i, -1, false);
                i = this.iToken + 1;
            }
            this.checkLength(doStep ? i + 1 : i);
        }
        if (this.chk && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        if (this.isCmdLine_c_or_C_Option) {
            isCheck = true;
        }
        boolean wasSyntaxCheck = this.chk;
        boolean wasScriptCheck = this.isCmdLine_c_or_C_Option;
        if (isCheck) {
            this.isCmdLine_c_or_C_Option = true;
            this.chk = true;
        }
        this.pushContext(null, "SCRIPT");
        this.contextPath = this.contextPath + " >> " + filename;
        if (theScript == null ? this.compileScriptFileInternal(filename, localPath, remotePath, scriptPath) : this.compileScript(null, theScript, false)) {
            boolean timeMsg;
            this.pcEnd = pcEnd;
            this.lineEnd = lineEnd;
            while (pc < this.lineNumbers.length && this.lineNumbers[pc] < lineNumber) {
                ++pc;
            }
            this.pc = pc;
            boolean saveLoadCheck = this.isCmdLine_C_Option;
            this.isCmdLine_C_Option &= loadCheck;
            this.executionStepping |= doStep;
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable();
            }
            this.contextVariables.put("_arguments", params == null ? SV.getVariableAI(new int[0]) : SV.getVariableList(params));
            this.contextVariables.put("_argcount", SV.newI(params == null ? 0 : params.size()));
            if (isCheck) {
                this.listCommands = true;
            }
            if (timeMsg = this.vwr.getBoolean(603979934)) {
                Logger.startTimer("script");
            }
            this.dispatchCommands(false, false, false);
            if (this.isStateScript) {
                ScriptManager.setStateScriptVersion(this.vwr, null);
            }
            if (timeMsg) {
                this.showString(Logger.getTimerMsg("script", 0));
            }
            this.isCmdLine_C_Option = saveLoadCheck;
            this.popContext(false, false);
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext(false, false);
            if (wasScriptCheck) {
                this.setErrorMessage(null);
            } else {
                this.evalError(null, null);
            }
        }
        this.chk = wasSyntaxCheck;
        this.isCmdLine_c_or_C_Option = wasScriptCheck;
    }

    private void cmdSelect(int i) throws ScriptException {
        if (this.slen == 1) {
            this.vwr.select(null, false, 0, !this.doReport());
            return;
        }
        if (this.slen == 2 && this.tokAt(1) == 1073742072) {
            return;
        }
        int tok = this.tokAt(2);
        this.vwr.slm.noneSelected = this.slen == 4 && tok == 1073742333;
        BS bs = null;
        switch (tok) {
            case 10: {
                if (!(this.getToken((int)2).value instanceof BondSet) && (this.tokAt(2) != 1677721602 || this.getToken((int)3).tok != 10)) break;
                if (this.slen != this.iToken + 2) {
                    this.invArg();
                }
                if (!this.chk) {
                    this.vwr.selectBonds((BS)this.theToken.value);
                }
                return;
            }
            case 1677721602: 
            case 1745489939: {
                if (this.slen == 5 && this.tokAt(3) == 10) {
                    bs = (BS)this.getToken((int)3).value;
                    ++this.iToken;
                } else if (this.isArrayParameter(4)) {
                    bs = new BS();
                    int[] a = this.expandFloatArray(this.floatParameterSet(4, 0, Integer.MAX_VALUE), 0);
                    int ii = a.length;
                    while (--ii >= 0) {
                        if (a[ii] < 0) continue;
                        bs.set(a[ii]);
                    }
                }
                this.checkLast(this.iToken);
                if (this.chk) {
                    return;
                }
                if (bs == null) {
                    this.invArg();
                }
                if (tok == 1745489939) {
                    this.setShapeProperty(6, "select", bs);
                } else {
                    this.vwr.selectBonds(bs);
                }
                return;
            }
        }
        int addRemove = 0;
        boolean isGroup = false;
        if (this.getToken((int)1).intValue == 0 && this.theTok != 1073742334) {
            Object v = this.parameterExpressionToken((int)0).value;
            if (!(v instanceof BS)) {
                this.invArg();
            }
            this.checkLast(this.iToken);
            bs = (BS)v;
        } else {
            tok = this.tokAt(i);
            switch (tok) {
                case 1073742334: 
                case 1073742335: {
                    if (!this.chk) {
                        this.vwr.setSelectionHalosEnabled(tok == 1073742335);
                    }
                    if ((tok = this.tokAt(++i)) != 0) break;
                    return;
                }
            }
            switch (tok) {
                case 1073742119: 
                case 1275069441: {
                    addRemove = tok;
                    tok = this.tokAt(++i);
                }
            }
            boolean bl = isGroup = tok == 1086324742;
            if (isGroup) {
                tok = this.tokAt(++i);
            }
            bs = this.atomExpressionAt(i);
        }
        if (this.chk) {
            return;
        }
        if (this.isBondSet) {
            this.vwr.selectBonds(bs);
        } else {
            if (bs.length() > this.vwr.ms.ac) {
                BS bs1 = this.vwr.getAllAtoms();
                bs1.and(bs);
                bs = bs1;
            }
            this.vwr.select(bs, isGroup, addRemove, !this.doReport());
        }
    }

    private void cmdSelectionHalos(int pt) throws ScriptException {
        boolean showHalo = false;
        switch (pt == this.slen ? 1073742335 : this.getToken((int)pt).tok) {
            case 1073742335: 
            case 1113589787: {
                showHalo = true;
            }
            case 1073742056: 
            case 1073742333: 
            case 1073742334: {
                this.setBooleanProperty("selectionHalos", showHalo);
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void cmdSet() throws ScriptException {
        boolean isContextVariable;
        String sval;
        if (this.slen == 1) {
            this.showString(this.vwr.getAllSettings(null));
            return;
        }
        boolean isJmolSet = this.paramAsStr(0).equals("set");
        String key = this.optParameterAsString(1);
        if (isJmolSet && this.slen == 2 && key.indexOf("?") >= 0) {
            this.showString(this.vwr.getAllSettings(key.substring(0, key.indexOf("?"))));
            return;
        }
        int tok = this.getToken((int)1).tok;
        int newTok = 0;
        int ival = Integer.MAX_VALUE;
        boolean showing = !this.chk && this.doReport() && !((String)this.st[0].value).equals("var");
        switch (tok) {
            case 553648148: 
            case 603979868: 
            case 603979902: 
            case 603979924: 
            case 603979960: 
            case 603979962: 
            case 603979964: 
            case 603979965: 
            case 603979970: {
                if (!this.isStateScript) break;
                return;
            }
            case 1611272194: {
                this.cmdAxes(2);
                return;
            }
            case 1610616835: {
                this.cmdBackground(2);
                return;
            }
            case 1678381065: {
                this.cmdBoundbox(2);
                return;
            }
            case 1611272202: {
                this.cmdFrank(2);
                return;
            }
            case 1610616855: {
                this.cmdHistory(2);
                return;
            }
            case 1825200146: {
                this.cmdLabel(2, null);
                return;
            }
            case 1814695966: {
                this.cmdUnitcell(2);
                return;
            }
            case 0x20000008: {
                this.sm.loadShape(8);
                this.setShapeProperty(8, "highlight", this.tokAt(2) == 1073742334 ? null : this.atomExpressionAt(2));
                return;
            }
            case 1610625028: 
            case 1611141171: {
                this.cmdSelectionHalos(2);
                return;
            }
            case 536875070: {
                this.cmdTimeout(2);
                return;
            }
            case 536870932: {
                Object object;
                if (this.isArrayParameter(2)) {
                    object = this.floatParameterSet(2, 2, 2);
                } else if (this.tokAt(2) == 2) {
                    float[] fArray = new float[2];
                    fArray[0] = this.intParameter(2);
                    object = fArray;
                    fArray[1] = this.intParameter(3);
                } else {
                    object = this.stringParameter(2);
                }
                float[] o = object;
                this.checkLast(this.iToken);
                if (this.chk) {
                    return;
                }
                if (o instanceof String) {
                    if (this.vwr.fm.loadImage(o, "\u0000windowImage", !this.useThreads())) {
                        throw new ScriptInterruption(this, "windowImage", 1);
                    }
                } else {
                    this.vwr.setWindowDimensions(o);
                }
                return;
            }
            case 1639976963: {
                float[] data;
                STR type = STR.getProteinStructureType(this.paramAsStr(2));
                if (type == STR.NOT) {
                    this.invArg();
                }
                if ((data = this.floatParameterSet(3, 0, Integer.MAX_VALUE)).length % 4 != 0) {
                    this.invArg();
                }
                this.vwr.setStructureList(data, type);
                this.checkLast(this.iToken);
                return;
            }
            case 545259526: {
                ival = this.getArgbParam(2);
                if (!this.chk) {
                    this.setObjectArgb("axes", ival);
                }
                return;
            }
            case 0x60000001: {
                boolean b = false;
                switch (this.getToken((int)this.checkLast((int)2)).tok) {
                    case 0x10000060: {
                        break;
                    }
                    case 0x10000050: {
                        b = true;
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                this.setBooleanProperty("bondModeOr", b);
                return;
            }
            case 0x20000004: {
                if (this.chk) {
                    return;
                }
                int iLevel = this.tokAt(2) == 1073742334 || this.tokAt(2) == 2 && this.intParameter(2) == 0 ? 4 : 5;
                Logger.setLogLevel(iLevel);
                this.setIntProperty("logLevel", iLevel);
                if (iLevel == 4) {
                    this.vwr.setDebugScript(false);
                    if (showing) {
                        this.vwr.showParameter("debugScript", true, 80);
                    }
                }
                this.setDebugging();
                if (showing) {
                    this.vwr.showParameter("logLevel", true, 80);
                }
                return;
            }
            case 537022465: {
                this.cmdSetEcho();
                return;
            }
            case 0x60000002: {
                this.cmdFont(5, this.checkLength23() == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 1613238294: {
                boolean bool = false;
                switch (this.tokAt(this.checkLast(2))) {
                    case 1114249217: {
                        bool = true;
                    }
                    case 2097178: {
                        this.setBooleanProperty("hbondsBackbone", bool);
                        break;
                    }
                    case 1073742150: {
                        bool = true;
                    }
                    case 0x40000066: {
                        this.setBooleanProperty("hbondsSolid", bool);
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                return;
            }
            case 0x20021010: 
            case 1745489939: {
                tok = this.tokAt(this.checkLast(2));
                switch (tok) {
                    case 1073742334: 
                    case 1073742335: {
                        this.setBooleanProperty("measurementlabels", tok == 1073742335);
                        return;
                    }
                    case 2: 
                    case 3: 
                    case 0x40000066: {
                        this.vwr.shm.loadShape(6);
                        int mad10 = this.getSetAxesTypeMad10(2);
                        if (mad10 != Integer.MAX_VALUE) {
                            this.setShapeSizeBs(6, mad10 / 10, null);
                        }
                        return;
                    }
                }
                this.setUnits(this.paramAsStr(2), 545259568);
                return;
            }
            case 1611141176: {
                boolean b = false;
                switch (this.tokAt(this.checkLast(2))) {
                    case 1114249217: {
                        b = true;
                        break;
                    }
                    case 2097178: {
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                this.setBooleanProperty("ssbondsBackbone", b);
                return;
            }
            case 0x60000005: {
                this.cmdSetLabel("toggle");
                return;
            }
            case 0x20000012: {
                Lst<Integer> v = new Lst<Integer>();
                for (int i = 2; i < this.slen; ++i) {
                    int argb = this.getArgbParam(i);
                    v.addLast(argb);
                    i = this.iToken;
                }
                if (this.chk) {
                    return;
                }
                int n = v.size();
                int[] scale = new int[n];
                int i = n;
                while (--i >= 0) {
                    scale[i] = (Integer)v.get(i);
                }
                this.vwr.cm.ce.setUserScale(scale);
                return;
            }
            case 553648188: {
                P3 pt;
                if (this.isFloatParameter(2)) {
                    this.checkLength(3);
                    this.setIntProperty("zSlab", (int)this.floatParameter(2));
                    pt = null;
                } else {
                    if (!this.isCenterParameter(2)) {
                        this.invArg();
                    }
                    pt = this.centerParameter(2, null);
                    this.checkLength(this.iToken + 1);
                }
                if (!this.chk) {
                    this.vwr.tm.zSlabPoint = pt == null ? null : P3.newP(pt);
                }
                return;
            }
        }
        boolean justShow = true;
        switch (tok) {
            case 0x20000002: {
                int modelNumber;
                if (this.slen <= 2) break;
                String modelDotted = this.getSettingStr(2, false);
                boolean useModelNumber = false;
                if (modelDotted.indexOf(".") < 0) {
                    modelNumber = PT.parseInt(modelDotted);
                    useModelNumber = true;
                } else {
                    modelNumber = ScriptEval.getFloatEncodedInt(modelDotted);
                }
                if (this.chk) {
                    return;
                }
                int modelIndex = this.vwr.ms.getModelNumberIndex(modelNumber, useModelNumber, true);
                this.vwr.setBackgroundModelIndex(modelIndex);
                return;
            }
            case 1648363544: {
                if (this.chk) {
                    return;
                }
                this.vwr.setAtomProperty(this.vwr.getAllAtoms(), 1648363544, -1, Float.NaN, null, null, null);
                if (this.slen > 2 && "probe".equalsIgnoreCase(this.getSettingStr(2, false))) {
                    this.runScript("#VDW radii for PROBE;{_H}.vdw = 1.0;{_H and connected(_C) and not connected(within(smiles,'[a]'))}.vdw = 1.17;{_C}.vdw = 1.75;{_C and connected(3) and connected(_O)}.vdw = 1.65;{_N}.vdw = 1.55;{_O}.vdw = 1.4;{_P}.vdw = 1.8;{_S}.vdw = 1.8;message VDW radii for H, C, N, O, P, and S set according to Word, et al., J. Mol. Biol. (1999) 285, 1711-1733");
                    return;
                }
                newTok = 545259555;
            }
            case 545259555: {
                if (this.slen <= 2) break;
                sval = this.paramAsStr(2);
                if (this.slen == 3 && VDW.getVdwType(sval) == null && VDW.getVdwType(sval = this.getSettingStr(2, false)) == null) {
                    this.invArg();
                }
                this.setStringProperty(key, sval);
                break;
            }
            case 0x20000006: {
                P3 pt;
                if (this.slen <= 2) break;
                SV var = this.parameterExpressionToken(2);
                if (var.tok == 8) {
                    pt = (P3)var.value;
                } else {
                    pt = new P3();
                    int ijk = var.asInt();
                    if (ijk >= 100) {
                        SimpleUnitCell.ijkToPoint3f(ijk, pt, -1);
                    }
                }
                if (this.chk) break;
                this.vwr.setDefaultLattice(pt);
                break;
            }
            case 545259545: 
            case 0x20800020: {
                if (this.slen <= 2) break;
                this.theTok = this.tokAt(2);
                sval = this.theTok == 1073741991 || this.theTok == 1073742116 ? this.paramAsStr(this.checkLast(2)) : this.getSettingStr(2, false);
                this.setStringProperty(key, sval);
                break;
            }
            case 1631586315: {
                ival = this.getSettingInt(2);
                if (ival == Integer.MIN_VALUE) {
                    this.invArg();
                }
                if (!this.chk) {
                    this.vwr.ms.setFormalCharges(this.vwr.bsA(), ival);
                }
                return;
            }
            case 545259564: {
                if (this.slen <= 2) break;
                this.setStringProperty(key, this.getSettingStr(2, isJmolSet));
                break;
            }
            case 545259559: 
            case 545259568: {
                if (this.slen <= 2) break;
                this.setUnits(this.getSettingStr(2, isJmolSet), tok);
                break;
            }
            case 545259573: {
                if (!this.chk) {
                    this.vwr.setPicked(-1);
                }
                if (this.slen <= 2) break;
                this.cmdSetPicking();
                return;
            }
            case 545259574: {
                if (this.slen <= 2) break;
                this.cmdSetPickingStyle();
                return;
            }
            case 1715472409: {
                break;
            }
            case 0x2000000C: {
                ival = this.getSettingInt(2);
                if (ival == Integer.MIN_VALUE || ival == 0 || ival == 1) {
                    justShow = false;
                    break;
                }
                tok = 553648174;
                key = "specularPercent";
                this.setIntProperty(key, ival);
                break;
            }
            case 1649022989: {
                tok = 553648178;
                key = "strandCount";
                this.setIntProperty(key, this.getSettingInt(2));
                break;
            }
            default: {
                justShow = false;
            }
        }
        if (justShow && !showing) {
            return;
        }
        boolean bl = isContextVariable = !justShow && !isJmolSet && this.getContextVariableAsVariable(key, false) != null;
        if (!justShow && !isContextVariable) {
            switch (tok) {
                case 1677721602: {
                    newTok = 603979928;
                    break;
                }
                case 0x60200006: {
                    newTok = 603979908;
                    break;
                }
                case 1612709900: {
                    newTok = 603979910;
                    break;
                }
                case 0x60000003: {
                    newTok = 603979879;
                    break;
                }
                case 1665140738: {
                    newTok = 0x22000032;
                    this.setFloatProperty("solventProbeRadius", this.getSettingFloat(2));
                    justShow = true;
                    break;
                }
                case 0x60000004: {
                    newTok = 0x2200002E;
                    break;
                }
                case 1612709912: {
                    newTok = 603979948;
                    break;
                }
                case 1765808134: {
                    newTok = 545259545;
                    break;
                }
                case 1611141175: {
                    sval = this.paramAsStr(2).toLowerCase();
                    switch ("x;y;z;fps;".indexOf(sval + ";")) {
                        case 0: {
                            newTok = 570425398;
                            break;
                        }
                        case 2: {
                            newTok = 570425400;
                            break;
                        }
                        case 4: {
                            newTok = 570425402;
                            break;
                        }
                        case 6: {
                            newTok = 570425396;
                            break;
                        }
                        default: {
                            this.errorStr2(50, "set SPIN ", sval);
                        }
                    }
                    if (!this.chk) {
                        this.vwr.setSpin(sval, (int)this.floatParameter(this.checkLast(3)));
                    }
                    justShow = true;
                }
            }
        }
        if (newTok != 0) {
            tok = newTok;
            key = T.nameOf(tok);
        } else if (!justShow && !isContextVariable) {
            String lckey;
            if (key.length() == 0 || key.charAt(0) == '_' && this.tokAt(2) != 0x10000040) {
                this.error(56);
            }
            if ((lckey = key.toLowerCase()).indexOf("label") == 0 && PT.isOneOf(lckey.substring(5), ";front;group;atom;offset;offsetexact;offsetabsolute;pointer;alignment;toggle;scalereference;for;") && this.cmdSetLabel(lckey.substring(5))) {
                return;
            }
            if (isJmolSet && lckey.indexOf("shift_") == 0) {
                float f = this.floatParameter(2);
                this.checkLength(3);
                if (!this.chk) {
                    this.vwr.getNMRCalculation().setChemicalShiftReference(lckey.substring(6), f);
                }
                return;
            }
            if (lckey.endsWith("callback")) {
                tok = 0x20000000;
            }
        }
        if (isJmolSet && !T.tokAttr(tok, 0x20000000)) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.errorStr2(50, "SET", key);
            }
            this.warning(51, "SET", key);
        }
        if (!justShow && isJmolSet) {
            switch (this.slen) {
                case 2: {
                    this.setBooleanProperty(key, true);
                    justShow = true;
                    break;
                }
                case 3: {
                    if (ival == Integer.MAX_VALUE) break;
                    this.setIntProperty(key, ival);
                    justShow = true;
                }
            }
        }
        if (!justShow && !isJmolSet && this.tokAt(2) == 1073742333) {
            if (!this.chk) {
                this.vwr.removeUserVariable(key.toLowerCase());
            }
            justShow = true;
        }
        if (!justShow) {
            this.setVariable(1, 0, key, true);
            if (!isJmolSet) {
                return;
            }
        }
        if (showing) {
            this.vwr.showParameter(key, true, 80);
        }
    }

    private void cmdSetEcho() throws ScriptException {
        String propertyName = null;
        Object propertyValue = null;
        Object id = null;
        boolean echoShapeActive = true;
        int pt = 2;
        switch (this.getToken((int)2).tok) {
            case 1073742334: {
                propertyName = "allOff";
                id = "allOff";
                this.checkLength(++pt);
                break;
            }
            case 1073742333: {
                echoShapeActive = false;
            }
            case 1073742327: {
                id = this.paramAsStr(2);
                this.checkLength(++pt);
                break;
            }
            case 4: 
            case 12289: 
            case 0x40000000: 
            case 1073741871: 
            case 1073741974: 
            case 1073741996: 
            case 1073742019: 
            case 1073742126: 
            case 1073742172: {
                if (this.theTok == 1073741974) {
                    // empty if block
                }
                int n = ++pt;
                ++pt;
                id = this.paramAsStr(n);
            }
        }
        if (!this.chk) {
            this.vwr.ms.setEchoStateActive(echoShapeActive);
            this.sm.loadShape(31);
            if (id != null) {
                this.setShapeProperty(31, propertyName == null ? "target" : propertyName, id);
            }
        }
        if (pt < this.slen) {
            block6 : switch (this.getToken((int)pt++).tok) {
                case 0x40000008: {
                    propertyName = "align";
                    switch (this.getToken((int)pt).tok) {
                        case 12289: 
                        case 1073741996: 
                        case 1073742126: {
                            propertyValue = this.paramAsStr(pt++);
                            break block6;
                        }
                    }
                    this.invArg();
                    break;
                }
                case 12289: 
                case 1073741996: 
                case 1073742126: {
                    propertyName = "align";
                    propertyValue = this.paramAsStr(pt - 1);
                    break;
                }
                case 554176526: {
                    propertyName = "%zpos";
                    propertyValue = (int)this.floatParameter(pt++);
                    break;
                }
                case 0x200028: 
                case 1073742335: 
                case 1610625028: {
                    propertyName = "hidden";
                    propertyValue = Boolean.FALSE;
                    break;
                }
                case 12294: 
                case 0x20002A: {
                    propertyName = "hidden";
                    propertyValue = Boolean.TRUE;
                    break;
                }
                case 1094717454: {
                    int modelIndex;
                    int n = modelIndex = this.chk ? 0 : this.modelNumberParameter(pt++);
                    if (modelIndex >= this.vwr.ms.mc) {
                        this.invArg();
                    }
                    propertyName = "model";
                    propertyValue = modelIndex;
                    break;
                }
                case 0x10000040: 
                case 1073742195: {
                    propertyName = "xypos";
                    propertyValue = this.xypParameter(--pt);
                    if (propertyValue == null) {
                        this.invArg();
                    }
                    pt = this.iToken + 1;
                    break;
                }
                case 2: {
                    int posx = this.intParameter(pt - 1);
                    String namex = "xpos";
                    if (this.tokAt(pt) == 268435634) {
                        namex = "%xpos";
                    }
                    propertyName = "ypos";
                    int n = ++pt;
                    propertyValue = this.intParameter(n);
                    if (this.tokAt(++pt) == 268435634) {
                        propertyName = "%ypos";
                        ++pt;
                    }
                    this.checkLength(pt);
                    this.setShapeProperty(31, namex, posx);
                    break;
                }
                case 1073742066: {
                    propertyName = "offset";
                    if (this.isPoint3f(pt)) {
                        P3 pt3 = this.getPoint3f(pt, false);
                        propertyValue = new float[]{-1.0f, pt3.x, pt3.y, pt3.z, 0.0f, 0.0f, 0.0f};
                        pt = this.iToken + 1;
                        break;
                    }
                    if (!this.isArrayParameter(pt)) break;
                    propertyValue = this.floatParameterSet(pt, 7, 7);
                    pt = this.iToken + 1;
                    break;
                }
                case 1073742334: {
                    propertyName = "off";
                    break;
                }
                case 1073742138: {
                    propertyName = "scale";
                    propertyValue = Float.valueOf(this.floatParameter(pt++));
                    break;
                }
                case 134222850: {
                    propertyName = "script";
                    propertyValue = this.paramAsStr(pt++);
                    break;
                }
                case 4120: {
                    ++pt;
                }
                case 4: {
                    boolean isImage = this.theTok != 4;
                    this.checkLength(pt--);
                    if (isImage) {
                        if (id == null) {
                            Object[] data = new String[1];
                            this.getShapePropertyData(31, "currentTarget", data);
                            id = data[0];
                        }
                        if (!this.chk && this.vwr.ms.getEchoStateActive() && this.vwr.fm.loadImage(this.getToken((int)pt).value, (String)id, !this.useThreads())) {
                            throw new ScriptInterruption(this, "setEchoImage", 1);
                        }
                        return;
                    }
                    this.cmdEcho(pt);
                    return;
                }
                case 134217751: {
                    propertyName = "point";
                    propertyValue = this.isCenterParameter(pt) ? this.centerParameter(pt, null) : null;
                    pt = this.iToken + 1;
                    break;
                }
                default: {
                    if (this.isCenterParameter(pt - 1)) {
                        propertyName = "xyz";
                        propertyValue = this.centerParameter(pt - 1, null);
                        pt = this.iToken + 1;
                        break;
                    }
                    this.invArg();
                }
            }
        }
        this.checkLength(pt);
        if (!this.chk && propertyName != null) {
            this.setShapeProperty(31, propertyName, propertyValue);
        }
    }

    private boolean cmdSetLabel(String str) throws ScriptException {
        this.sm.loadShape(5);
        Object propertyValue = null;
        this.setShapeProperty(5, "setDefaults", this.vwr.slm.noneSelected);
        if (str.equals("for")) {
            BS bs = this.atomExpressionAt(2);
            this.cmdLabel(this.iToken + 1, bs);
            return true;
        }
        if (str.equals("scalereference")) {
            float scaleAngstromsPerPixel = this.floatParameter(2);
            if (scaleAngstromsPerPixel >= 5.0f) {
                scaleAngstromsPerPixel = this.vwr.tm.getZoomSetting() / scaleAngstromsPerPixel / this.vwr.getScalePixelsPerAngstrom(false);
            }
            propertyValue = Float.valueOf(scaleAngstromsPerPixel);
        } else {
            boolean isAbsolute = false;
            if (str.equals("offset") || (isAbsolute = str.equals("offsetabsolute") || str.equals("offsetexact"))) {
                str = "offset";
                if (this.isPoint3f(2)) {
                    P3 pt = this.getPoint3f(2, false);
                    propertyValue = new float[]{-1.0f, pt.x, pt.y, pt.z, 0.0f, 0.0f, 0.0f};
                } else if (this.isArrayParameter(2)) {
                    propertyValue = this.floatParameterSet(2, 7, 7);
                } else {
                    int xOffset = this.intParameterRange(2, -500, 500);
                    int yOffset = this.intParameterRange(3, -500, 500);
                    if (xOffset == Integer.MAX_VALUE || yOffset == Integer.MAX_VALUE) {
                        return true;
                    }
                    propertyValue = JC.getOffset(xOffset, yOffset, isAbsolute);
                }
            } else if (str.equals("alignment")) {
                switch (this.getToken((int)2).tok) {
                    case 12289: 
                    case 1073741996: 
                    case 1073742126: {
                        str = "align";
                        propertyValue = this.theToken.value;
                        break;
                    }
                    default: {
                        this.invArg();
                        break;
                    }
                }
            } else if (str.equals("pointer")) {
                int flags = 0;
                switch (this.getToken((int)2).tok) {
                    case 1073742333: 
                    case 1073742334: {
                        break;
                    }
                    case 1610616835: {
                        flags |= 2;
                    }
                    case 1073742335: {
                        flags |= 1;
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                propertyValue = flags;
            } else {
                boolean TF;
                if (str.equals("toggle")) {
                    this.iToken = 1;
                    BS bs = this.slen == 2 ? this.vwr.bsA() : this.atomExpressionAt(2);
                    this.checkLast(this.iToken);
                    if (this.chk) {
                        return true;
                    }
                    this.vwr.shm.loadShape(5);
                    this.vwr.shm.setShapePropertyBs(5, "toggleLabel", null, bs);
                    return true;
                }
                this.iToken = 1;
                boolean bl = TF = this.slen == 2 || this.getToken((int)2).tok == 1073742335;
                if (str.equals("front") || str.equals("group")) {
                    if (!TF && this.tokAt(2) != 1073742334) {
                        this.invArg();
                    }
                    if (!TF) {
                        str = "front";
                    }
                    propertyValue = TF ? Boolean.TRUE : Boolean.FALSE;
                } else if (str.equals("atom")) {
                    if (!TF && this.tokAt(2) != 1073742334) {
                        this.invArg();
                    }
                    str = "front";
                    propertyValue = TF ? Boolean.FALSE : Boolean.TRUE;
                } else {
                    return false;
                }
            }
        }
        BS bs = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
        this.checkLast(this.iToken);
        if (this.chk) {
            return true;
        }
        if (bs == null) {
            this.setShapeProperty(5, str, propertyValue);
        } else {
            this.setShapePropertyBs(5, str, propertyValue, bs);
        }
        return true;
    }

    private void cmdSetPicking() throws ScriptException {
        if (this.slen == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.slen > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.getSettingStr(2, false));
            return;
        }
        int i = 2;
        String type = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1275082245: 
            case 1611141175: 
            case 1745489939: {
                if (this.checkLength34() != 4) break;
                type = this.paramAsStr(2).toUpperCase();
                if (type.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                i = 3;
                break;
            }
            case 12291: {
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String str = this.paramAsStr(i);
        switch (this.getToken((int)i).tok) {
            case 1073742056: 
            case 1073742335: {
                str = "identify";
                break;
            }
            case 1073742333: 
            case 1073742334: {
                str = "off";
                break;
            }
            case 1275082245: {
                str = "atom";
                break;
            }
            case 1825200146: {
                str = "label";
                break;
            }
            case 1677721602: {
                str = "bond";
                break;
            }
            case 12291: {
                this.checkLength(4);
                if (this.tokAt(3) != 1677721602) {
                    this.invArg();
                }
                str = "deleteBond";
            }
        }
        int mode = str.indexOf("_");
        mode = mode >= 0 ? mode : str.length();
        mode = ActionManager.getPickingMode(str.substring(0, mode));
        if (mode < 0) {
            this.errorStr2(50, "SET PICKING " + type, str);
        }
        this.setStringProperty("picking", str);
    }

    private void cmdSetPickingStyle() throws ScriptException {
        if (this.slen > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.getSettingStr(2, false));
            return;
        }
        int i = 2;
        boolean isMeasure = false;
        String type = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1745489939: {
                isMeasure = true;
                type = "MEASURE";
            }
            case 1275082245: {
                if (this.checkLength34() != 4) break;
                i = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String str = this.paramAsStr(i);
        switch (this.getToken((int)i).tok) {
            case 1073742333: 
            case 1073742334: {
                str = isMeasure ? "measureoff" : "toggle";
                break;
            }
            case 1073742335: {
                if (!isMeasure) break;
                str = "measure";
            }
        }
        if (ActionManager.getPickingStyleIndex(str) < 0) {
            this.errorStr2(50, "SET PICKINGSTYLE " + type, str);
        }
        this.setStringProperty("pickingStyle", str);
    }

    private void cmdSlab(boolean isDepth) throws ScriptException {
        boolean TF = false;
        P4 plane = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 9) {
            plane = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    int percent = this.intParameter(this.checkLast(1));
                    if (!this.chk) {
                        if (isDepth) {
                            this.vwr.tm.depthToPercent(percent);
                        } else {
                            this.vwr.tm.slabToPercent(percent);
                        }
                    }
                    return;
                }
                case 1073742335: {
                    TF = true;
                }
                case 1073742334: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", TF);
                    return;
                }
                case 4141: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    this.vwr.tm.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 36867: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.tm.setSlabDepthInternal(isDepth);
                    }
                    return;
                }
                case 0x100000A0: {
                    String str = this.paramAsStr(2);
                    if (str.equalsIgnoreCase("hkl")) {
                        plane = this.hklParameter(3);
                    } else if (str.equalsIgnoreCase("plane")) {
                        plane = this.planeParameter(2);
                    }
                    if (plane == null) {
                        this.invArg();
                    }
                    plane.scale4(-1.0f);
                    break;
                }
                case 134217750: {
                    switch (this.getToken((int)2).tok) {
                        case 1073742333: {
                            break block0;
                        }
                    }
                    plane = this.planeParameter(1);
                    break;
                }
                case 134219265: {
                    plane = this.getToken((int)2).tok == 1073742333 ? null : this.hklParameter(2);
                    break;
                }
                case 1073742118: {
                    return;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!this.chk) {
            this.vwr.tm.slabInternal(plane, isDepth);
        }
    }

    private void cmdSsbond() throws ScriptException {
        int mad = this.getMadParameter();
        if (mad == Integer.MAX_VALUE) {
            return;
        }
        this.setShapeProperty(1, "type", 256);
        this.setShapeSizeBs(1, mad, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void cmdStructure() throws ScriptException {
        STR type = STR.getProteinStructureType(this.paramAsStr(1));
        if (type == STR.NOT) {
            this.invArg();
        }
        BS bs = null;
        switch (this.tokAt(2)) {
            case 10: 
            case 1073742325: {
                bs = this.atomExpressionAt(2);
                this.checkLast(this.iToken);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.chk) {
            return;
        }
        this.clearDefinedVariableAtomSets();
        this.vwr.setProteinType(type, bs);
    }

    private void cmdSubset() throws ScriptException {
        BS bs = null;
        if (!this.chk) {
            this.vwr.slm.setSelectionSubset(null);
        }
        if (!(this.slen == 1 || this.slen == 4 && this.getToken((int)2).value.equals("off"))) {
            bs = this.atomExpressionAt(1);
        }
        if (!this.chk) {
            this.vwr.slm.setSelectionSubset(bs);
        }
    }

    private void cmdSync() throws ScriptException {
        String text = "";
        String applet = "";
        int port = PT.parseInt(this.optParameterAsString(1));
        if (port == Integer.MIN_VALUE) {
            this.checkLength(-3);
            port = 0;
            switch (this.slen) {
                case 1: {
                    applet = "*";
                    text = "ON";
                    break;
                }
                case 2: {
                    applet = this.paramAsStr(1);
                    if (applet.indexOf("jmolApplet") == 0 || PT.isOneOf(applet, ";*;.;^;")) {
                        text = "ON";
                        if (!this.chk) {
                            this.vwr.syncScript(text, applet, 0);
                        }
                        applet = ".";
                        break;
                    }
                    text = applet;
                    applet = "*";
                    break;
                }
                case 3: {
                    applet = this.paramAsStr(1);
                    text = this.tokAt(2) == 528443 ? "GET_GRAPHICS" : this.paramAsStr(2);
                }
            }
        } else {
            SV v = null;
            if (this.slen > 2 && (v = this.setVariable(2, -1, "", false)) == null) {
                return;
            }
            text = this.slen == 2 ? null : (v.tok == 6 ? v.toJSON() : v.asString());
            applet = null;
        }
        if (this.chk) {
            return;
        }
        this.vwr.syncScript(text, applet, port);
    }

    private void cmdThrow() throws ScriptException {
        if (this.chk) {
            return;
        }
        int pt = this.tokAt(1) == 14 ? 2 : 1;
        SV v = pt == 1 ? this.setVariable(1, this.slen, "thrown_value", false) : this.vwr.g.setUserVariable("thrown_value", SV.newS(this.optParameterAsString(2)));
        String info = v.asString();
        if (info.length() == 0 && (info = this.optParameterAsString(1)).length() == 0) {
            info = "context";
        }
        if (pt == 2) {
            this.saveContext(info);
            if (this.doReport()) {
                this.report(GT.o(GT._("to resume, enter: &{0}"), info), false);
            }
            throw new ScriptInterruption(this, info, Integer.MIN_VALUE);
        }
        this.evalError(info, null);
    }

    private ScriptContext saveContext(String saveName) {
        ScriptContext sc = this.getScriptContext("Context_" + saveName);
        this.vwr.stm.saveContext(saveName, sc);
        this.vwr.g.setUserVariable(saveName, SV.newV(14, sc));
        return sc;
    }

    private void cmdTimeout(int index) throws ScriptException {
        String name = null;
        String script = null;
        int mSec = 0;
        if (this.slen == index) {
            this.showString(this.vwr.showTimeout(null));
            return;
        }
        block6: for (int i = index; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1073741974: {
                    name = this.paramAsStr(++i);
                    if (this.slen != 3) continue block6;
                    if (!this.chk) {
                        this.vwr.triggerTimeout(name);
                    }
                    return;
                }
                case 1073742334: {
                    continue block6;
                }
                case 2: {
                    mSec = this.intParameter(i);
                    continue block6;
                }
                case 3: {
                    mSec = Math.round(this.floatParameter(i) * 1000.0f);
                    continue block6;
                }
                default: {
                    if (name == null) {
                        name = this.paramAsStr(i);
                        continue block6;
                    }
                    if (script == null) {
                        script = this.paramAsStr(i);
                        continue block6;
                    }
                    this.invArg();
                }
            }
        }
        if (!this.chk) {
            this.vwr.setTimeout(name, mSec, script);
        }
    }

    private void cmdTranslate(boolean isSelected) throws ScriptException {
        char type;
        BS bs = null;
        int i = 1;
        int i0 = 0;
        if (this.tokAt(1) == 1113589787) {
            isSelected = true;
            i0 = 1;
            i = 2;
        }
        if (this.isPoint3f(i)) {
            P3 pt = this.getPoint3f(i, true);
            bs = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
            this.checkLast(this.iToken);
            if (!this.chk) {
                this.vwr.setAtomCoordsRelative(pt, bs);
            }
            return;
        }
        char xyz = (this.paramAsStr(i).toLowerCase() + " ").charAt(0);
        if ("xyz".indexOf(xyz) < 0) {
            this.error(0);
        }
        float amount = this.floatParameter(++i);
        switch (this.tokAt(++i)) {
            case 0: 
            case 10: 
            case 1073742325: {
                type = '\u0000';
                break;
            }
            default: {
                type = (this.optParameterAsString(i).toLowerCase() + '\u0000').charAt(0);
            }
        }
        if (amount == 0.0f && type != '\u0000') {
            return;
        }
        this.iToken = i0 + (type == '\u0000' ? 2 : 3);
        bs = isSelected ? this.vwr.bsA() : (this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null);
        this.checkLast(this.iToken);
        if (!this.chk) {
            this.vwr.translate(xyz, amount, type, bs);
        }
    }

    private void cmdUnbind() throws ScriptException {
        if (this.slen != 1) {
            this.checkLength23();
        }
        String mouseAction = this.optParameterAsString(1);
        String name = this.optParameterAsString(2);
        if (mouseAction.length() == 0 || this.tokAt(1) == 1073742327) {
            mouseAction = null;
        }
        if (name.length() == 0 || this.tokAt(2) == 1073742327) {
            name = null;
        }
        if (name == null && mouseAction != null && ActionManager.getActionFromName(mouseAction) >= 0) {
            name = mouseAction;
            mouseAction = null;
        }
        if (!this.chk) {
            this.vwr.unBindAction(mouseAction, name);
        }
    }

    private void cmdUndoRedoMove() throws ScriptException {
        int n = 1;
        int len = 2;
        switch (this.tokAt(1)) {
            case 0: {
                len = 1;
                break;
            }
            case 1073742327: {
                n = 0;
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            default: {
                this.invArg();
            }
        }
        this.checkLength(len);
        if (!this.chk) {
            this.vwr.undoMoveAction(this.tokAt(0), n);
        }
    }

    public void setCurrentCagePts(T3[] originABC, String name) {
        SymmetryInterface sym = Interface.getSymmetry(this.vwr, "eval");
        if (sym == null && this.vwr.async) {
            throw new NullPointerException();
        }
        try {
            this.vwr.ms.setModelCage(this.vwr.am.cmi, originABC == null ? null : sym.getUnitCell(originABC, false, name));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void cmdUnitcell(int i) throws ScriptException {
        this.getCmdExt().dispatch(1814695966, i == 2, null);
    }

    private void cmdVector() throws ScriptException {
        RadiusData.EnumType type = RadiusData.EnumType.SCREEN;
        float value = 1.0f;
        this.checkLength(-3);
        this.iToken = this.slen;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 1073742335: {
                        break;
                    }
                    case 1073742334: {
                        value = 0.0f;
                        break;
                    }
                    case 2: {
                        int d = this.intParameterRange(1, 0, 19);
                        if (d == Integer.MAX_VALUE) {
                            return;
                        }
                        value = d;
                        break;
                    }
                    case 3: {
                        type = RadiusData.EnumType.ABSOLUTE;
                        value = this.floatParameterRange(1, 0.0f, 3.0f);
                        if (!Float.isNaN(value)) break block0;
                        return;
                    }
                    default: {
                        this.error(6);
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (this.tokAt(1)) {
                    case 1112152078: {
                        this.setIntProperty("vectorTrace", this.intParameterRange(2, 0, 20));
                        return;
                    }
                    case 1073742138: {
                        value = this.floatParameterRange(2, -100.0f, 100.0f);
                        if (!Float.isNaN(value)) {
                            this.setFloatProperty("vectorScale", value);
                        }
                        return;
                    }
                    case 64: {
                        float max = this.floatParameter(2);
                        if (!this.chk) {
                            this.vwr.ms.scaleVectorsToMax(max);
                        }
                        return;
                    }
                }
            }
        }
        this.setShapeSize(18, new RadiusData(null, value, type, null));
    }

    private void cmdVibration() throws ScriptException {
        this.checkLength(-3);
        float period = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                this.checkLength(2);
                period = this.vwr.getFloat(0x22000044);
                break;
            }
            case 1073742334: {
                this.checkLength(2);
                period = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                period = this.floatParameter(1);
                break;
            }
            case 1073742138: {
                period = this.floatParameterRange(2, -100.0f, 100.0f);
                if (!Float.isNaN(period)) {
                    this.setFloatProperty("vibrationScale", period);
                }
                return;
            }
            case 64: {
                float max = this.floatParameter(2);
                if (this.chk) break;
                this.vwr.ms.scaleVectorsToMax(max);
                break;
            }
            case 1073742090: {
                this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                return;
            }
            case 0x40000000: {
                this.invArg();
                break;
            }
            default: {
                period = -1.0f;
            }
        }
        if (period < 0.0f) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (period == 0.0f) {
            this.vwr.tm.setVibrationPeriod(0.0f);
            return;
        }
        this.vwr.setVibrationPeriod(-period);
    }

    private void cmdWireframe() throws ScriptException {
        int mad = Integer.MIN_VALUE;
        if (this.tokAt(1) == 4141) {
            this.checkLast(1);
        } else {
            mad = this.getMadParameter();
        }
        if (this.chk || mad == Integer.MAX_VALUE) {
            return;
        }
        this.setShapeProperty(1, "type", 1023);
        this.setShapeSizeBs(1, mad == Integer.MIN_VALUE ? 300 : mad, null);
    }

    private void cmdZap(boolean isZapCommand) throws ScriptException {
        boolean isQuiet;
        if (this.slen == 1 || !isZapCommand) {
            boolean doAll;
            boolean bl = doAll = isZapCommand && !this.isStateScript;
            if (doAll) {
                this.vwr.cacheFileByName(null, false);
            }
            this.vwr.zap(true, doAll, true);
            this.refresh(false);
            return;
        }
        BS bs = this.atomExpressionAt(1);
        if (this.chk) {
            return;
        }
        if (bs.nextSetBit(0) < 0 && this.slen == 4 && this.tokAt(2) == 1073742359) {
            int iModel = this.vwr.ms.getModelNumberIndex(this.getToken((int)2).intValue, false, true);
            if (iModel >= 0) {
                this.vwr.deleteModels(iModel, null);
            }
            return;
        }
        int nDeleted = this.vwr.deleteAtoms(bs, true);
        boolean bl = isQuiet = !this.doReport();
        if (!isQuiet) {
            this.report(GT.i(GT._("{0} atoms deleted"), nDeleted), false);
        }
        this.vwr.select(null, false, 0, isQuiet);
    }

    private void cmdZoom(boolean isZoomTo) throws ScriptException {
        float floatSecondsTotal;
        if (!isZoomTo) {
            int tok = this.slen > 1 ? this.getToken((int)1).tok : 1073742335;
            switch (tok) {
                case 0x400000FF: 
                case 1275068432: {
                    break;
                }
                case 1073742334: 
                case 1073742335: {
                    if (this.slen > 2) {
                        this.bad();
                    }
                    if (!this.chk) {
                        this.setBooleanProperty("zoomEnabled", tok == 1073742335);
                    }
                    return;
                }
            }
        }
        P3 center = null;
        int i = 1;
        float f = isZoomTo ? (this.isFloatParameter(i) ? this.floatParameter(i++) : 1.0f) : (floatSecondsTotal = 0.0f);
        if (floatSecondsTotal < 0.0f) {
            --i;
            floatSecondsTotal = 0.0f;
        }
        int ptCenter = 0;
        BS bsCenter = null;
        if (this.isCenterParameter(i)) {
            ptCenter = i;
            Object[] ret = new Object[1];
            center = this.centerParameter(i, ret);
            if (ret[0] instanceof BS) {
                bsCenter = (BS)ret[0];
            }
            i = this.iToken + 1;
        } else if (this.tokAt(i) == 2 && this.getToken((int)i).intValue == 0) {
            bsCenter = this.vwr.getAtomBitSet("visible");
            center = this.vwr.ms.getAtomSetCenter(bsCenter);
        }
        boolean isSameAtom = false;
        float zoom = this.vwr.tm.getZoomSetting();
        float newZoom = this.getZoom(ptCenter, i, bsCenter, zoom);
        i = this.iToken + 1;
        float xTrans = Float.NaN;
        float yTrans = Float.NaN;
        if (i != this.slen) {
            xTrans = this.floatParameter(i++);
            yTrans = this.floatParameter(i++);
        }
        if (i != this.slen) {
            this.invArg();
        }
        if (newZoom < 0.0f) {
            newZoom = -newZoom;
            if (isZoomTo) {
                if (this.slen == 1 || isSameAtom) {
                    newZoom *= 2.0f;
                } else if (center == null) {
                    newZoom /= 2.0f;
                }
            }
        }
        float max = 200000.0f;
        if (newZoom < 5.0f || newZoom > max) {
            this.numberOutOfRange(5.0f, max);
        }
        if (!this.vwr.tm.isWindowCentered()) {
            if (center != null) {
                BS bs = this.atomExpressionAt(ptCenter);
                if (!this.chk) {
                    this.vwr.setCenterBitSet(bs, false);
                }
            }
            center = this.vwr.tm.fixedRotationCenter;
            if (Float.isNaN(xTrans)) {
                xTrans = this.vwr.tm.getTranslationXPercent();
            }
            if (Float.isNaN(yTrans)) {
                yTrans = this.vwr.tm.getTranslationYPercent();
            }
        }
        if (this.chk) {
            return;
        }
        if (Float.isNaN(xTrans)) {
            xTrans = 0.0f;
        }
        if (Float.isNaN(yTrans)) {
            yTrans = 0.0f;
        }
        if (isSameAtom && Math.abs(zoom - newZoom) < 1.0f || !this.useThreads()) {
            floatSecondsTotal = 0.0f;
        }
        this.vwr.moveTo(this, floatSecondsTotal, center, JC.center, Float.NaN, null, newZoom, xTrans, yTrans, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        if (this.isJS && floatSecondsTotal > 0.0f && this.vwr.g.waitForMoveTo) {
            throw new ScriptInterruption(this, "zoomTo", 1);
        }
    }

    private void colorShape(int shapeType, int index, boolean isBackground) throws ScriptException {
        boolean isTranslucent;
        String translucency = null;
        Object colorvalue = null;
        Integer colorvalue1 = null;
        BS bs = null;
        String prefix = index == 2 && this.tokAt(1) == 1073741859 ? "ball" : "";
        boolean isColor = false;
        boolean isIsosurface = shapeType == 24 || shapeType == 25;
        int typeMask = 0;
        boolean doClearBondSet = false;
        float translucentLevel = Float.MAX_VALUE;
        if (index < 0) {
            bs = this.atomExpressionAt(-index);
            index = this.iToken + 1;
            if (this.isBondSet) {
                doClearBondSet = true;
                shapeType = 1;
            }
        }
        int tok = this.getToken((int)index).tok;
        if (isBackground) {
            this.getToken(index);
        } else {
            isBackground = tok == 1610616835;
            if (isBackground) {
                this.getToken(++index);
            }
        }
        if (isBackground) {
            prefix = "bg";
        } else if (isIsosurface) {
            switch (this.theTok) {
                case 1073742018: {
                    this.getToken(++index);
                    prefix = "mesh";
                    break;
                }
                case 1073742094: {
                    int argb = this.getArgbParamOrNone(++index, false);
                    colorvalue1 = argb == 0 ? null : Integer.valueOf(argb);
                    index = this.iToken + 1;
                    this.getToken(index);
                    break;
                }
                case 10: 
                case 1073742325: {
                    if (this.theToken.value instanceof BondSet) {
                        bs = (BondSet)this.theToken.value;
                        prefix = "vertex";
                    } else {
                        bs = this.atomExpressionAt(index);
                        prefix = "atom";
                    }
                    index = this.iToken + 1;
                    this.getToken(index);
                }
            }
        }
        if (!(this.chk || shapeType != 27 && shapeType != 28 || this.getIsoExt().dispatch(shapeType, true, this.st) == null)) {
            return;
        }
        boolean bl = isTranslucent = this.theTok == 603979967;
        if (isTranslucent || this.theTok == 1073742074) {
            if (translucentLevel == Float.MIN_VALUE) {
                this.invArg();
            }
            translucency = this.paramAsStr(index++);
            if (isTranslucent && this.isFloatParameter(index)) {
                translucentLevel = this.getTranslucentLevel(index++);
            }
        }
        tok = 0;
        if (index < this.slen && this.tokAt(index) != 1073742335 && this.tokAt(index) != 1073742334) {
            isColor = true;
            tok = this.getToken((int)index).tok;
            if ((!isIsosurface || this.tokAt(index + 1) != 1073742170) && this.isColorParam(index)) {
                int argb = this.getArgbParamOrNone(index, false);
                colorvalue = argb == 0 ? null : Integer.valueOf(argb);
                index = this.iToken + 1;
                if (this.tokAt(index) != 0 && translucency == null) {
                    this.getToken(index);
                    boolean bl2 = isTranslucent = this.theTok == 603979967;
                    if (isTranslucent || this.theTok == 1073742074) {
                        translucency = this.paramAsStr(index++);
                        if (isTranslucent && this.isFloatParameter(index)) {
                            translucentLevel = this.getTranslucentLevel(index++);
                        }
                    }
                }
                if (this.isColorParam(index)) {
                    argb = this.getArgbParamOrNone(index, false);
                    colorvalue1 = argb == 0 ? null : Integer.valueOf(argb);
                    index = this.iToken + 1;
                }
                this.checkLength(index);
            } else if (shapeType == 26) {
                --this.iToken;
            } else {
                BS bsSelected;
                PAL pal;
                boolean isColorIndex;
                String name = this.paramAsStr(index).toLowerCase();
                boolean isByElement = name.indexOf("byelement") == 0;
                boolean bl3 = isColorIndex = isByElement || name.indexOf("byresidue") == 0;
                PAL pAL = isColorIndex || isIsosurface ? PAL.PROPERTY : (pal = tok == 1112152075 ? PAL.CPK : PAL.getPalette(name));
                if (pal == PAL.UNKNOWN || (pal == PAL.TYPE || pal == PAL.ENERGY) && shapeType != 2) {
                    this.invArg();
                }
                float[] data = null;
                BS bS = bsSelected = pal != PAL.PROPERTY && pal != PAL.VARIABLE || !this.vwr.g.rangeSelected ? null : this.vwr.bsA();
                if (pal == PAL.PROPERTY) {
                    if (isColorIndex) {
                        if (!this.chk) {
                            data = this.getCmdExt().getBitsetPropertyFloat(bsSelected, (isByElement ? 1094715402 : 1094713356) | 0x100, null, Float.NaN, Float.NaN);
                        }
                    } else {
                        boolean isPropertyExplicit = name.equals("property");
                        if (isPropertyExplicit && T.tokAttr(tok = this.getToken((int)(++index)).tok, 0x40400000) && !T.tokAttr(tok, 0x40C00000)) {
                            String type;
                            tok = this.getToken((int)index).tok;
                            String string = type = tok == 1111490587 ? this.getToken((int)(++index)).value.toString() : null;
                            if (!this.chk) {
                                data = this.getCmdExt().getBitsetPropertyFloat(bsSelected, tok | 0x100, type, Float.NaN, Float.NaN);
                            }
                            ++index;
                        } else if (!isPropertyExplicit && !isIsosurface) {
                            ++index;
                        }
                    }
                } else if (pal == PAL.VARIABLE) {
                    int n = ++index;
                    ++index;
                    name = this.paramAsStr(n);
                    data = new float[this.vwr.ms.ac];
                    Parser.parseStringInfestedFloatArray("" + this.getParameter(name, 4, true), null, data);
                    pal = PAL.PROPERTY;
                }
                if (pal == PAL.PROPERTY) {
                    String scheme = null;
                    if (this.tokAt(index) == 4) {
                        scheme = this.paramAsStr(index++).toLowerCase();
                        if (this.isArrayParameter(index)) {
                            scheme = scheme + "=" + SV.sValue(SV.getVariableAS(this.stringParameterSet(index))).replace('\n', ' ');
                            index = this.iToken + 1;
                        }
                    } else if (isIsosurface && this.isColorParam(index)) {
                        scheme = this.getColorRange(index);
                        index = this.iToken + 1;
                    }
                    if (scheme != null && !isIsosurface) {
                        this.setStringProperty("propertyColorScheme", (isTranslucent && translucentLevel == Float.MAX_VALUE ? "translucent " : "") + scheme);
                        isColorIndex = scheme.indexOf("byelement") == 0 || scheme.indexOf("byresidue") == 0;
                    }
                    float min = 0.0f;
                    float max = Float.MAX_VALUE;
                    if (!(isColorIndex || this.tokAt(index) != 0x40000002 && this.tokAt(index) != 1073742114)) {
                        min = this.floatParameter(index + 1);
                        max = this.floatParameter(index + 2);
                        index += 3;
                        if (min == max && isIsosurface) {
                            float[] range = (float[])this.getShapeProperty(shapeType, "dataRange");
                            if (range != null) {
                                min = range[0];
                                max = range[1];
                            }
                        } else if (min == max) {
                            max = Float.MAX_VALUE;
                        }
                    }
                    if (!isIsosurface) {
                        if (data == null) {
                            if (!this.chk) {
                                this.vwr.setCurrentColorRange(name);
                            }
                        } else if (!this.chk) {
                            this.vwr.cm.setPropertyColorRangeData(data, bsSelected);
                        }
                    }
                    if (isIsosurface) {
                        ColorEncoder ce;
                        this.checkLength(index);
                        if (this.chk) {
                            return;
                        }
                        isColor = false;
                        ColorEncoder colorEncoder = ce = scheme == null ? (ColorEncoder)this.getShapeProperty(shapeType, "colorEncoder") : null;
                        if (ce == null && (ce = this.vwr.cm.getColorEncoder(scheme)) == null) {
                            return;
                        }
                        ce.isTranslucent = isTranslucent && translucentLevel == Float.MAX_VALUE;
                        ce.setRange(min, max, min > max);
                        if (max == Float.MAX_VALUE) {
                            ce.hi = max;
                        }
                        this.setShapeProperty(shapeType, "remapColor", ce);
                        this.showString(((String)this.getShapeProperty(shapeType, "dataRangeStr")).replace('\n', ' '));
                        if (translucentLevel == Float.MAX_VALUE) {
                            return;
                        }
                    } else if (max != Float.MAX_VALUE) {
                        this.vwr.cm.setPropertyColorRange(min, max);
                    }
                } else {
                    ++index;
                }
                this.checkLength(index);
                colorvalue = pal;
            }
        }
        if (this.chk || shapeType < 0) {
            return;
        }
        switch (shapeType) {
            case 4: {
                typeMask = 32768;
                break;
            }
            case 2: {
                typeMask = 30720;
                break;
            }
            case 3: {
                typeMask = 256;
                break;
            }
            case 1: {
                typeMask = 1023;
                break;
            }
            default: {
                typeMask = 0;
            }
        }
        if (typeMask == 0) {
            this.sm.loadShape(shapeType);
            if (shapeType == 5) {
                this.setShapeProperty(5, "setDefaults", this.vwr.slm.noneSelected);
            }
        } else {
            if (bs != null) {
                this.vwr.selectBonds(bs);
                bs = null;
            }
            shapeType = 1;
            this.setShapeProperty(shapeType, "type", typeMask);
        }
        if (isColor) {
            switch (tok) {
                case 1111492619: {
                    this.getPartialCharges(bs);
                    break;
                }
                case 1111490574: 
                case 1111490575: {
                    this.vwr.autoCalculate(tok, null);
                    break;
                }
                case 1111492620: {
                    if (!this.vwr.g.rangeSelected) break;
                    this.vwr.ms.clearBfactorRange();
                    break;
                }
                case 1086324742: {
                    this.vwr.ms.calcSelectedGroupsCount();
                    break;
                }
                case 0x41400011: 
                case 1094713362: {
                    this.vwr.ms.calcSelectedMonomersCount();
                    break;
                }
                case 0x41400010: {
                    this.vwr.ms.calcSelectedMoleculesCount();
                }
            }
            if (colorvalue1 != null && (isIsosurface || shapeType == 11 || shapeType == 14 || shapeType == 21)) {
                this.setShapeProperty(shapeType, "colorPhase", new Object[]{colorvalue1, colorvalue});
            } else if (bs == null) {
                this.setShapeProperty(shapeType, prefix + "color", colorvalue);
            } else {
                this.setShapePropertyBs(shapeType, prefix + "color", colorvalue, bs);
            }
        }
        if (translucency != null) {
            this.setShapeTranslucency(shapeType, prefix, translucency, translucentLevel, bs);
        }
        if (typeMask != 0) {
            this.setShapeProperty(1, "type", 1023);
        }
        if (doClearBondSet) {
            this.vwr.selectBonds(null);
        }
        if (shapeType == 0) {
            this.vwr.shm.checkInheritedShapes();
        }
    }

    public void getPartialCharges(BS bs) throws ScriptException {
        try {
            this.vwr.getOrCalcPartialCharges(bs, null);
        }
        catch (Exception e) {
            throw new ScriptInterruption(this, "partialcharge", 1);
        }
    }

    public RadiusData encodeRadiusParameter(int index, boolean isOnly, boolean allowAbsolute) throws ScriptException {
        float value = Float.NaN;
        RadiusData.EnumType factorType = RadiusData.EnumType.ABSOLUTE;
        VDW vdwType = null;
        int tok = index == -1 ? 1648363544 : this.getToken((int)index).tok;
        switch (tok) {
            case 1111490561: 
            case 0x42400002: 
            case 1111492618: 
            case 1111492620: 
            case 1113589786: 
            case 1648363544: {
                value = 1.0f;
                factorType = RadiusData.EnumType.FACTOR;
                vdwType = tok == 1648363544 ? null : VDW.getVdwType2(T.nameOf(tok));
                tok = this.tokAt(++index);
            }
        }
        switch (tok) {
            case 4141: {
                return this.vwr.rd;
            }
            case 1073741852: 
            case 0x40000020: 
            case 1073741857: 
            case 1073741991: 
            case 1073742116: {
                value = 1.0f;
                factorType = RadiusData.EnumType.FACTOR;
                this.iToken = index - 1;
                break;
            }
            case 2: 
            case 3: 
            case 0x100000A1: {
                float max;
                if (tok == 0x100000A1) {
                    ++index;
                } else {
                    if (this.tokAt(index + 1) == 268435634) {
                        value = Math.round(this.floatParameter(index));
                        this.iToken = ++index;
                        factorType = RadiusData.EnumType.FACTOR;
                        if (value < 0.0f || value > 200.0f) {
                            this.integerOutOfRange(0, 200);
                            return null;
                        }
                        value /= 100.0f;
                        break;
                    }
                    if (tok == 2) {
                        value = this.intParameter(index);
                        if (value > 749.0f || value < -200.0f) {
                            this.integerOutOfRange(-200, 749);
                            return null;
                        }
                        if (value > 0.0f) {
                            value /= 250.0f;
                            factorType = RadiusData.EnumType.ABSOLUTE;
                            break;
                        }
                        value /= -100.0f;
                        factorType = RadiusData.EnumType.FACTOR;
                        break;
                    }
                }
                if (tok == 0x100000A1 || !allowAbsolute) {
                    factorType = RadiusData.EnumType.OFFSET;
                    max = 16.0f;
                } else {
                    factorType = RadiusData.EnumType.ABSOLUTE;
                    vdwType = VDW.NADA;
                    max = 100.0f;
                }
                value = this.floatParameterRange(index, isOnly || !allowAbsolute ? -max : 0.0f, max);
                if (Float.isNaN(value)) {
                    return null;
                }
                if (isOnly) {
                    value = -value;
                }
                if (!(value > 16.0f)) break;
                value = 16.1f;
                break;
            }
            default: {
                if (value != 1.0f) break;
                --index;
            }
        }
        if (vdwType == null && (vdwType = VDW.getVdwType(this.optParameterAsString(++this.iToken))) == null) {
            this.iToken = index;
            vdwType = VDW.AUTO;
        }
        return new RadiusData(null, value, factorType, vdwType);
    }

    public int[] expandFloatArray(float[] a, int min) throws ScriptException {
        int n = a.length;
        boolean haveNeg = false;
        try {
            for (int i = 0; i < a.length; ++i) {
                if (!(a[i] < 0.0f)) continue;
                n = (int)((float)n + (Math.abs(a[i - 1] + a[i]) - 1.0f));
                haveNeg = true;
            }
            if (haveNeg) {
                float[] b = new float[n];
                int pt = 0;
                for (int i = 0; i < a.length; ++i) {
                    n = (int)a[i];
                    if (n >= 0) {
                        if (n < min) {
                            this.invArg();
                        }
                        b[pt++] = n;
                        continue;
                    }
                    int dif = (int)(a[i - 1] + (float)n);
                    int dir = dif < 0 ? 1 : -1;
                    int j = (int)a[i - 1];
                    while ((float)j != -a[i]) {
                        b[pt] = b[pt - 1] + (float)dir;
                        j += dir;
                        ++pt;
                    }
                }
                a = b;
                n = a.length;
            }
            int[] ia = new int[n];
            int i = n;
            while (--i >= 0) {
                ia[i] = (int)a[i];
            }
            return ia;
        }
        catch (Exception e) {
            this.invArg();
            return null;
        }
    }

    private void frameControl(int i) throws ScriptException {
        switch (this.getToken((int)this.checkLast((int)i)).tok) {
            case 4143: 
            case 20487: 
            case 1073741942: 
            case 1073741993: 
            case 1073742037: 
            case 0x40000110: 
            case 1073742098: 
            case 1073742108: 
            case 1073742125: {
                if (!this.chk) {
                    this.vwr.setAnimation(this.theTok);
                }
                return;
            }
        }
        this.invArg();
    }

    public String getColorRange(int i) throws ScriptException {
        int color1 = this.getArgbParam(i);
        if (this.tokAt(++this.iToken) != 1073742170) {
            this.invArg();
        }
        int color2 = this.getArgbParam(++this.iToken);
        int nColors = this.tokAt(this.iToken + 1) == 2 ? this.intParameter(++this.iToken) : 0;
        return ColorEncoder.getColorSchemeList(ColorEncoder.getPaletteAtoB(color1, color2, nColors));
    }

    public String getFullPathName() throws ScriptException {
        String filename;
        String string = filename = !this.chk || this.isCmdLine_C_Option ? this.vwr.fm.getFullPathName(true) : "test.xyz";
        if (filename == null) {
            this.invArg();
        }
        return filename;
    }

    private P3[] getObjectBoundingBox(String id) {
        Object[] data = new Object[]{id, null, null};
        return this.getShapePropertyData(24, "getBoundingBox", data) || this.getShapePropertyData(29, "getBoundingBox", data) || this.getShapePropertyData(25, "getBoundingBox", data) || this.getShapePropertyData(28, "getBoundingBox", data) || this.getShapePropertyData(27, "getBoundingBox", data) ? (P3[])data[2] : null;
    }

    protected P3 getObjectCenter(String axisID, int index, int modelIndex) {
        Object[] data = new Object[]{axisID, index, modelIndex};
        return this.getShapePropertyData(22, "getCenter", data) || this.getShapePropertyData(24, "getCenter", data) || this.getShapePropertyData(29, "getCenter", data) || this.getShapePropertyData(25, "getCenter", data) || this.getShapePropertyData(28, "getCenter", data) || this.getShapePropertyData(27, "getCenter", data) ? (P3)data[2] : null;
    }

    protected P4 getPlaneForObject(String id, V3 vAB) {
        int shapeType = this.sm.getShapeIdFromObjectName(id);
        switch (shapeType) {
            case 22: {
                this.setShapeProperty(22, "thisID", id);
                T3[] points = (T3[])this.getShapeProperty(22, "vertices");
                if (points == null || points.length < 3 || points[0] == null || points[1] == null || points[2] == null) break;
                return Measure.getPlaneThroughPoints(points[0], points[1], points[2], new V3(), vAB, new P4());
            }
            case 24: {
                this.setShapeProperty(24, "thisID", id);
                return (P4)this.getShapeProperty(24, "plane");
            }
        }
        return null;
    }

    public Quat[] getQuaternionArray(Object quaternionOrSVData, int itype) {
        Quat[] data;
        switch (itype) {
            case 134221850: {
                data = (Quat[])quaternionOrSVData;
                break;
            }
            case 9: {
                P4[] pts = (P4[])quaternionOrSVData;
                data = new Quat[pts.length];
                for (int i = 0; i < pts.length; ++i) {
                    data[i] = Quat.newP4(pts[i]);
                }
                break;
            }
            case 1073742001: {
                Lst sv = (Lst)quaternionOrSVData;
                data = new Quat[sv.size()];
                for (int i = 0; i < sv.size(); ++i) {
                    P4 pt = SV.pt4Value((SV)sv.get(i));
                    if (pt == null) {
                        return null;
                    }
                    data[i] = Quat.newP4(pt);
                }
                break;
            }
            default: {
                return null;
            }
        }
        return data;
    }

    public int getSetAxesTypeMad10(int index) throws ScriptException {
        if (index == this.slen) {
            return 1;
        }
        switch (this.getToken((int)this.checkLast((int)index)).tok) {
            case 1073742335: {
                return 1;
            }
            case 1073742334: {
                return 0;
            }
            case 0x40000066: {
                return -1;
            }
            case 2: {
                return this.intParameterRange(index, -1, 19);
            }
            case 3: {
                float angstroms = this.floatParameterRange(index, 0.0f, 2.0f);
                return Float.isNaN(angstroms) ? Integer.MAX_VALUE : (int)Math.floor(angstroms * 10000.0f * 2.0f);
            }
        }
        if (!this.chk) {
            this.errorStr(7, "\"DOTTED\"");
        }
        return 0;
    }

    private float getSettingFloat(int pt) throws ScriptException {
        return pt >= this.slen ? Float.NaN : SV.fValue(this.parameterExpressionToken(pt));
    }

    private int getSettingInt(int pt) throws ScriptException {
        return pt >= this.slen ? Integer.MIN_VALUE : this.parameterExpressionToken(pt).asInt();
    }

    private String getSettingStr(int pt, boolean isJmolSet) throws ScriptException {
        return isJmolSet && this.slen == pt + 1 ? this.paramAsStr(pt) : this.parameterExpressionToken(pt).asString();
    }

    public Object getShapeProperty(int shapeType, String propertyName) {
        return this.sm.getShapePropertyIndex(shapeType, propertyName, Integer.MIN_VALUE);
    }

    public boolean getShapePropertyData(int shapeType, String propertyName, Object[] data) {
        return this.sm.getShapePropertyData(shapeType, propertyName, data);
    }

    private int getShapeType(int tok) throws ScriptException {
        int iShape = JC.shapeTokenIndex(tok);
        if (iShape < 0) {
            this.error(49);
        }
        return iShape;
    }

    public float getTranslucentLevel(int i) throws ScriptException {
        float f = this.floatParameter(i);
        return this.theTok == 2 && f > 0.0f && f < 9.0f ? f + 1.0f : f;
    }

    private float getZoom(int ptCenter, int i, BS bs, float currentZoom) throws ScriptException {
        float zoom;
        float f = zoom = this.isFloatParameter(i) ? this.floatParameter(i++) : Float.NaN;
        if (zoom == 0.0f || currentZoom == 0.0f) {
            float r = Float.NaN;
            if (bs == null) {
                P3[] bbox;
                if (this.tokAt(ptCenter) == 1073742330 && ((bbox = this.getObjectBoundingBox(this.objectNameParameter(ptCenter + 1))) == null || (r = bbox[0].distance(bbox[1]) / 2.0f) == 0.0f)) {
                    this.invArg();
                }
            } else {
                r = this.vwr.ms.calcRotationRadiusBs(bs);
            }
            if (Float.isNaN(r)) {
                this.invArg();
            }
            currentZoom = this.vwr.getFloat(0x2200002C) / r * 100.0f;
            zoom = Float.NaN;
        }
        if (zoom < 0.0f) {
            zoom += currentZoom;
        } else if (Float.isNaN(zoom)) {
            int tok = this.tokAt(i);
            switch (tok) {
                case 0x400000FF: 
                case 1275068432: {
                    zoom = currentZoom * (tok == 0x400000FF ? 0.5f : 2.0f);
                    ++i;
                    break;
                }
                case 0x100000A1: 
                case 0x100000B0: 
                case 0x100000B1: {
                    float value = this.floatParameter(++i);
                    ++i;
                    switch (tok) {
                        case 0x100000B0: {
                            zoom = currentZoom / value;
                            break;
                        }
                        case 0x100000B1: {
                            zoom = currentZoom * value;
                            break;
                        }
                        case 0x100000A1: {
                            zoom = currentZoom + value;
                        }
                    }
                    break;
                }
                default: {
                    zoom = bs == null ? -currentZoom : currentZoom;
                }
            }
        }
        this.iToken = i - 1;
        return zoom;
    }

    private boolean setElementColor(String str, int argb) {
        int i = Elements.elementNumberMax;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase(Elements.elementNameFromNumber(i))) continue;
            if (!this.chk) {
                this.vwr.setElementArgb(i, argb);
            }
            return true;
        }
        i = Elements.altElementMax;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase(Elements.altElementNameFromIndex(i))) continue;
            if (!this.chk) {
                this.vwr.setElementArgb(Elements.altElementNumberFromIndex(i), argb);
            }
            return true;
        }
        if (str.charAt(0) != '_') {
            return false;
        }
        i = Elements.elementNumberMax;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase("_" + Elements.elementSymbolFromNumber(i))) continue;
            if (!this.chk) {
                this.vwr.setElementArgb(i, argb);
            }
            return true;
        }
        i = Elements.altElementMax;
        while (--i >= 4) {
            if (str.equalsIgnoreCase("_" + Elements.altElementSymbolFromIndex(i))) {
                if (!this.chk) {
                    this.vwr.setElementArgb(Elements.altElementNumberFromIndex(i), argb);
                }
                return true;
            }
            if (!str.equalsIgnoreCase("_" + Elements.altIsotopeSymbolFromIndex(i))) continue;
            if (!this.chk) {
                this.vwr.setElementArgb(Elements.altElementNumberFromIndex(i), argb);
            }
            return true;
        }
        return false;
    }

    public boolean setMeshDisplayProperty(int shape, int i, int tok) throws ScriptException {
        boolean checkOnly;
        String propertyName = null;
        Integer propertyValue = null;
        boolean allowCOLOR = shape == 25;
        boolean bl = checkOnly = i == 0;
        if (!checkOnly) {
            tok = this.getToken((int)i).tok;
        }
        switch (tok) {
            case 1765808134: {
                if (!allowCOLOR) break;
                ++this.iToken;
            }
            case 603979967: 
            case 1073742074: {
                if (!checkOnly) {
                    this.colorShape(shape, this.iToken, false);
                }
                return true;
            }
            case 0: 
            case 12291: 
            case 12294: 
            case 0x200028: 
            case 0x20002A: 
            case 1073742334: 
            case 1073742335: 
            case 1610625028: {
                if (this.iToken == 1 && shape >= 0 && this.tokAt(2) == 0) {
                    this.setShapeProperty(shape, "thisID", null);
                }
                if (tok == 0) {
                    return this.iToken == 1;
                }
                if (checkOnly) {
                    return true;
                }
                switch (tok) {
                    case 12291: {
                        this.setShapeProperty(shape, "delete", null);
                        return true;
                    }
                    case 12294: 
                    case 0x20002A: {
                        tok = 1073742334;
                        break;
                    }
                    case 0x200028: {
                        tok = 1073742335;
                        break;
                    }
                    case 1610625028: {
                        if (i + 1 != this.slen) break;
                        tok = 1073742335;
                    }
                }
            }
            case 1073741861: 
            case 1073741862: 
            case 0x4000004A: 
            case 1073741938: 
            case 1073741958: 
            case 0x40000088: 
            case 1073741964: 
            case 1073742018: 
            case 1073742039: 
            case 1073742042: 
            case 1073742046: 
            case 0x400000E4: 
            case 1073742057: 
            case 1073742058: 
            case 1073742060: 
            case 1073742182: 
            case 1112150019: {
                propertyName = "token";
                propertyValue = tok;
            }
        }
        if (propertyName == null) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        this.setShapeProperty(shape, propertyName, propertyValue);
        if (this.tokAt(this.iToken + 1) != 0 && !this.setMeshDisplayProperty(shape, ++this.iToken, 0)) {
            --this.iToken;
        }
        return true;
    }

    private void setObjectArgb(String str, int argb) {
        if (this.chk) {
            return;
        }
        this.vwr.setObjectArgb(str, argb);
    }

    public void setObjectMad10(int iShape, String name, int mad10) {
        if (!this.chk) {
            this.vwr.setObjectMad10(iShape, name, mad10);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String setObjectProp(String id, int tokCommand, int ptColor) throws ScriptException {
        Object[] data = new Object[]{id, null};
        String s = "";
        boolean isWild = PT.isWild(id);
        int iShape = 17;
        block14: while (true) {
            if (this.getShapePropertyData(iShape, "checkID", data)) {
                this.setShapeProperty(iShape, "thisID", id);
                switch (tokCommand) {
                    case 12291: {
                        this.setShapeProperty(iShape, "delete", null);
                        break;
                    }
                    case 12294: 
                    case 1610625028: {
                        this.setShapeProperty(iShape, "hidden", tokCommand == 1610625028 ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    case 134222350: {
                        s = s + (String)this.getShapeProperty(iShape, "command") + "\n";
                        break;
                    }
                    case 1765808134: {
                        if (ptColor < 0) break;
                        this.colorShape(iShape, ptColor + 1, false);
                    }
                }
                if (!isWild) return s;
            }
            switch (iShape) {
                case 17: {
                    iShape = 20;
                    continue block14;
                }
                case 20: {
                    iShape = 32;
                }
            }
            switch (--iShape) {
                case 27: {
                    --iShape;
                    break;
                }
                case 28: {
                    iShape -= 2;
                }
            }
            if (iShape < 21) return s;
        }
    }

    public String setObjectProperty() throws ScriptException {
        String id = this.setShapeNameParameter(2);
        return this.chk ? "" : this.setObjectProp(id, this.tokAt(0), this.iToken);
    }

    public String setShapeNameParameter(int i) throws ScriptException {
        String id = this.paramAsStr(i);
        boolean isWild = id.equals("*");
        if (id.length() == 0) {
            this.invArg();
        }
        if (isWild) {
            switch (this.tokAt(i + 1)) {
                case 0: 
                case 12291: 
                case 0x200028: 
                case 0x20002A: 
                case 1073742334: 
                case 1073742335: 
                case 1765808134: {
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(-1, 0, this.tokAt(i + 1))) break;
                    id = id + this.optParameterAsString(++i);
                }
            }
        }
        if (this.tokAt(i + 1) == 0x100000B1) {
            id = id + this.paramAsStr(++i);
        }
        this.iToken = i;
        return id;
    }

    public void setShapeProperty(int shapeType, String propertyName, Object propertyValue) {
        if (!this.chk) {
            this.sm.setShapePropertyBs(shapeType, propertyName, propertyValue, null);
        }
    }

    public void setShapePropertyBs(int iShape, String propertyName, Object propertyValue, BS bs) {
        if (!this.chk) {
            this.sm.setShapePropertyBs(iShape, propertyName, propertyValue, bs);
        }
    }

    private void setShapeSize(int shapeType, RadiusData rd) {
        if (!this.chk) {
            this.sm.setShapeSizeBs(shapeType, 0, rd, null);
        }
    }

    public void setShapeSizeBs(int shapeType, int size, BS bs) {
        if (!this.chk) {
            this.sm.setShapeSizeBs(shapeType, size, null, bs);
        }
    }

    public void setShapeTranslucency(int shapeType, String prefix, String translucency, float translucentLevel, BS bs) {
        if (translucentLevel == Float.MAX_VALUE) {
            translucentLevel = this.vwr.getFloat(0x2200000A);
        }
        this.setShapeProperty(shapeType, "translucentLevel", Float.valueOf(translucentLevel));
        if (prefix == null) {
            return;
        }
        if (bs == null) {
            this.setShapeProperty(shapeType, prefix + "translucency", translucency);
        } else if (!this.chk) {
            this.setShapePropertyBs(shapeType, prefix + "translucency", translucency, bs);
        }
    }

    private void setSize(int shape, float scale) throws ScriptException {
        RadiusData rd = null;
        int tok = this.tokAt(1);
        boolean isOnly = false;
        switch (tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
            }
            case 1073742335: {
                break;
            }
            case 1073742334: {
                scale = 0.0f;
                break;
            }
            case 3: {
                isOnly = this.floatParameter(1) < 0.0f;
            }
            default: {
                rd = this.encodeRadiusParameter(1, isOnly, true);
                if (rd == null) {
                    return;
                }
                if (!Float.isNaN(rd.value)) break;
                this.invArg();
            }
        }
        if (rd == null) {
            rd = new RadiusData(null, scale, RadiusData.EnumType.FACTOR, VDW.AUTO);
        }
        if (isOnly) {
            this.restrictSelected(false, false);
        }
        this.setShapeSize(shape, rd);
    }

    private void setSizeBio(int iShape) throws ScriptException {
        int mad = 0;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
            }
            case 1073742335: {
                mad = -1;
                break;
            }
            case 1073742334: {
                break;
            }
            case 1639976963: {
                mad = -2;
                break;
            }
            case 1073741922: 
            case 1111492620: {
                mad = -4;
                break;
            }
            case 2: {
                mad = this.intParameterRange(1, 0, 1000) * 8;
                if (mad != Integer.MAX_VALUE) break;
                return;
            }
            case 3: {
                mad = Math.round(this.floatParameterRange(1, -4.0f, 4.0f) * 2000.0f);
                if (mad == Integer.MAX_VALUE) {
                    return;
                }
                if (mad >= 0) break;
                this.restrictSelected(false, false);
                mad = -mad;
                break;
            }
            case 10: {
                if (!this.chk) {
                    this.sm.loadShape(iShape);
                }
                this.setShapeProperty(iShape, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSizeBs(iShape, mad, null);
    }

    private boolean setUnits(String units, int tok) throws ScriptException {
        if (tok == 545259568 && (units.endsWith("hz") || PT.isOneOf(units.toLowerCase(), ";angstroms;au;bohr;nanometers;nm;picometers;pm;vanderwaals;vdw;"))) {
            if (!this.chk) {
                this.vwr.setUnits(units, true);
            }
        } else if (tok == 545259559 && PT.isOneOf(units.toLowerCase(), ";kcal;kj;")) {
            if (!this.chk) {
                this.vwr.setUnits(units, false);
            }
        } else {
            this.errorStr2(50, "set " + T.nameOf(tok), units);
        }
        return true;
    }

    public String toString() {
        SB str = new SB();
        str.append("Eval\n pc:");
        str.appendI(this.pc);
        str.append("\n");
        str.appendI(this.aatoken.length);
        str.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            str.append("----\n");
            T[] atoken = this.aatoken[i];
            for (int j = 0; j < atoken.length; ++j) {
                str.appendO(atoken[j]);
                str.appendC('\n');
            }
            str.appendC('\n');
        }
        str.append("END\n");
        return str.toString();
    }

    static {
        commandHistoryLevelMax = 0;
        contextDepthMax = 100;
        scriptReportingLevel = 0;
    }
}

