/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;

public abstract class TruffleInstrument {
    protected TruffleInstrument() {
    }

    protected abstract void onCreate(Env var1);

    protected void onDispose(Env env) {
    }

    static {
        try {
            Class.forName(InstrumentationHandler.class.getName(), true, InstrumentationHandler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String id() default "";

        public String name() default "";

        public String version() default "";
    }

    public static final class Env {
        private final Object vm;
        private final Instrumenter instrumenter;
        private final InputStream in;
        private final OutputStream err;
        private final OutputStream out;
        private List<Object> services;

        Env(Object vm, Instrumenter instrumenter, OutputStream out, OutputStream err, InputStream in) {
            this.vm = vm;
            this.instrumenter = instrumenter;
            this.in = in;
            this.err = err;
            this.out = out;
        }

        public Instrumenter getInstrumenter() {
            return this.instrumenter;
        }

        public InputStream in() {
            return this.in;
        }

        public OutputStream out() {
            return this.out;
        }

        public OutputStream err() {
            return this.err;
        }

        public void registerService(Object service) {
            if (this.services == null) {
                throw new IllegalStateException();
            }
            this.services.add(service);
        }

        Object[] onCreate(TruffleInstrument instrument) {
            ArrayList<Object> arr = new ArrayList<Object>();
            this.services = arr;
            try {
                instrument.onCreate(this);
            }
            finally {
                this.services = null;
            }
            return arr.toArray();
        }

        public CallTarget parse(Source source, String ... argumentNames) throws IOException {
            return InstrumentationHandler.ACCESSOR.parse(null, source, null, argumentNames);
        }

        public boolean isEngineRoot(RootNode root) {
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().isEvalRoot(root);
        }

        public String toString(Node node, Object value) {
            RootNode rootNode = node.getRootNode();
            Class<? extends TruffleLanguage> languageClass = InstrumentationHandler.AccessorInstrumentHandler.nodesAccess().findLanguage(rootNode);
            TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().findEnv(this.vm, languageClass);
            TruffleLanguage<?> language = InstrumentationHandler.AccessorInstrumentHandler.langAccess().findLanguage(env);
            return InstrumentationHandler.AccessorInstrumentHandler.langAccess().toString(language, env, value);
        }
    }
}

